/* d_vs.cc
 *$Header: /al/acs/src/RCS/d_vs.cc,v 9.21 95/10/21 18:09:27 al Exp $
 * functions for fixed voltage sources
 * temporary kluge: it has resistance
 */
#include "d_vs.h"
#include "u_opt.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//	void	DEV_VS::expand();
// 	int	DEV_VS::dotr();
// 	void	DEV_VS::doac();
/*--------------------------------------------------------------------------*/
void DEV_VS::expand()
{
  loss = 1./OPT::shortckt;
  m0.x = 0.;
  y0.x = 0.;
  y0.f1 = val;
  y0.f0 = 0.;
  m0.f1 = 0.;
  m0.c0 = -loss * y0.f1;
  acg = ev = 0.;
}
/*--------------------------------------------------------------------------*/
int DEV_VS::dotr()
{
  assert(m0.x == 0.);
  assert(y0.x == 0.);
  if (trfun){
    trsetup();
    (*trfun)(this);
    m0.f1 = 0.;
    m0.c0 = -loss * y0.f1;
    return converged = conv_check();
  }else if (probes){
    trsetup();
    assert(conchk(m0.c0, -loss * y0.f1, OPT::abstol));
    return converged = TRUE;
  }else{
    assert(conchk(m0.c0, -loss * y0.f1, OPT::abstol));
    return converged = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
void DEV_VS::doac()
{
  acload_loss();
  if (acfun){
    acbias = 0.;
    ev = (*acfun)(this);
    acg = -loss * ev;
    acload_source();
  }else{
    assert(acg == 0.);
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
