/* s_tr.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/s_tr.h,v 9.21 95/10/21 18:11:17 al Exp $
 * Transient analysis
 */
#ifndef S_TR_H
#define S_TR_H
#include "s__.h"
/*--------------------------------------------------------------------------*/
class TRANSIENT : public SIM {
public:
	void	command(CS&);
private:
	void	review();
	void	setup(CS&);
protected:
	void	options(CS&);
	void	sweep();
private:
	void	first();
	int	next();
protected:
  double tstart;	// sweep start time
  double tstop;		// sweep stop time
  double tstep;		// printed step size
  double dtmax;		// max internal step size (step / skip)
  double dtratio;	// ratio of max/min dt
  int skip;		// fixed step size: internal steps per external
  int cold;		// flag: start time=0, all voltages=0
  int cont;		// flag: continue from previous run
private:
  int echo;		// flag: echo the input when using input data file
  int field;		// which field to use in input file
  int trace;		// enum: show extended diagnostics
  double approxtime;	// guess at best time for next step
  int control;		// why this time (enum)
  int printnow;		// flag: print this step
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
