/* u_timer.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/u_timer.h,v 9.21 95/10/21 18:11:23 al Exp $
 * CPU time accounting
 */
#ifndef U_TIMER_H
#define U_TIMER_H
#include "md.h"
/*--------------------------------------------------------------------------*/
class TIMER {
private:
  double ref_user;	// time the clock was started
  double ref_system;
  double last_user;	// time of timed operation
  double last_system;
  double total_user;	// time since program start
  double total_system;
  int running;
  char name[LABELEN+1];
public:
	TIMER();
	TIMER(const char*);
	void	fullreset();
	void	reset();
	void	zstart();
	void	start();
	void	stop();
	void	check();
	double	elapsed()const{return last_user+last_system;}
  	void	print();
	TIMER& 	operator=(const TIMER&);
friend	TIMER	operator-(const TIMER&,const TIMER&);
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
