

#include <stdlib.h>
#include <stdio.h>
#include "Maelstrom_Globals.h"

#include "bytesex.h"


int Load_Title(struct Title *title, int title_id)
{
	FILE *title_fp;
	char filename[256];
	
	/* Open the title file.. */
	sprintf(filename, "Images/Maelstrom_Titles#%d.icon", 
							title_id);
	if ( (title_fp=fopen(file2libpath(filename), "r")) == NULL )
		return(-1);
	fread(&title->width, 2, 1, title_fp);
	bytesexs(title->width);
	fread(&title->height, 2, 1, title_fp);
	bytesexs(title->height);
	title->data = new unsigned char[title->width*title->height];
	if ( ! fread(title->data, title->width*title->height, 1, title_fp) )
		return(-1);
	(void) fclose(title_fp);
	win->ReColor(title->data, title->width*title->height);
	return(0);
}

CIcon *GetCIcon(short cicn_id)
{
	CIcon         *cicn;
	FILE          *cicn_fp;
	char           filename[256];
	int            offset;
	
	/* Open the cicn sprite file.. */
	sprintf(filename, "Images/Maelstrom_Icon#%hd.cicn", 
							cicn_id);
	if ( (cicn_fp=fopen(file2libpath(filename), "r")) == NULL ) {
		fprintf(stderr, "GetCIcon(%hd): Can't open CICN %s: ",
						file2libpath(filename));
		perror("");
		return(NULL);
	}

	cicn = new CIcon;
        fread(&cicn->width, sizeof(cicn->width), 1, cicn_fp);
	bytesexs(cicn->width);
        fread(&cicn->height, sizeof(cicn->width), 1, cicn_fp);
	bytesexs(cicn->height);
        cicn->pixels= new unsigned char[cicn->width*cicn->height];
        if ( fread(cicn->pixels, 1, cicn->width*cicn->height, cicn_fp) != 
						cicn->width*cicn->height) {
		fprintf(stderr, "GetCIcon(%hd): Corrupt CICN!\n", cicn_id);
		delete[] cicn->pixels;
		delete   cicn;
		return(NULL);
	}
        cicn->mask=new unsigned char[(cicn->width/8)*cicn->height];
        if ( fread(cicn->mask, 1, (cicn->width/8)*cicn->height, cicn_fp) != 
					((cicn->width/8)*cicn->height) ) {
		fprintf(stderr, "GetCIcon(%hd): Corrupt CICN!\n", cicn_id);
		delete[] cicn->pixels;
		delete[] cicn->mask;
		delete   cicn;
		return(NULL);
	}
	(void) fclose(cicn_fp);

	win->ReColor(cicn->pixels, cicn->width*cicn->height);
	return(cicn);
}

void BlitCIcon(int x, int y, CIcon *cicn)
{
	win->Blit_Sprite(x, y, cicn->width, cicn->height, 
						cicn->pixels, cicn->mask);
}

void FreeCIcon(CIcon *cicn)
{
	delete[] cicn->pixels;
	delete[] cicn->mask;
	delete   cicn;
}

void SetRect(Rect *R, int left, int top, int right, int bottom)
{
	R->left = left;
	R->top = top;
	R->right = right;
	R->bottom = bottom;
}

void OffsetRect(Rect *R, int x, int y)
{
	R->left += x;
	R->top += y;
	R->right += x;
	R->bottom += y;
}

void InsetRect(Rect *R, int x, int y)
{
	R->left += x;
	R->top += y;
	R->right -= x;
	R->bottom -= y;
}
