/*
 * Programm XBLAST V1.2.13 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 2nd 1996
 * started August 1993
 *
 * File: data.h
 * include file for data.c
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 3; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _DATA_H
#define _DATA_H

#define TOTAL_LEVEL (LEVEL_MAX+2)

#define STATUS_BOARD     LEVEL_MAX
#define WINNING_THE_GAME (LEVEL_MAX+1)

#include "include.h"

#include "mytypes.h"

/*
 * global variables
 */
#ifndef _DATA_C
extern BMLevelData *maze_data[TOTAL_LEVEL];
#endif

/* 
 * game mode flags for levels 
 */
#define GM_Random     (1<<0)
#define GM_2_Player   (1<<1)
#define GM_3_Player   (1<<2)
#define GM_4_Player   (1<<3)
#define GM_5_Player   (1<<4)
#define GM_NoGrid     (1<<5) 

#define GM_234_Player (GM_2_Player|GM_3_Player|GM_4_Player)

/*
 * init flags for extras
 */
#define IF_None     0
#define IF_Kick     (1<<1)
#define RF_Kick     (1<<1)
#define XF_Kick     (3<<1)
#define IF_RC       (1<<3)
#define RF_RC       (1<<3)
#define XF_RC       (3<<3)
#define IF_Teleport (1<<5)
#define RF_Teleport (1<<5)
#define XF_Teleport (3<<5)

/*
 * bomb click flags 
 */
#define BC_None          0
#define BC_Snooker       1
#define BC_Contact       2
#define BC_Clockwise     3
#define BC_Anticlockwise 4
#define BC_Random        5
#define BC_Rebound       6

#define WC_None          0
#define WC_Rebound       1
#define WC_Contact       2
#define WC_Clockwise     3
#define WC_Anticlockwise 4
#define WC_Random        5

#define PC_StunStop      0
#define PC_StunThruInit  1
#define PC_StunThru      2
#define PC_Contact       3
#define PC_Rebound       4

/* Bomb types */

#define BMTnormal 0
#define BMTnapalm 1
#define BMTblastnow 2
#define BMTclose 3
#define BMTfirecracker 4
#define BMTfirecracker2 5
#define BMTconstruction 6
#define BMTthreebombs 7
#define BMTgrenade 8
#define BMTtrianglebombs 9
#define BMTdestruction 10
#define BMTfungus 11
#define BMTrenovation 12
#define BMTpyro 13
#define BMTpyro2 14
#define BMTrandom 15

#define NUM_BMT 16

  /* Fuse lengths */

#define FUSEshort 0
#define FUSEnormal 1
#define FUSElong 2

#define NUM_FUSES 3

  /* extras */

#define EXNone 0

  /* Extra distribution */

#define DEnone    0
#define DEsingle  1
#define DEall     2
#define DEspecial 3


/* 
 * shadow types for levels 
 */
#define ShadowNone  0
#define ShadowBlock 1
#define ShadowExtra 2
#define ShadowFull  3


/*
 * scramble macro
 */
#define SCRAMBLE_VOID {GAME_TIME+1, 0, NULL}

/*
 * macros for extras
 */
#define EXTRA_BOMB        { BLBomb,         "Black", "Red",         "White" }
#define EXTRA_RANGE       { BLRange,        "Black", "Yellow",      "White" }
#define EXTRA_TRAP        { BLTrap,         "Black", "Cyan",        "White" }
#define EXTRA_KICK        { BLKick,         "Black", "Blue",        "White" }
#define EXTRA_INVINC      { BLInvincible,   "Black", "Gold",        "White" }
#define EXTRA_BUTTON      { BLIgnite,       "Black", "DeepPink",    "White" }
#define EXTRA_CONSTR      { BLConstruction, "Black", "Firebrick1",  "White" }
#define EXTRA_RC          { BLRemoteControl,"Black", "SpringGreen", "White" }
#define EXTRA_BEAM        { BL_Q3A_BEAM,    "Black", "Orchid",      "White" }
#define EXTRA_AIRPUMP     { BLAirPump,      "Black", "SkyBlue",     "White" }
#define EXTRA_NAPALM      { BLNapalm,       "Black", "OrangeRed",   "White" }
#define EXTRA_FIRECRACKER { BLFirecracker,  "Black", "Orange",      "White" }
#define EXTRA_SYRINGE     { BLSyringe,      "Black", "YellowGreen", "White" }

#endif
/*
 * end of file data.h
 */



