#ifdef _plan9_
#include <u.h>
#include <libc.h>
#include <stdio.h>
#else
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#endif
#include "zoom.h"
#include "autopilot.h"
#include "ui.h"

#define InSet(i) (i==context->colors[0])
static number_t minsize = 1000;
static number_t maxsize = 0;
static int autime = 0;
static int minlong = 0;
#define MINCOUNT 5
void clean_autopilot(void)
{
    minsize = 1000;
    maxsize = 0;
    autime = 0;
    minlong = 0;
}
void do_autopilot(zoom_context * context, int *x, int *y, int *controls)
{
    static int x1, y1, c1;
    int i, j, i1, j1, c, max;
    if (context->dirty)
	clean_autopilot();
    if (context->s.mc - context->s.nc < minsize) {
	minsize = context->s.mc - context->s.nc;
	minlong = 0;
    }
    if (context->s.mc - context->s.nc > maxsize) {
	minsize = context->s.mc - context->s.nc;
	maxsize = context->s.mc - context->s.nc;
	minlong = 0;
    }
    j = 0;
    for (i = 0; i < context->width - 1; i++) {	/*detection of out of precisity... */
	if (context->xpos[i] == context->xpos[i + 1])
	    j++;
    }
    if (minlong > MINCOUNT || j > context->width / 3 || context->s.mc - context->s.nc>100) {
	minsize = 1000;
	set_view(context, &context->currentformula->v);
	clean_autopilot();
	ui_message();
	ui_tbreak();
	ui_updateparameters();
	minlong = 0;
    }
    if (autime <= 0) {
	minlong++;
	max = NGUESSES1;
	ui_tbreak();
	do {
	    max--;
	    c = 0;
	    x1 = rand() % (context->width - 2 * LOOKSIZE) + LOOKSIZE;
	    y1 = rand() % (context->height - 2 * LOOKSIZE) + LOOKSIZE;
	    autime = rand() % MAXTIME;
	    for (i = x1 - LOOKSIZE; i <= x1 + LOOKSIZE; i++)
		for (j = y1 - LOOKSIZE; j <= y1 + LOOKSIZE; j++)
		    if (InSet(*(context->vbuff + i + j * context->width)))
			c++;
	} while ((c == 0 || c > LOOKSIZE * LOOKSIZE) && max > 0);
	if (max > 0)
	    c1 = BUTTON1;
	else {
	    max = NGUESSES2;
	    do {
		max--;
		c = 0;
		x1 = rand() % (context->width - 2 * LOOKSIZE) + LOOKSIZE;
		y1 = rand() % (context->height - 2 * LOOKSIZE) + LOOKSIZE;
		autime = rand() % MAXTIME;
		for (i = x1 - LOOKSIZE; i <= x1 + LOOKSIZE; i++)
		    for (j = y1 - LOOKSIZE; j < y1 + LOOKSIZE; j++)
			for (i1 = x1 - LOOKSIZE; i1 < x1 + LOOKSIZE; i1++)
			    for (j1 = y1 - LOOKSIZE; j1 < y1 + LOOKSIZE; j1++)
				if (i1 != i && j1 != j &&
				    (*(context->vbuff + i + j * context->width)) ==
				    (*(context->vbuff + i1 + j1 * context->width)))
				    c++;
	    } while ((c > LOOKSIZE * LOOKSIZE / 2) && max > 0);
	    if (max > 0)
		c1 = BUTTON1;
	    else
		c1 = BUTTON3, autime >>= 1;
	}
    }
    autime--; {
	*x = x1;
	*y = y1;
	*controls = c1;
    }
}
