#include "sysincludes.h"
#include "msdos.h"
#include "mtools.h"
#include "patchlevel.h"

const char *mversion = VERSION;
const char *mdate = DATE;
int	mtools_raw_tty = 1;

static const struct dispatch {
	char *cmd;
	void (*fn)(int, char **, int);
	int type;
} dispatch[] = {
	{"mattrib",mattrib, 0},
	{"mbadblocks",mbadblocks, 0},
	{"mcd",mcd, 0},
	{"mcopy",mcopy, 0},
	{"mdel",mdel, 0},
	{"mdeltree",mdel, 2},
	{"mdir",mdir, 0},
	{"mformat",mformat, 0},
	{"mlabel",mlabel, 0},
	{"mmd",mmd, 0},
	{"mmount",mmount, 0},
	{"mrd",mdel, 1},
	{"mread",mcopy, 0},
	{"mmove",mmove, 0},
	{"mren",mmove, 1},
	{"mtest", mtest, 0},
	{"mtype",mcopy, 1},
	{"mwrite",mcopy, 0},
};
#define NDISPATCH (sizeof dispatch / sizeof dispatch[0])


void main(int argc,char **argv)
{
	char *name;
	int i;

	/* print the version */
	if(argc >= 2 && strcmp(argv[1], "-V") == 0) {
		printf("Mtools version %s, dated %s\n", mversion, mdate);
		exit(0);
	}

	if ((name = strrchr(argv[0],'/')))
		name++;
	else name = argv[0];
	argv[0] = name;
	
	read_config();
	setup_signal();
	for (i = 0; i < NDISPATCH; i++) {
		if (!strcmp(name,dispatch[i].cmd))
			dispatch[i].fn(argc, argv, dispatch[i].type);
	}
	if (strcmp(name,"mtools"))
		fprintf(stderr,"Unknown mtools command '%s'\n",name);
	fprintf(stderr,"Supported commands:");
	for (i = 0; i < NDISPATCH; i++) {
		if (i%8 == 0) putc('\n', stderr);
		else fprintf(stderr, ", ");
		fprintf(stderr, "%s", dispatch[i].cmd);
	}
	putc('\n', stderr);

	cleanup_and_exit(1);
}
