/*** analog 1.91beta ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** macstuff.c; stuff only required for the Mac port ***/
/* The functions in this file are due to Jason Linhart (jason@summary.net) */

#include "analhea2.h"
#ifdef MAC_EVENTS

void MacInit(void)
{
  SIOUXSettings.asktosaveonclose=false;
  printf("Processing...\n");
}

void MacFini(void)
{
  extern char *commandname;
  extern long Mac_good_lines, Mac_bad_lines, Mac_tab_lines;  /* in sscanf.c */
  extern int total_succ_reqs;
  extern flag warnq, anywarns;

  if (!Mac_good_lines && Mac_tab_lines > 4 && total_succ_reqs < 5 && warnq) {
    fprintf(stderr,"%s: Warning: No valid log entries found!\n", commandname);
    fprintf(stderr,"WebStar logs must start with a LOG_FORMAT line something like:\n");
    fprintf(stderr,"!!LOG_FORMAT DATE TIME RESULT URL TRANSFER_TIME BYTES_SENT HOSTNAME REFERER\n");
    fprintf(stderr,"except with the fields listed in the order they actually occur.\n");
    fprintf(stderr,"WebSTAR 1.2.1 or higher should create this line automatically.\n\n");
    anywarns = ON;
  }
  if (!anywarns)
    SIOUXSettings.autocloseonquit=true;
  printf("Complete!\n");
}

void MacIdle(void)
{
  static long time = 0;

  EventRecord myEvent;
  WindowPtr whichWindow;
  char theChar;

  if (TickCount()<time) return;
  time=TickCount()+6;
  SystemTask();
  if (WaitNextEvent(everyEvent, &myEvent, 1, nil)) {

    if (!SIOUXHandleOneEvent(&myEvent)) switch (myEvent.what) {

    case mouseDown:
      switch (FindWindow(myEvent.where,&whichWindow)) {

      case inMenuBar:
	MenuSelect(myEvent.where);
	break;
      case inSysWindow:
	SystemClick(&myEvent,whichWindow);
	break;
      case inContent:
	SelectWindow(whichWindow);
	break;
      case inDrag:
	DragWindow(whichWindow,myEvent.where,&qd.screenBits.bounds);
	break;
      }
      break;
    case keyDown:
      theChar = myEvent.message & charCodeMask;
      break;
    case updateEvt:
      BeginUpdate((WindowPtr) myEvent.message);
      EndUpdate((WindowPtr) myEvent.message);
      break;
    }
  }
}
#endif   /* (ifdef MAC_EVENTS) */
