/* filename: rlpr-common.h
 * project: rlpr
 * author: meem  --  meem@sherilyn.wustl.edu
 * version: $Id: rlpr-common.h,v 1.8 1996/10/12 07:08:22 meem Exp $
 * contents: common #defines, headers for general-purpose rlpr functions
 *
 * Time-stamp: <1996/10/12 02:08 -- meem@sherilyn.wustl.edu>
 */

#ifndef RLPR_COMMON_H
#define RLPR_COMMON_H

#ifndef __GNUC__
#define __attribute__(x)  /* nothing */
#define __FUNCTION__      ""
#endif /* __GNUC__ */

#include <sys/types.h>
#include <errno.h>

#ifndef HAVE_STRDUP
extern char * strdup(const char *s);
#endif

#ifndef HAVE_STRCSPN
extern size_t strcspn(const char *s, const char *reject);
#endif

#ifdef sparc
#include <netdb.h>                        /* braindamage for MAXHOSTNAMELEN */
#else /* NOT sparc */
#include <sys/param.h>
#endif

/* this is the default port the proxy listens on (rlprd) and the
 * client connects to to contact the proxy. it can be whatever you
 * want as long as the client and the server are both in agreement.
 * note that putting it below 1024 is asinine.  */

#define DEFAULT_RLPRD_TO_PORT   7290

#define DEFAULT_TMP_DIR        "/tmp"       /* fallback */
#define DEFAULT_WIDTH          "132"	    /* according to RFC 1179 */

#define DEFAULT_INDENT_NO_PARAM "8"
#define DEFAULT_WIDTH_NO_PARAM  "80"	    /* according to RFC 1179 */

/* environment variable names */
#define PRINTHOST         "RLPR_PRINTHOST"
#define PROXY             "RLPR_PROXY"

/* i made these up because i couldn't find a good source for them */
#define MAX_STR_LEN       255
#define MAX_FILE_LEN      64              /* NOT DEFINED IN RFC 1179! */
#define MAX_QUEUE_LEN     64              /* NOT DEFINED IN RFC 1179! */

/* NOTHING BELOW THIS POINT SHOULD NEED TO BE CHANGED */

/* FROM RFC 1179 */
#define MAX_USER_LEN      31
#define MAX_SOURCE_LEN    131
#define MAX_HOST_LEN      31
#define MAX_JOB_LEN       99
#define MAX_CLASS_LEN     31
#define MAX_TITLE_LEN     79

#define LO_LPD_FROM_PORT  721             /* INCLUSIVE */
#define HI_LPD_FROM_PORT  731             /* INCLUSIVE */
#define LPD_TO_PORT       515

/* odds and ends */
#define ERRNO  (errno ? strerror(errno) : "" )

/* printing attributes struct */

typedef struct print_attr {
  char         filetype;             /* format of file to print */
  int          fflag:1;              /* form feed after printing? */
  int	       mflag:1;              /* mail after printing? */
  int	       rflag:1;              /* remove file after printing? */
  int	       bflag:1;              /* burst page flag (1 = print it) */
  int	       qflag:1;              /* quiet flag (1 = quiet) */
  int	       wflag:1;		     /* windows flag (for braindead lpd's) */
  char *       indent_cols;          /* number of columns to indent by (string) */
  char *       width;                /* width, also stored as a string */
  char *       tmpdir;		     /* this follows the GNU custom */
  unsigned int copies;               /* number of copies to print */

  /* these fields are MAX + 1 so they can hold the null byte */

  char      class[MAX_CLASS_LEN  + 1];  /* job classification on burst page */
  char    printer[MAX_QUEUE_LEN  + 1];  /* name of printer queue */
  char       user[MAX_USER_LEN   + 1];  /* user name to print on burst page */
  char        job[MAX_JOB_LEN    + 1];  /* job name to print on burst page */
  char      title[MAX_TITLE_LEN  + 1];  /* title (optional for pr) */
} print_attr;

typedef struct net_attr {
  char  localhost[MAXHOSTNAMELEN + 1];  /* hostname of host rlpr is running on */
  char  proxyhost[MAXHOSTNAMELEN + 1];  /* hostname of proxy to go through */
  char  printhost[MAXHOSTNAMELEN + 1];  /* hostname of printer to print to */
  u_short      port;                    /* port number to connect to */
} net_attr;

/* global variables */

print_attr   opts_;                       /* global printing options struct */
net_attr     net_;		          /* global network options struct  */
extern char *name;			  /* program name */

/* function prototypes */

void   		  get_local_hostname(char *buf, size_t sz); 
char * 		  strlower(char *str);
off_t  		  filesz(int fd);
int    		  writen(int fd, char *ptr, int nbytes);
inline void *     rlpr_malloc(size_t sz);
inline void *     rlpr_strdup(char * orig);
void   		  rlpr_fatal(char *fmt, ...) __attribute__((noreturn));	
void   		  rlpr_warn(char *fmt, ...);	

#define check_ptr(x) \
  if ((x) == NULL) rlpr_fatal("%s: ouch, out of memory!", __FUNCTION__)

#define safe_writen(fd, buf, buflen) \
  if (writen((fd), (buf), (buflen)) < 0) \
    rlpr_fatal("writen in %s: %s", __FUNCTION__, ERRNO)
    
#endif /* RLPR_COMMON_H */

