#if defined(__unix__)
#include <unistd.h>
#endif
#if defined(__unix__) || defined(VMS)
#define GLOBALDEF
#define GLOBALREF extern
#elif defined(_WIN32)
#include <windows.h>
#define GLOBALDEF __declspec(dllexport)
#define GLOBALREF __declspec(dllimport)
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__unix__)
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#if defined(_AIX)
#include <sys/select.h>
#endif
#elif defined(VMS)
#include <types.h>
#include <socket.h>
#include <in.h>
#include <netdb.h>
typedef unsigned long fd_set;
#define FD_ZERO(fd) ((*fd) = 0)
#define FD_SET(fd,fdsetp) ((*fdsetp) |= (1<<fd))
#define FD_CLR(fd,fdsetp) ((*fdsetp) &= ~(1<<fd))
#define FD_ISSET(fd,fdsetp) (((*fdsetp) & (1<<fd)) != 0)
#elif defined(_WIN32)
#include <winsock.h>
#endif

#if !defined(_WIN32)
#include "ftplib.h"
#endif

#if defined(_WIN32)
#define SETSOCKOPT_OPTVAL_TYPE (const char *)
#else
#define SETSOCKOPT_OPTVAL_TYPE (void *)
#endif

#define FTP_BUFSIZ 8192
#define ACCEPT_TIMEOUT 30

typedef struct {
    char *cput,*cget;
    int handle;
    int cavail,cleft;
    char buf[FTP_BUFSIZ];
} netbuf;

static char *rcs_id = "$Id: ftplib.c,v 2.15 1996/02/23 15:07:09 pfau Exp $";
static int sDatal = -1;
static int sControl;
static netbuf *nControl;
static char rspbuf[256];
GLOBALDEF char *ftplib_lastresp = rspbuf;
GLOBALDEF int ftplib_debug = 0;

#if defined(__unix__) || defined(VMS)
#define net_read read
#define net_write write
#define net_close close
#elif defined(_WIN32)
#define net_read(x,y,z) recv(x,y,z,0)
#define net_write(x,y,z) send(x,y,z,0)
#define net_close closesocket
#endif

#if defined(VMS)
/*
 * VAX C does not supply a memccpy routine so I provide my own
 */
void *memccpy(void *dest, const void *src, int c, size_t n)
{
    int i=0;
    unsigned char *ip=src,*op=dest;
    while (i < n)
    {
	if ((*op++ = *ip++) == c)
	    break;
	i++;
    }
    if (i == n)
	return NULL;
    return op;
}
#endif

/*
 * read a line of text
 *
 * return -1 on error or bytecount
 */
static int readline(char *buf,int max,netbuf *ctl)
{
    int x,retval = 0;
    char *end;
    int eof = 0;

    if (max == 0)
	return 0;
    do
    {
    	if (ctl->cavail > 0)
    	{
	    x = (max >= ctl->cavail) ? ctl->cavail : max-1;
	    end = memccpy(buf,ctl->cget,'\n',x);
	    if (end != NULL)
		x = end - buf;
	    retval += x;
	    buf += x;
	    *buf = '\0';
	    max -= x;
	    ctl->cget += x;
	    ctl->cavail -= x;
	    if (end != NULL)
	    	break;
    	}
    	if (max == 1)
    	{
	    *buf = '\0';
	    break;
    	}
    	if (ctl->cput == ctl->cget)
    	{
	    ctl->cput = ctl->cget = ctl->buf;
	    ctl->cavail = 0;
	    ctl->cleft = FTP_BUFSIZ;
    	}
	if (eof)
	{
	    if (retval == 0)
		retval = -1;
	    break;
	}
    	if ((x = net_read(ctl->handle,ctl->cput,ctl->cleft)) == -1)
    	{
	    if(ftplib_debug > 1)
perror("read");
	    retval = -1;
	    break;
    	}
	if (x == 0)
	    eof = 1;
    	ctl->cleft -= x;
    	ctl->cavail += x;
    	ctl->cput += x;
    }
    while (1);
    return retval;
}

/*
 * read a response from the server
 *
 * return 0 if first char doesn't match
 * return 1 if first char matches
 */
static int readresp(char c)
{
    char match[5];
    if (readline(rspbuf,256,nControl) == -1)
    {
	if(ftplib_debug > 1)
perror("Control socket read failed");
	return 0;
    }
    if (ftplib_debug > 1)
	fprintf(stderr,"%s",rspbuf);
    if (rspbuf[3] == '-')
    {
	strncpy(match,rspbuf,3);
	match[3] = ' ';
	match[4] = '\0';
	do
	{
	    if (readline(rspbuf,256,nControl) == -1)
	    {
		if(ftplib_debug > 1)
perror("Control socket read failed");
		return 0;
	    }
	    if (ftplib_debug > 1)
		fprintf(stderr,"%s",rspbuf);
	}
	while (strncmp(rspbuf,match,4));
    }
    if (rspbuf[0] == c)
	return 1;
    return 0;
}

/*
 * ftpinit for stupid operating systems that require it (Windows NT)
 */
GLOBALDEF void ftpInit(void)
{
#if defined(_WIN32)
    WORD wVersionRequested;
    WSADATA wsadata;
    int err;
    wVersionRequested = MAKEWORD(1,1);
    if ((err = WSAStartup(wVersionRequested,&wsadata)) != 0)
	fprintf(stderr,"Network failed to start: %d\n",err);
#endif
}

/*
 * ftpOpen - connect to remote server
 *
 * return 1 if connected, 0 if not
 */
GLOBALDEF int ftpOpen(char *host)
{
    struct sockaddr_in sin;
    struct hostent *phe;
    struct servent *pse;
    int on=1;

    ftplib_lastresp[0] = '\0';
    memset(&sin,0,sizeof(sin));
    sin.sin_family = AF_INET;
#if defined(VMS)
    sin.sin_port = htons(21);
#else
    if ((pse = getservbyname("ftp","tcp")) == NULL)
    {
	if(ftplib_debug > 1)
perror("getservbyname");
	return 0;
    }
    sin.sin_port = pse->s_port;
#endif
    if ((phe = gethostbyname(host)) == NULL)
    {
	if(ftplib_debug > 1)
perror("gethostbyname");
	return 0;
    }
    memcpy((char *)&sin.sin_addr, phe->h_addr, phe->h_length);
    sControl = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (sControl == -1)
    {
	if(ftplib_debug > 1)
perror("socket");
	return 0;
    }
    if (setsockopt(sControl,SOL_SOCKET,SO_REUSEADDR,
		   SETSOCKOPT_OPTVAL_TYPE &on, sizeof(on)) == -1)
    {
	if(ftplib_debug > 1)
perror("setsockopt");
	close(sControl);
	return 0;
    }
    if (connect(sControl, (struct sockaddr *)&sin, sizeof(sin)) == -1)
    {
	if(ftplib_debug > 1)
perror("connect");
	close(sControl);
	return 0;
    }
    nControl = calloc(1,sizeof(netbuf));
    if (nControl == NULL)
    {
	if(ftplib_debug > 1)
perror("calloc");
	close(sControl);
	return 0;
    }
    nControl->handle = sControl;
    if (readresp('2') == 0)
    {
	close(sControl);
	free(nControl);
	return 0;
    }
    return 1;
}

/*
 * ftpSendCmd - send a command and wait for expected response
 *
 * return 1 if proper response received, 0 otherwise
 */
static int ftpSendCmd(char *cmd, char expresp)
{
    char buf[256];
    if (ftplib_debug > 2)
	fprintf(stderr,"%s\n",cmd);
    sprintf(buf,"%s\r\n",cmd);
    if (net_write(sControl,buf,strlen(buf)) <= 0)
    {
	if(ftplib_debug > 1)
perror("write");
	return 0;
    }    
    return readresp(expresp);
}

/*
 * ftpLogin - log in to remote server
 *
 * return 1 if logged in, 0 otherwise
 */
GLOBALDEF int ftpLogin(char *user, char *pass)
{
    char tempbuf[64];
    ftplib_lastresp[0] = '\0';
    sprintf(tempbuf,"user %s",user);
    if (!ftpSendCmd(tempbuf,'3'))
	return 0;
    sprintf(tempbuf,"pass %s",pass);
    return ftpSendCmd(tempbuf,'2');
}

/*
 * ftpPort - set up date connection
 *
 * return 1 if successful, 0 otherwise
 */
static int ftpPort(void)
{
    union {
	struct sockaddr sa;
	struct sockaddr_in in;
    } sin;
    struct linger lng = { 0, 0 };
    int l;
    char buf[64];
    int on=1;

    l = sizeof(sin);
    if (getsockname(sControl,&sin.sa,&l) < 0)
	return 0;
    sDatal = socket(PF_INET,SOCK_STREAM,IPPROTO_TCP);
    if (sDatal == -1)
    {
	if(ftplib_debug > 1)
perror("socket");
	return 0;
    }
    if (setsockopt(sDatal,SOL_SOCKET,SO_REUSEADDR,
		   SETSOCKOPT_OPTVAL_TYPE &on,sizeof(on)) == -1)
    {
	if(ftplib_debug > 1)
perror("setsockopt");
	net_close(sDatal);
	return 0;
    }
    if (setsockopt(sDatal,SOL_SOCKET,SO_LINGER,
		   SETSOCKOPT_OPTVAL_TYPE &lng,sizeof(lng)) == -1)
    {
	if(ftplib_debug > 1)
perror("setsockopt");
	net_close(sDatal);
	return 0;
    }
    sin.in.sin_port = 0;
    if (bind(sDatal,&sin.sa,sizeof(sin)) == -1)
    {
	if(ftplib_debug > 1)
perror("bind");
	net_close(sDatal);
	sDatal = -1;
	return 0;
    }
    if (listen(sDatal,1) < 0)
    {
	if(ftplib_debug > 1)
perror("listen");
	net_close(sDatal);
	sDatal = -1;
	return 0;
    }
    if (getsockname(sDatal,&sin.sa,&l) < 0)
	return 0;
    sprintf(buf,"port %d,%d,%d,%d,%d,%d",
	    (unsigned char)sin.sa.sa_data[2],(unsigned char)sin.sa.sa_data[3],
	    (unsigned char)sin.sa.sa_data[4],(unsigned char)sin.sa.sa_data[5],
	    (unsigned char)sin.sa.sa_data[0],(unsigned char)sin.sa.sa_data[1]);
    if (!ftpSendCmd(buf,'2'))
	return 0;
    return 1;
}

/*
 * ftpSite - send a SITE command
 *
 * return 1 if command successful, 0 otherwise
 */
GLOBALDEF int ftpSite(char *cmd)
{
    char buf[256];
    ftplib_lastresp[0] = '\0';
    sprintf(buf,"site %s",cmd);
    if (!ftpSendCmd(buf,'2'))
	return 0;
    return 1;
}

/*
 * ftpMkdir - create a directory at server
 *
 * return 1 if successful, 0 otherwise
 */
GLOBALDEF int ftpMkdir(char *path)
{
    char buf[256];
    ftplib_lastresp[0] = '\0';
    sprintf(buf,"mkd %s",path);
    if (!ftpSendCmd(buf,'2'))
	return 0;
    return 1;
}

/*
 * ftpChdir - change path at remote
 *
 * return 1 if successful, 0 otherwise
 */
GLOBALDEF int ftpChdir(char *path)
{
    char buf[256];
    ftplib_lastresp[0] = '\0';
    sprintf(buf,"cwd %s",path);
    if (!ftpSendCmd(buf,'2'))
	return 0;
    return 1;
}

GLOBALDEF int ftpRmdir(char *path)
{
    char buf[256];
    ftplib_lastresp[0] = '\0';
    sprintf(buf,"RMD %s",path);
    if (!ftpSendCmd(buf,'2'))
	return 0;
    return 1;
}

/*
 * accept_connect - wait for incoming connection
 *
 * return -2 on error or timeout
 * return -1 on remote reported error
 * otherwise returns socket descriptor
 */
static int accept_connect(void)
{
    int sData;
    struct sockaddr addr;
    int l;
    struct timeval tv;
    fd_set mask;

    FD_ZERO(&mask);
    FD_SET(sControl,&mask);
    FD_SET(sDatal,&mask);
    tv.tv_usec = 0;
    tv.tv_sec = ACCEPT_TIMEOUT;
    l = (sControl > sDatal) ? sControl : sDatal;
    if (select(l+1,&mask,NULL,NULL,&tv) == 0)
    {
	net_close(sDatal);
	return -2;
    }
    if (FD_ISSET(sControl,&mask))
    {
	net_close(sDatal);
	readresp('2');
	return -1;
    }
    l = sizeof(addr);
    if ((sData = accept(sDatal,&addr,&l)) > 0)
	return sData;
    net_close(sDatal);
    return -2;
}

/*
 * ftpNlst - issue an NLST command and write response to output
 *
 * return 1 if successful, 0 otherwise
 */
GLOBALDEF int ftpNlst(char *outputfile, char *path)
{
    int sData,l;
    char buf[256];
    char *dbuf;
    FILE *output;

    ftplib_lastresp[0] = '\0';
    if (!ftpSendCmd("type A",'2'))
	return 0;
    if (!ftpPort())
	return 0;
    strcpy(buf,"nlst");
    if (path != NULL)
	sprintf(buf+strlen(buf)," %s",path);
    if (!ftpSendCmd(buf,'1'))
	return 0;
    if ((sData = accept_connect()) < 0)
    {
	if (sData == -2)
	    if(ftplib_debug > 1)
perror("accept");
	else
	    printf("%s",rspbuf);
	return 0;
    }
    if (outputfile == NULL)
	output = stdout;
    else
    {
	output = fopen(outputfile,"w");
	if (output == NULL)
	{
	    if(ftplib_debug > 1)
perror(outputfile);
	    output = stdout;
	}
    }
    dbuf = malloc(FTP_BUFSIZ);
    while ((l = net_read(sData,dbuf,FTP_BUFSIZ)) > 0)
	fwrite(dbuf,1,l,output);
    if (outputfile != NULL)
	fclose(output);
    free(dbuf);
    shutdown(sData,2);
    net_close(sData);
    net_close(sDatal);
    return readresp('2');
}

/*
 * ftpDir - issue a LIST command and write response to output
 *
 * return 1 if successful, 0 otherwise
 */
GLOBALDEF int ftpDir(char *outputfile, char *path)
{
    int sData,l;
    char buf[256];
    char *dbuf;
    FILE *output;

    ftplib_lastresp[0] = '\0';
    if (!ftpSendCmd("type A",'2'))
	return 0;
    if (!ftpPort())
	return 0;
    strcpy(buf,"list");
    if (path != NULL)
	sprintf(buf+strlen(buf)," %s",path);
    if (!ftpSendCmd(buf,'1'))
	return 0;
    if ((sData = accept_connect()) < 0)
    {
	if (sData == -2)
	    if(ftplib_debug > 1)
perror("accept");
	else
	    printf("%s",rspbuf);
	return 0;
    }
    if (outputfile == NULL)
	output = stdout;
    else
    {
	output = fopen(outputfile,"w");
	if (output == NULL)
	{
	    if(ftplib_debug > 1)
perror(outputfile);
	    output = stdout;
	}
    }
    dbuf = malloc(FTP_BUFSIZ);
    while ((l = net_read(sData,dbuf,FTP_BUFSIZ)) > 0)
	fwrite(dbuf,1,l,output);
    if (outputfile != NULL)
	fclose(output);
    free(dbuf);
    shutdown(sData,2);
    net_close(sData);
    net_close(sDatal);
    return readresp('2');
}

/*
 * ftpGet - issue a GET command and write received data to output
 *
 * return 1 if successful, 0 otherwise
 */
GLOBALDEF int ftpGet(char *outputfile, char *path, char mode)
{
    int sData;
    int l;
    char buf[256];
    char *dbuf;
    FILE *output;

    ftplib_lastresp[0] = '\0';
    sprintf(buf,"type %c",mode);
    if (!ftpSendCmd(buf,'2'))
	return 0;
    if (!ftpPort())
	return 0;
    sprintf(buf,"retr %s",path);
    if (!ftpSendCmd(buf,'1'))
	return 0;
    if ((sData = accept_connect()) < 0)
    {
	if (sData == -2)
	    if(ftplib_debug > 1)
perror("accept");
	else
	    printf("%s",rspbuf);
	return 0;
    }
    if (outputfile == NULL)
	output = stdout;
    else
    {
	output = fopen(outputfile,"w");
	if (output == NULL)
	{
	    if(ftplib_debug > 1)
perror(outputfile);
	    output = stdout;
	}
    }
    dbuf = malloc(FTP_BUFSIZ);
    if (mode == 'A')
    {
	netbuf *nData;
	int dl;
	nData = calloc(1,sizeof(netbuf));
	if (nData == NULL)
	{
	    if(ftplib_debug > 1)
perror("calloc");
	    net_close(sData);
	    net_close(sDatal);
	    return 0;
	}
	nData->handle = sData;
	while ((dl = readline(dbuf,FTP_BUFSIZ,nData))!= -1)
	{
	    if (strcmp(&dbuf[dl-2],"\r\n") == 0)
	    {
		dl -= 2;
		dbuf[dl++] = '\n';
		dbuf[dl] = '\0';
	    }
	    fwrite(dbuf,1,dl,output);
	}
    }
    else
	while ((l = net_read(sData,dbuf,FTP_BUFSIZ)) > 0)
	    fwrite(dbuf,1,l,output);
    if (outputfile != NULL)
    	fclose(output);
    free(dbuf);
    shutdown(sData,2);
    net_close(sData);
    net_close(sDatal);
    return readresp('2');
}

/*
 * ftpPut - issue a PUT command and send data from input
 *
 * return 1 if successful, 0 otherwise
 */
GLOBALDEF int ftpPut(char *inputfile, char *path, char mode)
{
    int sData;
    int l;
    char buf[256];
    char *dbuf;
    FILE *input;

    if (inputfile == NULL)
    {
	fprintf(stderr,"Must specify a file name to send\n");
	return 0;
    }
    input = fopen(inputfile,"r");
    if (input == NULL)
    {
	if(ftplib_debug > 1)
perror(inputfile);
	return 0;
    }
    ftplib_lastresp[0] = '\0';
    sprintf(buf,"type %c",mode);
    if (!ftpSendCmd(buf,'2'))
	return 0;
    if (!ftpPort())
	return 0;
    sprintf(buf,"stor %s",path);
    if (!ftpSendCmd(buf,'1'))
	return 0;
    if ((sData = accept_connect()) < 0)
    {
	if (sData == -2)
	    if(ftplib_debug > 1)
perror("accept");
	else
	    printf("%s",rspbuf);
	return 0;
    }
    dbuf = malloc(FTP_BUFSIZ);
    if (mode == 'A')
    {
	netbuf *nData;
	int dl;
	nData = calloc(1,sizeof(netbuf));
	if (nData == NULL)
	{
	    if(ftplib_debug > 1)
perror("calloc");
	    net_close(sData);
	    net_close(sDatal);
	    fclose(input);
	    return 0;
	}
	nData->handle = fileno(input);
	while ((dl = readline(dbuf,FTP_BUFSIZ-1,nData))!= -1)
	{
	    if (dbuf[dl-1] == '\n')
	    {
		dbuf[dl-1] = '\r';
		dbuf[dl++] = '\n';
		dbuf[dl] = '\0';
	    }
	    if (net_write(sData,dbuf,dl) == -1)
	    {
		if(ftplib_debug > 1)
perror("write");
		break;
	    }
	}
	free(nData);
    }
    else
	while ((l = fread(dbuf,1,FTP_BUFSIZ,input)) != 0)
	    if (net_write(sData,dbuf,l) == -1)
	    {
		if(ftplib_debug > 1)
perror("write");
		break;
	    }
    fclose(input);
    free(dbuf);
    if (shutdown(sData,2) == -1)
	if(ftplib_debug > 1)
perror("shutdown");
    if (net_close(sData) == -1)
	if(ftplib_debug > 1)
perror("close");
    net_close(sDatal);
    return readresp('2');
}

/*
 * ftpRename - rename a file at remote
 *
 * return 1 if successful, 0 otherwise
 */
GLOBALDEF int ftpRename(char *src, char *dst)
{
    char cmd[256];
    ftplib_lastresp[0] = '\0';
    sprintf(cmd,"RNFR %s",src);
    if (!ftpSendCmd(cmd,'3'))
	return 0;
    sprintf(cmd,"RNTO %s",dst);
    if (!ftpSendCmd(cmd,'2'))
	return 0;
    return 1;
}

/*
 * ftpDelete - delete a file at remote
 *
 * return 1 if successful, 0 otherwise
 */
GLOBALDEF int ftpDelete(char *fnm)
{
    char cmd[256];
    ftplib_lastresp[0] = '\0';
    sprintf(cmd,"DELE %s",fnm);
    if (!ftpSendCmd(cmd,'2'))
	return 0;
    return 1;
}

/*
 * ftpQuit - disconnect from remote
 *
 * return 1 if successful, 0 otherwise
 */
GLOBALDEF void ftpQuit(void)
{
    ftplib_lastresp[0] = '\0';
    ftpSendCmd("quit",'2');
    free(nControl);
    net_close(sControl);
}
