#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <sys/stat.h>

#include "McApp.h"
#include "McFileRequest.h"
#include "McInfoRequest.h"

#include "xg3.h"
#include "filegui.h"
#include "confirm.h"
#include "files.h"

unsigned char *current_path = NULL;
unsigned char *current_file = NULL;
unsigned char *current_mask = NULL;
unsigned char *current_timing_file = NULL;

static int open_func(unsigned char *, unsigned char *, unsigned char *);
static int save_func(unsigned char *, unsigned char *, unsigned char *);

#define DEFAULT_MASK	"*.g3"

/****************************************************************************/

void new_path(unsigned char *path, unsigned char *file, unsigned char *mask) {
  if (file && (file!=current_file)) {
    if (current_file) free(current_file);
    current_file=strdup(file);
  }

  if (path && (path!=current_path)) {
    if (current_path) free(current_path);
    current_path=strdup(path);
  }

  if (mask && (mask!=current_mask)) {
    if (current_mask) free(current_mask);
    current_mask=strdup(mask);
  }
}

/****************************************************************************/

extern void reopen_proc(int nonsense) {
  BeepAssert(old_request);
  if (current_file) {
    open_file(current_file);
    UpdateDisplay();
  } else {
    open_proc(nonsense);
  }
}

/****************************************************************************/

extern void open_proc(int nonsense) {
  BeepAssert(old_request);

  if (!current_mask) current_mask=strdup(DEFAULT_MASK);
  old_request=McCreateFileRequest(app, MCF_POPUP|MCF_MUST_EXIST,
				  "Open file", current_mask,
				  current_path, current_file, NULL, open_func);
}

/****************************************************************************/

extern void save_proc(int nonsense) {

  if (current_data && current_size) {
    BeepAssert(old_request);
    if (current_file) {
      save_file(current_file);
      UpdateDisplay();
    } else {
      save_as_proc(nonsense);
    }
  } else {
    McError(app, "No data.");
  }
}

/****************************************************************************/

extern void save_as_proc(int nonsense) {
  if (current_data && current_size) {
    BeepAssert(old_request);
    if (!current_mask) current_mask=strdup(DEFAULT_MASK);
    old_request=McCreateFileRequest(app, MCF_POPUP, "Save as", current_mask,
				    current_path, current_file, "Save",
				    save_func);
  } else {
    McError(app, "No data.");
  }
}

/****************************************************************************/

static int save_func(unsigned char *path,
		     unsigned char *file, unsigned char *mask) {
  old_request=NULL;
  new_path(path, file, mask);
  if (file) {
    UpdateDisplay();
    confirm_overwrite(file, save_file, NULL);
  }
  return 1;
}

/****************************************************************************/

static int open_func(unsigned char *path,
		     unsigned char *file, unsigned char *mask) {
  old_request=NULL;
  new_path(path, file, mask);
  if (file) {
    open_file(current_file);
    UpdateDisplay();
  }
  return 1;
}

/****************************************************************************/

void no_file(void) {
  if (current_file) {
    free(current_file);
    current_file=0;
  }
}

/**************************************************************************/

