/*
 * Copyright 1996 by Kevin E. Martin, Chapel Hill, North Carolina.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of Kevin
 * E. Martin not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Kevin E. Martin makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * KEVIN E. MARTIN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.  */

/* $XFree86: xc/programs/Xserver/hw/xfree86/accel/mach64/mach64fifo.c,v 3.0 1996/10/18 15:00:21 dawes Exp $ */

#include "mach64.h"

#define MAX_CDEPTH 6
#define MAX_DOTCLOCKS 14

typedef struct {
    short dotclock;
    unsigned char fifo_val;
} mach64FIFOTable;


static unsigned char defaultFIFOVals[] = {
    0x02, 0x0c, 0x02, 0x06, 0x02, 0x0e, /*  8 bpp */
    0x02, 0x0e, 0x02, 0x0e, 0x02, 0x0e, /* 16 bpp */
    0x02, 0x0e, 0x02, 0x0e, 0x02, 0x0e, /* 24 bpp */
    0x02, 0x0e, 0x02, 0x0e, 0x02, 0x0e  /* 32 bpp */
};

static unsigned char CT_FIFOVals[] = {
    /* 640x480 */
    0x04, 0x0c, 0x04, 0x08, 0x09, 0x0f, /*  8 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x08, 0x0f, /* 16 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x08, 0x0f, /* 24 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x08, 0x0f, /* 32 bpp */
    /* 800x600 */
    0x04, 0x0c, 0x04, 0x08, 0x08, 0x0f, /*  8 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x08, 0x0f, /* 16 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x0e, 0x0f, /* 24 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x0e, 0x0f, /* 32 bpp */
    /* 1024x768 */
    0x04, 0x0c, 0x04, 0x08, 0x08, 0x0f, /*  8 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x0e, 0x0f, /* 16 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x0e, 0x0f, /* 24 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x0e, 0x0f, /* 32 bpp */
    /*1280x1024 */
    0x04, 0x0c, 0x04, 0x08, 0x0e, 0x0f, /*  8 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x0e, 0x0f, /* 16 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x0e, 0x0f, /* 24 bpp */
    0x04, 0x0e, 0x04, 0x0e, 0x0e, 0x0f  /* 32 bpp */
};

static mach64FIFOTable VTA3_SDRAM_1M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 3600, 0x04}, { 4400, 0x06}, { 6800, 0x06}, { 9000, 0x08}, 
    {10500, 0x0a}, {24000, 0x0c} },  /* 8bpp */
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0e} },  /* 15bpp */
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0e} },   /* 16bpp */
  { { 2200, 0x08}, { 2600, 0x08}, { 3300, 0x0a}, { 3600, 0x0c},
    { 4000, 0x0e}, {24000, 0x0e} }, /* 24bpp */
  { {24000, 0x08} } /* 32bpp */
};

static mach64FIFOTable VTA3_SDRAM_2M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4400, 0x04}, { 9400, 0x06}, {24000, 0x08} },  /* 4bpp */
  { { 4000, 0x04}, { 5700, 0x06}, { 9400, 0x08}, {11200,0x0c},
    {24000, 0x0e} }, /* 8bpp */
  { { 2600, 0x06}, { 4200, 0x08}, { 4600, 0x0a}, { 6400, 0x0c},
    {24000, 0x0e} }, /* 15bpp */
  { { 2600, 0x06}, { 4200, 0x08}, { 4600, 0x0a}, { 6400, 0x0c},
    {24000, 0x0e} }, /* 16bpp */
  { { 2600, 0x0a}, { 3800, 0x0c}, { 4000, 0x0c}, { 4500, 0x28},
    {24000, 0x2c} }, /* 24bpp */
  { { 2200, 0x0a}, { 3000, 0x0c},  { 3400, 0x0e}, {24000, 0x0e} } /* 32bpp */
};

static mach64FIFOTable VTA3_SDRAM_1M_6300_5[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x08} },
  { { 3800, 0x04}, { 4400, 0x06}, { 6600, 0x06}, { 9000, 0x08},
    {24000, 0x0a} },
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, { 6900, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, { 6900, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 2600, 0x0a}, { 3400, 0x0c}, { 4200, 0x0e},
    { 4600, 0x0e}, {24000, 0x0e} },
  { {24000, 0x06} }
 };

static mach64FIFOTable VTA3_SDRAM_2M_6300_5[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4400, 0x04}, { 9400, 0x06}, {24000, 0x08} },
  { { 3000, 0x04}, { 4000, 0x06}, { 6000, 0x08}, { 9400, 0x0a},
    {10000, 0x0c}, {11200, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x06}, { 3500, 0x08}, { 4400, 0x0a}, { 6400, 0x0e},
    { 6800, 0x0e}, { 8200, 0x0e}, {10100, 0x0e}, {11100, 0x0e},
    {13100, 0x0e}, {13600, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x06}, { 3500, 0x08}, { 4400, 0x0a}, { 6400, 0x0e},
    { 6800, 0x0e}, { 8200, 0x0e}, {10100, 0x0e}, {11100, 0x0e},
    {13100, 0x0e}, {13600, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x0a}, { 4200, 0x0c}, { 4500, 0x28}, { 5200, 0x2c},
    { 5700, 0x2c}, { 6600, 0x2c}, { 6800, 0x2c}, { 7600, 0x2c},
    { 8200, 0x2c}, {10100, 0x2c}, {11100, 0x2c}, {12200, 0x2c},
    {24000, 0x2c} },
  { { 2000, 0x0a}, { 3000, 0x0c}, { 3400, 0x0e}, { 4100, 0x2e},
    { 4600, 0x2e}, { 5200, 0x2e}, { 5700, 0x2e}, { 6600, 0x2e},
    { 7000, 0x2e}, { 7600, 0x2e}, { 7900, 0x2e}, { 8200, 0x2e},
    {24000, 0x2e} }
};

static mach64FIFOTable VTA3_SDRAM_1M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 3600, 0x04}, { 4400, 0x06}, { 7500, 0x06}, { 8200, 0x08},
    {24000,0x0a}},  /* 8bpp */
  { { 2600, 0x06}, { 3200, 0x06}, { 3600, 0x08}, { 4000, 0x0a},
    { 5800, 0x0c}, { 8000, 0x0e}, {24000, 0x0e} },  /* 15bpp */
  { { 2600, 0x06}, { 3200, 0x06}, { 3600, 0x08}, { 4000, 0x0a},
    { 5800, 0x0c}, { 8000, 0x0e}, {24000, 0x0e} },  /* 16bpp */
  { { 2000, 0x08}, { 2600, 0x08}, { 3200, 0x0a}, { 3700, 0x0c},
    { 4200, 0x0c}, {24000, 0x0e} }, /* 24bpp */
  { {24000, 0x06} } /* 32bpp */
};

static mach64FIFOTable VTA3_SDRAM_2M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4400, 0x04}, { 9400, 0x06}, {24000, 0x08} }, /* 4 bpp */
  { { 4000, 0x04}, { 5800, 0x06}, { 8200, 0x08}, {10000, 0x0a},
    {11200, 0x0c}, {24000, 0x0e}},  /* 8bpp */
  { { 2600, 0x06}, { 4000, 0x08}, { 5100, 0x0a}, { 5800, 0x0c},
    {24000, 0x0e} }, /* 15bpp */
  { { 2600, 0x06}, { 4000, 0x08}, { 5100, 0x0a}, { 5800, 0x0c},
    {24000, 0x0e} }, /* 16bpp */
  { { 2600, 0x0a}, { 4000, 0x0c}, { 4500, 0x28}, {24000, 0x2c} },  /* 24bpp */
  { { 2600, 0x0a}, { 3600, 0x0e}, {24000, 0x2e} }   /* 32bpp */
};

static mach64FIFOTable VTA3_SDRAM_1M_6700[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, { 8000, 0x08},
    {24000, 0x08} },
  { { 3800, 0x04}, { 4400, 0x06}, { 7800, 0x06}, { 9000, 0x08},
    {24000, 0x0a}},
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0c} },
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0c} },
  { { 2000, 0x06}, { 2600, 0x06}, { 3400, 0x0a}, { 4100, 0x0c},
    {24000, 0x0e} },
  { {24000, 0x06} }
};

static mach64FIFOTable VTA3_SDRAM_2M_6700[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x04}, { 9400, 0x06}, {11200, 0x08}, {24000, 0x08} },
  { { 4400, 0x04}, { 6600, 0x06}, { 9400, 0x08}, {10000, 0x0a},
    {11200, 0x0c}, {14000, 0x0c}, {24000, 0x0c}},
  { { 3400, 0x06}, { 4200, 0x08}, { 5400, 0x0a}, { 6600, 0x0c},
    { 8000, 0x0e}, {24000, 0x0e} },
  { { 3400, 0x06}, { 4200, 0x08}, { 5400, 0x0a}, { 6600, 0x0c},
    { 8000, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 3000, 0x08}, { 3300, 0x0a}, { 4200, 0x0c},
    { 4600, 0x0c}, {24000, 0x2c} },
  { { 3000, 0x0a}, { 3400, 0x0c}, { 3800, 0x0e}, { 5200, 0x0e}, }
};

static mach64FIFOTable VTA3_EDO_1M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} },
  { { 3000, 0x04}, { 3800, 0x04}, { 4800, 0x06}, { 5400, 0x06}, 
    { 6800, 0x0a}, { 7700, 0x0a}, { 9000, 0x0a}, {11000, 0x0c}, 
    {24000,0x0e}},
  { { 2000, 0x06}, { 3000, 0x06}, { 3300, 0x0a}, {4400, 0x0a}, 
    { 4800, 0x0e}, {5500, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3300, 0x0a}, {4400, 0x0a}, 
    { 4800, 0x0e}, {5500, 0x0e}, {24000, 0x0e} },
  { { 2200, 0x0a}, { 3000, 0x0a}, {3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x0c} }
};

static mach64FIFOTable VTA3_EDO_2M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 4600, 0x04}, { 5600, 0x06}, { 7000, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11100, 0x0c}, {13000, 0x0c}, {14000, 0x0c},
    {24000, 0x0e}},
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5100, 0x0a}, 
    { 5500, 0x0c}, { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e},
    { 7900, 0x0e}, {11100, 0x0e}, {24000, 0x0e}  },          
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5100, 0x0a}, 
    { 5500, 0x0c}, { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e},
    { 7900, 0x0e}, {11100, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 3400, 0x0a}, { 3800, 0x0a}, { 4100, 0x0a},
    { 4500, 0x0c}, { 5200, 0x0e}, { 5700, 0x2a}, { 6800, 0x2a},
    {24000, 0x2a} },
  { { 3000, 0x0a}, { 3500, 0x0e}, {4200, 0x0e}, { 4600, 0x2a},
    { 5200, 0x2a}, {24000, 0x2a} }
};

static mach64FIFOTable VTA3_EDO_1M_6700_6[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} },
  { { 3000, 0x04}, { 3800, 0x04}, { 5400, 0x06}, { 7700, 0x0a},
    { 9000, 0x0a}, {10500, 0x0c}, {24000, 0x0e}},
  { { 2000, 0x06}, { 3000, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 4800, 0x0c}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 4800, 0x0c}, {24000, 0x0e} },
  { { 2000, 0x0a}, { 3000, 0x0a}, { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x06} }
};

static mach64FIFOTable VTA3_EDO_2M_6700_6[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 4600, 0x04}, { 5600, 0x06}, { 7000, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11300, 0x0c}, {14000, 0x0c}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5500, 0x0a},
    { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5500, 0x0a},
    { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 3400, 0x0a}, { 3800, 0x0a}, { 4200, 0x0a},
    { 4500, 0x0c}, { 5200, 0x0c}, {24000, 0x2c} },
  { { 2000, 0x0a}, { 3000, 0x0a}, { 3500, 0x0c}, { 4200, 0x0e},
    {24000, 0x2a} }
};

static mach64FIFOTable VTA3_EDO_1M_6700_7[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4200, 0x04}, { 6400, 0x06}, { 9000, 0x0a}, {24000, 0x0c} },
  { { 3800, 0x08}, { 6400, 0x0a}, { 7000, 0x0c}, { 9000, 0x0c},
    {24000, 0x0c}},
  { { 3800, 0x0a}, { 4800, 0x0c}, { 5600, 0x0e}, {24000, 0x0e} },
  { { 3800, 0x0a}, { 4800, 0x0c}, { 5600, 0x0e}, {24000, 0x0e} },
  { { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x06}  }
};

static mach64FIFOTable VTA3_EDO_2M_6700_7[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x02}, { 7000, 0x04}, {10200, 0x06}, {24000, 0x0a} },
  { { 5200, 0x06}, { 6400, 0x08}, { 7000, 0x0a}, { 7900, 0x0c},
    { 8200, 0x0c}, {10800, 0x0c}, {13000, 0x0c}, {24000, 0x0c} },
  { { 3000, 0x06}, { 3800, 0x08}, { 4200, 0x0a}, { 5200, 0x0a}, 
    { 6600, 0x0c}, { 7600, 0x0c}, { 8200, 0x0c}, {24000, 0x0e} },
  { { 3000, 0x06}, { 3800, 0x08}, { 4200, 0x0a}, { 5200, 0x0c},
    { 6600, 0x0c}, { 7600, 0x0c}, { 8200, 0x0c}, {24000, 0x0e} },
  { { 3000, 0x0a}, { 3400, 0x0a}, { 3600, 0x0a}, { 4400, 0x0c},
    { 5200, 0x0c} },
  { { 3400, 0x0c}, { 5200, 0x0c} }
};

static mach64FIFOTable VTA3_PSEUDO_1M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] = 
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} },
  { { 3000, 0x04}, { 3800, 0x04}, { 5400, 0x06}, { 7700, 0x0a}, 
    { 9000, 0x0a}, {12000, 0x0c}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 4400, 0x0a}, { 4800, 0x0e},
    { 5500, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 4400, 0x0a}, { 4800, 0x0e},
    { 5500, 0x0e}, {24000, 0x0e} },
  { { 2200, 0x0a}, { 3000, 0x0a}, { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x0c} }
};

static mach64FIFOTable VTA3_PSEUDO_2M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] = 
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 4600, 0x04}, { 5600, 0x06}, { 7000, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11300, 0x0c}, {12700, 0x0c}, {14000, 0x0c},
    {24000, 0x0e} }, /* 8bpp */
  { { 2200, 0x06}, { 3400, 0x06}, { 4200, 0x0a}, { 5500, 0x0a}, 
    { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 15bpp */
  { { 2200, 0x06}, { 3400, 0x06}, { 4200, 0x0a}, { 5500, 0x0a}, 
    { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 16bpp */
  { { 2000, 0x08}, { 3400, 0x0a}, { 3800, 0x0a}, { 4200, 0x0a}, 
    { 4500, 0x0c}, { 5200, 0x28}, {24000, 0x2a} }, /* 24bpp */
  { { 3000, 0x0a}, { 3500, 0x0e}, { 4200, 0x0e}, {24000, 0x2a} } /* 32bpp */
};

static mach64FIFOTable VTA3_PSEUDO_1M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] = 
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} },
  { { 3000, 0x04}, { 3800, 0x04}, { 4800, 0x06}, { 5400, 0x06}, 
    { 6800, 0x0a}, { 7700, 0x0a}, { 9000, 0x0a}, {11100, 0x0c},
    {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3300, 0x0a}, { 4400, 0x0a},
    { 4800, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3300, 0x0a}, { 4400, 0x0a},
    { 4800, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} },
  { { 2200, 0x0a}, { 3000, 0x0a}, { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x0c} }
};

static mach64FIFOTable VTA3_PSEUDO_2M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] = 
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 4600, 0x04}, { 5600, 0x06}, { 7000, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11100, 0x0c}, {13000, 0x0c}, {14000, 0x0c},
    {24000, 0x0e} },
  { { 2200, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5100, 0x0a},
    { 5500, 0x0c}, { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e},
    { 7900, 0x0e}, {11100, 0x0e}, {24000, 0x0e} },
  { { 2200, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5100, 0x0a},
    { 5500, 0x0c}, { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e},
    { 7900, 0x0e}, {11100, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 3400, 0x0a}, { 3800, 0x0a}, { 4100, 0x0a},
    { 4500, 0x0c}, { 5200, 0x0e}, { 5700, 0x2a}, { 6800, 0x2a},
    {24000, 0x2a} },
  { { 3000, 0x0a}, { 3500, 0x0e}, { 4200, 0x0e}, { 4600, 0x2a},
    { 5200, 0x2a}, {24000, 0x2a} }
};

static mach64FIFOTable VTA3_DRAM_1M_5200[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4000, 0x02}, { 5200, 0x04}, { 9000, 0x06}, {24000, 0x0a} },
  { { 2300, 0x02}, { 3800, 0x04}, { 5200, 0x06}, { 7800, 0x0a},
    { 8500, 0x0c}, {24000, 0x0e} },
  { { 1500, 0x04}, { 3000, 0x06}, { 3500, 0x08}, { 3800, 0x0a},
    { 4000, 0x0c}, { 4500, 0x0e}, {24000, 0x2e} }, 
  { { 1500, 0x04}, { 3000, 0x06}, { 3500, 0x08}, { 3800, 0x0a},
    { 4000, 0x0c}, { 4500, 0x0e}, {24000, 0x2e} },
  { { 1500, 0x06}, { 2200, 0x0a}, { 3000, 0x0c}, {24000, 0x0e} },
  { {24000, 0x0c} }
};

static mach64FIFOTable VTA3_DRAM_2M_5200[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x02}, { 8200, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 3000, 0x02}, { 4600, 0x04}, { 6000, 0x06}, { 7600, 0x08},
    { 9000, 0x0a}, {10200, 0x0c}, {12200, 0x0e}, {24000, 0x0e} },
  { { 1500, 0x02}, { 2300, 0x04}, { 3000, 0x06}, { 3800, 0x08},
    { 4600, 0x0a}, { 5200, 0x0c}, { 7400, 0x28}, {24000, 0x0e} },
  { { 1500, 0x02}, { 2300, 0x04}, { 3000, 0x06}, { 3800, 0x08},
    { 4600, 0x0a}, { 5200, 0x0c}, { 7400, 0x28}, {24000, 0x0e} },
  { { 1500, 0x06}, { 2300, 0x08}, { 3000, 0x0a}, { 3300, 0x0c}, 
    { 3800, 0x0c}, { 4300, 0x0c}, { 4600, 0x0e}, {24000, 0x2c} },
  { { 1500, 0x06}, { 2300, 0x0a}, { 3400, 0x0c}, {24000, 0x2c} }
};

static mach64FIFOTable VTA3_DRAM_1M_5600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x04}, { 7900, 0x06}, {24000, 0x0a} },
  { { 3800, 0x04}, { 5400, 0x06}, { 5800, 0x08}, { 7800, 0x0a},
    { 8500, 0x0c}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3400, 0x08}, { 3800, 0x0a},
    { 4400, 0x0c}, { 5000, 0x0e}, {24000, 0x2c} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3400, 0x08}, { 3800, 0x0a},
    { 4400, 0x0c}, { 5000, 0x0e}, {24000, 0x2c} },
  { { 2000, 0x0a}, { 3000, 0x0a}, { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x06} }
};

static mach64FIFOTable VTA3_DRAM_2M_5600[MAX_CDEPTH][MAX_DOTCLOCKS]=
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 4600, 0x04}, { 5600, 0x06}, { 6600, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11200, 0x0c}, {14000, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5500, 0x0a},
    { 5800, 0x0c}, { 7000, 0x0e}, { 7900, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5200, 0x0a},
    { 5800, 0x0c}, { 7000, 0x0e}, { 7900, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5200, 0x0a},
    { 5800, 0x0c}, { 7000, 0x0e}, { 7900, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x0a}, { 3500, 0x0c}, { 3800, 0x0c}, { 4200, 0x0e},
    {24000, 0x2c} }
};

static mach64FIFOTable VTA4_SDRAM_1M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 3600, 0x04}, { 4400, 0x06}, { 5500, 0x06}, { 6800, 0x06},
    { 8100, 0x08}, { 9000, 0x08}, {10500, 0x0a}, {11500, 0x0c},
    {12600, 0x0c}, {24000, 0x0c} }, /* 8bpp */
  { { 2200, 0x06}, { 2600, 0x06}, { 3000, 0x06}, { 3400, 0x06}, 
    { 3700, 0x08}, { 3800, 0x08}, { 4400, 0x0a}, { 4900, 0x0c}, 
    { 5100, 0x0c}, { 5800, 0x0c}, { 6800, 0x0e}, {24000, 0x0e} }, /* 15bpp*/
  { { 2200, 0x06}, { 2600, 0x06}, { 3000, 0x06}, { 3400, 0x06}, 
    { 3700, 0x08}, { 3800, 0x08}, { 4400, 0x0a}, { 4900, 0x0c},
    { 5100, 0x0c}, { 5800, 0x0c}, { 6800, 0x0e}, {24000, 0x0e} }, /* 16bpp*/
  { { 2200, 0x08}, { 2600, 0x08}, { 3300, 0x0a}, { 3600, 0x0c},
    { 4000, 0x0e}, { 4500, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} }, /* 24bpp */
  { {24000, 0x08} } /* 32bpp */
};

static mach64FIFOTable VTA4_SDRAM_2M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4400, 0x04}, { 9400, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 3700, 0x04}, { 4000, 0x04}, { 5700, 0x06}, { 7900, 0x08},
    { 8100, 0x08}, { 9400, 0x08}, {11200, 0x0c}, {13200, 0x0e},
    {13600, 0x0e}, {24000, 0x0e} }, /* 8bpp */
  { { 2200, 0x06}, { 2600, 0x06}, { 3700, 0x08}, { 4200, 0x08},
    { 4600, 0x0a}, { 5000, 0x0c}, { 5700, 0x0c}, { 6400, 0x0c},
    { 6800, 0x0e}, { 7900, 0x0e}, { 8100, 0x0e}, {10000, 0x0e},
    {11000, 0x0e}, {24000, 0x0e} }, /* 15bpp */
  { { 2200, 0x06}, { 2600, 0x06}, { 3700, 0x08}, { 4200, 0x08},
    { 4600, 0x0a}, { 5000, 0x0c}, { 5700, 0x0c}, { 6400, 0x0c},
    { 6800, 0x0e}, { 7900, 0x0e}, { 8100, 0x0e}, {10000, 0x0e},
    {11000, 0x0e}, {24000, 0x0e} }, /* 16bpp */
  { { 2200, 0x0a}, { 2600, 0x0a}, { 3800, 0x0c}, { 4000, 0x0c},
    { 4500, 0x28}, { 5000, 0x2c}, { 5100, 0x2c}, { 5700, 0x2c},
    { 7500, 0x2c}, {24000, 0x2c} }, /* 24bpp */
  { { 2200, 0x0a}, { 2600, 0x0c}, { 3000, 0x0c}, { 3300, 0x0e},
    { 3400, 0x0e}, { 3800, 0x0e}, { 4000, 0x0e}, { 5000, 0x0e},
    { 5700, 0x0e}, { 6800, 0x0e}, {24000, 0x0e} } /* 32bpp */
};

static mach64FIFOTable VTA4_SDRAM_1M_6300_5[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x08} },
  { { 3800, 0x04}, { 4400, 0x06}, { 6600, 0x06}, { 9000, 0x08},
    {24000, 0x0a} },
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, { 6900, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, { 6900, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 2600, 0x0a}, { 3400, 0x0c}, { 4200, 0x0e},
    { 4600, 0x0e}, {24000, 0x0e} },
  { {24000, 0x06} }
};

static mach64FIFOTable VTA4_SDRAM_2M_6300_5[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4400, 0x04}, { 9400, 0x06}, {24000, 0x08} },
  { { 3000, 0x04}, { 4000, 0x06}, { 6000, 0x08}, { 9400, 0x0a},
    {10000, 0x0c}, {11200, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x06}, { 3500, 0x08}, { 4400, 0x0a}, { 6400, 0x0e},
    { 6800, 0x0e}, { 8200, 0x0e}, {10100, 0x0e}, {11100, 0x0e},
    {13100, 0x0e}, {13600, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x06}, { 3500, 0x08}, { 4400, 0x0a}, { 6400, 0x0e},
    { 6800, 0x0e}, { 8200, 0x0e}, {10100, 0x0e}, {11100, 0x0e},
    {13100, 0x0e}, {13600, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x0a}, { 4200, 0x0c}, { 4500, 0x28}, { 5200, 0x2c},
    { 5700, 0x2c}, { 6600, 0x2c}, { 6800, 0x2c}, { 7600, 0x2c},
    { 8200, 0x2c}, {10100, 0x2c}, {11100, 0x2c}, {12200, 0x2c},
    {24000, 0x2c} },
  { { 2000, 0x0a}, { 3000, 0x0c}, { 3400, 0x0e}, { 4100, 0x2e},
    { 4600, 0x2e}, { 5200, 0x2e}, { 5700, 0x2e}, { 6600, 0x2e},
    { 7000, 0x2e}, { 7600, 0x2e}, { 7900, 0x2e}, { 8200, 0x2e},
    {24000, 0x2e} }
};

static mach64FIFOTable VTA4_SDRAM_1M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 3600, 0x04}, { 4400, 0x06}, { 5800, 0x06}, { 7500, 0x06}, 
    { 8200, 0x08}, {11000, 0x0a}, {24000,0x0a}}, /* 8bpp */
  { { 2600, 0x06}, { 3200, 0x06}, { 3600, 0x08}, { 4000, 0x0a},
    { 4500, 0x0c}, { 5800, 0x0c}, { 8000, 0x0e}, {24000, 0x0e} }, /* 15bpp */
  { { 2600, 0x06}, { 3200, 0x06}, { 3600, 0x08}, { 4000, 0x0a},
    { 4500, 0x0c}, { 5800, 0x0c}, { 8000, 0x0e}, {24000, 0x0e} }, /* 16bpp */
  { { 2000, 0x08}, { 2600, 0x08}, { 3200, 0x0a}, { 3700, 0x0c},
    { 4200, 0x0c}, { 4600, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} }, /* 24bpp */
  { {24000, 0x06} } /* 32bpp */
};

static mach64FIFOTable VTA4_SDRAM_2M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4400, 0x04}, { 9400, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 4000, 0x04}, { 5800, 0x06}, { 8200, 0x08}, {10000, 0x0a},
    {11200, 0x0c}, {12200, 0x0e}, {13500, 0x0e}, {24000, 0x0e} }, /* 8bpp */
  { { 2600, 0x06}, { 4000, 0x08}, { 5100, 0x0a}, { 5800, 0x0c},
    { 6800, 0x0e}, { 8100, 0x0e}, {10000, 0x0e}, { 1100, 0x0e},
    {12200, 0x0e}, {12600, 0x0e}, {13500, 0x0e}, {24000, 0x0e} }, /* 15bpp */
  { { 2600, 0x06}, { 4000, 0x08}, { 5100, 0x0a}, { 5800, 0x0c},
    { 6800, 0x0e}, { 8100, 0x0e}, {10000, 0x0e},  {1100, 0x0e}, 
    {12200, 0x0e}, {12600, 0x0e}, {13500, 0x0e}, {24000, 0x0e} }, /* 16bpp */
  { { 2600, 0x0a}, { 4000, 0x0c}, { 4500, 0x28}, { 5200, 0x2c},
    { 5700, 0x2c}, { 6600, 0x2c}, { 6800, 0x2c}, { 7600, 0x2c},
    { 8200, 0x2c}, {10100, 0x2c}, {11100, 0x2c}, {12600, 0x2c},
    {24000, 0x2c} }, /* 24bpp */
  { { 2600, 0x0a}, { 3600, 0x0e}, { 4000, 0x0e}, { 4500, 0x2e},
    { 5200, 0x2e}, { 5700, 0x2e}, { 6600, 0x2e}, { 6800, 0x2e},
    { 7600, 0x2e}, { 8200, 0x2e}, {24000, 0x2e} } /* 32bpp */
};

static mach64FIFOTable VTA4_SDRAM_1M_6700[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, { 8000, 0x08},
    {24000, 0x08} },
  { { 3800, 0x04}, { 4400, 0x06}, { 7800, 0x06}, { 9000, 0x08},
    {24000, 0x0a}},
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0c} },
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0c} },
  { { 2000, 0x06}, { 2600, 0x06}, { 3400, 0x0a}, { 4100, 0x0c},
    {24000, 0x0e} },
  { {24000, 0x06} }
};

static mach64FIFOTable VTA4_SDRAM_2M_6700[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x04}, { 9400, 0x06}, {11200, 0x08}, {24000, 0x08} },
  { { 4400, 0x04}, { 6600, 0x06}, { 9400, 0x08}, {10000, 0x0a},
    {11200, 0x0c}, {14000, 0x0c}, {24000, 0x0c}},
  { { 3400, 0x06}, { 4200, 0x08}, { 5400, 0x0a}, { 6600, 0x0c},
    { 8000, 0x0e}, {24000, 0x0e} },
  { { 3400, 0x06}, { 4200, 0x08}, { 5400, 0x0a}, { 6600, 0x0c},
    { 8000, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 3000, 0x08}, { 3300, 0x0a}, { 4200, 0x0c},
    { 4600, 0x0c}, {24000, 0x2c} },
  { { 3000, 0x0a}, { 3400, 0x0c}, { 3800, 0x0e}, { 5200, 0x0e} }
};

static mach64FIFOTable VTA4_EDO_1M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} },
  { { 3000, 0x04}, { 3800, 0x04}, { 4800, 0x06}, { 5400, 0x06}, 
    { 6800, 0x0a}, { 7700, 0x0a}, { 9000, 0x0a}, {11000, 0x0c}, 
    {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3300, 0x0a}, { 4400, 0x0a}, 
    { 4800, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3300, 0x0a}, { 4400, 0x0a}, 
    { 4800, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} },
  { { 2200, 0x0a}, { 3000, 0x0a}, { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x0c} }
};

static mach64FIFOTable VTA4_EDO_2M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 4600, 0x04}, { 5600, 0x06}, { 7000, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11100, 0x0c}, {13000, 0x0c}, {14000, 0x0c},
    {24000,0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5100, 0x0a}, 
    { 5500, 0x0c}, { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e},
    { 7900, 0x0e}, {11100, 0x0e}, {24000, 0x0e} },          
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5100, 0x0a}, 
    { 5500, 0x0c}, { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e},
    { 7900, 0x0e}, {11100, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 3400, 0x0a}, { 3800, 0x0a}, { 4100, 0x0a},
    { 4500, 0x0c}, { 5200, 0x0e}, { 5700, 0x2a}, { 6800, 0x2a},
    {24000, 0x2a} },
  { { 3000, 0x0a}, { 3500, 0x0e}, { 4200, 0x0e}, { 4600, 0x2a},
    { 5200, 0x2a}, {24000, 0x2a} }
};

static mach64FIFOTable VTA4_EDO_1M_6700_6[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} },
  { { 3000, 0x04}, { 3800, 0x04}, { 5400, 0x06}, { 7700, 0x0a},
    { 9000, 0x0a}, {10500, 0x0c}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 4800, 0x0c}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 4800, 0x0c}, {24000, 0x0e} },
  { { 2000, 0x0a}, { 3000, 0x0a}, { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x06} }
};

static mach64FIFOTable VTA4_EDO_2M_6700_6[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 4600, 0x04}, { 5600, 0x06}, { 7000, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11300, 0x0c}, {14000, 0x0c}, {24000, 0x0e}},
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5500, 0x0a},
    { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5500, 0x0a},
    { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 3400, 0x0a}, { 3800, 0x0a}, { 4200, 0x0a},
    { 4500, 0x0c}, { 5200, 0x0c}, {24000, 0x2c} },
  { { 2000, 0x0a}, { 3000, 0x0a}, { 3500, 0x0c}, { 4200, 0x0e},
    {24000, 0x2a} }
};

static mach64FIFOTable VTA4_EDO_1M_6700_7[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4200, 0x04}, { 6400, 0x06}, { 9000, 0x0a}, {24000, 0x0c} },
  { { 3800, 0x08}, { 6400, 0x0a}, { 7000, 0x0c}, { 9000, 0x0c},
    {24000, 0x0c} },
  { { 3800, 0x0a}, { 4800, 0x0c}, { 5600, 0x0e}, {24000, 0x0e} },
  { { 3800, 0x0a}, { 4800, 0x0c}, { 5600, 0x0e}, {24000, 0x0e} },
  { { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x06} }
};

static mach64FIFOTable VTA4_EDO_2M_6700_7[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x02}, { 7000, 0x04}, {10200, 0x06}, {24000, 0x0a} },
  { { 5200, 0x06}, { 6400, 0x08}, { 7000, 0x0a}, { 7900, 0x0c},
    { 8200, 0x0c}, {10800, 0x0c}, {13000, 0x0c}, {24000, 0x0c} },
  { { 3000, 0x06}, { 3800, 0x08}, { 4200, 0x0a}, { 5200, 0x0a}, 
    { 6600, 0x0c}, { 7600, 0x0c}, { 8200, 0x0c}, {24000, 0x0e} },
  { { 3000, 0x06}, { 3800, 0x08}, { 4200, 0x0a}, { 5200, 0x0c},
    { 6600, 0x0c}, { 7600, 0x0c}, { 8200, 0x0c}, {24000, 0x0e} },
  { { 3000, 0x0a}, { 3400, 0x0a}, { 3600, 0x0a}, { 4400, 0x0c},
    { 5200, 0x0c} },
  { { 3400, 0x0c}, { 5200, 0x0c} } 
};

static mach64FIFOTable VTA4_PSEUDO_1M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] = 
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} },
  { { 3000, 0x04}, { 3800, 0x04}, { 4000, 0x06}, { 5400, 0x06}, 
    { 7700, 0x0a}, { 8000, 0x0a}, { 9000, 0x0a}, {10500, 0x0c},
    {12000, 0x0c}, {12400, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3700, 0x0a}, { 4400, 0x0a}, 
    { 4800, 0x0e}, { 5200, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3700, 0x0a}, { 4400, 0x0a}, 
    { 4800, 0x0e}, { 5200, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} },
  { { 2200, 0x0a}, { 3000, 0x0a}, { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x0c} } };

static mach64FIFOTable VTA4_PSEUDO_2M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] = 
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 2000, 0x04}, { 3800, 0x04}, { 4600, 0x04}, { 5600, 0x06},
    { 7000, 0x06}, { 9400, 0x08}, {10000, 0x0a}, {11300, 0x0c}, 
    {12700, 0x0c}, {14000, 0x0c}, {24000, 0x0e} }, /* 8bpp */
  { { 2200, 0x06}, { 3400, 0x06}, { 3700, 0x08}, { 4200, 0x0a},
    { 4500, 0x0a}, { 5500, 0x0a}, { 6600, 0x0c}, { 7000, 0x0c}, 
    { 7600, 0x0e}, { 7900, 0x0e}, { 9000, 0x0e}, {10500, 0x0e}, 
    {11500, 0x0e}, {24000, 0x0e} }, /* 15bpp */
  { { 2200, 0x06}, { 3400, 0x06}, { 3700, 0x08}, { 4200, 0x0a},
    { 4500, 0x0a}, { 5500, 0x0a}, { 6600, 0x0c}, { 7000, 0x0c},
    { 7600, 0x0e}, { 7900, 0x0e}, { 9000, 0x0e}, {10500, 0x0e}, 
    {11500, 0x0e}, {24000, 0x0e} }, /* 16bpp */
  { { 2000, 0x08}, { 3400, 0x0a}, { 3800, 0x0a}, { 4200, 0x0a}, 
    { 4500, 0x0c}, { 5200, 0x28}, { 6000, 0x2a}, { 6600, 0x2a}, 
    { 7000, 0x2a}, { 7900, 0x2a}, {24000, 0x2a} }, /* 24bpp */
  { { 2000, 0x0a}, { 3000, 0x0a}, { 3500, 0x0e}, { 3700, 0x0e},
    { 4200, 0x0e}, { 4500, 0x2a}, { 5100, 0x2a}, { 5600, 0x2a},
    {24000, 0x2a} } /* 32bpp */
};

static mach64FIFOTable VTA4_PSEUDO_1M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] = 
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} },
  { { 3000, 0x04}, { 3800, 0x04}, { 4800, 0x06}, { 5400, 0x06}, 
    { 6800, 0x0a}, { 7700, 0x0a}, { 9000, 0x0a}, {11100, 0x0c},
    {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3300, 0x0a}, { 4400, 0x0a},
    { 4800, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3300, 0x0a}, { 4400, 0x0a},
    { 4800, 0x0e}, { 5500, 0x0e}, {24000, 0x0e} },
  { { 2200, 0x0a}, { 3000, 0x0a}, { 3400, 0x0c}, {24000, 0x0e} },
  { {24000, 0x0c} }
};

static mach64FIFOTable VTA4_PSEUDO_2M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] = 
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 4600, 0x04}, { 5600, 0x06}, { 7000, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11100, 0x0c}, {13000, 0x0c}, {14000, 0x0c},
    {24000, 0x0e} },
  { { 2200, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5100, 0x0a},
    { 5500, 0x0c}, { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e},
    { 7900, 0x0e}, {11100, 0x0e}, {24000, 0x0e} },
  { { 2200, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5100, 0x0a},
    { 5500, 0x0c}, { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e},
    { 7900, 0x0e}, {11100, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x08}, { 3400, 0x0a}, { 3800, 0x0a}, { 4100, 0x0a},
    { 4500, 0x0c}, { 5200, 0x0e}, { 5700, 0x2a}, { 6800, 0x2a},
    {24000, 0x2a} },
  { { 3000, 0x0a}, { 3500, 0x0e}, { 4200, 0x0e}, { 4600, 0x2a},
    { 5200, 0x2a}, {24000, 0x2a} }
};

static mach64FIFOTable VTA4_DRAM_1M_5200[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4000, 0x02}, { 5200, 0x04}, { 9000, 0x06}, {24000, 0x0a} },
  { { 2300, 0x02}, { 3800, 0x04}, { 5200, 0x06}, { 7800, 0x0a},
    { 8500, 0x0c}, {24000, 0x0e} },
  { { 1500, 0x04}, { 3000, 0x06}, { 3500, 0x08}, { 3800, 0x0a},
    { 4000, 0x0c}, { 4500, 0x0e}, {24000, 0x2e} }, 
  { { 1500, 0x04}, { 3000, 0x06}, { 3500, 0x08}, { 3800, 0x0a},
    { 4000, 0x0c}, { 4500, 0x0e}, {24000, 0x2e} },
  { { 1500, 0x06}, { 2200, 0x0a}, { 3000, 0x0c}, {24000, 0x0e} },
  { {24000, 0x0c} }
};

static mach64FIFOTable VTA4_DRAM_2M_5200[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x02}, { 8200, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 3000, 0x02}, { 4600, 0x04}, { 6000, 0x06}, { 7600, 0x08},
    { 9000, 0x0a}, {10200, 0x0c}, {12200, 0x0e}, {24000, 0x0e} },
  { { 1500, 0x02}, { 2300, 0x04}, { 3000, 0x06}, { 3800, 0x08},
    { 4600, 0x0a}, { 5200, 0x0c}, { 7400, 0x28}, {24000, 0x0e} },
  { { 1500, 0x02}, { 2300, 0x04}, { 3000, 0x06}, { 3800, 0x08},
    { 4600, 0x0a}, { 5200, 0x0c}, { 7400, 0x28}, {24000, 0x0e} },
  { { 1500, 0x06}, { 2300, 0x08}, { 3000, 0x0a}, { 3300, 0x0c}, 
    { 3800, 0x0c}, { 4300, 0x0c}, { 4600, 0x0e}, {24000, 0x2c} },
  { { 1500, 0x06}, { 2300, 0x0a}, { 3400, 0x0c}, {24000, 0x2c} }
};

static mach64FIFOTable VTA4_DRAM_1M_5600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x04}, { 7900, 0x06}, {24000, 0x0a} },
  { { 3800, 0x04}, { 5400, 0x06}, { 5800, 0x08}, { 7800, 0x0a},
    { 8500, 0x0c}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3400, 0x08}, 
    { 4400, 0x0c}, { 5000, 0x0e}, {24000, 0x2c} },
  { { 2000, 0x06}, { 3000, 0x06}, { 3400, 0x08}, 
    { 4400, 0x0c}, { 5000, 0x0e}, {24000, 0x2c} },
  { { 2000, 0x0a}, { 3000, 0x0a}, {24000, 0x0e} },
  { {24000, 0x06} }
};

static mach64FIFOTable VTA4_DRAM_2M_5600[MAX_CDEPTH][MAX_DOTCLOCKS]=
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} },
  { { 3400, 0x04}, { 4600, 0x04}, { 6600, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11200, 0x0c}, {14000, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5500, 0x0a},
    { 5800, 0x0c}, { 7000, 0x0e}, { 7900, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5200, 0x0a},
    { 5800, 0x0c}, { 7000, 0x0e}, { 7900, 0x0e}, {24000, 0x0e} },
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5200, 0x0a},
    { 5800, 0x0c}, { 7000, 0x0e}, { 7900, 0x0e}, {24000, 0x0e} },
  { { 3000, 0x0a}, { 3500, 0x0c}, { 3800, 0x0c}, { 4200, 0x0e},
    {24000, 0x2c} }
};

/* This is the CT-D fifo table                                       */
/* The datum were taken from the ct$9d-*.drm files                   */
/*-------------------------------------------------------------------*/

/* The following two tables are extracted from CT9D-46.DRM           */
static mach64FIFOTable CTD_DRAM_2M_4600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3900, 0x04}, { 4700, 0x05}, { 5500, 0x06}, { 6300, 0x07},
    { 7100, 0x08}, { 7900, 0x09}, { 8700, 0x0a}, { 9500, 0x0b},
    {10300, 0x0c}, {11100, 0x0d}, {11900, 0x0e}, {14000, 0x0f},
    {24000, 0x1f} }, /* 4bpp */
  { { 4000, 0x04}, { 4700, 0x05}, { 5700, 0x06}, { 7600, 0x07},
    { 8000, 0x08}, { 8200, 0x09}, {10100, 0x0b}, {11100, 0x0d},
    {12700, 0x0f}, {24000, 0x10} }, /* 8bpp */
  { { 3300, 0x06}, { 4100, 0x08}, { 4600, 0x09}, { 5200, 0x0b},
    { 6600, 0x0f}, { 7900, 0x10}, { 8200, 0x13}, {24000, 0x1f} }, /* 15bpp */
  { { 3300, 0x06}, { 4100, 0x08}, { 4600, 0x09}, { 5200, 0x0b},
    { 6600, 0x0f}, { 7900, 0x10}, { 8200, 0x13}, {24000, 0x1f} }, /* 16bpp */
  { { 2700, 0x09}, { 3300, 0x0b}, { 4300, 0x0e}, { 4600, 0x10},
    { 5200, 0x12}, { 5700, 0x15}, {24000, 0x1f} }, /* 24bpp */
  { { 2600, 0x0b}, { 3300, 0x0f}, { 4100, 0x13}, { 4600, 0x15},
    {24000, 0x1f} } /* 32bpp */
};

static mach64FIFOTable CTD_DRAM_1M_4600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3100, 0x04}, { 3800, 0x05}, { 4400, 0x06}, { 5100, 0x07},
    { 5700, 0x08}, { 6300, 0x09}, { 7000, 0x0a}, { 7600, 0x0b},
    { 8300, 0x0c}, { 8900, 0x0d}, { 9500, 0x0e}, {14000, 0x0f},
    {24000, 0x1f} }, /* 4bpp */
  { { 4100, 0x04}, { 4600, 0x05}, { 5200, 0x06}, { 5700, 0x07},
    { 7600, 0x09}, { 7900, 0x0a}, { 8200, 0x0b}, {24000, 0x1f} }, /* 8bpp*/
  { { 2800, 0x08}, { 3300, 0x09}, { 4100, 0x0b}, { 4600, 0x0c},
    {24000, 0x1f} }, /* 15bpp */
  { { 2800, 0x08}, { 3300, 0x09}, { 4100, 0x0b}, { 4600, 0x0c},
    {24000, 0x1f} }, /* 15bpp */
  { { 2500, 0x0d}, { 2700, 0x0e}, { 3300, 0x1c}, {24000, 0x1f} }, /* 24bpp */
  { {24000, 0x1f} } /* 32bpp */
};


/* The following four tables are extracted from CT9D-51.DRM           */
/* The tables CTD_.._4900 are created to cater for the DRAM Memory    */
/* Clock that is less than 49MHz.                                     */
/* Also some alternation is needed (in the function) to cater for the */
/* condition of 1M, DRAM Memory Clock between 50MHz and 49MHz with 15 */
/* and 16bpp                                                          */
static mach64FIFOTable CTD_DRAM_2M_5100[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x04}, { 4700, 0x05}, { 5700, 0x06}, { 6700, 0x07},
    { 7600, 0x08}, { 8600, 0x09}, { 9500, 0x0a}, {10500, 0x0b},
    {11500, 0x0c}, {12400, 0x0d}, {13400, 0x0e}, {14000, 0x0f},
    {24000, 0x1f} },  /* 4bpp */
  { { 3800, 0x04}, { 4700, 0x05}, { 5700, 0x06}, { 6700, 0x07},
    { 7600, 0x08}, { 8600, 0x09}, { 9500, 0x0a}, {10500, 0x0b},
    {11500, 0x0c}, {12400, 0x0d}, {13400, 0x0e}, {14000, 0x0f},
    {24000, 0x1f} },  /* 8bpp */
  { { 2600, 0x05}, { 3100, 0x06}, { 3700, 0x07}, { 4200, 0x08},
    { 4700, 0x09}, { 5300, 0x0a}, { 5500, 0x0b}, { 6300, 0x0c},
    { 6600, 0x0d}, { 7400, 0x0e}, { 7900, 0x0f}, { 9000, 0x11},
    {24000, 0x1f} },  /* 15bpp */
  { { 2600, 0x05}, { 3100, 0x06}, { 3700, 0x07}, { 4200, 0x08},
    { 4700, 0x09}, { 5300, 0x0a}, { 5500, 0x0b}, { 6300, 0x0c},
    { 6600, 0x0d}, { 7400, 0x0e}, { 7900, 0x0f}, { 9000, 0x11},
    {24000, 0x1f} },  /* 16bpp */
  { { 2500, 0x09}, { 2900, 0x0a}, { 3300, 0x0b}, { 3600, 0x0c},
    { 4000, 0x0d}, { 4400, 0x0e}, { 4700, 0x10}, { 5100, 0x11},
    { 6500, 0x15}, { 7000, 0x16}, {24000, 0x1f} },  /* 24bpp */
  { { 2500, 0x0b}, { 2800, 0x0c}, { 3000, 0x0d}, { 3200, 0x0e},
    { 4000, 0x12}, { 4600, 0x13}, { 5200, 0x16}, {24000, 0x1f} } /* 32bpp*/
};

static mach64FIFOTable CTD_DRAM_1M_5100[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3500, 0x04}, { 4300, 0x05}, { 5000, 0x06}, { 5700, 0x07},
    { 6400, 0x08}, { 7100, 0x09}, { 7900, 0x0a}, { 8600, 0x0b},
    { 9300, 0x0c}, {10000, 0x0d}, {10700, 0x0e}, {14000, 0x0f},
    {24000, 0x1f} }, /* 4bpp */
  { { 3500, 0x04}, { 4300, 0x05}, { 5000, 0x06}, { 5700, 0x07},
    { 6400, 0x08}, { 7100, 0x09}, { 7900, 0x0a}, { 8600, 0x0b},
    { 9300, 0x0c}, {10000, 0x0d}, {11000, 0x1d}, {24000, 0x1f} }, /* 8bpp */
  { { 2700, 0x07}, { 3100, 0x08}, { 3500, 0x09}, { 3900, 0x0a},
    { 4300, 0x0b}, { 4700, 0x0c}, { 5100, 0x0d}, { 5500, 0x0e},
    {14000, 0x0f}, {24000, 0x1f} },  /* 15bpp */
  { { 2700, 0x07}, { 3100, 0x08}, { 3500, 0x09}, { 3900, 0x0a},
    { 4300, 0x0b}, { 4700, 0x0c}, { 5100, 0x0d}, { 5500, 0x0e},
    {14000, 0x0f}, {24000, 0x1f} },  /* 16bpp */
  { { 2700, 0x0a}, { 3000, 0x0b}, { 3500, 0x0d}, { 3800, 0x0e},
    { 8000, 0x0f}, {24000, 0x1f} },  /* 24bpp */
  { {24000, 0x0f} } /* 32bpp */
};

static mach64FIFOTable CTD_DRAM_2M_4900[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x04}, { 4700, 0x05}, { 5700, 0x06}, { 6700, 0x07},
    { 7600, 0x08}, { 8600, 0x09}, { 9500, 0x0a}, {10500, 0x0b},
    {11500, 0x0c}, {12400, 0x0d}, {13400, 0x0e}, {14000, 0x0f},
    {24000, 0x1f} },  /* 4bpp */
  { { 3800, 0x04}, { 4700, 0x05}, { 5700, 0x06}, { 6700, 0x07},
    { 7600, 0x08}, { 8600, 0x09}, { 9500, 0x0a}, {10500, 0x0b},
    {11500, 0x0c}, {14000, 0x0f}, {24000, 0x1f} },  /* 8bpp */
  { { 2600, 0x05}, { 3100, 0x06}, { 3700, 0x07}, { 4200, 0x08},
    { 4700, 0x09}, { 5200, 0x0b}, { 5500, 0x0c}, { 6600, 0x0d},
    { 7900, 0x0f}, { 9000, 0x12}, {24000, 0x1f} },  /* 15bpp */
  { { 2600, 0x05}, { 3100, 0x06}, { 3700, 0x07}, { 4200, 0x08},
    { 4700, 0x09}, { 5200, 0x0b}, { 5500, 0x0c}, { 6600, 0x0d},
    { 7900, 0x0f}, { 9000, 0x12}, {24000, 0x1f} },  /* 16bpp */
  { { 2500, 0x09}, { 2900, 0x0a}, { 3300, 0x0b}, { 3600, 0x0c},
    { 4000, 0x0d}, { 4400, 0x0e}, { 4700, 0x10}, { 5100, 0x11},
    { 6500, 0x15}, { 7000, 0x16}, {24000, 0x1f} },  /* 24bpp */
  { { 2500, 0x0b}, { 2800, 0x0c}, { 3000, 0x0d}, { 3200, 0x0e},
    { 4000, 0x12}, { 4600, 0x15}, {24000, 0x1f} } /* 32bpp */
};

static mach64FIFOTable CTD_DRAM_1M_4900[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3500, 0x04}, { 4300, 0x05}, { 5000, 0x06}, { 5700, 0x07},
    { 6400, 0x08}, { 7100, 0x09}, { 7900, 0x0a}, { 8600, 0x0b},
    { 9300, 0x0c}, {10000, 0x0d}, {10700, 0x0e}, {14000, 0x0f},
    {24000, 0x1f} }, /* 4bpp */
  { { 3500, 0x04}, { 4300, 0x05}, { 5000, 0x06}, { 5700, 0x07},
    { 6400, 0x08}, { 7100, 0x09}, { 7900, 0x0a}, { 8600, 0x0b},
    { 9300, 0x0c}, {10100, 0x13}, {24000, 0x1f} }, /* 8bpp */
  { { 2700, 0x07}, { 3100, 0x08}, { 3500, 0x09}, { 3900, 0x0a},
    { 4300, 0x0b}, { 4700, 0x0c}, { 5000, 0x12}, {24000, 0x1f} }, /* 15bpp */
  { { 2700, 0x07}, { 3100, 0x08}, { 3500, 0x09}, { 3900, 0x0a},
    { 4300, 0x0b}, { 4700, 0x0c}, { 5000, 0x12}, {24000, 0x1f} }, /* 16bpp */
  { { 2700, 0x0a}, { 3000, 0x0b}, { 3500, 0x0e}, {24000, 0x1f} }, /* 24bpp */
  { {24000, 0x0f} } /* 32bpp */
};

/* Fifo Table extracted from the file CT9D-54.DRM                        */
static mach64FIFOTable CTD_DRAM_2M_5400[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x04}, { 4700, 0x05}, { 5700, 0x06}, { 6700, 0x07},
    { 7600, 0x08}, { 8600, 0x09}, { 9500, 0x0a}, {10500, 0x0b},
    {11500, 0x0c}, {12400, 0x0d}, {13400, 0x0e}, {14000, 0x0e},
    {24000, 0x1f} },  /* 4bpp */
  { { 3800, 0x04}, { 4700, 0x05}, { 5700, 0x06}, { 6700, 0x07},
    { 7600, 0x08}, { 8600, 0x09}, { 9500, 0x0a}, {10500, 0x0b},
    {11500, 0x0c}, {12400, 0x0d}, {13400, 0x0e}, {14000, 0x0f},
    {24000, 0x1f} },  /* 8bpp */
  { { 2600, 0x05}, { 3100, 0x06}, { 3700, 0x07}, { 4200, 0x08},
    { 4700, 0x09}, { 5300, 0x0a}, { 5800, 0x0b}, { 6300, 0x0c},
    { 6900, 0x0d}, { 7400, 0x0e}, {14000, 0x0f}, {24000, 0x1f} },  /* 15bpp */
  { { 2600, 0x05}, { 3100, 0x06}, { 3700, 0x07}, { 4200, 0x08},
    { 4700, 0x09}, { 5300, 0x0a}, { 5800, 0x0b}, { 6300, 0x0c},
    { 6900, 0x0d}, { 7400, 0x0e}, {14000, 0x0f}, {24000, 0x1f} },  /* 16bpp */
  { { 2500, 0x08}, { 2900, 0x09}, { 3300, 0x0a}, { 3600, 0x0b},
    { 4000, 0x0c}, { 4400, 0x0d}, { 4700, 0x0e}, {14000, 0x1f},
    {24000, 0x1f} },  /* 24bpp */
  { { 2500, 0x0b}, { 2800, 0x0c}, { 3000, 0x0d}, { 3200, 0x0e},
    {14000, 0x0f}, {24000, 0x1f} } /* 32bpp */
};

static mach64FIFOTable CTD_DRAM_1M_5400[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3500, 0x04}, { 4300, 0x05}, { 5000, 0x06}, { 5700, 0x07}, 
    { 6400, 0x08}, { 7100, 0x09}, { 7900, 0x0a}, { 8600, 0x0b},
    { 9300, 0x0c}, {10000, 0x0d}, {10700, 0x0e}, {24000, 0x1f} }, /* 4bpp */
  { { 3500, 0x04}, { 4300, 0x05}, { 5000, 0x06}, { 5700, 0x07},
    { 6400, 0x08}, { 7100, 0x09}, { 7900, 0x0a}, { 8600, 0x0b},
    { 9300, 0x0c}, {10000, 0x0d}, {10700, 0x0e}, {24000, 0x1f} }, /* 8bpp */
  { { 2700, 0x07}, { 3100, 0x08}, { 3500, 0x09}, { 3900, 0x0a},
    { 4300, 0x0b}, { 4700, 0x0c}, { 5100, 0x0d}, { 5500, 0x0e},
    {24000, 0x1f} },  /* 15bpp */
  { { 2700, 0x07}, { 3100, 0x08}, { 3500, 0x09}, { 3900, 0x0a},
    { 4300, 0x0b}, { 4700, 0x0c}, { 5100, 0x0d}, { 5500, 0x0e},
    {24000, 0x1f} },  /* 16bpp */
  { { 2700, 0x0a}, { 3000, 0x0b}, { 3300, 0x0c}, { 3500, 0x0d},
    { 3800, 0x0e}, {24000, 0x0f} },  /* 24bpp */
  { {24000, 0x0f} }  /* 32bpp */
};

/* Fifo Table extracted from the file CT9D-56.DRM                        */
static mach64FIFOTable CTD_DRAM_2M_5600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4700, 0x04}, { 5700, 0x05}, { 6700, 0x06}, { 7600, 0x07},
    { 8600, 0x08}, { 9500, 0x09}, {10500, 0x0a}, {11500, 0x0b},
    {12400, 0x0c}, {13400, 0x0d}, {14000, 0x0e}, {24000, 0x1f} }, /* 4bpp */
  { { 4700, 0x04}, { 5700, 0x05}, { 6700, 0x06}, { 7600, 0x07},
    { 8600, 0x08}, { 9500, 0x09}, {10500, 0x0a}, {11500, 0x0b},
    {12400, 0x0c}, {13400, 0x0d}, {14000, 0x0e}, {24000, 0x1f} }, /* 8bpp */
  { { 2600, 0x05}, { 3100, 0x06}, { 3700, 0x07}, { 4200, 0x08},
    { 5300, 0x0a}, { 5800, 0x0b}, { 6300, 0x0c}, { 6900, 0x0d},
    { 7400, 0x0e}, { 9000, 0x0f}, {24000, 0x1f} },  /* 15bpp */
  { { 2600, 0x05}, { 3100, 0x06}, { 3700, 0x07}, { 4200, 0x08},
    { 5300, 0x0a}, { 5800, 0x0b}, { 6300, 0x0c}, { 6900, 0x0d},
    { 7400, 0x0e}, { 9000, 0x0f}, {24000, 0x1f} },  /* 16bpp */
  { { 2500, 0x07}, { 2900, 0x08}, { 3300, 0x09}, { 3600, 0x0a},
    { 4000, 0x0b}, { 4400, 0x0c}, { 4700, 0x0d}, { 5100, 0x0e},
    { 6500, 0x13}, { 7000, 0x14}, {24000, 0x1f} },  /* 24bpp */
  { { 3800, 0x0e}, { 4200, 0x0f}, { 5200, 0x14}, {24000, 0x1f} } /* 32bpp */
};

static mach64FIFOTable CTD_DRAM_1M_5600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3500, 0x04}, { 4300, 0x05}, { 5000, 0x06}, { 5700, 0x07},
    { 6400, 0x08}, { 7100, 0x09}, { 7900, 0x0a}, { 8600, 0x0b},
    { 9300, 0x0c}, {10000, 0x0d}, {10700, 0x0e}, {24000, 0x1f} },  /* 4bpp */
  { { 3500, 0x04}, { 4300, 0x05}, { 5000, 0x06}, { 5700, 0x07},
    { 6400, 0x08}, { 7100, 0x09}, { 7900, 0x0a}, { 8600, 0x0b},
    { 9300, 0x0c}, {10000, 0x0d}, {10700, 0x0e}, {24000, 0x0f} },  /* 8bpp */
  { { 2700, 0x06}, { 3100, 0x07}, { 3500, 0x08}, { 3900, 0x09},
    { 4300, 0x0a}, { 4700, 0x0b}, { 5100, 0x0c}, { 5500, 0x0d},
    { 5900, 0x0e}, {24000, 0x1f} },   /* 15bpp */
  { { 2700, 0x06}, { 3100, 0x07}, { 3500, 0x08}, { 3900, 0x09},
    { 4300, 0x0a}, { 4700, 0x0b}, { 5100, 0x0c}, { 5500, 0x0d},
    { 5900, 0x0e}, {24000, 0x1f} },   /* 16bpp */
  { { 2700, 0x09}, { 3000, 0x0a}, { 3300, 0x0b}, { 3500, 0x0c},
    { 3800, 0x0d}, { 4100, 0x0e}, {24000, 0x1f} },  /* 24bpp */
  { { 2500, 0x0b}, { 2700, 0x0c}, { 2900, 0x0d}, { 3100, 0x0e},
    {24000, 0x1f} }  /* 32bpp */
};

/* This is the GT-A2 fifo table                                      */
/* The datum were taken from the gt$9a-*.* files                     */
/*-------------------------------------------------------------------*/
/* The FIFO TABLE FOR SDRAM                                          */
/*-------------------------------------------------------------------*/
/* The fifo table for GT SDRAM  of 60MHz                             */
/* data was extracted from gt$9a-60.sdr                              */
/* table for 2M Ram                                                  */
static mach64FIFOTable GTA2_SDRAM_2M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4400, 0x04}, { 9400, 0x06}, {24000, 0x08} }, /* 4 bpp */
  { { 4000, 0x04}, { 6000, 0x06}, { 9400, 0x08}, {11200, 0x0c},
    {24000, 0x0e} },                               /* 8 bpp */
  { { 3000, 0x06}, { 4200, 0x08}, { 4600, 0x0a}, { 6400, 0x0c},
    {24000, 0x0e} },                               /* 565   */
  { { 3000, 0x06}, { 4200, 0x08}, { 4600, 0x0a}, { 6400, 0x0c},
    {24000, 0x0e} },                               /* 565   */
  { { 3000, 0x0a}, { 3800, 0x0c}, { 4200, 0x0c}, { 4500, 0x28},
    {24000, 0x2c} },                               /* 24bpp */
  { { 2000, 0x0a}, { 3000, 0x0c}, { 3400, 0x0e}, {24000, 0x0e} } /* 32bpp */
};

/* table for 1M Ram                                                  */
static mach64FIFOTable GTA2_SDRAM_1M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, { 8000, 0x08},
    {24000, 0x08} },                             /* 4 bpp */
  { { 3800, 0x04}, { 4400, 0x06}, { 6800, 0x06}, { 9000, 0x08},
    {10500, 0x0a}, {24000, 0x0c} },              /* 8 bpp */
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0e} },               /* 565   */
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0e} },               /* 565   */
  { { 2000, 0x08}, { 2600, 0x08}, { 3300, 0x0a}, { 3700, 0x0c},
    { 4100, 0x0e}, {24000, 0x0e} },               /* 24bpp */
  { {24000, 0x06} }                               /* 32bpp */
};

/* The fifo table for GT SDRAM of 63MHz                              */
/* data was extracted from gt$9a-63.sdr                              */
/* table for 2M Ram                                                  */
static mach64FIFOTable GTA2_SDRAM_2M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4400, 0x04}, { 9400, 0x06}, {24000, 0x08} }, /* 4 bpp */
  { { 3800, 0x04}, { 6000, 0x06}, { 7600, 0x08}, { 9800, 0x0a},
    {11200, 0x0c}, {24000, 0x0e} },                /* 8 bpp */
  { { 3000, 0x06}, { 3800, 0x08}, { 5400, 0x0a}, { 6400, 0x0c},
    {24000, 0x0e} },                               /* 565   */
  { { 3000, 0x06}, { 3800, 0x08}, { 5400, 0x0a}, { 6400, 0x0c},
    {24000, 0x0e} },                               /* 565   */
  { { 3000, 0x0a}, { 3800, 0x0c}, { 4200, 0x0c}, { 4500, 0x2a},
    {24000, 0x2c} },                               /* 24bpp */
  { { 2200, 0x0a}, { 3000, 0x0c}, { 3400, 0x0e}, {24000, 0x2e} } /* 32bpp */
};

/* table for 1M Ram                                                  */
static mach64FIFOTable GTA2_SDRAM_1M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, { 8000, 0x08},
    {24000, 0x08} },                               /* 4 bpp */
  { { 3800, 0x04}, { 4400, 0x06}, { 6600, 0x06}, { 9000, 0x08},
    {24000, 0x0a} },                               /* 8 bpp */
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0e} },                /* 555   */
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0e} },                /* 565   */
  { { 2600, 0x0a}, { 3400, 0x0c}, { 4200, 0x0c}, {24000, 0x0e} }, /*24bpp*/
  { {24000, 0x08} }                                /* 32bpp */
};

/* The fifo table for GT SDRAM of 67MHz                              */
/* data was extracted from gt$9a-67.sdr                              */
/* table for 2M Ram                                                  */
static mach64FIFOTable GTA2_SDRAM_2M_6700[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x04}, { 9400, 0x06}, {11200, 0x08}, {24000, 0x08} }, /* 4bpp */
  { { 4400, 0x04}, { 6600, 0x06}, { 9400, 0x08}, {10000, 0x0a},
    {11200, 0x0c}, {14000, 0x0c}, {24000, 0x0c} }, /* 8 bpp */
  { { 3400, 0x06}, { 4200, 0x08}, { 5400, 0x0a}, { 6600, 0x0c},
    { 8000, 0x0e}, {24000, 0x0e} },                /* 555   */
  { { 3400, 0x06}, { 4200, 0x08}, { 5400, 0x0a}, { 6600, 0x0c},
    { 8000, 0x0e}, {24000, 0x0e} },                /* 565   */
  { { 2000, 0x08}, { 3000, 0x08}, { 3300, 0x0a}, { 4200, 0x0c},
    { 4600, 0x0c}, {24000, 0x2c} },                /* 24bpp */
  { { 3000, 0x0a}, { 3400, 0x0c}, { 3800, 0x0e}, { 5200, 0x0e} } /* 32bpp */
};

/* table for 1M Ram                                                  */
static mach64FIFOTable GTA2_SDRAM_1M_6700[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, { 8000, 0x08},
    {24000, 0x08} },                               /* 4 bpp */
  { { 3800, 0x04}, { 4400, 0x06}, { 7800, 0x06}, { 9000, 0x08},
    {24000, 0x0a} },                               /* 8 bpp */
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0c} },                /* 555   */
  { { 3000, 0x06}, { 3400, 0x06}, { 3800, 0x08}, { 4400, 0x0a},
    { 5800, 0x0c}, {24000, 0x0c} },                /* 565   */
  { { 2000, 0x06}, { 2600, 0x06}, { 3400, 0x0a}, { 4100, 0x0c},
    {24000, 0x0e} },                               /* 24bpp */
  { {24000, 0x06} }                                /* 32bpp */
};

/*------------------------------------------------------------------*/
/* The FIFO TABLE FOR DRAM                                          */
/*------------------------------------------------------------------*/
/* The fifo table for GT DRAM  of 56MHz                             */
/* data was extracted from gt$9a-56.dr                              */
/* table for 2M Ram                                                 */
static mach64FIFOTable GTA2_DRAM_2M_5600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 7600, 0x04}, {10100, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 4600, 0x04}, { 5500, 0x06}, { 5800, 0x06}, { 7600, 0x08},
    { 8200, 0x0a}, {10100, 0x0c}, {11100, 0x0e}, {12300, 0x0e},
    {24000, 0x0e} },                               /* 8 bpp */
  { { 2000, 0x04}, { 2200, 0x04}, { 2600, 0x06}, { 3700, 0x08},
    { 4600, 0x0a}, { 5200, 0x0c}, { 5700, 0x0e}, { 6600, 0x0e},
    { 8000, 0x0e}, { 24000, 0x0e} },               /* 555   */
  { { 2000, 0x04}, { 2200, 0x04}, { 2600, 0x06}, { 3700, 0x08},
    { 4600, 0x0a}, { 5200, 0x0c}, { 5700, 0x0e}, { 6600, 0x0e},
    { 8000, 0x0e}, {24000, 0x0e} },                /* 565   */
  { { 2600, 0x0a}, { 3200, 0x0c}, { 3600, 0x0c}, { 4100, 0x0c},
    { 4600, 0x0c}, {24000, 0x2c} },                /* 24bpp */
  { { 1500, 0x06}, { 2200, 0x0a}, { 2600, 0x0c}, { 3300, 0x0c},
    { 3700, 0x0c}, {24000, 0x0e} }                 /* 32bpp */
};

/* table for 1M Ram                                                 */
static mach64FIFOTable GTA2_DRAM_1M_5600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7900, 0x06}, {24000, 0x0a} }, /* 4bpp */
  { { 3300, 0x04}, { 4600, 0x06}, { 5500, 0x08}, { 6800, 0x0a},
    { 7900, 0x0c}, { 8100, 0x0e}, {24000, 0x0e} }, /* 8 bpp */
  { { 2600, 0x08}, { 3300, 0x0a}, { 3700, 0x0c}, { 4600, 0x0e},
    {24000, 0x0e} },                               /* 555   */
  { { 2600, 0x08}, { 3300, 0x0a}, { 3700, 0x0c}, { 4600, 0x0e},
    {24000, 0x0e} },                               /* 565   */
  { { 2000, 0x0a}, { 2600, 0x0c}, {24000, 0x0e} }, /* 24bpp */
  { { 1500, 0x08}, {24000, 0x0c} }                 /* 32bpp */
};

/*-----------------------------------------------------*         
 * The FIFO TABLE FOR EDO RAM                          *
 *-----------------------------------------------------*
 * The fifo table for GT EDO RAM  of 63MHz             *
 * data was extracted from gt$9a-63.edo                *
 * table for 2M Ram                                    */
static mach64FIFOTable GTA2_EDO_2M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 7600, 0x04}, {10200, 0x06}, {24000, 0x0a} }, /* 4bpp*/
  { { 4100, 0x04}, { 5200, 0x06}, { 5600, 0x08}, { 7600, 0x08},
    { 9400, 0x0a}, {10000, 0x0c}, {11300, 0x0e}, {13000, 0x0e},
    {24000, 0x0e} }, /* 8 bpp */
  { { 2400, 0x06}, { 2600, 0x0a}, { 3700, 0x08}, { 4600, 0x0a},
    { 5200, 0x0c}, { 5800, 0x0e}, { 6900, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 555 */
  { { 2400, 0x06}, { 2600, 0x0a}, { 3700, 0x08}, { 4600, 0x0a},
    { 5200, 0x0c}, { 5800, 0x0e}, { 6900, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 565 */
  { { 2700, 0x0a}, { 3300, 0x0c}, { 3900, 0x0c}, { 4600, 0x0c},
    { 5200, 0x0e}, {24000, 0x0e} }, /*24bpp */
  { { 2200, 0x0a}, { 2700, 0x0c}, { 3300, 0x0c}, { 3700, 0x0e},
    {24000, 0x0e} } /* 32bpp */
};

/*table for 1M Ram*/
static mach64FIFOTable GTA2_EDO_1M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} }, /* 4bpp */
  { { 2400, 0x06}, { 2600, 0x0a}, { 3300, 0x04}, { 3800, 0x06},
    { 4800, 0x08}, { 6800, 0x0a}, { 9000, 0x0c}, {24000, 0x0e} }, /* 8bpp */
  { { 2600, 0x08}, { 3300, 0x0a}, { 4100, 0x0c}, { 4600, 0x0e},
    { 5200, 0x0c}, {24000, 0x0c} }, /* 555 */
  { { 2600, 0x08}, { 3300, 0x0a}, { 4100, 0x0c}, { 4600, 0x0e},
    { 5200, 0x0c}, {24000, 0x0c} }, /* 565 */
  { { 2400, 0x0a}, { 3000, 0x0c}, {24000, 0x0c} }, /* 24bpp */
  { { 1500, 0x08}, {24000, 0x0c} } /* 32bpp */
};

/* The fifo table for GT DRAM of 67MHz                              */
/* data was extracted from gt$9a-67.edo                             */
/* table for 2M Ram                                                 */
static mach64FIFOTable GTA2_EDO_2M_6700_6[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} }, /* 4bpp */
  { { 4600, 0x04}, { 5600, 0x06}, { 7000, 0x06}, { 9400, 0x08},
    {10000, 0x0a}, {11300, 0x0c}, {14000, 0x0c}, {24000, 0x0e} }, /* 8 bpp*/
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5500, 0x0a},
    { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e}, {24000, 0x0e} }, /* 555 */
  { { 2000, 0x06}, { 3400, 0x06}, { 4200, 0x08}, { 5500, 0x0a},
    { 6600, 0x0c}, { 7000, 0x0c}, { 7600, 0x0e}, {24000, 0x0e} }, /* 565 */
  { { 2000, 0x08}, { 3400, 0x0a}, { 3800, 0x0a}, { 4200, 0x0a},
    { 4500, 0x0c}, { 5200, 0x0c}, {24000, 0x2c} }, /*24bpp*/
  { { 2000, 0x0a}, { 3000, 0x0a}, { 3500, 0x0c}, { 4200, 0x0e},
    {24000, 0x2a} } /* 32bpp */
};

/*table for 1M Ram*/
static mach64FIFOTable GTA2_EDO_1M_6700_6[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { {3800, 0x02}, {5200, 0x04}, {7600, 0x06}, {24000, 0x0a} }, /* 4bpp */
  { {3000, 0x04}, {3800, 0x04}, {5400, 0x06}, {7700, 0x0a},
    {9000, 0x0a}, {10500, 0x0c}, {24000, 0x0e} }, /* 8 bpp */
  { {2000, 0x06}, {3000, 0x06}, {3800, 0x08}, {4400, 0x0a},
    {4800, 0x0c}, {24000, 0x0e} }, /* 555 */
  { {2000, 0x06}, {3000, 0x06}, {3800, 0x08}, {4400, 0x0a},
    {4800, 0x0c}, {24000, 0x0e} }, /* 565 */
  { {2000, 0x0a}, {3000, 0x0a}, {3400, 0x0c}, {24000, 0x0e} }, /*24bpp*/
  { {24000, 0x06} } /* 32bpp */
};


/* The fifo table for GT EDO RAM of 67MHz   *
 * data was extracted from gt$9a-67.ed7     *
 * table for 2M Ram                         */
static mach64FIFOTable GTA2_EDO_2M_6700_7[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x02}, { 7000, 0x04}, {10200, 0x06}, {24000, 0x0a} }, /* 4bpp */
  { { 5200, 0x06}, { 6400, 0x08}, { 7000, 0x0a}, { 7900, 0x0c},
    { 8200, 0x0c}, {10800, 0x0c}, {13000, 0x0c}, {24000, 0x0c} }, /* 8bpp */
  { { 3000, 0x06}, { 3800, 0x08}, { 4200, 0x0a}, { 5200, 0x0a},
    { 6600, 0x0c}, { 7600, 0x0c}, { 8200, 0x0c}, {24000, 0x0e} }, /* 555 */
  { { 3000, 0x06}, { 3800, 0x08}, { 4200, 0x0a}, { 5200, 0x0a},
    { 6600, 0x0c}, { 7600, 0x0c}, { 8200, 0x0c}, {24000, 0x0e} }, /* 565 */
  { { 3000, 0x0a}, { 3400, 0x0a}, { 3600, 0x0a}, { 4400, 0x0c},
    { 5200, 0x0c} }, /* 24bpp */
  { { 3400, 0x0c}, { 5200, 0x0c} } /* 32bpp */
};

/*table for 1M Ram */
static mach64FIFOTable GTA2_EDO_1M_6700_7[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4200, 0x04}, { 6400, 0x06}, { 9000, 0x0a}, {24000, 0x0c} }, /* 4bpp */
  { { 3800, 0x08}, { 6400, 0x0a}, { 7000, 0x0c}, { 9000, 0x0c},
    {24000, 0x0c} }, /* 8 bpp */
  { { 3800, 0x0a}, { 4800, 0x0c}, { 5600, 0x0e}, {24000, 0x0e} }, /* 555 */
  { { 3800, 0x0a}, { 4800, 0x0c}, { 5600, 0x0e}, {24000, 0x0e} }, /* 565 */
  { { 3400, 0x0c}, {24000, 0x0e} }, /*24bpp */
  { {24000, 0x06} } /* 32bpp */
};

/*-----------------------------------------------------*         
 * The FIFO TABLE FOR PSEUDO EDO RAM                   *
 *-----------------------------------------------------*
 * The fifo table for GT PSEUDO EDO RAM of 56MHz       *
 * data was extracted from gt$9a-56.pdo                */

/*table for 2M Ram*/
static mach64FIFOTable GTA2_PSEUDO_2M_5600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 7600, 0x04}, {10200, 0x06}, {24000, 0x0a} }, /* 4bpp*/
  { { 4100, 0x04}, { 5200, 0x06}, { 5600, 0x08}, { 7300, 0x08},
    { 9400, 0x0a}, {10000, 0x0c}, {11300, 0x0e}, {12600, 0x0e},
    {24000, 0x0e} }, /* 8 bpp */
  { { 2400, 0x06}, { 2600, 0x0a}, { 3700, 0x08}, { 4600, 0x0a},
    { 5200, 0x0c}, { 5800, 0x0e}, { 6900, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 555 */
  { { 2400, 0x06}, { 2600, 0x0a}, { 3700, 0x08}, { 4600, 0x0a},
    { 5200, 0x0c}, { 5800, 0x0e}, { 6900, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 565 */
  { { 2700, 0x0a}, { 3300, 0x0c}, { 3900, 0x0c}, { 4600, 0x0c},
    {24000, 0x0e} }, /*24bpp*/
  { { 2200, 0x0a}, { 2700, 0x0c}, { 3300, 0x0c}, { 3700, 0x0e},
    {24000, 0x0e} } /* 32bpp */
};

/*Table for 1M Ram*/
static mach64FIFOTable GTA2_PSEUDO_1M_5600[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} }, /* 4bpp */
  { { 2400, 0x06}, { 2600, 0x0a}, { 3300, 0x04}, { 3800, 0x06},
    { 4800, 0x08}, { 6800, 0x0a}, {24000, 0x0e} }, /* 8 bpp */
  { { 2600, 0x08}, { 3300, 0x0a}, { 3900, 0x0c}, { 4400, 0x0e},
    { 4800, 0x0c}, {24000, 0x0c} }, /* 555 */
  { { 2600, 0x08}, { 3300, 0x0a}, { 3900, 0x0c}, { 4400, 0x0e},
    { 4800, 0x0c}, {24000, 0x0c} }, /* 565 */
  { { 2000, 0x0a}, { 3000, 0x0c}, {24000, 0x0e} }, /*24bpp*/
  { { 1500, 0x08}, {24000, 0x0e} } /* 32bpp */
};


/* The fifo table for GT PSEUDO EDO RAM of 58MHz  *
 * data was extracted from gt$9a-58.pdo           */

/*table for 2M Ram */
static mach64FIFOTable GTA2_PSEUDO_2M_5800[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 7600, 0x04}, {10200, 0x06}, {24000, 0x0a} }, /* 4bpp*/
  { { 4100, 0x04}, { 5200, 0x06}, { 5600, 0x08}, { 7500, 0x08},
    { 9400, 0x0a}, {10000, 0x0c}, {11300, 0x0e}, {12600, 0x0e},
    {24000, 0x0e} }, /* 8 bpp */
  { { 2400, 0x06}, { 2600, 0x0a}, { 3700, 0x08}, { 4600, 0x0a},
    { 5200, 0x0c}, { 5800, 0x0e}, { 6900, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 555 */
  { { 2400, 0x06}, { 2600, 0x0a}, { 3700, 0x08}, { 4600, 0x0a},
    { 5200, 0x0c}, { 5800, 0x0e}, { 6900, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 565 */
  { { 2700, 0x0a}, { 3300, 0x0c}, { 3900, 0x0c}, { 4600, 0x0c},
    {24000, 0x0e} }, /*24bpp*/
  { { 2200, 0x0a}, { 2700, 0x0c}, { 3300, 0x0c}, { 3700, 0x0e},
    {24000, 0x0e} } /* 32bpp */
};

/*table for 1M Ram*/
static mach64FIFOTable GTA2_PSEUDO_1M_5800[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} }, /* 4bpp */
  { { 2400, 0x06}, { 2600, 0x0a}, { 3300, 0x04}, { 3800, 0x06},
    { 4800, 0x08}, { 6800, 0x0a}, { 9000, 0x0c}, {24000, 0x0e} }, /* 8 bpp */
  { { 2600, 0x08}, { 3300, 0x0a}, { 4100, 0x0c}, { 4600, 0x0e},
    { 5200, 0x0c}, {24000, 0x0c} }, /* 555 */
  { { 2600, 0x08}, { 3300, 0x0a}, { 4100, 0x0c}, { 4600, 0x0e},
    { 5200, 0x0c}, {24000, 0x0c} }, /* 565 */
  { { 2400, 0x0a}, { 3000, 0x0c}, {24000, 0x0c} }, /*24bpp */
  { { 1500, 0x08}, {24000, 0x0c} } /* 32bpp */
};

/* The fifo table for GT PSEUDO EDO RAM of 60MHz *
 * data was extracted from gt$9a-60.pdo          */

/*table for 2M Ram*/
static mach64FIFOTable GTA2_PSEUDO_2M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 9400, 0x04}, {11200, 0x06}, {24000, 0x08} }, /* 4bpp*/
  { { 3000, 0x04}, { 3300, 0x06}, { 4600, 0x04}, { 5600, 0x06},
    { 5800, 0x06}, { 7900, 0x08}, { 8200, 0x0a}, {11300, 0x0c},
    {13000, 0x0c}, {14000, 0x0c}, {24000, 0x0e} }, /* 8 bpp */
  { { 2400, 0x06}, { 2600, 0x08}, { 4100, 0x08}, { 4600, 0x0a},
    { 5500, 0x0c}, { 5700, 0x0e}, { 6600, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 555 */
  { { 2400, 0x06}, { 2600, 0x08}, { 4100, 0x08}, { 4600, 0x0a},
    { 5500, 0x0c}, { 5700, 0x0e}, { 6600, 0x0e}, { 7900, 0x0e},
    {24000, 0x0e} }, /* 565 */
  { { 2000, 0x08}, { 2600, 0x0a}, { 3300, 0x0c}, { 4000, 0x0c},
    { 4500, 0x26}, { 5200, 0x28}, {24000, 0x2a} }, /*24bpp*/
  { { 2000, 0x0a}, { 2200, 0x0c}, { 2600, 0x0c}, { 3300, 0x0e},
    { 4200, 0x0e}, {24000, 0x2a} } /* 32bpp */
};

/*table for 1M Ram*/
static mach64FIFOTable GTA2_PSEUDO_1M_6000[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x02}, { 5200, 0x04}, { 7600, 0x06}, {24000, 0x0a} }, /* 4bpp */
  { { 2400, 0x04}, { 3000, 0x06}, { 3300, 0x06}, { 4600, 0x0a},
    { 5200, 0x08}, { 6800, 0x0a}, { 8200, 0x0c}, {10100, 0x0e},
    {24000, 0x0e} }, /* 8 bpp */
  { { 1500, 0x0a}, { 2000, 0x08}, { 2400, 0x0a}, { 2600, 0x08},
    { 3700, 0x0a}, { 4100, 0x0c}, { 4600, 0x0e}, { 5200, 0x0e},
    {24000, 0x0e} }, /* 555 */
  { { 1500, 0x0a}, { 2000, 0x08}, { 2400, 0x0a}, { 2600, 0x08},
    { 3700, 0x0a}, { 4100, 0x0c}, { 4600, 0x0e}, { 5200, 0x0e},
    {24000, 0x0e} }, /* 565 */
  { { 2000, 0x0a}, { 2200, 0x0c}, { 2600, 0x0c}, { 3300, 0x0c},
    {24000, 0x0e} }, /*24bpp*/
  { { 2000, 0x0c}, {24000, 0x0c} } /* 32bpp */
};

/* The fifo table for GT PSEUDO EDO RAM of 60MHz *
 * data was extracted from gt$9a-63.pdo          */

/*table for 2M Ram*/
static mach64FIFOTable GTA2_PSEUDO_2M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 4600, 0x02}, { 7600, 0x04}, {10200, 0x06}, {24000, 0x0a} }, /* 4bpp */
  { { 4600, 0x04}, { 5600, 0x06}, { 7600, 0x08}, { 9400, 0x0a},
    {10000, 0x0c}, {11300, 0x0e}, {13000, 0x0e}, {24000, 0x0e} }, /* 8 bpp*/
  { { 2400, 0x06}, { 3700, 0x08}, { 4600, 0x0a}, { 5200, 0x0c},
    { 5800, 0x0e}, { 6900, 0x0e}, { 7900, 0x0e}, {24000, 0x0e} }, /* 555 */
  { { 2400, 0x06}, { 3700, 0x08}, { 4600, 0x0a}, { 5200, 0x0c},
    { 5800, 0x0e}, { 6900, 0x0e}, { 7900, 0x0e}, {24000, 0x0e} }, /* 565 */
  { { 2700, 0x0a}, { 3300, 0x0c}, { 3900, 0x0c}, { 4600, 0x0c},
    { 5200, 0x0e}, {24000, 0x0e} }, /*24bpp */
  { { 2200, 0x0a}, { 2700, 0x0c}, { 3300, 0x0c}, { 3700, 0x0e},
    {24000, 0x0e} } /* 32bpp */
};

/*table for 1M Ram*/
static mach64FIFOTable GTA2_PSEUDO_1M_6300[MAX_CDEPTH][MAX_DOTCLOCKS] =
{ { { 3800, 0x04}, { 5200, 0x04}, { 7600, 0x06}, { 8000, 0x0a},
    {24000, 0x0a} }, /* 4bpp*/
  { { 3800, 0x06}, { 4800, 0x08}, { 5800, 0x0a}, { 6800, 0x0a},
    { 9000, 0x0c}, {24000, 0x0e} }, /* 8 bpp */
  { { 3000, 0x08}, { 3400, 0x0a}, { 3800, 0x0e}, { 4400, 0x0e},
    { 5800, 0x0e}, {24000, 0x0e} }, /* 555 */
  { { 3000, 0x08}, { 3400, 0x0a}, { 3800, 0x0e}, { 4400, 0x0e},
    { 5800, 0x0e}, {24000, 0x0e} }, /* 565 */
  { { 2400, 0x0a}, { 3000, 0x0c}, { 3400, 0x0c}, {24000, 0x0c} }, /*24bpp*/
  { { 3400, 0x0c}, {24000, 0x0e} } /* 32bpp */
};


/*
 * mach64FIFOdepthDefault --
 *	Calculates the correct FIFO depth for the Mach64 depending on the
 *	color depth and clock selected.
 */
int mach64FIFOdepthDefault(cdepth, clock, width)
    int cdepth;
    int clock;
    int width;
{
    int fifo_depth;
    int index;

    fifo_depth = clock/100;

    switch (cdepth) {
    case CRTC_PIX_WIDTH_15BPP:
    case CRTC_PIX_WIDTH_16BPP:
	fifo_depth <<= 1;
	index = 1*6;
	break;
    case CRTC_PIX_WIDTH_24BPP:
	fifo_depth = (fifo_depth << 1) + fifo_depth;
	index = 2*6;
	break;
    case CRTC_PIX_WIDTH_32BPP:
	fifo_depth <<= 2;
	index = 3*6;
	break;
    default:
	index = 0*6;
	break;
    }

    if (mach64MemorySize <= MEM_SIZE_1M) {
	if (mach64MemorySize == MEM_SIZE_1M) index += 2;
	fifo_depth /= 6;
    } else {
	index += 4;
	fifo_depth /= 12;
    }

    if (fifo_depth < defaultFIFOVals[index])
	fifo_depth = defaultFIFOVals[index];
    if (fifo_depth < defaultFIFOVals[index+1])
	fifo_depth = defaultFIFOVals[index+1];

    return(fifo_depth);
}


/*
 * mach64FIFOdepthVTA3 --
 *	Calculates the correct FIFO depth for the Mach64 depending on the
 *	color depth and clock selected.
 */
int mach64FIFOdepthVTA3(cdepth, clock, width)
    int cdepth;
    int clock;
    int width;
{
    int i, cdepth_index = (cdepth >> 8) - 1;
    mach64FIFOTable *pFIFOTable;

    switch (mach64MemType) {
    case SDRAM:
	if (mach64DRAMMemClk >= 6000 && mach64DRAMMemClk < 6300) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA3_SDRAM_1M_6000[cdepth_index][0];
	    else
		pFIFOTable = &VTA3_SDRAM_2M_6000[cdepth_index][0];
	} else if (mach64DRAMMemClk >= 6300 && mach64DRAMMemClk < 6700) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA3_SDRAM_1M_6300[cdepth_index][0];
	    else
		pFIFOTable = &VTA3_SDRAM_2M_6300[cdepth_index][0];
	} else { /* 67MHz and up */
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA3_SDRAM_1M_6700[cdepth_index][0];
	    else
		pFIFOTable = &VTA3_SDRAM_2M_6700[cdepth_index][0];
	}
	break;
    case EDO_DRAM:
	if (mach64DRAMMemClk >= 6300 && mach64DRAMMemClk < 6700) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA3_EDO_1M_6300[cdepth_index][0];
	    else
		pFIFOTable = &VTA3_EDO_2M_6300[cdepth_index][0];
	} else { /* 67MHz and up */
	    if (mach64MemCycle <= 6) { /* 6 cycles */
		if (mach64MemorySize <= MEM_SIZE_1M)
		    pFIFOTable = &VTA3_EDO_1M_6700_6[cdepth_index][0];
		else
		    pFIFOTable = &VTA3_EDO_2M_6700_6[cdepth_index][0];
	    } else { /* 7 cycles */
		if (mach64MemorySize <= MEM_SIZE_1M)
		    pFIFOTable = &VTA3_EDO_1M_6700_7[cdepth_index][0];
		else
		    pFIFOTable = &VTA3_EDO_2M_6700_7[cdepth_index][0];
	    }
	}
	break;
    case PSEUDO_EDO:
	if (mach64DRAMMemClk >= 6000 && mach64DRAMMemClk < 6300) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA3_PSEUDO_1M_6000[cdepth_index][0];
	    else
		pFIFOTable = &VTA3_PSEUDO_2M_6000[cdepth_index][0];
	} else { /* 63MHz and up */
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA3_PSEUDO_1M_6300[cdepth_index][0];
	    else
		pFIFOTable = &VTA3_PSEUDO_2M_6300[cdepth_index][0];
	}
	break;
    default: /* DRAM */
	if (mach64DRAMMemClk >= 5200 && mach64DRAMMemClk < 5600) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA3_DRAM_1M_5200[cdepth_index][0];
	    else
		pFIFOTable = &VTA3_DRAM_2M_5200[cdepth_index][0];
	} else { /* 63MHz and up */
	    if (mach64DRAMMemClk < 5650) {
		switch (cdepth) {
		case CRTC_PIX_WIDTH_15BPP:
		case CRTC_PIX_WIDTH_16BPP:
		    for (i = 0; i < MAX_DOTCLOCKS; i++)
			if (VTA3_DRAM_2M_5600[cdepth_index][i].dotclock == 7000)
			    VTA3_DRAM_2M_5600[cdepth_index][i].dotclock = 7600;
		    break;
		case CRTC_PIX_WIDTH_24BPP:
		    for (i = 0; i < MAX_DOTCLOCKS; i++)
			if (VTA3_DRAM_1M_5600[cdepth_index][i].dotclock == 3000)
			    VTA3_DRAM_1M_5600[cdepth_index][i].fifo_val = 0x0c;
		    break;
		default: /* Table is fine as is */
		    break;
		}
	    }
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA3_DRAM_1M_5600[cdepth_index][0];
	    else
		pFIFOTable = &VTA3_DRAM_2M_5600[cdepth_index][0];
	}
	break;
    }

    for (i = 0; i < MAX_DOTCLOCKS; i++)
	if (clock <= (pFIFOTable+i)->dotclock)
	    return (pFIFOTable+i)->fifo_val;

    return 0;
}


/*
 * mach64FIFOdepthVTA4 --
 *	Calculates the correct FIFO depth for the Mach64 depending on the
 *	color depth and clock selected.
 */
int mach64FIFOdepthVTA4(cdepth, clock, width)
    int cdepth;
    int clock;
    int width;
{
    int i, cdepth_index = (cdepth >> 8) - 1;
    mach64FIFOTable *pFIFOTable;

    switch (mach64MemType) {
    case SDRAM:
	if (mach64DRAMMemClk >= 6000 && mach64DRAMMemClk < 6300) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA4_SDRAM_1M_6000[cdepth_index][0];
	    else
		pFIFOTable = &VTA4_SDRAM_2M_6000[cdepth_index][0];
	} else if (mach64DRAMMemClk >= 6300 && mach64DRAMMemClk < 6700) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA4_SDRAM_1M_6300[cdepth_index][0];
	    else
		pFIFOTable = &VTA4_SDRAM_2M_6300[cdepth_index][0];
	} else { /* 67MHz and up */
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA4_SDRAM_1M_6700[cdepth_index][0];
	    else
		pFIFOTable = &VTA4_SDRAM_2M_6700[cdepth_index][0];
	}
	break;
    case EDO_DRAM:
	if (mach64DRAMMemClk >= 6300 && mach64DRAMMemClk < 6700) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA4_EDO_1M_6300[cdepth_index][0];
	    else
		pFIFOTable = &VTA4_EDO_2M_6300[cdepth_index][0];
	} else { /* 67MHz and up */
	    if (mach64MemCycle <= 6) { /* 6 cycles */
		if (mach64MemorySize <= MEM_SIZE_1M)
		    pFIFOTable = &VTA4_EDO_1M_6700_6[cdepth_index][0];
		else
		    pFIFOTable = &VTA4_EDO_2M_6700_6[cdepth_index][0];
	    } else { /* 7 cycles */
		if (mach64MemorySize <= MEM_SIZE_1M)
		    pFIFOTable = &VTA4_EDO_1M_6700_7[cdepth_index][0];
		else
		    pFIFOTable = &VTA4_EDO_2M_6700_7[cdepth_index][0];
	    }
	}
	break;
    case PSEUDO_EDO:
	if (mach64DRAMMemClk >= 6000 && mach64DRAMMemClk < 6300) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA4_PSEUDO_1M_6000[cdepth_index][0];
	    else
		pFIFOTable = &VTA4_PSEUDO_2M_6000[cdepth_index][0];
	} else { /* 63MHz and up */
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA4_PSEUDO_1M_6300[cdepth_index][0];
	    else
		pFIFOTable = &VTA4_PSEUDO_2M_6300[cdepth_index][0];
	}
	break;
    default: /* DRAM */
	if (mach64DRAMMemClk >= 5200 && mach64DRAMMemClk < 5600) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA4_DRAM_1M_5200[cdepth_index][0];
	    else
		pFIFOTable = &VTA4_DRAM_2M_5200[cdepth_index][0];
	} else { /* 63MHz and up */
	    if (mach64DRAMMemClk < 5650) {
		switch (cdepth) {
		case CRTC_PIX_WIDTH_15BPP:
		case CRTC_PIX_WIDTH_16BPP:
		    for (i = 0; i < MAX_DOTCLOCKS; i++)
			if (VTA4_DRAM_2M_5600[cdepth_index][i].dotclock == 7000)
			    VTA4_DRAM_2M_5600[cdepth_index][i].dotclock = 7600;
		    break;
		case CRTC_PIX_WIDTH_24BPP:
		    for (i = 0; i < MAX_DOTCLOCKS; i++)
			if (VTA4_DRAM_1M_5600[cdepth_index][i].dotclock == 3000)
			    VTA4_DRAM_1M_5600[cdepth_index][i].fifo_val = 0x0c;
		    break;
		default: /* Table is fine as is */
		    break;
		}
	    }
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &VTA4_DRAM_1M_5600[cdepth_index][0];
	    else
		pFIFOTable = &VTA4_DRAM_2M_5600[cdepth_index][0];
	}
	break;
    }

    for (i = 0; i < MAX_DOTCLOCKS; i++)
	if (clock <= (pFIFOTable+i)->dotclock)
	    return (pFIFOTable+i)->fifo_val;

    return 0;
}


/*
 * mach64FIFOdepthGT --
 *	Calculates the correct FIFO depth for the Mach64 depending on the
 *	color depth and clock selected.
 */
int mach64FIFOdepthGT(cdepth, clock, width)
    int cdepth;
    int clock;
    int width;
{
    int i, cdepth_index = (cdepth >> 8) - 1;
    mach64FIFOTable *pFIFOTable;

    switch (mach64MemType) {
    case SDRAM:
	if (mach64DRAMMemClk >= 6000 && mach64DRAMMemClk < 6300) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &GTA2_SDRAM_1M_6000[cdepth_index][0];
	    else
		pFIFOTable = &GTA2_SDRAM_2M_6000[cdepth_index][0];
	} else if (mach64DRAMMemClk >= 6300 && mach64DRAMMemClk < 6700) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &GTA2_SDRAM_1M_6300[cdepth_index][0];
	    else
		pFIFOTable = &GTA2_SDRAM_2M_6300[cdepth_index][0];
	} else { /* 67MHz and up */
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &GTA2_SDRAM_1M_6700[cdepth_index][0];
	    else
		pFIFOTable = &GTA2_SDRAM_2M_6700[cdepth_index][0];
	}
	break;
    case EDO_DRAM:
	if (mach64DRAMMemClk >= 6300 && mach64DRAMMemClk < 6700) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &GTA2_EDO_1M_6300[cdepth_index][0];
	    else
		pFIFOTable = &GTA2_EDO_2M_6300[cdepth_index][0];
	} else { /* 67MHz and up */
	    if (mach64MemCycle <= 6) { /* 6 cycles */
		if (mach64MemorySize <= MEM_SIZE_1M)
		    pFIFOTable = &GTA2_EDO_1M_6700_6[cdepth_index][0];
		else
		    pFIFOTable = &GTA2_EDO_2M_6700_6[cdepth_index][0];
	    } else { /* 7 cycles */
		if (mach64MemorySize <= MEM_SIZE_1M)
		    pFIFOTable = &GTA2_EDO_1M_6700_7[cdepth_index][0];
		else
		    pFIFOTable = &GTA2_EDO_2M_6700_7[cdepth_index][0];
	    }
	}
	break;
    case PSEUDO_EDO:
	if (mach64DRAMMemClk >= 5600 && mach64DRAMMemClk < 5800) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &GTA2_PSEUDO_1M_5600[cdepth_index][0];
	    else
		pFIFOTable = &GTA2_PSEUDO_2M_5600[cdepth_index][0];
	} else if (mach64DRAMMemClk >= 5800 && mach64DRAMMemClk < 6000) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &GTA2_PSEUDO_1M_5800[cdepth_index][0];
	    else
		pFIFOTable = &GTA2_PSEUDO_2M_5800[cdepth_index][0];
	} else if (mach64DRAMMemClk >= 6000 && mach64DRAMMemClk < 6300) {
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &GTA2_PSEUDO_1M_6000[cdepth_index][0];
	    else
		pFIFOTable = &GTA2_PSEUDO_2M_6000[cdepth_index][0];
	} else { /* 63MHz and up */
	    if (mach64MemorySize <= MEM_SIZE_1M)
		pFIFOTable = &GTA2_PSEUDO_1M_6300[cdepth_index][0];
	    else
		pFIFOTable = &GTA2_PSEUDO_2M_6300[cdepth_index][0];
	}
	break;
    default: /* DRAM */
	/* Default to 56MHz */
	if (mach64MemorySize <= MEM_SIZE_1M)
	    pFIFOTable = &GTA2_DRAM_1M_5600[cdepth_index][0];
	else
	    pFIFOTable = &GTA2_DRAM_2M_5600[cdepth_index][0];
	break;
    }

    for (i = 0; i < MAX_DOTCLOCKS; i++)
	if (clock <= (pFIFOTable+i)->dotclock)
	    return (pFIFOTable+i)->fifo_val;

    return 0;
}


/*
 * mach64FIFOdepthCT --
 *	Calculates the correct FIFO depth for the Mach64 depending on the
 *	color depth and clock selected.
 */
int mach64FIFOdepthCT(cdepth, clock, width)
    int cdepth;
    int clock;
    int width;
{
    int fifo_depth;
    int index;

    fifo_depth = clock/100;

    switch (cdepth) {
    case CRTC_PIX_WIDTH_15BPP:
    case CRTC_PIX_WIDTH_16BPP:
	fifo_depth <<= 1;
	index = 1*6;
	break;
    case CRTC_PIX_WIDTH_24BPP:
	fifo_depth = (fifo_depth << 1) + fifo_depth;
	index = 2*6;
	break;
    case CRTC_PIX_WIDTH_32BPP:
	fifo_depth <<= 2;
	index = 3*6;
	break;
    default:
	index = 0*6;
	break;
    }

    if (mach64MemorySize <= MEM_SIZE_1M) {
	if (mach64MemorySize == MEM_SIZE_1M) index += 2;
	fifo_depth /= 6;
    } else {
	index += 4;
	fifo_depth /= 10;
    }

    if (width <= 640)
	index += 0;
    else if (width <= 800)
	index += 1*6*4;
    else if (width <= 1024)
	index += 2*6*4;
    else
	index += 3*6*4;

    if (fifo_depth < CT_FIFOVals[index])
	fifo_depth = CT_FIFOVals[index];
    if (fifo_depth < CT_FIFOVals[index+1])
	fifo_depth = CT_FIFOVals[index+1];

    return(fifo_depth);
}


/*
 * mach64FIFOdepthCTD --
 *	Calculates the correct FIFO depth for the Mach64 depending on the
 *	color depth and clock selected.
 */
int mach64FIFOdepthCTD(cdepth, clock, width)
    int cdepth;
    int clock;
    int width;
{
    int i, cdepth_index = (cdepth >> 8) - 1;
    mach64FIFOTable *pFIFOTable;

    if (mach64DRAMMemClk >= 5600) {
	if (mach64MemorySize <= MEM_SIZE_1M)
	    pFIFOTable = &CTD_DRAM_1M_5600[cdepth_index][0];
	else
	    pFIFOTable = &CTD_DRAM_2M_5600[cdepth_index][0];
    } else if (mach64DRAMMemClk >= 5400) {
	if (mach64MemorySize <= MEM_SIZE_1M)
	    pFIFOTable = &CTD_DRAM_1M_5400[cdepth_index][0];
	else
	    pFIFOTable = &CTD_DRAM_2M_5400[cdepth_index][0];
    } else if (mach64DRAMMemClk > 4900) {
	if (mach64DRAMMemClk <= 5000 && mach64MemorySize <= MEM_SIZE_1M &&
	    (cdepth == CRTC_PIX_WIDTH_15BPP ||
	     cdepth == CRTC_PIX_WIDTH_16BPP)) {
	    for (i = 0; i < MAX_DOTCLOCKS; i++) {
		if (CTD_DRAM_1M_5100[cdepth_index][i].dotclock == 5100)
		    CTD_DRAM_1M_5100[cdepth_index][i].dotclock = 5000;
		if (CTD_DRAM_1M_5100[cdepth_index][i].dotclock == 5500 ||
		    CTD_DRAM_1M_5100[cdepth_index][i].dotclock == 14000) {
		    CTD_DRAM_1M_5100[cdepth_index][i].dotclock = 5200;
		    CTD_DRAM_1M_5100[cdepth_index][i].fifo_val = 0x10;
		}
	    }
	}
	if (mach64MemorySize <= MEM_SIZE_1M)
	    pFIFOTable = &CTD_DRAM_1M_5100[cdepth_index][0];
	else
	    pFIFOTable = &CTD_DRAM_2M_5100[cdepth_index][0];
    } else if (mach64DRAMMemClk >= 4800) {
	if (mach64MemorySize <= MEM_SIZE_1M)
	    pFIFOTable = &CTD_DRAM_1M_4900[cdepth_index][0];
	else
	    pFIFOTable = &CTD_DRAM_2M_4900[cdepth_index][0];
    } else { /* <= 48MHz */
	if (mach64MemorySize <= MEM_SIZE_1M)
	    pFIFOTable = &CTD_DRAM_1M_4600[cdepth_index][0];
	else
	    pFIFOTable = &CTD_DRAM_2M_4600[cdepth_index][0];
    }

    for (i = 0; i < MAX_DOTCLOCKS; i++)
	if (clock <= (pFIFOTable+i)->dotclock)
	    return (pFIFOTable+i)->fifo_val;

    return 0;
}
