/* This default ilugss_conf.h is configured for normal UNIX
 * workstations with 32-bit integers, and a Big-Endian architecture;
 * OR for Windows 32 machines with 32-bit ints, and Little-Endian
 * architecture.
 */

#ifndef	_ILUGSS_CONF_H_
#define	_ILUGSS_CONF_H_

#ifdef WIN32

/* Define if your processor stores words with the most significant
   byte first (like Motorola and SPARC, unlike Intel and VAX).
   Some security mechanisms need to have this information to
   do marshalling properly. */
#ifdef WORDS_BIGENDIAN
#undef WORDS_BIGENDIAN
#endif

/* figure the sizes of char, short, int, and long */
#define SIZEOF_CHAR 1
#define SIZEOF_SHORT 2
#define SIZEOF_INT 4
#define SIZEOF_LONG 4

#else	/* not WIN32 */

/* Define if your processor stores words with the most significant
   byte first (like Motorola and SPARC, unlike Intel and VAX).
   Some security mechanisms need to have this information to
   do marshalling properly. */
#define WORDS_BIGENDIAN 1

/* figure the sizes of char, short, int, and long */
#define SIZEOF_CHAR 1
#define SIZEOF_SHORT 2
#define SIZEOF_INT 4
#define SIZEOF_LONG 4

#endif	/* def WIN32 */

#endif	/* _ILUGSS_CONF_H_ */
