/* IluAny.java */
/* Chris Jacobi, September 2, 1997 5:09 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */

/* $Id: IluAny.java,v 1.5 1997/09/03 01:41:25 jacobi Exp $ */

package xerox.ilu;

/**
 * Representation of values of unspecified types. <p>
 *  
 * The fact that Any's are mutable is a disaster of poor design.
 * It not only would forces us to do locking but forces 
 * restrictions to get reasonable locking constraints... <p>
 *
 * We simplify the design and can ignore locking issues by
 * making the "IluAny" a simple shell holding a "xerox.ilu.IluPickle" <br>
 * The "xerox.ilu.IluPickle" is immutable... <p>
 *
 * We nevertheless do pickling immediately when an IluAny is assigned and
 * unpickling only when a value is extracted. <p>
 *
 * @see xerox.ilu.IluPickle
 * @see xerox.ilu.IluTypeCode
 * @see org.omg.CORBA.TypeCode
 * @see org.omg.CORBA.Any
 */
 
public final class IluAny extends org.omg.CORBA.Any {
    private xerox.ilu.IluPickle thePickle = null;
    
    /** Not recommended */
    public IluAny() {}
    
    /** 
     * Returns the current pickle or raises an exception if none.
     * Not CORBA. 
     */
    public final xerox.ilu.IluPickle getPickle() 
            throws xerox.ilu.IluSystemException {
        xerox.ilu.IluPickle pickle = this.thePickle;
        if (pickle==null) { 
            throw new xerox.ilu.IluSystemException(
                "No value has been assigned"
                );
        }
        return pickle;
    } //getPickle
       

    /** 
     * Assigns a new pickle.
     * Not CORBA. 
     */
    public final void setPickle(xerox.ilu.IluPickle pickle) 
            throws xerox.ilu.IluSystemException {
        pickle.ensureValidPickle();
        this.thePickle = pickle;
    } //setPickle
    
    
    /** 
     * Returns a TypeCode for the value contained in the IluAny. 
     */
    public xerox.ilu.IluTypeCode type() throws xerox.ilu.IluSystemException {
        xerox.ilu.IluPickle pickle = getPickle();
        return pickle.type();
    } //type   


    /** 
     * TOTALLY IDIOTIC CORBA FUNCTION.
     */
    public void type(org.omg.CORBA.TypeCode t) 
            throws xerox.ilu.IluSystemException {
        throw new xerox.ilu.IluSystemException("moron");
    } //type   
 

    /** 
     * Returns a Java value for the value contained in the IluAny
     * Returns instances of Java wrapper classes instead of Java 
     * basic types.
     * Not CORBA.
     */
    public java.lang.Object value() throws xerox.ilu.IluSystemException {
        xerox.ilu.IluPickle pickle = thePickle;
        if (pickle==null) return null;
        return pickle.value();
    } //value


    /** 
     * The formal value input argument needs to have the Java class
     * or subclass for the mapping of the IDL type.  If an input
     * argument is mapped to a Java basic type, this procedure will
     * accept the corresponding Java wrapper class.
     * Not CORBA.
     */ 
    public static IluAny alloc(IluTypeCode type, java.lang.Object value) 
            throws xerox.ilu.IluSystemException {
        xerox.ilu.IluPickle pickle = xerox.ilu.IluPickle.alloc(type, value);
        IluAny a = new IluAny();
        a.thePickle = pickle;
        return a;
    } //alloc
    
    /** 
     * Not recommended to clients.
     * Not CORBA.
     */
    public void assign(IluTypeCode type, java.lang.Object value) 
            throws xerox.ilu.IluSystemException {
        xerox.ilu.IluPickle pickle = xerox.ilu.IluPickle.alloc(type, value);
        thePickle = pickle;
    } //assign
         
    
    /** Off-limits to applications; accessed by stubs */
    public void _outAny(xerox.ilu.IluCall call) 
             throws xerox.ilu.IluSystemException {
        xerox.ilu.IluPickle pickle = getPickle();
        pickle._out(call);
    } //_outAny
    
           
    /** Off-limits to applications; accessed by stubs */
    public int _szAny(xerox.ilu.IluCall call) 
             throws xerox.ilu.IluSystemException {
        xerox.ilu.IluPickle pickle = getPickle();
        return pickle._sz(call);
    } //_szAny
    
    
    /** Off-limits to applications; accessed by stubs */
    public static IluAny _inAny(xerox.ilu.IluCall call) 
             throws xerox.ilu.IluSystemException {
        xerox.ilu.IluPickle pickle = xerox.ilu.IluPickle._in(call);
        IluAny a = new IluAny();
        a.thePickle = pickle;
        return a;
    } //_inAny
        
      
    /* anticipated stubber generated code in helper classes
     *
     * public static XXXX extract(IluAny any) throws ... {
     *     xerox.ilu.IluPickle pickle = getPickle(); 
     *     return from_IluPickle(pickle); //also stubber generated
     * } //extract
     *
     *
     * public static IluAny insert(XXX _x) throws ... {
     *     xerox.ilu.IluPickle pickle = to_pickle(_x); //also stubber generated
     *     IluAny any = new IluAny();
     *     any.thePickle = pickle;
     *     return any;
     * } //insert
     *
     */

    
    /*friendly*/ static xerox.ilu.IluSystemException badOperation() {
        xerox.ilu.IluSystemException e = 
            new IluSomeSystemException("CORBA::BAD_OPERATION");
        return e; 
    }


    /* 
     * Required standard types ... 
     */
    
    /** 
     * Extract an idl-short value, if it is stored in the IluAny. 
     */
    public short extract_short() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Short) {
            java.lang.Short s = (java.lang.Short) v;
            return s.shortValue();
        }
        throw badOperation(); 
    } //extract_short   

    /** 
     * Stores an idl-short value into the IluAny.
     */
    public void insert_short(short s) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_short(), new java.lang.Short(s));
    } //insert_short   
 
 
    /** 
     * Extract an idl-long (java-int) value, if it is stored in the IluAny. 
     */
    public int extract_long() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Integer) {
            java.lang.Integer i = (java.lang.Integer) v;
            return i.intValue();
        }
        throw badOperation();
    } //extract_long   

    /** 
     * Stores an idl-long (java-int) value into the IluAny.
     */
    public void insert_long(int i) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_long(), new java.lang.Integer(i));
    } //insert_long   
 
 
    /** 
     * Extract an idl-longlong (java-long) value, if it is stored in the IluAny. 
     */
    public long extract_longlong() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Long) {
            java.lang.Long i = (java.lang.Long) v;
            return i.longValue();
        }
        throw badOperation();
    } //extract_longlong   

    /** 
     * Stores an idl-longlong (java-long) value into the IluAny.
     */
    public void insert_longlong(long i) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_longlong(), new java.lang.Long(i));
    } //insert_longlong   
 
 
    /** 
     * Extract an idl-ushort value, if it is stored in the IluAny. 
     */
    public short extract_ushort() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Short) {
            java.lang.Short s = (java.lang.Short) v;
            return s.shortValue();
        }
        throw badOperation(); 
    } //extract_ushort   

    /** 
     * Stores an idl-ushort value into the IluAny.
     */
    public void insert_ushort(short s) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_ushort(), new java.lang.Short(s));
    } //insert_ushort   
 
 
    /** 
     * Extract an idl-ulong (java-int) value, if it is stored in the IluAny. 
     */
    public int extract_ulong() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Integer) {
            java.lang.Integer i = (java.lang.Integer) v;
            return i.intValue();
        }
        throw badOperation();
    } //extract_ulong   

    /** 
     * Stores an idl-long (java-int) value into the IluAny.
     */
    public void insert_ulong(int i) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_ulong(), new java.lang.Integer(i));
    } //insert_long   
 
    /** 
     * Extract an idl-ulonglong (java-long) value, if it is stored in the IluAny. 
     */
    public long extract_ulonglong() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Long) {
            java.lang.Long i = (java.lang.Long) v;
            return i.longValue();
        }
        throw badOperation();
    } //extract_ulonglong   

    /** 
     * Stores an idl-ulonglong (java-long) value into the IluAny.
     */
    public void insert_ulonglong(long i) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_ulonglong(), new java.lang.Long(i));
    } //insert_ulonglong   
 
 
    /** 
     * Extract an float value, if it is stored in the IluAny. 
     */
    public float extract_float() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Float) {
            java.lang.Float i = (java.lang.Float) v;
            return i.floatValue();
        }
        throw badOperation();
    } //extract_float   

    /** 
     * Stores an float value into the IluAny.
     */
    public void insert_float(float i) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_float(), new java.lang.Float(i));
    } //insert_float   
 
 
    /** 
     * Extract an double value, if it is stored in the IluAny. 
     */
    public double extract_double() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Double) {
            java.lang.Double i = (java.lang.Double) v;
            return i.doubleValue();
        }
        throw badOperation();
    } //extract_double   

    /** 
     * Stores an float value into the IluAny.
     */
    public void insert_double(float i) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_double(), new java.lang.Double(i));
    } //insert_double   
 
 
    /** 
     * Extract an boolean value, if it is stored in the IluAny. 
     */
    public boolean extract_boolean() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Boolean) {
            java.lang.Boolean i = (java.lang.Boolean) v;
            return i.booleanValue();
        }
        throw badOperation();
    } //extract_boolean   

    /** 
     * Stores an boolean value into the IluAny.
     */
    public void insert_boolean(boolean i) 
            throws xerox.ilu.IluSystemException {
        assign(
            IluTypeCode.corba_boolean(), 
            (i ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE)
            );
    } //insert_boolean   
 
    /** 
     * Extract an char value, if it is stored in the IluAny. 
     */
    public char extract_char() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Character) {
            java.lang.Character i = (java.lang.Character) v;
            return i.charValue();
        }
        throw badOperation();
    } //extract_char   

    /** 
     * Stores an char value into the IluAny.
     */
    public void insert_char(char i) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_char(), new java.lang.Character(i));
    } //insert_char   
 

    /** 
     * Extract an wchar value, if it is stored in the IluAny. 
     */
    public char extract_wchar() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Character) {
            java.lang.Character i = (java.lang.Character) v;
            return i.charValue();
        }
        throw badOperation();
    } //extract_wchar   

    /** 
     * Stores an wchar value into the IluAny.
     */
    public void insert_wchar(char i) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_char(), new java.lang.Character(i));
    } //insert_wchar   
 

    /** 
     * Extract an octet value, if it is stored in the IluAny. 
     */
    public byte extract_octet() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.Byte) {
            java.lang.Byte b = (java.lang.Byte) v;
            return b.byteValue();
        }
        throw badOperation();
    } //extract_octet   

    /** 
     * Stores an octet value into the IluAny.
     */
    public void insert_octet(byte i) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_octet(), new java.lang.Byte(i));
    } //insert_octet   
 

    /** 
     * Extract an IluAny value from an IluAny, if it is stored in the IluAny. 
     */
    public IluAny extract_IluAny() throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof IluAny) return (IluAny) v;
        throw badOperation();
    } //extract_IluAny   

    /** 
     * Stores an IluAny value into the IluAny.
     */
    public void insert_IluAny(IluAny a) throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_any(), a);
    } //insert_IluAny   
 
 
    /** 
     * Extract an org.omg.CORBA.Object value from an IluAny, 
     * if it is stored in the IluAny. 
     */
    public org.omg.CORBA.Object extract_Object() 
            throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof org.omg.CORBA.Object) {
            return (org.omg.CORBA.Object) v;
        }
        throw badOperation();
    } //extract_Object   

    /** 
     * Stores an CORBA.Object value into the IluAny.
     */
    public void insert_Object(org.omg.CORBA.Object obj) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_objref(), obj);
    } //insert_Object   


    /** 
     * Extract an string value, if it is stored in the IluAny. 
     */
    public java.lang.String extract_string() 
            throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.String) {
            return (java.lang.String) v;
        }
        throw badOperation();
    } //extract_string   

    /** 
     * Stores an string value into the IluAny.
     */
    public void insert_string(java.lang.String s) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_string(), s);
    } //insert_string   
 

    /** 
     * Extract an wstring value, if it is stored in the IluAny. 
     */
/*
    public java.lang.String extract_wstring() 
            throws xerox.ilu.IluSystemException {
        java.lang.Object v = this.value();
        if (v instanceof java.lang.String) {
            return (java.lang.String) v;
        }
        throw badOperation();
    } //extract_wstring   
*/
    /** 
     * Stores an wstring value into the IluAny.
     */
/*
    public void insert_wstring(java.lang.String s) 
            throws xerox.ilu.IluSystemException {
        assign(IluTypeCode.corba_wstring(), s);
    } //insert_wstring   
*/
    
    /* wstring is not yet implemented */
    /* TypeCode is not a first class data type in ILU  */
    /* Principal is depreciated by omg; use Passports in ILU */
 
} //IluAny



