/* IluEnvironment.java */
/* Chris Jacobi, April 21, 1997 11:00 am PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluEnvironment.java,v 1.4 1997/04/21 18:45:41 jacobi Exp $ */

package xerox.ilu;

/**
 * Access of values set up by the environment. <p>
 */
public final class IluEnvironment {
    
/*===== Generic property access =====*/
    
    /** 
     * Accesses a string from the system properties.
     * null if not defined
     */
    public static String getStringProp(java.lang.String key) {
        return xerox.basics.Environment.getStringProp(key);
    } //getStringProp
    
    /** 
     * Accesses an integer from the system properties.
     * If not defined, returns defaultvalue
     */
    public static int getIntProp(java.lang.String key, int defaultvalue) {
        return xerox.basics.Environment.getIntProp(key, defaultvalue);
    } //getIntProp
    
    
/*===== Specific properties =====*/

    private static int threadPrio = 0;
    
    /** Regular property used for most ilu threads */
    public static int threadPriority() {
        if (threadPrio<=0) {
            threadPrio = getIntProp(
                "ilu.priority", java.lang.Thread.MAX_PRIORITY-3);
        }
        return threadPrio;
    }
    
    
    /** 
     * Returns whether the caller "frames" down
     * is priviledged to modify ilu features.
     * 1 frame down is the direct caller of isPriviledged)
     * Priviledged means there is no class loader, or, the
     * same class loader which was used for ilu itself.
     */
    public static boolean isPriviledged(int frames) {
        //we don't do real applets yet...
        return true;
    }

} // IluEnvironment
