/* IluJava_IluPort.c */ 
/* Chris Jacobi, November 6, 1997 3:21 pm PST */

/*
 * Copyright (c) 1996, 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluJava_IluPort.c,v 1.34 1997/11/25 22:19:32 janssen Exp $ */
 
/*
 * C side of IluPort.java, IluPassport.java, IluIdentity, IluIdentityType and IluTransportInfo.java
 */

#include "IluJava_Includes.h"
#include "IluJava_Common.h"
#include "IluJava_JArrays.h"


#include "IluJava_JStubs.h"
#include "xerox_ilu_IluIdentity.h"
#include "xerox_ilu_IluIdentityType.h"
#include "xerox_ilu_IluPassport.h"
#include "xerox_ilu_IluPipeline.h"
#include "xerox_ilu_IluSerializationContext.h"
#include "xerox_ilu_IluSBH.h"
#include "IluJava_JGC.h"

#define JIluPort Hxerox_ilu_IluPort*
#define JIluTransportInfo Hxerox_ilu_IluTransportInfo*
#define JIluPassport Hxerox_ilu_IluPassport*
#define JIluSerializationContext Hxerox_ilu_IluSerializationContext*
#define JIluPipeline Hxerox_ilu_IluPipeline*
#define JIluSBH Hxerox_ilu_IluSBH*
#define JIluIdentity Hxerox_ilu_IluIdentity*
#define JIluIdentityType Hxerox_ilu_IluIdentityType*

#include "IluJava_Ops.h"


JAVAEXPORT(IluPort_nativeInitPort, void) 
    JIluPort jh_Port
    ENDJAVAEXPORT
{

    JGC_WP_TYPE(JIluPort) jwp_Port = JGC_GET_WP_FROM_JAVA_OBJECT(jh_Port);
    JGC_WP_TYPE(JIluServer) jwp_Server = 
    JGC_GET_WP_FROM_JAVA_OBJECT(GET_IluPort_jjServer(jh_Port));
    JString jjProtocolInfo = 
        GET_IluPort_jjProtocolInfo(JGC_WP_REVEAL(jwp_Port));
    JIluTransportInfo jjTransportInfo;
    JIluPassport jjPassport;
    ilu_string cProtInfo;
    ilu_Server cServer;
    ilu_TransportInfo cTransInfo = 0;
    ilu_Passport cPassport = 0; 
    ilu_Port cPort;
    ilu_Error errs;
    if (jjProtocolInfo) {
        cProtInfo = COPY_TO_FREEABLE_C_STRING(jjProtocolInfo);
    } else {
        cProtInfo = ilu_DefaultProtocolInfo();
    }
    jjTransportInfo = GET_IluPort_jjTransportInfo(JGC_WP_REVEAL(jwp_Port));
    if (jjTransportInfo) {
        cTransInfo = GET_IluTransportInfo_yIluTransportInfo(jjTransportInfo);
    }
    if (cTransInfo == 0) {
        cTransInfo = ilu_DefaultTransportInfo();
    }
    cServer = GET_IluServer_yIluServer(JGC_WP_REVEAL(jwp_Server));
    if (_ilujava_pctFlag > 0) {
        ilu_DebugPrintf("$ IluPort_nativeInitPort jprt: %x jsrv: %x csrv %x\n", 
            (int) JGC_WP_REVEAL(jwp_Port), 
            (int) JGC_WP_REVEAL(jwp_Server), (int) cServer);
    }
	jjPassport = GET_IluPort_jjPassport(JGC_WP_REVEAL(jwp_Port));
    if (jjPassport) {
        cPassport = GET_IluPassport_yIluPassport(jjPassport);
    }
    cPort = ilu_CreatePort(cServer, cProtInfo, cTransInfo, cPassport, &errs);
    if (jjProtocolInfo) {
        java_free(cProtInfo);
    }
    if (ILU_ERRNOK(errs)) {
        CONDPRINT("$ nativeInitPort: Error creating port");
        _ilujava_IluErrorToException(&errs, "Error creating port");
        return;
    }
    if (cPort == 0) {
        CONDPRINT("$ nativeInitPort: null port");
        SignalError(EE(), "xerox/ilu/IluSomeSystemException", "null port");
        return;
    }
    PUT_IluPort_yPort(JGC_WP_REVEAL(jwp_Port), cPort);
    if (_ilujava_pctFlag>0) {
        ilu_DebugPrintf("$ Port created %x \n", (int) cPort);
    }
} /* nativeInitPort */


JAVAEXPORT(IluPort_nativeClosePort, void) 
    JIluPort jjPort
    ENDJAVAEXPORT
{
    ilu_Port cPort = GET_IluPort_yPort(jjPort);
    if (cPort == 0) return;
    ilu_ClosePort(cPort);
 }  /* nativeClosePort */


JAVAEXPORT(IluPort_nativeDonePort, void) 
    JIluPort jjPort
    ENDJAVAEXPORT
{
    ILU_ERRS((bad_param, bad_locks, internal)) errs;
    ilu_boolean dontCare;
    ilu_Port cPort = GET_IluPort_yPort(jjPort);
    ILU_CLER(errs);
    if (cPort == 0) return;
    PUT_IluPort_yPort(jjPort, 0);
    if (GET_IluPort_pstate(jjPort) > 3) return;
    PUT_IluPort_pstate(jjPort, 99);
    dontCare = ilu_DoneWithPort(cPort, &errs);
}  /* nativeDonePort */


JAVAEXPORT(IluTransportInfo_nativeInitTransportInfo, void) 
    JIluTransportInfo jh_TransInfo,
    HArrayOfString * jjInfo
    ENDJAVAEXPORT
{
    JGC_WP_TYPE(JIluTransportInfo) jwp_TransInfo = JGC_WP_MAKE(jh_TransInfo);
	char ** cObject = 0;
    if (jjInfo) {
        char * rover; /* the next un-assigned byte */
        JString jjString;
        int totalLen = 0;
        int thisLen = 0;
        int i;
        int cnt = obj_length(jjInfo);
        /* compute length */
        for (i = 0; i < cnt; i = i+1) {
            jjString = ARRAY_object_GET(jjInfo, i);
            thisLen = JSTRING_LENGTH(jjString);
            totalLen = totalLen+thisLen;
        }
        totalLen = totalLen + cnt; /* add padding per string */
        totalLen = totalLen + cnt; /* add extra padding per string; see below */
        totalLen = totalLen + (cnt+2)*sizeof(char *); 
                /* pointer array, stopper and final padding */
        /* allocate data */
        cObject = (char **) ilu_must_malloc(totalLen);
        /* copy data */
        cObject[cnt] = 0;
        rover = (char *) & (cObject[cnt+1]);
        for (i = 0; i < cnt; i = i+1) {
            cObject[i] = rover;
            jjString = ARRAY_object_GET(jjInfo, i);
            thisLen = JSTRING_LENGTH(jjString);
            /* 
             * ? Must add 1 otherwise it overwrites the last character.   
             * I do not understand this, but the java rt does the same thing.
             */
            javaString2CString(jjString, rover, thisLen+1); /*javaString.h*/
            rover = rover + thisLen+1;
            rover[0] = '\0';
            rover = rover + 1; 
        }
    }
    PUT_IluTransportInfo_yIluTransportInfo(
        JGC_WP_REVEAL(jwp_TransInfo), cObject); 
    JGC_WP_RELEASE(jwp_TransInfo);
} /* nativeInitTransportInfo */


JAVAEXPORT(IluTransportInfo_nativeFinalizeTransportInfo, void) 
    JIluTransportInfo jjTransInfo
    ENDJAVAEXPORT
{
    ilu_TransportInfo cMem =
        GET_IluTransportInfo_yIluTransportInfo(jjTransInfo);
    PUT_IluTransportInfo_yIluTransportInfo(jjTransInfo, 0);
    if (cMem) ilu_free(cMem);
} /* nativeFinalizeTransportInfo */


JAVAEXPORT(IluTransportInfo_nativeCountDefaultComponents, Jint)
    JIluTransportInfo jjTransInfo
    ENDJAVAEXPORT
{
    int result = 0;
    ilu_TransportInfo to = ilu_DefaultTransportInfo();
    if (to) {
        while (*to) {
            to++; result++;
        }
    } 
    return result; 
} /* nativeCountDefaultComponents */


JAVAEXPORT(IluTransportInfo_nativeGetDefaultComponent, JString)
    JIluTransportInfo jjTransInfo,
    Jint n
    ENDJAVAEXPORT
{
    ilu_string cs;
    if (n == -1) {
        /* special convention */
        cs = ilu_DefaultProtocolInfo();
    } else {
        /* normal case */
        ilu_TransportInfo to = ilu_DefaultTransportInfo();
        cs = to[n];
    }
    return makeJavaString(cs, strlen(cs)); 
} /* nativeCountDefaultComponents */


static ilu_Passport cDefaultPassport;


EXPORTLIMITED void
_ilujava_PassportInit()
{
    ilu_Error errs = ILU_INIT_NO_ERR;
    cDefaultPassport = ilu_CreatePassport(0, &errs);
}


EXPORTLIMITED ilu_Passport 
_ilujava_getIluPassport(
        ilu_refany jh_iluPassport /* JIluPassport */ 
	)
/* Converts java passport to ilu passport.
 * Converts null IluPassport into default passport. 
 */
 {
     ilu_Passport cpp = 0;
     JIluPassport jh_pp = (JIluPassport) jh_iluPassport;
     if (jh_pp == 0) return cDefaultPassport;
     cpp = GET_IluPassport_yIluPassport(jh_pp);
     if (cpp == 0) return cDefaultPassport;
     return cpp;
 }


JAVAEXPORT(IluSBH_nativeSetSBHO, void)
	JIluSBH jh_self,
	JString jh_sbhs
	ENDJAVAEXPORT
{
    JGC_WP_TYPE(JIluSBH) jwp_self = JGC_WP_MAKE(jh_self);
    ilu_Error	errs		= ILU_INIT_NO_ERR;
    char*	cSBH;
    char*	cih		= 0;
    char*	csid		= 0;
    char*	cmstid		= 0;
    char*	ccinfo		= 0;
    ilu_cardinal len		= 0;
    ilu_boolean pcinfo		= ilu_FALSE;
    cSBH = COPY_TO_FREEABLE_C_STRING(jh_sbhs); 
    if (!ilu_ParseSBH(cSBH, &cih, &csid, &cmstid, &ccinfo, &len, &pcinfo, &errs)) { 
         _ilujava_IluErrorToException(&errs, "ilu_ParseSBH");
         return;
    }
    PUT_IluSBH_jjih(JGC_WP_REVEAL(jwp_self),    
        makeJavaString(cih, strlen(cih)));
    PUT_IluSBH_jjsid(JGC_WP_REVEAL(jwp_self),   
        makeJavaString(csid, strlen(csid)));
    PUT_IluSBH_jjmstid(JGC_WP_REVEAL(jwp_self), 
        makeJavaString(cmstid, strlen(cmstid)));
    PUT_IluSBH_jjcinfo(JGC_WP_REVEAL(jwp_self), 
        makeJavaString(ccinfo, len));
    JGC_WP_RELEASE(jwp_self);
    ilu_free(cih);
    ilu_free(csid);
    ilu_free(cmstid);
    if (pcinfo) ilu_free(ccinfo);
    java_free(cSBH);
}


JAVAEXPORT(IluPassport_nInitClientPassport, void)
	JIluPassport jh_ppSelf
	ENDJAVAEXPORT
{
    JGC_WP_TYPE(JIluPassport) jwp_pp = JGC_GET_WP_FROM_JAVA_OBJECT(jh_ppSelf);
    ilu_Passport cpp = 0;
    ILU_ERRS((no_memory)) errs;
    ILU_CLER(errs);
    cpp = ilu_CreatePassport(0, &errs);
    PUT_IluPassport_yIluPassport(JGC_WP_REVEAL(jwp_pp), cpp);
}


JAVAEXPORT(IluPassport_nFinalizePassport, void)
	JIluPassport jh_ppSelf
	ENDJAVAEXPORT
{
    ILU_ERRS((no_memory)) errs;
    ilu_Passport cpp;
    /* no locking or checking:  finalize is protected final */
    cpp = GET_IluPassport_yIluPassport(jh_ppSelf);
    PUT_IluPassport_yIluPassport(jh_ppSelf, 0);
    if (cpp) {
        ILU_CLER(errs);
        ilu_DestroyPassport(cpp, &errs);
    }
}

JAVAEXPORT(IluIdentity_nFinalizeIdentity, void)
	JIluIdentity jh_iiSelf
	ENDJAVAEXPORT
{
    ILU_ERRS((no_memory)) errs;
    ilu_IdentityInfo cii;
    /* no locking or checking:  finalize is protected final */
    cii = GET_IluIdentity_yIluIdentity(jh_iiSelf);
    PUT_IluIdentity_yIluIdentity(jh_iiSelf, 0);
    if (cii) {
        ILU_CLER(errs);
        cii->ii_type->it_free_data(cii, &errs);
        /* ?? does this make sense? */
    }
}


JAVAEXPORT(IluPassport_nAddIdentity, Jint)
	JIluPassport jh_ppSelf,
	JIluIdentity jh_ii
	ENDJAVAEXPORT
{
    ILU_ERRS((no_memory)) errs;
    ilu_Passport cpp;
    ilu_IdentityInfo cii;
    ilu_boolean ret;
    cpp = GET_IluPassport_yIluPassport(jh_ppSelf);
    cii = GET_IluIdentity_yIluIdentity(jh_ii);
    ret = ilu_AddIdentity(cpp, cii, &errs);
    if (ret) {
        /* ok */
        return 0;
    } else {
        /* failed */
        return -1;
    }
}


JAVAEXPORT(IluPassport_nFindIdentity, void)
	JIluPassport jh_ppSelf,
	JIluCall jh_call,
	JIluIdentityType jh_it,
	JIluIdentity jh_iicontainer
	ENDJAVAEXPORT
{
    ILU_ERRS((no_memory)) errs;
    JGC_WP_TYPE(JIluIdentity) jwp_iicontainer = 
        JGC_GET_WP_FROM_JAVA_OBJECT(jh_iicontainer);
    ilu_IdentityInfo cii;
    ilu_Passport cpp = 0;
    ilu_IdentityType cit;
    cpp = GET_IluPassport_yIluPassport(jh_ppSelf);
    cit = GET_IluIdentityType_yIluIdentityType(jh_it);
    if (cpp) {
        /* client generated passport */
    } else {
        ilu_Call cCall = GET_IluCall_yCall(jh_call);
        if (cCall) {cpp = ilu_CallerPassportOfCall(cCall);}
    }
    if (cpp) {
        cii = ilu_FindIdentity(cpp, cit);
        cii = ilu_CopyIdentity(cii, &errs);
        PUT_IluIdentity_yIluIdentity(JGC_WP_REVEAL(jwp_iicontainer), cii);
    }
}


JAVAEXPORT(IluIdentity_nId2String, JString)
	JIluIdentity jh_iiSelf
	ENDJAVAEXPORT
{
    JString jh_string = 0;
    ILU_ERRS((no_memory)) errs;
    ilu_string s = 0;
    ilu_IdentityInfo cii;
    cii = GET_IluIdentity_yIluIdentity(jh_iiSelf);
    if (cii==0) {goto do_return;}
    s = ilu_malloc(1000);
    cii->ii_type->it_string_form(cii, s, 1000, &errs);
    if (ILU_ERRNOK(errs)) {
        goto do_return;
    }
    jh_string = makeJavaString(s, (int) strlen(s));
    /*fall through*/
  do_return:
    if (s) {ilu_free(s);}
    return jh_string;
}


JAVAEXPORT(IluIdentityType_nRegStdIdentityType, Jint)
	JIluIdentityType jh_itSelf,
	Jint key
	ENDJAVAEXPORT
{
    Jint returnkey;
    returnkey = -1;
    if (key==0) {
        PUT_IluIdentityType_yIluIdentityType(
            jh_itSelf, ilu_NoIdentity
            );
        return 1;
    } 
    if (key==1) {
        PUT_IluIdentityType_yIluIdentityType(
            jh_itSelf, ilu_ConnectionIdentity
            );
        return 1;
    } 
    return -1;
}

JAVAEXPORT(IluSerializationContext_nInitSerializationContext, void)
    JIluSerializationContext jh_self,
    JIluServer jh_server,
    JIluOInt jh_oi
    ENDJAVAEXPORT
{
    ILU_ERRS((no_memory, no_resources, bad_locks, broken_locks, bad_param)) errs;
    ilu_Server cServer = 0;
    ilu_Serializer cSerializer = 0;
    /* using frame instead weak pointer because once the serializer
     * has been setup there is no further native call which is 
     * under danger of java garbage collection
     */ 
    struct {
       JIluSerializationContext jh_serializer;
       } frame;
    JGC_FRAME_DECL(framename)  
    JGC_FRAME_PUSH(framename, &frame, sizeof(frame))
    frame.jh_serializer = jh_self;
    if (jh_server) {
        cServer = GET_IluServer_yIluServer(jh_server);
        
        /* ??? wait a second: 
        this is done outside the server lock.  This is only
        legal if holding on to the IluServer will hold on
        to the cServer...
        Not a problem yet as (September 19, 1997 1:47:22 pm PDT)
        because surrogate IluServer don't even exist.
        */
        
        cSerializer = ilu_GetSerializer(cServer, &errs);
            /* java garbage collection */
        if (ILU_ERRNOK(errs)) {
            cSerializer = 0;
        } else {
            /* good */
        }
    } else if (jh_oi) {
        /* we need to prevent unlucky finalization order
         * which would retire the server before the serializer 
         * is released.  Thats why we used to use ilu_DeltaServerHolds
         */
        KInfo kinfo;
        _ilujava_getSetCIluObject(jh_oi, &kinfo, ilu_TRUE);
        if (kinfo.cIluObject) {
            
            /*
            Not necessary anymore since now GetSerializer does 
            DeltaServerHolds in the kernel ...            
            ilu_DeltaServerHolds(kinfo.cServer, 1, &errs);
            if (ILU_ERRNOK(errs)) {
                _ilujava_IluErrorToCallException(&errs, "zzzz");
            } else {
                PUT_IluSerializationContext_ykServer(
                    frame.jh_serializer, kinfo.cServer
                    );
                PUT_IluSerializationContext_yClass(
                    frame.jh_serializer, kinfo.cClass
                    );
                cSerializer = ilu_InnerGetSerializer(kinfo.cServer, &errs);
                if (ILU_ERRNOK(errs)) { cSerializer = 0;}
            }
            */
            
            cSerializer = ilu_InnerGetSerializer(kinfo.cServer, &errs);
            if (ILU_ERRNOK(errs)) { cSerializer = 0;}
            ilu_ExitServer(kinfo.cServer, kinfo.cClass);
        }
    }
    PUT_IluSerializationContext_ySerializationContext(
        frame.jh_serializer, cSerializer
        );
    JGC_FRAME_POP(framename)
}

JAVAEXPORT(IluSerializationContext_nFinalizeSerializationContext, void)
    JIluSerializationContext jh_self
    ENDJAVAEXPORT
{
    ILU_ERRS((bad_locks, broken_locks, bad_param)) errs;
    ilu_Serializer cSerializer = 0;
    ilu_Class cClass = 0;
    ilu_Server cServer = 0;
    cSerializer = GET_IluSerializationContext_ySerializationContext(jh_self);
    cServer = GET_IluSerializationContext_ykServer(jh_self);
    cClass = GET_IluSerializationContext_yClass(jh_self);
    PUT_IluSerializationContext_ySerializationContext(jh_self, 0);
    PUT_IluSerializationContext_ykServer(jh_self, 0);
    PUT_IluSerializationContext_yClass(jh_self, 0);
    if (cSerializer) {
        ilu_ReleaseSerializer(cSerializer, &errs);
    }
    
    
    /*
    DeltaServerHolds is now done in the kernel
    and doesn't need to be done by the LSR anymore
    if (cServer) {
        ilu_EnterServer(cServer, cClass);
        ilu_DeltaServerHolds(cServer, -1, &errs);
        ilu_ExitServer(cServer, cClass);
    }
    */
    
}


JAVAEXPORT(IluPipeline_nInitPipeline, void)
    JIluPipeline jh_self
    ENDJAVAEXPORT
{
    ILU_ERRS((no_memory, no_resources, bad_locks, broken_locks, bad_param)) errs;
    ilu_Pipeline cPipeline = 0;
    /* using frame instead weak pointer because once the pipeline
     * has been setup there is no further native call which is 
     * under danger of java garbage collection
     */ 
    struct {
       JIluPipeline jh_pipline;
       } frame;
    JGC_FRAME_DECL(framename)  
    JGC_FRAME_PUSH(framename, &frame, sizeof(frame))
    frame.jh_pipline = jh_self;
    cPipeline = ilu_GetPipeline(&errs);
        /* java garbage collection */
    if (ILU_ERRNOK(errs)) {
    } else {
        PUT_IluPipeline_yIluPipeline(frame.jh_pipline, cPipeline);
    }
    JGC_FRAME_POP(framename)
}

JAVAEXPORT(IluPipeline_nFinalizePipeline, void)
    JIluPipeline jh_self
    ENDJAVAEXPORT
{
    ILU_ERRS((bad_locks, broken_locks, bad_param)) errs;
    ilu_Pipeline cPipeline = 0;
    cPipeline = GET_IluPipeline_yIluPipeline(jh_self);
    PUT_IluPipeline_yIluPipeline(jh_self, 0);
    if (cPipeline) {
        ilu_ReleasePipeline(cPipeline, &errs);
    }
}


/* end */



