# Top level makefile to build Win32 version of ILU using
# Microsoft Visual C++

!IF "$(CFG)" == ""
CFG=Win32 Release
!MESSAGE No configuration specified.  Defaulting to Win32 Release.
!ENDIF 

!IF "$(CFG)" != "Win32 Release" && "$(CFG)" != "Win32 Debug"
!MESSAGE Invalid configuration "$(CFG)" specified.
!MESSAGE You can specify a configuration when running NMAKE on this makefile
!MESSAGE by defining the macro CFG on the command line.  For example:
!MESSAGE 
!MESSAGE NMAKE /f "iluwin32.mak" CFG="Win32 Release"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "Win32 Release"
!MESSAGE "Win32 Debug"
!MESSAGE 
!ERROR An invalid configuration is specified.
!ENDIF 

!IF "$(JAVA_HOME)" == ""
ALL : NOJAVAMAKE
!ELSE

JAVA_CLASS_DIR=.\javaclasses
JAVA_BUILD_DIR=.\build


!IF "$(CFG)" == "Win32 Release"

!IF "$(JAVASDK)" == "Microsoft"
ILU_JAVAC_FLAGS= /d $(JAVA_CLASS_DIR)
ILU_GNH_FLAGS= -rni
!ELSE
ILU_JAVAC_FLAGS= -d $(JAVA_CLASS_DIR)
ILU_GNH_FLAGS= -oni
!ENDIF
!ELSE
!IF "$(JAVASDK)" == "Microsoft"
ILU_JAVAC_FLAGS= /g /d $(JAVA_CLASS_DIR)
ILU_GNH_FLAGS= -rni
!ELSE
ILU_JAVAC_FLAGS= -g -d $(JAVA_CLASS_DIR)
ILU_GNH_FLAGS= -oni
!ENDIF
!ENDIF


!IF "$(JAVASDK)" == "Microsoft"
JAVAC = $(JAVA_HOME)\bin\jvc
JAVAH = $(JAVA_HOME)\bin\msjavah
JAVAI = jview
ILU_JAVAH_FLAGS= /d $(JAVA_BUILD_DIR) /noclinit
ILU_JAVAH_STUB_FLAG =
ILU_JAVARTMAKE = ilumsoft.mak
!ELSE
JAVAC = $(JAVA_HOME)\bin\javac
JAVAH = $(JAVA_HOME)\bin\javah
JAVAI = java
ILU_JAVAH_FLAGS= -d $(JAVA_BUILD_DIR)
ILU_JAVAH_STUB_FLAG = -stubs
ILU_JAVARTMAKE = ilujsoft.mak
!ENDIF

ALL : $(ILUHOME) $(ILUHOME)\bin $(ILUHOME)\lib JAVAMAKE

!ENDIF

################################################################################

NOJAVAMAKE :
	echo JAVA_HOME environment variable not set, not building Java runtime

$(ILUHOME) : 
    if not exist $(ILUHOME)\nul mkdir $(ILUHOME)

$(ILUHOME)\lib : 
    if not exist $(ILUHOME)\lib\nul mkdir $(ILUHOME)\lib

$(ILUHOME)\bin : 
    if not exist $(ILUHOME)\bin\nul mkdir $(ILUHOME)\bin


BASIC_SOURCES = \
	NowhereStream.java \
	NowhereWriter.java \
	Consumer0.java \
	Queue.java \
	Environment.java \
	VMExtras.java \
	IntTab.java \
	float128.java

PRE_SOURCES = \
	IluInit.java

PRE_EXCEPTION_SOURCES = \
	CompletionStatus.java \
	NO_MEMORY.java \
	IMP_LIMIT.java \
	COMM_FAILURE.java \
	INITIALIZE.java \
	NO_IMPLEMENT.java \
	BAD_TYPECODE.java \
	NO_RESOURCES.java \
	NO_RESPONSE.java \
	PERSIST_STORE.java \
	BAD_INV_ORDER.java \
	TRANSIENT.java \
	FREE_MEM.java \
	INV_IDENT.java \
	INV_FLAG.java \
	INTF_REPOS.java \
	BAD_CONTEXT.java \
	OBJ_ADAPTER.java \
	OBJECT_NOT_EXIST.java \
	TRANSACTIONREQUIRED.java \
	TRANSACTIONROLLEDBACK.java \
	INTERNAL.java \
	MARSHAL.java \
	BAD_PARAM.java \
	IluBadParameterException.java \
	UNKNOWN.java \
	IluInconsistentCallException.java \
	IluNoObjectException.java \
	IluInternalException.java \
	IluUnexpectedException.java \
	IluSomeSystemException.java \
	SystemException.java \
	IluSystemException.java \
	IluSystemException0.java \
	IluRuntimeError.java \
	IluUserExceptionBase.java \
	IluSystemExceptionBase.java 

EXCEPTION_SOURCES = \
	IluCallException.java \
	UserException.java \
	IluEnumerationRangeException.java \
	BAD_OPERATION.java \
	IluUnionDiscriminantException.java \
	DATA_CONVERSION.java \
	IluCharacterRangeException.java \
	NO_PERMISSION.java \
	INV_OBJREF.java \
	IluConstantValueKind.java \
	IluTypeKind.java \
	TCKind.java

RT_SOURCES = \
	BOA.java \
	ORB.java \
	IluLifetimeArgs.java \
	IluLifetimeRemember.java \
	IluLifetimeForget.java \
	IluUserException.java \
	IluDebugWriter.java \
	IluEnvironment.java \
	IluDebug.java \
	IluDataSupport.java \
	IluIHProposer.java \
	IluObject.java \
	Object.java \
	ObjectImpl.java \
	IluWPBase.java \
	IluObjectBase.java \
	IluFactory.java \
	IluPassport.java \
	IluSerializationContext.java \
	IluPipeline.java \
	IluSurrogateConnection.java \
	IluServiceThread.java \
	IluServerConnection.java \
	IluIdentity.java \
	IluIdentityType.java \
	IluUnixIdentityType.java \
	IluInit2.java \
	IluDebugHooks.java \
	IluClassRep.java \
	IluClassAccess.java \
	IluRuntimeException.java \
	IluExceptionRep.java \
	IluOInt.java \
	IluAlarmTech.java \
	IluForkTech.java \
	IluCall.java \
	IluMethodRep.java \
	IluMethodArgRep.java \
	IluServer.java \
	IluServerRelocation.java \
	IluServerRelocationInfo.java \
	IluObjectTable.java \
	IluRT0.java \
	IluSkeleton.java \
	IluSurrogateObject.java \
	IluTransportInfo.java \
	IluPort.java \
	IluServantFinalizable.java \
	corba_ServantFinalizer.java \
	IluGCClient.java \
	Ilu.java \
	IluSBH.java \
	IluSimpleBinding.java \
	IluTypeCode.java \
	TypeCode.java \
	IluTypeRep.java \
	Any.java \
	IluAny.java \
	IluIOFunctions.java \
	IluCustomMapping.java \
	IluCustomMappingException.java \
	IluPickle.java \
	IluRootObjectHelper.java \
	CStringHolder.java \
	CStringHelper.java \
	CORBA_ObjectStub.java \
	CORBA_ObjectHelper.java

HOLDER_SOURCES = \
	ShortHolder.java \
	IntHolder.java \
	LongHolder.java \
	ByteHolder.java \
	FloatHolder.java \
	DoubleHolder.java \
	CharHolder.java \
	BooleanHolder.java \
	StringHolder.java \
	ObjectHolder.java \
	AnyHolder.java \
	TypeCodeHolder.java \
	PrincipalHolder.java 

XEROX_C_AND_H_SOURCES = \
	xerox.ilu.IluInit2 \
	xerox.ilu.IluPassport \
	xerox.ilu.IluSerializationContext \
	xerox.ilu.IluPipeline \
	xerox.ilu.IluIdentity \
	xerox.ilu.IluIdentityType \
	xerox.ilu.IluUnixIdentityType \
	xerox.ilu.IluServiceThread \
	xerox.ilu.IluServerConnection \
	xerox.ilu.IluSurrogateConnection \
	xerox.ilu.IluOInt \
	xerox.ilu.IluClassRep \
	xerox.ilu.IluServer \
	xerox.ilu.IluServerRelocation \
	xerox.ilu.IluServerRelocationInfo \
	xerox.ilu.IluAlarmTech \
	xerox.ilu.IluForkTech \
	xerox.ilu.IluCall \
	xerox.ilu.IluExceptionRep \
	xerox.ilu.IluRT0 \
	xerox.ilu.IluTransportInfo \
	xerox.ilu.IluPort \
	xerox.ilu.IluDebugHooks \
	xerox.ilu.IluGCClient \
	xerox.ilu.IluDebug \
	xerox.ilu.IluDebugWriter \
	xerox.ilu.IluPickle \
	xerox.ilu.IluTypeCode \
	xerox.ilu.IluTypeRep \
	xerox.ilu.IluSBH \
	xerox.ilu.IluWPBase


XEROX_H_SOURCES = \
	xerox.ilu.IluObject \
	xerox.ilu.IluMethodRep \
	xerox.ilu.IluMethodArgRep \
	xerox.ilu.IluObjectTable \
	xerox.ilu.IluSurrogateObject


JAVAMAKE :
	if not exist .\javaclasses\nul mkdir .\javaclasses
	if not exist .\javaclasses\nul mkdir .\build
	if exist .\ilunative.h attrib -r .\ilunative.h
	if exist .\ilunative.c attrib -r .\ilunative.c
	$(JAVAC) $(ILU_JAVAC_FLAGS) gnh.java
	set CLASSPATH=.\javaclasses;$(CLASSPATH)
	$(JAVAI) xerox.ilu.tools.gnh $(ILU_GNH_FLAGS) ilunative.in
	$(JAVAC) $(ILU_JAVAC_FLAGS) $(BASIC_SOURCES)
	$(JAVAC) $(ILU_JAVAC_FLAGS) $(PRE_SOURCES)
	$(JAVAC) $(ILU_JAVAC_FLAGS) $(PRE_EXCEPTION_SOURCES)
	$(JAVAC) $(ILU_JAVAC_FLAGS) $(EXCEPTION_SOURCES)
	$(JAVAC) $(ILU_JAVAC_FLAGS) $(RT_SOURCES)
	$(JAVAC) $(ILU_JAVAC_FLAGS) $(HOLDER_SOURCES)
	$(JAVAH) $(ILU_JAVAH_FLAGS) $(ILU_JAVAH_STUB_FLAG) $(XEROX_C_AND_H_SOURCES)
	$(JAVAH) $(ILU_JAVAH_FLAGS) $(XEROX_C_AND_H_SOURCES)
	$(JAVAH) $(ILU_JAVAH_FLAGS) $(XEROX_H_SOURCES)
	nmake -f $(ILU_JAVARTMAKE) CFG="$(CFG)"

clean :
    if exist WinDebug\nul del /q WinDebug\*
    if exist WinDebug\nul rmdir WinDebug
    if exist WinRel\nul del /q Winrel\*
    if exist WinRel\nul rmdir Winrel
	if exist $(JAVA_CLASS_DIR) rmdir $(JAVA_CLASS_DIR) /s
	if exist $(JAVA_BUILD_DIR) rmdir $(JAVA_BUILD_DIR) /s
	

# End 
################################################################################
