/*
Copyright (c) 1996-1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: cppparsename.hpp,v 1.13 1997/09/10 17:41:12 srjohnso Exp $
*/

#ifndef _cppparsename_hpp_
#define _cppparsename_hpp_ 1


#ifdef __GNUC__  // G++2.7.1 Compiler Note #2
#pragma interface "cppparsename.hpp"
#endif  // __GNUC__

#include "iluptypecpp.hpp"


#define CppParseName_(name) NAME_INSIDE_SCOPE(CppParseName, name)
#define CppParseName(name) NAME_OUTSIDE_SCOPE(CppParseName, name)

BEGIN_NAMESPACE(CppParseName)

  typedef const char * CppParseName_(Key);

  class CppParseName_(Scope);

  class CppParseName_(Name) {
    public: // name access
      const char * name (const CppParseName_(Scope) * context = NULL) const;
      const char * name (CppParseName_(Key), const CppParseName_(Scope) * context = NULL) const;
      const char * localName (CppParseName_(Key) = NULL) const;
      const char * baseName () const;
      const CppParseName_(Scope) * scope () const;
      virtual const char * simpleName (CppParseName_(Key) key = NULL) const;
    public:
      CppParseName_(Name) (::iluptype::Name, const CppParseName_(Scope) * = NULL);
      CppParseName_(Name) (::iluptype::Type);
      CppParseName_(Name) (::iluptype::Procedure);  // TMP 7/3: NEW
      CppParseName_(Name) (::iluptype::Imported);
      CppParseName_(Name) (::iluptype::Interface);
      CppParseName_(Name) (::iluptype::Exception);
      CppParseName_(Name) (const char *, const CppParseName_(Scope) * = NULL);
      virtual ~CppParseName_(Name) ();
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      protected:
        void reInit (::iluptype::Name n, const CppParseName_(Scope) * ns);
        void reInit (::iluptype::Type);
        void reInit (::iluptype::Procedure);  // TMP 7/3: NEW
        void reInit (::iluptype::Imported);
        void reInit (::iluptype::Interface);
        void reInit (::iluptype::Exception);
        void reInit (const char *, const CppParseName_(Scope) *);
      protected:
        CppParseName_(Scope) * definedIn;
        char * sName;
        ::iluptype::Name pName;
        ILUCPP_BOOL ownPName;
    #else
      protected:
        const CppParseName_(Scope) * definedIn;
        ::iluptype::Name pName;
        const char * sName;
        const ILUCPP_BOOL ownPName;
    #endif  // __SUNPRO_CC
    #ifdef __GNUC__ // G++2.7.1 Compiler Note #3
      public:
    #else
      protected:
    #endif  // __GNUC__
        void resetName (const CppParseName_(Scope) *);
        void resetName (::iluptype::Name, const CppParseName_(Scope) *);
  };

  class CppParseName_(TempName) {
    public: // name access
      const char * name (const CppParseName_(Scope) * context = NULL) const;
      const char * name (CppParseName_(Key), const CppParseName_(Scope) * context = NULL) const;
      const char * localName (CppParseName_(Key) = NULL) const;
      const char * baseName () const;
      const CppParseName_(Scope) * scope () const;
      const char * simpleName () const;
    public:
      CppParseName_(TempName) ();
      CppParseName_(TempName) (const char *, const CppParseName_(Scope) * = NULL);
      void reset (const char *, const CppParseName_(Scope) * = NULL);
    private:
      const CppParseName_(Scope) * definedIn;
      const char * _m_baseName;
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      protected:
        void reInit (const char *, const CppParseName_(Scope) *);
    #endif  // __SUNPRO_CC
  };

  enum CppParseName_(ContinuationFlag) {
    CppParseName_(proceed),
    CppParseName_(halt)
    };

  class CppParseName_(Scope) : public virtual CppParseName_(Name), public virtual CppParseNarrow_Root {
    CppParseNarrow_FUNCS0(CppParseName_(Scope));
    public:
      virtual CppParseName_(ContinuationFlag) qualify (const char * n, const char ** qn, CppParseName_(Key) key, const CppParseName_(Scope) * context) const;
      virtual CppParseName_(ContinuationFlag) qualifyLocal (const char * n, const char ** qn, CppParseName_(Key) key) const;
    protected:  // construction
      CppParseName_(Scope) (::iluptype::Name, const CppParseName_(Scope) *  parent = NULL);
  };


  enum CppParseName_(TypeUsage) {
    CppParseName_(in),                   // "IN" procedure argument
    CppParseName_(out),                  // "OUT" procedure argument
    CppParseName_(inOut),                // "INOUT" procedure argument
    CppParseName_(returnVal),            // procedure return value
    CppParseName_(recordMember),         // record or exception member
    CppParseName_(unionMember),          // union member
    CppParseName_(element),              // array or sequence element
    CppParseName_(var),                  // T_var
    CppParseName_(ptr),                  // T_ptr
    CppParseName_(slice),                // T_slice
    CppParseName_(constRef)              // const_T (Strings, WideStrings, Optionals)  // TMP 8/3: NEW
  };

  struct CppParseName_(AffixPair) {
      const char * prefix;
      const char * suffix;
  };

  struct CppParseName_(AffixSet) {
      CppParseName_(AffixPair) base[CppParseName_(returnVal) + 1];
      CppParseName_(AffixPair) name[CppParseName_(returnVal) + 1];
  };


  class CppParseName_(AliasName);
  
  
  class CppParseName_(TypeName): public virtual CppParseName_(Name) {
      friend CppParseName_(AliasName);
/* TMP 7/20
  public:
      const char * usageName (CppParseName_(TypeUsage), const CppParseName_(Scope) * context = NULL) const;
      const char * localUsageName (CppParseName_(TypeUsage)) const;
*/
  public:
      virtual const char * usageName (CppParseName_(TypeUsage), const CppParseName_(Scope) * context = NULL) const;
      virtual const char * localUsageName (CppParseName_(TypeUsage)) const;
  public:
      virtual const char * simpleName (CppParseName_(TypeUsage)) const;
  public:  // override method inherited from Name
      virtual const char * simpleName (CppParseName_(Key) key = NULL) const;
  protected:  // construction
      CppParseName_(TypeName) (::iluptype::Type);
  private:
      virtual const CppParseName_(AffixSet) * affixes () const = 0;
      virtual const CppParseName_(AffixSet) * optionalAffixes () const = 0;  // TMP 6/28: NEW
  };


  class CppParseName_(AliasName): public virtual CppParseName_(TypeName) {
  public:  // override methods inherited from TypeName
      virtual const char * simpleName (CppParseName_(TypeUsage)) const;
      virtual const char * simpleName (CppParseName_(Key) key = NULL) const;
  protected:  // construction
      CppParseName_(AliasName) (::iluptype::Type alias);
  private:
      CppParseName_(TypeName) * const urTypeName;
  };




  NS_EXTERN ::iluptype::ilu_interface_s * CppParseName_(CorbaInterface);

  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaBoolean) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaULong) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaString_var) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaObject) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaObject_ptr) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaOBJECT_NIL) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaSystemException) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaUserException) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaUNKNOWN) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaCOMPLETED_NO) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaCOMPLETED_MAYBE) ();
  NS_EXTERN const CppParseName_(Name) * CppParseName_(CorbaBAD_PARAM) ();

  NS_EXTERN const CppParseName_(Name) * CppParseName_(iluCString) ();

  NS_EXTERN ILUCPP_BOOL CppParseName_(isIluCString) (const CppParseName_(Name)*);



END_NAMESPACE;


#endif  // _cppparsename_hpp_


/*

    SunPro4.1 Compiler Note #2 - In cases involving virtual inheritance and virtual functions, the compiler will trash the base class' data members before the derived class' constructor completes. Thus, we add a "reInit" member function to re-initialize data members after construction. (Note that this also requires that any "const" data members be made non-const).

    G++2.7.1 Compiler Note #3 - When CppParseName::Name::resetName is protected, the compiler will not allow re-definitions of resetName in derived classes to access it (" method `void CppParseName::Name::setScope(const class CppParseName::Scope *)' is protected ... within this context".

*/
