// Copyright (c) 1997,1998 Albrecht Kleine    All rights reserved
// file version #200

#include "tyaconfig.h"
#include <stdio.h>
#include <native.h>
#include <monitor.h>
#include "tya.h"


#ifdef MEMDEBUG
#include "MemDebug.h"
#endif

//---------------- helpers for function recode()----------------------
//
// all together they are a kind of construction set
//
// compile handling of integer comparison
//
void CompVergleich(unsigned char code,int* pj,unsigned short int opcode86,struct CINFO* cinfo)
{
   int i;
   cinfo->backp[cinfo->backcnt].java=cinfo->bptr+(*pj-1);
   cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
   i=getint16S(pj,cinfo);   
   dprintf(stderr,"jump %d java byte\n",i);
   
   if (code==0xA7)
     CB(JMP1);
   else
     {
	if (code<=0x9e)
	  {
	     CW(OR_AXAX);	// to set proper flags
	     CB(POPAX);
	  }
	else
	  if (code>=0x9f && code<=0xA4)
	    {
	       CB(POPBX);
	       CW(CMP_BXAX);	// to set proper flags
	       CB(POPAX);
	    }
	CW(opcode86);
     }
     cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
     CL(0);			// backpatched later
     cinfo->backp[cinfo->backcnt].javadist=i;
     cinfo->backcnt++;
}

// compile handling of double/float comparison
//
void Comp87Vergleich(unsigned char code,struct CINFO* cinfo)
{
	CW(FCOMPP);
	CW(XOR_BXBX);	// ebx=0
	CW(FSTSW_AX);
	CB(SAHF);
   	CB(XCHG_AXBX);	// mov 0 to ax without "xor","sub"
	CB(JNE);	// to label0
	if (code==0x97 || code == 0x95)	// handling NaN
	{
	  CB(2);
	  CB(JNC);	// to label1 both equal
	  CB(5);
	}
	else
	{
	  CB(3);
	  CB(JNC);	// to label1 both equal
	  CB(6);
	  CB(CMC);
	}
	//label0:	// not_equal
	CB(DEC_AX);	// eax=-1
	CB(JB);		// jb label1
	CB(2);
	CB(INC_AX);	// 
	CB(INC_AX);	// eax=+1
   	//label1:	// ready
	// result in eax == stacktop
}


// for truncate
// uses a helper place for temporary storing the x87-control-word
// (compute 1000.89 to 1000 ,  not 1001)
// FIXME: avoid slow FLDCW_MBP coding
// FIXME: should use own NPU stack in general
//
void Comp87ToInteger(unsigned char code,struct CINFO* cinfo)
{
   switch (code)
     {
      case 0x8b:	// f2i
	CW(MOV_BXAX);
	CB(AND_AX_LONG);
	CL(0x7FC00000);
	CB(CMP_AX);
	CL(0x7FC00000);			// FIXME perhaps easier recognition of nan
	CB(JNE);
	CB(4);
	CW(XOR_AXAX);
	CB(JMPS);
	CB(14+6+7);			// jmp nan_label
	
	CB(PUSHBX);			// 1
	CW(FSTCW_MBP);			// 3
	CB(LOCSTART-4 );		// 4
	CW(MOV_AX_MBP_8);		// 6
	CB(LOCSTART-4);			// 7
	CW(OR_MBP_8_BYTE);		// 9
	CB(LOCSTART-4 +1);		// 10
	CB(0xC);			// 11
	CW(FLDCW_MBP);			// 13
	CB(LOCSTART-4);			// 14
	
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	// 17	fld dword [esp]
	CW(FISTP_MSP);CB(SP_ADDR_BYTE3);// 20	put Int32 result on stack
	break;
      case 0x8c:	// f2l
	CW(MOV_BXAX);
	CB(AND_AX_LONG);
	CL(0x7FC00000);
	CB(CMP_AX);
	CL(0x7FC00000);			// nan check FIXME
	CB(JNE);
	CB(5);
	CW(XOR_AXAX);
	CB(PUSHAX);
	CB(JMPS);
	CB(14+6+1+7);			// jmp nan_label
	
	CB(PUSHBX);			// 1
	CW(FSTCW_MBP);			// 3
	CB(LOCSTART-4 );		// 4
	CW(MOV_AX_MBP_8);		// 6
	CB(LOCSTART-4);			// 7
	CW(OR_MBP_8_BYTE);		// 9
	CB(LOCSTART-4 +1);		// 10
	CB(0xC);			// 11
	CW(FLDCW_MBP);			// 13
	CB(LOCSTART-4);			// 14

	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	
	CB(PUSHBX);			// get 32bit space on stack
	CW(FISTPQ_MSP);CB(SP_ADDR_BYTE3);	
	break;
      case 0x8e:	// d2i
	CW(MOV_BXAX);
	CB(POPAX);
	CB(PUSHAX);
	CB(AND_AX_LONG);
	CL(0x7FF80000);
	CB(CMP_AX);
	CL(0x7FF80000);			// nan check FIXME
	CB(JNE);
	CB(4);
	CW(XOR_AXAX);
	CB(JMPS);
	CB(14+6+1+7);			// jmp nan_label
	
	CB(PUSHBX);			// 1
	
	CW(FSTCW_MBP);			// 3
	CB(LOCSTART-4 );		// 4
	CW(MOV_AX_MBP_8);		// 6
	CB(LOCSTART-4);			// 7
	CW(OR_MBP_8_BYTE);		// 9
	CB(LOCSTART-4 +1);		// 10
	CB(0xC);			// 11
	CW(FLDCW_MBP);			// 13
	CB(LOCSTART-4);			// 14

	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	
	CB(POPBX);
	CW(FISTP_MSP);CB(SP_ADDR_BYTE3);
	break;
      case 0x8f:	// d2l
	CW(MOV_BXAX);
	CB(POPAX);
	CB(PUSHAX);
	CB(AND_AX_LONG);
	CL(0x7FF80000);
	CB(CMP_AX);
	CL(0x7FF80000);			// nan check FIXME

	CB(JNE);
	CB(5);
	CW(XOR_AXAX);
	CB(PUSHAX);
	CB(JMPS);
	CB(14+6+7);			// jmp nan_label

	CB(PUSHBX);			// 1
	
	CW(FSTCW_MBP);			// 3
	CB(LOCSTART-4 );		// 4
	CW(MOV_AX_MBP_8);		// 6
	CB(LOCSTART-4);			// 7
	CW(OR_MBP_8_BYTE);		// 9
	CB(LOCSTART-4 +1);		// 10
	CB(0xC);			// 11
	CW(FLDCW_MBP);			// 13
	CB(LOCSTART-4);			// 14
	
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FISTPQ_MSP);CB(SP_ADDR_BYTE3);// 6
	break;
     }
   CW(MOV_MBP_8_AX);	//2
   CB(LOCSTART-4);	//3
   CW(FLDCW_MBP);	//5
   CB(LOCSTART-4);	//6
   CB(POPAX);		//7
   // nan_label:
}

//-------------------------- local variables ---------------------------------
	  
// read a local variable on stack via ebp
// FIXME: should better arrange #parameter or #variable to both registers...
// ... currently we are using variable only but paramter ("this" etc.)
// ... could be _much_ better   (EXCEPT isinline - of course)
//
// FYI: PUSH means write the logical stacktop, this is not CPU-stacktop
//
void Comp_PUSH_LocalVar(int wo,struct CINFO* cinfo)
{
  // You need to pushax before if applicable, because you have to save OLD stacktop!
  if (cinfo->isinline)
  {     
    if (0==wo)
    {
     CW(MOV_AXDI);
    }
    else
     if (1 ==wo)
     {
	CW(MOV_AXSI);
     }	
    return;
  }
#ifdef USE_REG_OPT
  if (cinfo->mb->args_size==wo)
	CW(MOV_AXDI);
  else
     if (cinfo->mb->args_size+1 ==wo)
	CW(MOV_AXSI);
   else
#endif
     {
	int offset = LOCSTART + SIS4* (cinfo->mb->nlocals + cinfo->mb->args_size -1 - wo);
	if (offset < 128)
	  {
	     CW(MOV_AX_MBP_8);
	     CB(offset);
	  }
	else
	  {
	     CW(MOV_AX_MBP_32);
	     CL(offset);
	  }
     }
}

//
// a special case needed by ret and ret_w opcodes
//
void Comp_PUSH_LocalVarToStack(int wo,struct CINFO* cinfo)
{
  if (cinfo->isinline)
  {     
    if (0==wo)
       CB(PUSHDI);
    else
     if (1 ==wo)
	CB(PUSHSI);
    return;
  }
#ifdef USE_REG_OPT
  if (cinfo->mb->args_size==wo)
	CB(PUSHDI);
  else
     if (cinfo->mb->args_size+1 ==wo)
	CB(PUSHSI);
   else
#endif
     {
	int offset = LOCSTART + SIS4* (cinfo->mb->nlocals + cinfo->mb->args_size -1 - wo);
	if (offset < 128)
	  {
	     CW(0x5D8B);//MOV_BX_MBP_8);
	     CB(offset);
	  }
	else
	  {
	     CW(0x9D8B);//MOV_BX_MBP_32);
	     CL(offset);
	  }
	CB(PUSHBX);
     }
}

//
// write local variable on stack frame via ebp
//
void Comp_POP_StoreLocalVar(int wo,struct CINFO* cinfo)
{
   if (cinfo->isinline)
   {     
    if (0==wo)
    {
     CW(MOV_DIAX);
    }
    else
     if (1 ==wo)
     {
     	CW(MOV_SIAX);
     }
     CB(POPAX);
    return;
   }
#ifdef USE_REG_OPT   
   if (cinfo->mb->args_size==wo)
     CW(MOV_DIAX);
   else
     if (cinfo->mb->args_size+1 ==wo)
     	CW(MOV_SIAX);
     // else //***!!***
     // ^it's commented out for running as read cache
     // 1. because running a write cache seems to be dangerous because of GC
     // 2. because in case of exceptions we need a source to reload registers
#endif
     {
      int offset = LOCSTART + SIS4* (cinfo->mb->nlocals + cinfo->mb->args_size -1 - wo);
      if (offset < 128)
      {
	CW(MOV_MBP_8_AX);
	CB(offset);
      }
      else
      {
     	CW(MOV_MBP_32_AX);
	CL(offset);
      }
     }
  CB(POPAX);	// our _NEW_ stacktop now
}

// inc local integer var
//
void Comp_INC_LocalVar(int wo,int inc,struct CINFO* cinfo)
{
  int offset = LOCSTART + SIS4* (cinfo->mb->nlocals + cinfo->mb->args_size -1 - wo);
  if (cinfo->isinline)
  {
     if (0==wo)
     {
	if (inc==1) 
	  CB(INC_DI);
	else 
	  if (inc==-1) 
	    CB(DEC_DI);
	  else
	  {
	     CW(ADD_DI);
	     CL(inc);
	  }
     }
     else
       if (1==wo)
       {
	  if (inc==1)
	    CB(INC_SI);
	  else
	    if (inc==-1)
	      CB(DEC_SI);
	    else
	    {
	       CW(ADD_SI);
	       CL(inc);
	    }
       }
     return;
  } 
  // ----- end of inline stuff ---------
  if (cinfo->wide)
     dprintf(stderr,"wide iinc:  offs %d  , inc %d\n",offset,inc);
#ifdef USE_REG_OPT
   if (cinfo->mb->args_size==wo)   
     {
	if (inc==1) 
	  CB(INC_DI);
	else 
	  if (inc==-1) 
	    CB(DEC_DI);
	else
	  {
	     CW(ADD_DI);
	     CL(inc);
	  }
     }
   else
     if (cinfo->mb->args_size+1==wo)
	  {
	     if (inc==1)
	       CB(INC_SI);
	     else
	       if (inc==-1)
		 CB(DEC_SI);
	     else
	       {
		  CW(ADD_SI);
		  CL(inc);
	       }
	  }
	// else 
   	// compare above comment marked "***!!***" in Comp_POP_StoreLocalVar()
#endif
	  {
	   if (offset < 128)
	       {

		  if (cinfo->wide)
		    {
		       CW(ADD_MBP_8_LONG);
		       CB(offset);
		       CL(inc);
	            }
		  else
		    {
		       CW(ADD_MBP_8_BYTE);
		       CB(offset);
			    CB(inc);
			 }
		    }
	       else
	       {
	       	  CW(ADD_MBP_32_LONG);
		  CL(offset);
		  CL(inc);
	       }

          }
}

// used for field access
//
void CompAddFieldOffset(struct fieldblock *fbp,struct CINFO* cinfo)
{
	CW(MOV_BX_MBX);		// points to first instance variable
	if ( fbp->u.offset<128 )
	  {
	     CW(ADD_BX_BYTE);	// add offset
	     CB((unsigned char) fbp->u.offset);
	  }
	else
	  {
	     CW(ADD_BX_LONG);
	     CL( fbp->u.offset);
	  }
}

