// Copyright (c) 1997,1998 Albrecht Kleine    All rights reserved
// Copyright (c) 1998 Artur Biesiadowski
// file version #202

#include "tyaconfig.h"
#include <stdio.h>
#include <native.h>
#include <monitor.h>
#include "tya.h"

#ifdef MEMDEBUG
#include "MemDebug.h"
#endif

#ifdef INLINE_LONGARITM
long long __divdi3( long long, long long);
long long __moddi3( long long, long long);
#endif

//-----------------------------------------------------------------------
// most important: the code translator, producing x86_code from bytecode
//
// returns -1 if error    else x bytes read
//
int recode(int j,Classjava_lang_Class *klass,struct CINFO* cinfo)
{
   unsigned char code;
   struct fieldblock *fbp;
   struct methodblock *mbp;
   int jj=j;
   int k,m,n ,wop,stac,*pi,etype;
   int i,defaultip,tabsize,aktip,compar,indexmin,indexmax;
   unsigned char op1;
   unsigned short op2;
   int compileJVMinvoke,compileLOCALspace;
   ClassClass *clazz;

   if (cinfo->cptr - cinfo->codebase >= cinfo->maxspace - cinfo->resspace)
   {
	// lprintf("TYA: not enough space at %d\n",cinfo->maxspace - cinfo->resspace);
        return NOSPACE_ERROR;
   }
   code=*(cinfo->bptr+j);
   cinfo->iptab[cinfo->ipcnt].java=cinfo->bptr+j;
   cinfo->iptab[cinfo->ipcnt].x86=cinfo->cptr;
   cinfo->iptab[cinfo->ipcnt].isdest=0;
   cinfo->ipcnt++;
   j++;
   dprintf(stderr,"Code=%02x\n",code);
#ifdef VERBOSE_ASM86
   iprintf("--------- OPCODE=%02x ",code);
   decode_bytecode(cinfo->bptr+j-1);
   iprintf(" %p ---------\n",cinfo->cptr);
#endif   
   // did not use any #defines like "#define NOP 0" etc,
   // because it's important for you to get a feeling 
   // for the real opcodes: if you see some hexdumped 
   // byte code, then it should be easy to "read" this ;-)
   switch (code)
     {
      case 0:break;	// nop
      case 0x01:	// aconst_null
      case 0x03:	// iconst_0
      case 0x0b:	// fconst_0
	CB(PUSHAX);
	CW(XOR_AXAX);
	break;
      case 0x02:	// iconst_m1
	CB(PUSHAX);
	CB(MOV_AX);
	CL(-1);
	break;
      case 0x04:	// iconst_1
      case 0x05:	// iconst_2
      case 0x06:	// iconst_3
      case 0x07:	// iconst_4
      case 0x08:	// iconst_5	
	CB(PUSHAX);
	CB(MOV_AX);
	CL(code-3);
	break;
      case 0x0a:	// lconst_1
	CB(PUSHAX);
	CB(PUSHLONG2);
	CB(0);
	CB(MOV_AX);
	CL(1);
	break;
      case 0x0c:	// fconst_1
      	CB(PUSHAX);
	CB(MOV_AX);
	CL(0x3F800000);	// = "dd 1.0"
	break;
      case 0x0d:	// fconst_2
	CB(PUSHAX);
	CB(MOV_AX);
	CL(0x40000000);
	break;
      case 0x09:	// lconst_0
      case 0x0e:	// dconst_0
	CB(PUSHAX);
	CB(PUSHLONG2);
	CB(0);
	CW(XOR_AXAX);
	break;
      case 0x0F:	// dconst_1
	CB(PUSHAX);
	CB(PUSHLONG);
	CL(0x3FF00000);	// = "dq 1.0"
	CW(XOR_AXAX);
	break;
      case 0x10:	// bipush
	m=*(signed char*)(cinfo->bptr+j++);
	CB(PUSHAX);
	CB(MOV_AX);
	CL(m);
	break;
      case 0x11:	// sipush
	m=getint16S(&j,cinfo);
	CB(PUSHAX);
	CB(MOV_AX);
	CL(m);
	break;
      case 0x12:	// ldc1
      case 0xCB:	// ldc_quick
	op1=*(cinfo->bptr+j++);
	if (code==0x12)
	 #ifdef JDK102
	 if (!ResolveClassConstantFromClass(klass,op1,cinfo->ee,(unsigned)-1))
	 #else
	 if (!ResolveClassConstantFromClass(klass->HandleToSelf,op1,cinfo->ee,(unsigned)-1))
	 #endif
	  {  
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
	     return -1;
	  }
	m=klass->constantpool[op1].i;
	CB(PUSHAX);
	CB(MOV_AX);
	CL(m);
	break;
      case 0x13:	// ldc2
	wop=getint16U(&j,cinfo);
	#ifdef JDK102
	if (!ResolveClassConstantFromClass(klass,wop,cinfo->ee,(unsigned)-1))
	#else
	if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
	#endif
	  {
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
	     return -1;
	  }
	m=klass->constantpool[wop].i;
	CB(PUSHAX);
	CB(MOV_AX);
	CL(m);
	break;
      case 0x14:	// ldc2w
      case 0xCD:	// ldc2_w_quick
	wop=getint16U(&j,cinfo);
	if (code!=0xCD)
	#ifdef JDK102
	 if (!ResolveClassConstantFromClass(klass,wop,cinfo->ee,(unsigned)-1))
	#else
	 if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
	#endif    
	  {  
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
	  return -1;
	  }
	pi=&(klass->constantpool[wop].i);
	m=*pi;
	pi++;
	n=*pi;
	CB(PUSHAX);
	CB(PUSHLONG);
	CL(n);
	CB(MOV_AX);
	CL(m);
	break;
      case 0x15:	// iload
      case 0x17:	// fload
      case 0x19:	// aload
	if (cinfo->wide)
	  {
	     op2=getint16U(&j,cinfo);
	  }
	else
	  {  
	     op2=*(cinfo->bptr+j++);
	  }	
	
	CB(PUSHAX);
	Comp_PUSH_LocalVar(op2,cinfo);
	break;
      case 0x16:	// lload
      case 0x18:	// dload
	if (cinfo->wide)
	  {
	     op2=getint16U(&j,cinfo);
	  }
	else
	  {  
	     op2=*(cinfo->bptr+j++);
	  }		  
	CB(PUSHAX);
	Comp_PUSH_LocalVar(op2,cinfo);
	CB(PUSHAX);
	Comp_PUSH_LocalVar(op2+1,cinfo);
	break;
      case 0x1A:	// iload_0
      case 0x22:	// fload_0
      case 0x2a:	// aload_0
//#define ALOAD_0 0x2a	
	CB(PUSHAX);
	Comp_PUSH_LocalVar(0,cinfo);
	break;
      case 0x1e:	// lload_0
      case 0x26:	// dload_0
	CB(PUSHAX);
	Comp_PUSH_LocalVar(0,cinfo);
	CB(PUSHAX);
	Comp_PUSH_LocalVar(1,cinfo);
	break;
      case 0x1B:	// iload_1
      case 0x23:	// fload_1
      case 0x2B:	// aload_1
	CB(PUSHAX);
	Comp_PUSH_LocalVar(1,cinfo);
	break;
      case 0x1F:	// lload_1
      case 0x27:	// dload_1
	CB(PUSHAX);
	Comp_PUSH_LocalVar(1,cinfo);
	CB(PUSHAX);
	Comp_PUSH_LocalVar(2,cinfo);
	break;
      case 0x1C:	// iload_2
      case 0x24:	// fload_2
      case 0x2C:	// aload_2
	CB(PUSHAX);
	Comp_PUSH_LocalVar(2,cinfo);
	break;
      case 0x20:	// lload_2
      case 0x28:	// dload_2
	CB(PUSHAX);
	Comp_PUSH_LocalVar(2,cinfo);
	CB(PUSHAX);
	Comp_PUSH_LocalVar(3,cinfo);
	break;
      case 0x1D:	// iload_3
      case 0x25:	// fload_3
      case 0x2D:	// aload_3
	CB(PUSHAX);
	Comp_PUSH_LocalVar(3,cinfo);
	break;
      case 0x21:	// lload_3
      case 0x29:	// dload_3
	CB(PUSHAX);
	Comp_PUSH_LocalVar(3,cinfo);
	CB(PUSHAX);
	Comp_PUSH_LocalVar(4,cinfo);
	break;
      case 0x32:	// aaload
      case 0x2e:	// iaload
      case 0x30:	// faload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo,ECX);
	CW(MOV_BX_MBX);	// points to element 0
	// mov ax,[bx+ax*4]
	MOV_R_Rsib( EAX, SIB(SIB_SCALE4, EAX, EBX) );
	break;
      case 0x2f:	// laload
      case 0x31:	// daload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo,ECX);
	CW(MOV_BX_MBX);	// points to element 0
	// mov ecx, [eax*8+ebx+4]
	MOV_R_Rsiboffs8(ECX, SIB(SIB_SCALE8, EAX,EBX), 4);
	// mov eax, [eax*8+ebx]
	MOV_R_Rsib(EAX, SIB(SIB_SCALE8, EAX,EBX));		
        CB(PUSHCX);
	break;
      case 0x33:	// baload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo,ECX);
	CW(MOV_BX_MBX);	// points to element 0
	// Eugen: baload should copy with sign extension
	CL(0x0304be0f);	// movsxb	eax, [ebx + eax]
	break;
      case 0x34:	// caload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo,ECX);

	CW(MOV_BX_MBX);	// points to element 0
	MOV_R_Rsib(EAX, SIB(SIB_SCALE2, EAX, EBX));
	CB(AND_AX_LONG);
	CL(0xFFFF);	// hide other int16
	break;
      case 0x35:	// saload 	(index is in eax on stacktop)
	CB(POPBX);	// array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo,ECX);

	CW(MOV_BX_MBX);	// points to element 0
	// Eugen: saload should copy with sign extension
	CL(0x4304bf0f);	// movsxw	eax, [ebx + eax*2]
	break;
      case 0x36:	// istore
      case 0x38:	// fstore
      case 0x3a:	// astore
	if (cinfo->wide)
	  {
	     op2=getint16U(&j,cinfo);
	  }
	else
	  {  
	     op2=*(cinfo->bptr+j++);
	  }
	Comp_POP_StoreLocalVar(op2,cinfo);
	break;
      case 0x37:	// lstore
      case 0x39:	// dstore
	if (cinfo->wide)
	  {
	     op2=getint16U(&j,cinfo);
	  }
	else
	  {  
	     op2=*(cinfo->bptr+j++);
	  }
	Comp_POP_StoreLocalVar(op2+1,cinfo);
	Comp_POP_StoreLocalVar(op2,cinfo);
	break;
      case 0x3b:	//istore_0
      case 0x43:	//fstore_0
      case 0x4b:	//astore_0
	Comp_POP_StoreLocalVar(0,cinfo);
	break;
      case 0x3f:	//lstore_0
      case 0x47:	//dstore_0
	Comp_POP_StoreLocalVar(1,cinfo);
	Comp_POP_StoreLocalVar(0,cinfo);
	break;
      case 0x3c:	//istore_1
      case 0x44:	//fstore_1
      case 0x4C:	//astore_1
	Comp_POP_StoreLocalVar(1,cinfo);
	break;
      case 0x40:	//lstore_1
      case 0x48:	//dstore_1
	Comp_POP_StoreLocalVar(2,cinfo);
	Comp_POP_StoreLocalVar(1,cinfo);
	break;
      case 0x3d:	//istore_2
      case 0x45:	//fstore_2
      case 0x4d:	//astore_2
	Comp_POP_StoreLocalVar(2,cinfo);
	break;
      case 0x41:	//lstore_2
      case 0x49:	//dstore_2
	Comp_POP_StoreLocalVar(3,cinfo);
	Comp_POP_StoreLocalVar(2,cinfo);
	break;
      case 0x4e:	//astore_3
      case 0x3e:	//istore_3
      case 0x46:	//fstore_3
	Comp_POP_StoreLocalVar(3,cinfo);
	break;
      case 0x42:	//lstore_2
      case 0x4A:	//dstore_3
	Comp_POP_StoreLocalVar(4,cinfo);
	Comp_POP_StoreLocalVar(3,cinfo);
	break;
      case 0x4f:	// iastore
      case 0x51:	// fastore
      case 0x53:	// aastore
	CW(MOV_DXAX);	// =get value from stacktop
	CB(POPAX);	// =index	
	CB(POPBX);	// =array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo,ECX);
	if (code==0x53)	// aastore
	  CompTriggerArrayStoreException(cinfo);
	CW(MOV_BX_MBX);	// points to element 0
	// mov [ebx + 4*eax], edx
	MOV_Rsib_R( SIB(SIB_SCALE4, EAX,EBX ), EDX );	
	CB(POPAX);
	break;
      case 0x50:	// lastore
      case 0x52:	// dastore
	CW(MOV_DXAX);	// =get value from stacktop
	CB(POPCX);
	CB(POPAX);	// =index 
	CB(POPBX);	// =array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo,-1);
	CW(MOV_BX_MBX);	// points to element 0
	// mov [eax*8+ebx+4], ecx
	MOV_Rsiboffs8_R( SIB(SIB_SCALE8, EAX, EBX), 4, ECX);
	// mov [eax*8+ebx], edx
	MOV_Rsib_R(SIB(SIB_SCALE8, EAX,EBX), EDX);
	CB(POPAX);
	break;
      case 0x54:	// bastore
	CW(MOV_DXAX);	// =get value from stacktop
	CB(POPAX);	// =index
	CB(POPBX);	// =array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo,ECX);
	CW(MOV_BX_MBX);	// points to element 0
	MOV_Rsib_8R(SIB(SIB_SCALE1, EAX, EBX), R8_DL);
	CB(POPAX);
	break;
      case 0x55:	// castore
      case 0x56:	// sastore
	CW(MOV_DXAX);	// =get value from stacktop
	CB(POPAX);	// =index	
	CB(POPBX);	// =array
	CompTriggerNullPointerException(cinfo,EBX);
	CompTriggerArrOutOfBoundsException(cinfo,ECX);
	CW(MOV_BX_MBX);	// points to element 0
	CB(PREF_32);
	MOV_Rsib_R(SIB(SIB_SCALE2, EAX,EBX), EDX);
	CB(POPAX);
	break;
      case 0x57:	//pop
	CB(POPAX);
	break;
      case 0x58:	//pop2
	CB(POPAX);
	CB(POPAX);
	break;
      case 0x59:	//dup
	CB(PUSHAX);
	break;
      case 0x5a:	//dup_x1
	CB(POPBX);
	CB(PUSHAX);
	CB(PUSHBX);
	break;
      case 0x5b:	//dup_x2	FYI: eax==stacktop
	CB(POPBX);//2
	CB(POPDX);//3
	CB(PUSHAX);//4=1
	CB(PUSHDX);//3
	CB(PUSHBX);//2
	break;
      case 0x5C:	//dup2		ditto
	CB(POPBX);//2
	CB(PUSHBX);//4=2
	CB(PUSHAX);//3=1
	CB(PUSHBX);//2
	break;
      case 0x5D:	//dup2_x1	etc
	CB(POPBX);//2
	CB(POPDX);//3
	CB(PUSHBX);//5=2
	CB(PUSHAX);//4=1
	CB(PUSHDX);//3
	CB(PUSHBX);//2
	break;
      case 0x5E:	//dup2_x2
	CB(POPBX);//2
	CB(POPCX);//3
	CB(POPDX);//4
	CB(PUSHBX);//6=2
	CB(PUSHAX);//5=1
	CB(PUSHDX);//4
	CB(PUSHCX);//3
	CB(PUSHBX);//2
	break;
      case 0x5F:	//swap
	CB(POPDX);
	CB(PUSHAX);
	CW(MOV_AXDX);
	break;	
      case 0x60:	//iadd
	CB(POPBX);
	CW(ADD_AXBX);
	break;
      case 0x61:	//ladd
	CB(POPCX);
	CB(POPBX);
	CB(POPDX);
	CW(ADD_AXBX);
	CW(ADC_CXDX);
	CB(PUSHCX);
	break;
      case 0x62:	// fadd
      	CB(PUSHAX); //FIXAB
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	// fld word [sp]
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FADDP_ST1);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX); //FIXAB
	break;
      case 0x63:	// dadd
      	CB(PUSHAX); // FIXAB
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	// fld qword [sp]
	CB(POPAX);
	CB(POPAX);
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FADDP_ST1);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX); // FIXAB
	break;
      case 0x64:	// isub
	CW(MOV_DXAX);
	CB(POPAX);
	CW(SUB_AXDX);
	break;
      case 0x65:	// lsub
	CW(MOV_BXAX);	// stacktop
	CB(POPDX);
	CB(POPAX);
	CB(POPCX);
	CW(SUB_AXBX);
	CW(SBB_CXDX);
	CB(PUSHCX);
	break;
      case 0x66:	// fsub
      	CB(PUSHAX);// FIXAB
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	// fld word [sp]
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FSUBRP_ST1);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX); // FIXAB
	break;
      case 0x67:	// dsub
      	CB(PUSHAX); // FIXAB
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	CB(POPAX);
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FSUBRP_ST1);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX); // FIXAB
	break;
      case 0x68:	// imul
	CB(POPBX);
	CW(IMUL_BX);
	break;
      case 0x69:	// lmul
      	CB(PUSHAX);	// push logical stacktop on cpu stack
	CB(MOV_BX);
	CL(llmul_wrapper);
	CL(CALL_ADDSP);
	CB(0x10);
	CB(PUSHDX);
	break;
      case 0x6A:	// fmul
      	CB(PUSHAX); // FIXAB
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FMULP_ST1);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX); // FIXAB
	break;
      case 0x6b:	// dmul
      	CB(PUSHAX); // FIXAB
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	CB(POPAX);
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FMULP_ST1);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX); // FIXAB	
	break;
      case 0x6c:	// idiv
#ifndef EXCEPTIONS_BY_SIGNALS
	CW(OR_AXAX);
	CompTriggerDivZeroException(cinfo);
#endif	
	CB(POPBX);
	CB(XCHG_AXBX);
	CB(CWD);	// eax->edx:eax
	CW(IDIV_BX);
	break;
      case 0x6d:	// ldiv
////      	CB(PUSHAX);	// push logical stacktop on cpu stack
	CompTriggerLONGDivZeroException(cinfo); 
#ifdef INLINE_LONGARITM
	MOV_R_R( EAX, ESP );
	PUSH_Roffs8(EAX, 12);
	PUSH_Roffs8(EAX, 8);
	CB(MOV_BX);
	CL(__divdi3);
	CL(CALL_ADDSP);
	CB(0x18);
	CB(PUSHDX); 	// eax is our stacktop
#else
	CB(MOV_BX);
	CL(lldiv_wrapper);
	CL(CALL_ADDSP);
	CB(0x10);
	CB(PUSHDX); 	// eax is our stacktop
#endif	
	break;
      case 0x6E:	// fdiv
      	CB(PUSHAX); // FIXAB
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FDIVRP_ST1);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX); // FIXAB
	break;
      case 0x6f:	// ddiv
      	CB(PUSHAX); // FIXAB
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	CB(POPAX);
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FDIVRP_ST1);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX); // FIXAB
	break;
      case 0x70:	// irem
#ifndef EXCEPTIONS_BY_SIGNALS
	CW(OR_AXAX);
	CompTriggerDivZeroException(cinfo);
#endif	
	CB(POPBX);
	CB(XCHG_AXBX);
	CB(CWD);	// eax->edx:eax
	CW(IDIV_BX);
	CW(MOV_AXDX);
	break;
      case 0x71:	// lrem
////      	CB(PUSHAX);	// push logical stacktop on cpu stack
	CompTriggerLONGDivZeroException(cinfo);
#ifdef INLINE_LONGARITM
	MOV_R_R( EAX, ESP );
	PUSH_Roffs8(EAX, 12);
	PUSH_Roffs8(EAX, 8);
	CB(MOV_BX);
	CL(__moddi3);
	CL(CALL_ADDSP);
	CB(0x18);
	CB(PUSHDX); 	// eax is our stacktop
#else	
	CB(MOV_BX);
	CL(llrem_wrapper);
	CL(CALL_ADDSP);	
	CB(0x10);
	CB(PUSHDX);
#endif
	break;
      case 0x72:	// frem
      	CB(PUSHAX); // FIXAB
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FPREM);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX); // FIXAB
	break;
      case 0x73:	// drem
      	CB(PUSHAX); // FIXAB
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	CB(POPAX);
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FPREM);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX); // FIXAB
	break;
      case 0x74:	// ineg
	CW(NEG_AX);
	break;
      case 0x75:	// lneg
	CB(POPBX);
	CW(NOTBX);
	CW(NOTAX);
	CW(ADDAX);
	CB(1);		// =Zweier-Komplement  [ in English: "complement on two" ? ]
	CW(ADCBX);
	CB(0);
	CB(PUSHBX);
	break;
      case 0x76:	// fneg
      	CB(PUSHAX); // FIXAB
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FCHS);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX); // FIXAB
	break;
      case 0x77:	// dneg
      	CB(PUSHAX); // FIXAB
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FCHS);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      	CB(POPAX); // FIXAB
	break;
      case 0x78:	// ishl
	CW(MOV_CXAX);	// stacktop to reg ecx
	CB(POPAX);
	CW(SHL_AXCL);
	break;
      case 0x79:	// lshl
	CB(AND_AL);
	CB(0x3F);	// 6 bit
	CW(MOV_CXAX);	
	CB(POPAX);
	CB(POPDX);
	CW(ROR_CL);
	CB(1);
	CB(PREBYTE_0F);CW(SHLD_DXAXCL);
	CW(SHL_AXCL);
	CB(PREBYTE_0F);CW(SHLD_DXAXCL);
	CW(SHL_AXCL);
	CW(SHR_CL);
	CB(7);
	CB(PREBYTE_0F);CW(SHLD_DXAXCL);
	CW(SHL_AXCL);
	CB(PUSHDX);
	break;
	
      case 0x7A:	// ishr
	CW(MOV_CXAX);	// stacktop is shift
	CB(POPAX);
	CW(SAR_AXCL);
	break;

      case 0x7B:	// lshr
	CB(AND_AL);
	CB(0x3F);
	CW(MOV_CXAX);
	CB(POPAX);
	CB(POPDX);
	CW(ROR_CL);
	CB(1);
	
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SAR_DXCL);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SAR_DXCL);
	CW(SHR_CL);
	CB(7);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SAR_DXCL);
	CB(PUSHDX);
	break;

      case 0x7C:	// iushr
	CW(MOV_CXAX);	//		etc
	CB(POPAX);
	CW(SHR_AXCL);
	break;

      case 0x7D:	// lushr
	CB(AND_AL);
	CB(0x3F);
	CW(MOV_CXAX);
	CB(POPAX);
	CB(POPDX);
	CW(ROR_CL);
	CB(1);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SHR_DXCL);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SHR_DXCL);
	CW(SHR_CL);
	CB(7);
	CB(PREBYTE_0F);CW(SHRD_DXAXCL);
	CW(SHR_DXCL);
	CB(PUSHDX);
	break;

      case 0x7E:	// iand
	CB(POPBX);
	CW(AND_AXBX);
	break;
      case 0x7F:	// land
	CB(POPBX);
	CB(POPCX);	
	CB(POPDX);
	CW(AND_AXCX);
	CW(AND_DXBX);
	CB(PUSHDX);
	break;
      case 0x80:	// ior
	CB(POPBX);
	CW(OR_AXBX);
	break;
      case 0x81:	// lor
	CB(POPBX);
	CB(POPCX);
	CB(POPDX);
	CW(OR_AXCX);
	CW(OR_DXBX);
	CB(PUSHDX);
	break;
      case 0x82:	// ixor
	CB(POPBX);
	CW(XOR_AXBX);
	break;
      case 0x83:	// lxor
	CB(POPBX);
	CB(POPCX);
	CB(POPDX);
	CW(XOR_AXCX);
	CW(XOR_DXBX);
	CB(PUSHDX);
	break;
      case 0x84:	// iinc
	if (cinfo->wide)
	  {
	     op2=getint16U(&j,cinfo);
	     n=getint16S(&j,cinfo);
	  }
	else
	  {  
	     op2=*(cinfo->bptr+j++);
	     n=*(signed char*)(cinfo->bptr+j++);
	  }
	dprintf(stderr,"iinc: op2=%d n=%d\n",op2,n);
	Comp_INC_LocalVar(op2,n,cinfo);
	cinfo->wide=0;
	break;
      case 0x85:	// i2l 
	CB(CDQ);
	CB(PUSHDX);
	break;
      case 0x86:	// i2f
	CB(PUSHAX); //FIXAB	
	CW(FILDW_MSP);CB(SP_ADDR_BYTE3);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX); //FIXAB	
	break;
      case 0x87:	// i2d
	CB(PUSHAX); //FIXAB	
	CW(FILDW_MSP);CB(SP_ADDR_BYTE3);
	CB(PUSHAX);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX); //FIXAB	
	break;
      case 0x88:	// l2i
	CB(POPBX);	// discard 32 bits
	break;
      case 0x89:	// l2f
	CB(PUSHAX); //FIXAB	
	CW(FILDQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX); //FIXAB	
	break;
      case 0x8a:	// l2d
	CB(PUSHAX); //FIXAB	
	CW(FILDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX); //FIXAB	
	break;
      case 0x8b:	// f2i
      case 0x8c:	// f2l
      case 0x8e:	// d2i
      case 0x8f:	// d2l
	Comp87ToInteger(code,cinfo);
	break;
      case 0x8d:	// f2d
	CB(PUSHAX); //FIXAB	
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CB(PUSHAX);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX); //FIXAB	
	break;
      case 0x90:	// d2f
	CB(PUSHAX); //FIXAB	
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	
	CB(POPAX);
	CW(FSTPW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX); //FIXAB	
	break;
      case 0x91:	// int2byte
	CL(MOVSXAL);	// movsx eax,al
	break;
      case 0x92:	// int2char
	CB(AND_AX_LONG);
	CL(0xffff);
	break;
      case 0x93:	// int2short
	CB(CWDE);
	break;
      case 0x94:	// lcmp
	CW(MOV_BXAX);						
	CB(POPAX);
	CB(POPDX);
	CB(POPCX);
	CW(CMP_CXAX);
	CB(MOV_AX);
	CL(0);
	CB(JNGE);
	CB(8);                        
	CB(JNLE);
	CB(9);
	CW(CMP_DXBX);						
	CB(JE);
	CB(6);
	CB(JA);
	CB(3);
	CB(DEC_AX);
	CB(JMPS);
	CB(1);
	CB(INC_AX);
	break;
      case 0x95:	// fcmpl
      case 0x96:	// fcmpg
	CB(PUSHAX); //FIXAB	
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	
	CB(POPAX);
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	Comp87Vergleich(code,cinfo);
	break;
      case 0x97:	// dcmpl
      case 0x98:	// dcmpg
	CB(PUSHAX); //FIXAB
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	
	CB(POPAX);
	CB(POPAX);
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	
	CB(POPAX);
	CB(POPAX);
	Comp87Vergleich(code,cinfo);
	break;

      case 0x99:	// ifeq
      case 0xC6:	// ifnull
	CompVergleich(0x99,&j,JZ,cinfo);
	break;
      case 0x9A:	// ifne
      case 0xC7:	// ifnonnull
	CompVergleich(0x9A,&j,JNZ,cinfo);
	break;
      case 0x9B:	// iflt
	CompVergleich(0x9B,&j,JL,cinfo);
	break;
      case 0x9c:	// ifge
	CompVergleich(0x9C,&j,JGE,cinfo);
	break;
      case 0x9d:	// ifgt
	CompVergleich(0x9D,&j,JG,cinfo);
	break;
      case 0x9e:	// ifle
	CompVergleich(0x9E,&j,JLE,cinfo);
	break;
      case 0x9F:	// if_icmpeq
      case 0xa5:	// if_acmpeq
	CompVergleich(0x9F,&j,JZ,cinfo);
	break;
      case 0xA0:	// if_icmpne
      case 0xA6:	// if_acmpne
	CompVergleich(0xA0,&j,JNZ,cinfo);
	break;
      case 0xA1:	// if_icmplt
	CompVergleich(0xA1,&j,JL,cinfo);
	break;
      case 0xA2:	// if_icmpge
	CompVergleich(0xA2,&j,JGE,cinfo);
	break;
      case 0xA3:	// if_icmpgt
	CompVergleich(0xA3,&j,JG,cinfo);
	break;
      case 0xA4:	// if_icmple
	CompVergleich(0xA4,&j,JLE,cinfo);
	break;
      case 0xA7:	// goto
	CompVergleich(0xA7,&j,0/*unused*/,cinfo);
	break;

      case 0xA8:	// jsr
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+(j-1);
	m=getint16S(&j,cinfo);
	dprintf(stderr,"jsr: jump %d java byte\n",m);
	CB(PUSHAX);
	CB(CALL);
	CL(0);
	CB(POPAX); //1
	CW(ADDAX); //3 	stacktop now is "next_java_instruction"
	CB(9);	//4
	CB(JMP1); //5
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	CL(0); //9	 backpatched later
	cinfo->backp[cinfo->backcnt].javadist=m;
	cinfo->backcnt++;
	break;

      case 0xA9:	// ret
	op1=*(cinfo->bptr+j++);
	dprintf(stderr,"ret: jump  #%d var\n",op1);	
	Comp_PUSH_LocalVarToStack(op1,cinfo);	// bypassing eax-stacktop
	CB(RETN);
	break;

      case 0xAA:	// tableswitch
	k=j-1;		// jump base adr offset
  	while ((int)(cinfo->bptr+j) % 4)
	     j++;
	defaultip=getint32(&j,cinfo);
	indexmin =getint32(&j,cinfo);
	indexmax =getint32(&j,cinfo);
	tabsize  =indexmax-indexmin+1;
	#define AATAB 5
	if (cinfo->cptr - cinfo->codebase >=
	    cinfo->maxspace - cinfo->resspace + tabsize * AATAB)
        {
	 lprintf("TYA: not enough space in tableswitch at %d\n", cinfo->cptr - cinfo->codebase);
         return NOSPACE_ERROR;
        }
	CW(MOV_BXAX); //value to swich
	CW(SUB_BX_LONG);
	CL(indexmin);
//	CW(LEA_BX_AX_LONG);	// eax==value to swich
//	CL(-indexmin);		// lea ebx,[eax-indexmin]
	CW(CMP_BX);
	CL(tabsize);
	CB(POPAX);  	// <-- go jumping with a proper stacktop
	CW(JNB);	// default branch
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
	CL(0);			// backpatched later
	cinfo->backp[cinfo->backcnt].javadist=defaultip;
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+k;
	cinfo->backcnt++;
	CW(LEA_BX);		// lea ebx,[ebx+ebx*4]  == mul_5
	CB(0x9b);
	   
	CB(CALL);		// indexed relative jump
	CL(0);
	CB(POPCX);//1
	CB(0x8D);//2		// lea ebx,[ecx+ebx+7]
	CB(0x5C);//3
	CB(0x19);//4
	CB(0x07);//5   	// <---- 7 Byte  **take care**
	CW(JMP_BX);//7
	for (i=0;i<tabsize;i++)
	{
	  aktip=getint32(&j,cinfo);
	  CB(JMP1);  
	  cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	  cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
	  CL(0);		// backpatched later
	  cinfo->backp[cinfo->backcnt].javadist=aktip;
	  cinfo->backp[cinfo->backcnt].java=cinfo->bptr+k;
	  cinfo->backcnt++;
	}
	#define AATAB 5		// 5 byte per tabentry
	break;

      case 0xAB:	// lookupswitch	
	k=j-1;		// jump base adr offset
  	while ((int)(cinfo->bptr+j) % 4)
	     j++;
	defaultip=getint32(&j,cinfo);
	tabsize  =getint32(&j,cinfo);
	dprintf(stderr,"lookupswitch tab=>%d  def=%d\n",tabsize,defaultip);
	#define ABTAB 13
	if (cinfo->cptr - cinfo->codebase >=
	    cinfo->maxspace - cinfo->resspace + tabsize * ABTAB)
        {
	 lprintf("TYA: not enough space in lookupswitch at %d\n", cinfo->cptr - cinfo->codebase);
         return NOSPACE_ERROR;
        }
	CW(MOV_DXAX);	//value to switch
	CB(POPAX);	// <-- go jumping with a proper stacktop
	for (i=0;i<tabsize;i++)
	{
	  compar=getint32(&j,cinfo);
	  CB(MOV_BX);
	  CL(compar);     	// read 1 int more
	  aktip=getint32(&j,cinfo);
	  CW(CMP_BXDX);
	  CW(JZ);
	  cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	  cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
	  CL(0);		// backpatched later
	  cinfo->backp[cinfo->backcnt].javadist=aktip;
	  cinfo->backp[cinfo->backcnt].java=cinfo->bptr+k;
	  cinfo->backcnt++;
	}			
	#define ABTAB 13	// 13 byte per tabentry
	CB(JMP1);
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
	CL(0);			// backpatched later
	cinfo->backp[cinfo->backcnt].javadist=defaultip;
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+k;
	cinfo->backcnt++;
	break;
	
      case 0xB0:	// areturn
      case 0xAC:	// ireturn
      case 0xAE:	// freturn
      case 0xAD:	// lreturn
      case 0xAF:	// dreturn
	if (cinfo->isinline)
	{ 
	  if (cinfo->mb->code_length-j)
	  {
   	     cinfo->backp[cinfo->backcnt].java=cinfo->bptr+j-1;
	     cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
	     CW(JMP);
	     cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	     CL(0);		// backpatched later
	     cinfo->backp[cinfo->backcnt].javadist=cinfo->mb->code_length-j+1;
	     cinfo->backcnt++;
	  }
	  break;
	}
#ifndef NOCOMPSYNC
	if (cinfo->mb->CompiledCodeInfo == invokeSynchronizedJavaMethod)
	  {
	     CB(PUSHAX);
	     if (cinfo->mb->fb.access & ACC_STATIC)
	       {
		  CB(PUSHLONG);
		  #ifdef JDK102
		  CL(klass);
		  #else
		  CL(klass->HandleToSelf);
		  #endif
	       }
	     else  
	       {
	          Comp_PUSH_LocalVar(0,cinfo);
		  CB(PUSHAX);
               }  
	     CB(MOV_BX);
	     CL(monitorExit);
	     CW(CALL_EBX);
	     CB(POPBX);	     
	     CB(POPAX);
	  }
#endif
	if (code==0xAD || code==0xAF)
	   CB(POPDX);
	CW(MOV_SPBP);
	CL(POPBPDISIBX);
	CB(RETN);
	break;
      case 0xB1:	// void return
	if (cinfo->isinline)
	{ 
	  if (cinfo->mb->code_length-j)
	  {
   	     cinfo->backp[cinfo->backcnt].java=cinfo->bptr+j-1;
	     cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
	     CW(JMP);
	     cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	     CL(0);		// backpatched later
	     cinfo->backp[cinfo->backcnt].javadist=cinfo->mb->code_length-j+1;
	     cinfo->backcnt++;
	  }
	  break;
	}
#ifndef NOCOMPSYNC
	if (cinfo->mb->CompiledCodeInfo == invokeSynchronizedJavaMethod)
	  {
     	     if (cinfo->mb->fb.access & ACC_STATIC)
	       {
		  CB(PUSHLONG);
		  #ifdef JDK102
		  CL(klass);
		  #else
		  CL(klass->HandleToSelf);
		  #endif
	       }
	     else
	     {
	       Comp_PUSH_LocalVar(0,cinfo);
	       CB(PUSHAX);
	     }  
	     CB(MOV_BX);
	     CL(monitorExit);
	     CW(CALL_EBX);
	  }
#endif	
	CW(MOV_SPBP);
	CL(POPBPDISIBX);
	CB(RETN);
	break;
	
      case 0xB2:	// getstatic
      case 0xD2:	// getstatic_quick
	CB(PUSHAX);
        fbp=GetBlock(NULL,1,code,&j,klass,cinfo,code==0xD2);
        if (!fbp)
	  {
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
	     return -1;	// error
	  }

	  /*
	  	All static finals are guaranteed to be set after clinit
		We cannot inline them in clinit, because they might be used
		in the same clinit they are set
	  */
	  
	  if ( fbp->access & ACC_FINAL  && strcmp("<clinit>", cinfo->mb->fb.name))
	  {
		dprintf(stderr,"Final static %s:%s\n", unhand(fbp->clazz)->name, fbp->name );
		if (*fbp->signature==SIGNATURE_DOUBLE || *fbp->signature==SIGNATURE_LONG)
		  {			 
			 CB(PUSHLONG);
			 CL(*(((int*)fbp->u.static_address)+1));
			 CB(MOV_AX);
			 CL(*(int*)fbp->u.static_address);
		  }
		else
		  {
			  CB(MOV_AX);
			  CL(fbp->u.static_value);
		  }		  
	  }
	  else
	  {	 
	if (*fbp->signature==SIGNATURE_DOUBLE || *fbp->signature==SIGNATURE_LONG)
	  {
	     MOV_R_mem( EAX, fbp->u.static_address+4);
	     CB(PUSHAX);
	     MOV_R_mem( EAX, fbp->u.static_address);
	  }
	else
	  {
     	     MOV_R_mem(EAX, &fbp->u.static_value );
	  }
	  }	  
	break;

      case 0xB3:	// putstatic
      case 0xD3:	// putstatic_quick
        fbp=GetBlock(NULL,1,code,&j,klass,cinfo,code==0xD3);
        if (!fbp)
	  {
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
	     return -1;	// error
	  }
	if (*fbp->signature==SIGNATURE_DOUBLE || *fbp->signature==SIGNATURE_LONG)
	  {
	     MOV_mem_R( fbp->u.static_address, EAX );
	     CB(POPAX);		// second half value on stacktop	     
	     MOV_mem_R( fbp->u.static_address+4, EAX );
          }
        else
          {
	     MOV_mem_R( &fbp->u.static_value, EAX );    
   	  }
	CB(POPAX);
	break;

      case 0xB4:	// getfield
      case 0xE3:	// getfield_quick_w
        fbp=GetBlock(NULL,1,code,&j,klass,cinfo,code==0xE3);
        if (!fbp)
	  {
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
	     return -1;
	  }
	CompTriggerNullPointerException(cinfo,EAX);
	CW(MOV_BX_MAX);		// points to first instance variable
	m = fbp->u.offset;
	if (*fbp->signature==SIGNATURE_DOUBLE || *fbp->signature==SIGNATURE_LONG)
	  {
	   MOV_R_Rmemoffs_(EDX, EBX, m+4);
	   MOV_R_Rmemoffs_(EAX, EBX, m);	   	
	   CB(PUSHDX);
	  }
	else
	  {
	   MOV_R_Rmemoffs_(EAX, EBX, m);
	}
	break;

      case 0xB5:	// putfield
      case 0xE4:	// putfield_quick    (=value in eax)
        fbp=GetBlock(NULL,1,code,&j,klass,cinfo,code==0xE4);
        if (!fbp)
	  {
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
	     return -1;
	  }
	m = fbp->u.offset;  
	if (*fbp->signature==SIGNATURE_DOUBLE || *fbp->signature==SIGNATURE_LONG)
	{
 	   CB(POPDX);
	   CB(POPBX);	// =object
	   CompTriggerNullPointerException(cinfo,EBX);
	   CW(MOV_BX_MBX); // first instance variable adress
	   MOV_Rmemoffs__R( EBX, m+4, EDX);
	   MOV_Rmemoffs__R( EBX, m, EAX);
	}
	else
	{
	   CB(POPBX);	// =object
	   CompTriggerNullPointerException(cinfo,EBX);
	   CW(MOV_BX_MBX);
	   MOV_Rmemoffs__R( EBX, m, EAX);
	   	   
	}
	CB(POPAX);
	break;

      case 0xDC: 	// undocumented_invoke (?) (some kind of invoke_non_virtual)
	j+=2;		// "handled" by ignoring ;-)
	CB(POPAX);	// discard "this"-argument
	//dprintf(stderr,"0x DC short cut %x\n",code);
	break;

#define STATIC_INV(opcode)	( (opcode) == 0xB8 || (opcode) == 0xD9 )
#define QUICK_INV(opcode)	( (opcode)  > 0xCA )
#define VIRTUAL_INV(opcode)	( (opcode) == 0xB6 || (opcode) == 0xE2 )
#define INTERFACE_INV(opcode)	( (opcode) == 0xB9 )
#define NONVIRT_INV(opcode)	( (opcode) == 0xB7 || (opcode) == 0xD7 )
      case 0xb8:	// invokestatic
      case 0xD9:	// invokestatic_quick
	
      case 0xB7:	// invoke_non_virtual
      case 0xD7:	// invokenonvirtual_quick
	
      case 0xB9:	// invokeinterface
	
      case 0xB6:	// invokevirtual
      case 0xE2:	// invokevirtual_quick_w
  	// { unsigned char *tmp=cinfo->cptr;
      	CB(PUSHAX); 	// put logical stacktop to CPU-stack for the common caller stackframe
	// presumed is coding the complete INVOCATION code...
	// ...but under certain conditions we can leave out some parts
	compileJVMinvoke=FALSE;
	compileLOCALspace=-1;	// == "unknown at compile time"
	//
	// ======== 1. get a first method block [or alias] =================
	// (but could be invalid for virtual and interface methods)
	//
	mbp=GetBlock( VIRTUAL_INV(code) ? &k : NULL ,0,code,&j,klass,cinfo, QUICK_INV(code) );
	if (!mbp)
	  {
	     lprintf("TYA: Resolve problem in opcode %x\n",code);
	     return -1;	// error
	  }
	m=0;
	while (mbp->fb.signature[m]!=SIGNATURE_ENDFUNC)
  	 m++;
	m++;
	etype=mbp->fb.signature[ m ];

	//
	// ======== 2. get args_on_stack count =============================
	//
	if ( INTERFACE_INV(code) )
	  {
	     op1=*(cinfo->bptr+j++);
	     stac=op1*SIS4;
	     j++;		// for the one reserved byte
	  }
	else
	  {
	     stac=Signature2ArgsSize(mbp->fb.signature) * SIS4;
	     if ( !STATIC_INV(code) )
	      stac+=SIS4;	// one for "this"
	  }
	//
	// 3. ========== if non static then get object from stack =============
	//
	if ( !STATIC_INV(code) )
	  {
	    // get object from stack
	    if (stac!=4)	// if stac == 4 then it is already in eax
	    {
	      CW(MOV_BX_SP);
	      if (stac<128)
              { 
		CW(MOV_AX_MBX_8);
	        CB((unsigned char)(stac - SIS4));
	      }
 	      else
	      {
		CW(MOV_AX_MBX_32);
	        CL(stac - SIS4);
	      }
	    }
#ifndef EXCEPTIONS_BY_SIGNALS
	CompTriggerNullPointerException(cinfo, EAX);
#endif	     
	  }
	//
	// 3A. =================== try to inline ===================
	//
	if ( STATIC_INV(code)  ||  NONVIRT_INV(code)
	    || (mbp->fb.access & ACC_FINAL)  
	    || (mbp->fb.access & ACC_PRIVATE)
 	    || (unha11(mbp->fb.clazz)->access  & ACC_FINAL)
	    )
	  {
#ifdef EXCEPTIONS_BY_SIGNALS	     
 	    // this test is independend EXCEPTIONS_BY_SIGNALS
 	   if (VIRTUAL_INV(code))
	     CompTriggerNullPointerException2(cinfo,EAX);
#endif
#ifdef INLINING
           if (mbp->CompiledCodeInfo == invokeJavaMethod)	// no synchron, no native
             if (!cinfo->isinline)			// no recursive inlining
	       if (mbp->code)				// some code present?
	  	 if (mbp->nlocals+mbp->args_size <=2)	// have only two free registers
		   if (!mbp->exception_table_length)	// no exception handling
		     if (mbp->maxstack<=2)
		       if (!cinfo->inlineerr)		// don't do it in a 2nd try
	   {
             struct CINFO c2;
             int j,erg;
	     if (mbp->nlocals+mbp->args_size==2)
		{
		 	CW(MOV_MBP_8_SI);
		   	CB( LOCSTART-12);
			CW(MOV_MBP_8_DI);
			CB( LOCSTART-8 );
		}
	      else
	      if (mbp->nlocals+mbp->args_size==1)
		{
			CW(MOV_MBP_8_DI);
			CB( LOCSTART-8 );
		}
	      
	     if (stac==4)
	       CB(POPDI);
	     else   
	       if (stac==8)
               { 
		 CB(POPSI);
		 CB(POPDI); 
	       }
	     CB(POPAX);
             c2=*cinfo;
             c2.wide=0;
             c2.bptr=(unsigned char*)mbp->code;
             c2.mb=mbp;
	     dprintf(stderr,"inline start: %s.%s\n",unha11(mbp->fb.clazz)->name,mbp->fb.name);
	     c2.iptab=alloca(sizeof(struct iptrans) * (mbp->code_length+1));
	     c2.backp=alloca(sizeof(struct back) * (mbp->code_length+1));
	     if (!c2.iptab || !c2.backp)
		{
		   lprintf("TYA: inline coding: memory problem\n");
		   return -1;
		}
	     //
	     c2.ipcnt=0;
	     c2.backcnt=0;
             c2.isinline=mbp->code_length;
             for (j=0;j<mbp->code_length ;)
             {
                erg=recode(j,unha11(mbp->fb.clazz),&c2);
		if (erg<0)
		  {
		    if (erg==NOSPACE_ERROR)
		      return erg;
		    lprintf("TYA: inline coding aborted %d\n",erg);
		    return INLINE_ERROR;
		  }
                j+=erg;
                // no exceptions to handle
             }
	     //
	     // next "+1" is to handle intermediate return as jumps to the end
	     c2.iptab[c2.ipcnt].java=mbp->code+mbp->code_length;
	     c2.iptab[c2.ipcnt].x86=c2.cptr;
	     c2.ipcnt++;
	     BackPatchJumpDists(&c2);
	     dprintf(stderr,"inline end: %d\n",c2.ipcnt-1);
	     //
	     // continue "suspended" method
	     cinfo->cptr=c2.cptr;
	     if (mbp->nlocals+mbp->args_size==2)
		{
		    CW(MOV_SI_MBP_8);
		    CB(   LOCSTART-12);
		    CW(MOV_DI_MBP_8);
		    CB(   LOCSTART-8 );
		}
	      else
	      if (mbp->nlocals+mbp->args_size==1)
		{
		    CW(MOV_DI_MBP_8);
		    CB(   LOCSTART-8 );
		}
             break;
           }
#endif
	//
	// 4. =================== get a usable method block  ===================
	//
	   if (mbp->fb.access & ACC_NATIVE)
	       compileJVMinvoke=TRUE;
	   // "runtime" mbp known during compilation, but no inlining
	   compileLOCALspace=mbp->nlocals*SIS4;
	   CB(PUSH_SP);			// compare next chapter (5.)
#ifdef USEASM
	   CB(MOV_AX);
	   CL(mbp);
	   CB(PUSHAX);
#else	     
	   CB(PUSHLONG);
	   CL(mbp);
#endif	     
	}
	else  // this is (INTERFACE_INV(code)  || ( VIRTUAL_INV(code)
  	{
	     CW(MOV_BX_MAX_8);
	     CB(4);			// &object->methodtabelle
	   
	     if ( VIRTUAL_INV(code) )
	       {
	     // (ebx contains object)
	     // the next is in C: { eax:=(obj_array_classblock(hobj))->methodtable->methods[nr] }
	     CW(TEST_BX);
	     CL(FLAG_MASK);		// ebx is T_NORMAL_OBJECT ?
	     CB(JE);
	     CB(7);

	     CB(MOV_AX);		// object class for ARRAY
	     CL(mbp);	//!! unha11(classJavaLangObject)->methodtable->methods);
	     CB(JMPS);
	     if ( (k+1)*SIS4>127 )
	       CB(6);
	     else
	       CB(k?3:5);
		  if (k)
		    {  
		       if ( (k+1)*SIS4>127 )
			 {			 
			CW(MOV_AX_MBX_32);
			CL((k+1)*SIS4);		// k method #
			 }
		       else
			 {
			CW(MOV_AX_MBX_8);
			CB((k+1)*SIS4);
			 }
		    }
		  #ifndef NOGUA_WORKAROUND
		  else
		    {
			CB(MOV_AX);
			CL(mbp);
			lprintf("TYA: GUA_WORKAROUND in action\n");
		    }
		  #endif
	       }
	     else
	       {
		  i=GetMethNr(mbp);
#ifdef USEASM
		  CW(MOV_AX_MBX);
		  CW(MOV_AX_MAX);
		  CW(MOV_AX_MAX_8);
		  k=(char*)(&klass->imethodtable) - (char*)klass;
		  CB( k );		// (currently imethodtable offset is 96)
		  CW(LEA_DX_AX_8);
		  CB(-4);
		  CW(ADD_DX_BYTE);
		  CB(8);
		  CW(CMP_MDX_LONG);
		  CL(mbp->fb.clazz);
		  CB(JNE); 
		  CB(-11);		// jmp loop
		  CB(MOV_AX);
		  CL(i * sizeof(int) );
		  CW(MOV_DX_MDX_8);
		  CB(4);
		  CW(ADD_DXAX);
		  CW(MOV_AX_MDX);
		  CL(0x0483448B);	// mov eax, 0x4( ebx, eax,4)
#else		  
		  if (i<128)
		    {
			 CB(PUSHLONG2);
			 CB(i);		       
		    }
		  else
		    {
			 CB(PUSHLONG);
			 CL(i);
		    }
		  CB(PUSHLONG);
		  CL((mbp->fb.clazz));
		  CB(PUSHAX);
		  CB(MOV_BX);
		  CL(RTGetIMeth);
		  CL(CALL_ADDSP);
		  CB(12);
#endif		  
	       }
	     CB(PUSH_SP);		// compare next chapter (5.)
	     CB(PUSHAX);		// ebx == RT mbp_called
#ifdef TRY_FAST_INVOKE			  
	     CW(MOV_BX_MAX_8);
	     k=(char*)(&mbp->nlocals) - (char*)mbp;
	     CB(k);
	     CW(SHL_BX);		// * SIS4
	     CB(2);
	     CW(MOV_MBP_8_BX);		// use helper place
	     CB(LOCSTART-4);
#endif			  
	}
	//
	// 5. ============ prepare invocation ====================
	// (check if fast invocation is possible or not)
	//
	// SP and mbp are already pushed
	CW(MOV_BX_MBP_8);	// get EE into ebx
	CB(LOCSTART-16);	// needed both fast invoke and native invoke
	CB(PUSHBX);		// EE
	//
	// Stack layout at runtime as follows:
	//  x. <--(here possibly method's args)
	//  3. <--(here possibly object reference)
	//  2. args pointer ==SP
	//  1. mb called
	//  0. EE		// this 3 stackplaces are later temp used
	// prepare call of:
	//   XY(ExecEnv *ee,struct methodblock *mb1,va_list args);
	//   ... where XY can be: FastInvCheck() or CodeRunner()
#ifdef TRY_FAST_INVOKE
	if (compileJVMinvoke)
#endif			  
	{
	//
	// 6A. =============== JVM invocation ============================
	// (using a wrapper for convenience)
 	  CB(MOV_AX);
	  if (etype ==SIGNATURE_LONG || etype ==SIGNATURE_DOUBLE)
	   CL(CodeRunner64);
	  else
	   CL(CodeRunner32);
	  CW(CALL_EAX);
	}
#ifdef TRY_FAST_INVOKE						       
	else
	{
	//
	// 6B. =============== fast invocation ============================
	// (call directly address returned by FastInvCheck
	//	   
	  /* important: FastInvCheck has to preserve ebx !*/
	  CB(MOV_CX);
	  if ( compileLOCALspace!=-1 && mbp->CompiledCode )
	  {
	   if (etype ==SIGNATURE_LONG || etype ==SIGNATURE_DOUBLE)	     
	     CL(FastInvNoCheck64);
	   else
	     CL(FastInvNoCheck32);	// returns ptr_to_code in eax, and keeps ebx!
  	  }
	  else
  	  {
	   if (etype ==SIGNATURE_LONG || etype ==SIGNATURE_DOUBLE)	     
	     CL(FastInvCheck64);
	   else
	     CL(FastInvCheck32);
  	  }
	  CW(CALL_ECX);
	  //---
	  if (compileLOCALspace==-1)
	  {
	    CW(SUB_SP_MBP_8);	// insert space for local vars (stored in [ebp-4])
	    CB(LOCSTART-4);
     	  }
 	  else
	     if (compileLOCALspace)
	     {
	       if (compileLOCALspace<128)
		 {
		   CW(SUB_SP_BYTE);
		   CB(compileLOCALspace);
		 }
		 else
	         {
		   CW(SUB_SP_LONG);
		   CL(compileLOCALspace);
	         }
	     }

	  CB(PUSHBX);		// EE
#ifndef USEASM
	  // next is needed for common caller interface with "USEASM" part
	  CW(MOV_CX_MBX_8);
	  CB(4);		// mov ecx,&ee->current_frame

	  CB(CMP_AX);
	  CL(CodeRunner32_withDummies);
	  CB(JE);		// no prev
	  CB(10);
	  CB(CMP_AX);
	  CL(CodeRunner64_withDummies);
	  CB(JE);		// ditto
	  CB(3);
	    
	  CW(MOV_CX_MCX_8);	// mov ecx,ee->current_frame->prev
	  CB(16);		// the frame to set when method returns
#else	
	  /*do nothing */	// frame->prev in ecx [ from FastInvCheck() ]
#endif
	  CB(PUSHCX);
	  CW(CALL_EAX);		// expecting 32bit result in eax, 64bit in edx:eax
	  //	    
	  // in C you would write:  (with pointer to ExecEnv in ebx)
	  // { ee->current_frame=ee->current_frame->prev; }
	  CB(POPCX);		// retrieve frame->prev
	  CW(MOV_MBX_8_CX);
	  CB(4);		// set prev frame
	  // keep EE in ebx for CompTriggerExceptionFromInvoked() !
	  //--
	  if (compileLOCALspace==-1)
	    {
	       CW(ADD_SP_MBP_8);	// add local variable part
	       CB(LOCSTART-4);
	       stac+=4;			// was ee in ebx parameter
	    }
	  else
	    stac+=(compileLOCALspace+4);
	}
#endif	// TRY_FAST_INVOKE
	// 7. ==== release used stack space, store results, check exceptions ===========
	// label:		// we are expecting EE in ebx
	//			// keep it for CompTriggerExceptionFromInvoked() !
         stac+=12;
	  if (stac<128)
	  {
	    CW(ADD_SP_BYTE);	// add arguments stack part
	    CB(stac);		
	  }
	  else
	  {	     
	    CW(ADD_SP_LONG);	// add arguments stack part
	    CL(stac);
	  }
	if (etype ==SIGNATURE_LONG || etype ==SIGNATURE_DOUBLE)
	  CB(PUSHDX);
	CompTriggerExceptionFromInvoked(cinfo);
	if (etype == SIGNATURE_VOID)
	  CB(POPAX);
#if 0
	 /* this is an example how to get some information what's on stack during runtime */
	 CB(PUSHAX);			       
     	 CB(MOV_BX);
	 CL(debughelper);
	 CW(CALL_EBX);
	 CB(POPAX);
#endif
	 break;
      case 0xBB:	// new
      case 0xDD:	// new_quick
	wop=getint16U(&j,cinfo);
	if (code!=0xDD)
	{
  	#ifdef JDK102
	  if (!ResolveClassConstantFromClass(klass,wop,cinfo->ee, 1 << CONSTANT_Class   ))
    	#else
    	  if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee, 1 << CONSTANT_Class   ))
    	#endif
            {
    	      #if RESOLVE_FT>=1
	       clazz =(ClassClass*)klass->constantpool[ wop ].cp;
	       CheckException(cinfo->ee,code);
	       if ((int)clazz>0x4000000)
	         dprintf(stderr,"     wop=%04x class = %p %s\n",wop,unha11(clazz), unha11(clazz)->name);
	       else
	       {
	         dprintf(stderr,"     unknown clazz %x\n",(int)clazz);
		 return -1;
	       }
	      #endif
	      #if RESOLVE_FT == 1
	       if (IgnoreBadClass(klass,unha11(clazz)))
	         return -1;
	      #endif
	      #if RESOLVE_FT==0
	  	return -1;
    	      #endif
	    }
	}
	clazz =(ClassClass*)klass->constantpool[ wop ].cp;
	dprintf(stderr,"NEW  wop=%04x class = %p %s\n",wop,unha11(clazz), unha11(clazz)->name);
	CB(PUSHAX);	// eax is not a parameter here
#ifndef USEASM	   
	CB(PUSHLONG);
#else
	CB(MOV_AX);
#endif	   
	CL(clazz);
	CB(MOV_BX);
	CL(MyObjAlloc);// result in eax
	CW(CALL_EBX);
#ifndef USEASM				
	CB(POPCX);
#endif				
	break;
	
      case 0xbc:	// newarray  array size on stacktop in eax
	op1=*(cinfo->bptr+j++);
	dprintf(stderr,"NEWARRAY op1 =%02x\n",op1);	// 11=long, etc.
	CompTriggerNegArraySizeException(cinfo);
	CB(PUSHAX);
	CB(PUSHLONG2);	// type
	CB(op1);	// 4..11
	// HObject *MyArrayAlloc(int type,int len);
	CB(MOV_BX);
	CL(MyArrayAlloc);// result in eax
	CW(CALL_EBX);
	CB(POPCX);
	CB(POPDX);
//	CompTriggerOutOfMemoryException(cinfo);
	break;
	
      case 0xBD:	// anewarray
      case 0xDE:	// newarray_quick	array size on stacktop in eax
	wop=getint16U(&j,cinfo);
	#ifdef JDK102
	if (!ResolveClassConstantFromClass(klass,wop,cinfo->ee,(unsigned)-1))
    	#else
  	if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
    	#endif
  	{
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
	   return -1;
	}
	clazz=( ClassClass *) klass->constantpool[wop].p;
	dprintf(stderr,"ANEWARRAY wop =%d %p %s\n",wop,clazz,unha11(clazz)->name);
	CompTriggerNegArraySizeException(cinfo);
	CB(PUSHAX);
	CB(PUSHLONG2);
	CB(T_CLASS);	// type
	// HObject *MyArrayAlloc(int type,int len);
	CB(MOV_BX);
	CL(MyArrayAlloc);
	CW(CALL_EBX);
	CB(POPCX);
	CB(POPDX);	// len
//	CompTriggerOutOfMemoryException(cinfo);
	CW(MOV_BX_MAX);
	CB(MOV_CX);
	CL(clazz);
	// mov [ebx + 4*edx], ecx
	MOV_Rsib_R( SIB(SIB_SCALE4, EDX,EBX ), ECX );
	break;

      case 0xbe:	// arraylength
	CompTriggerNullPointerException(cinfo,EAX);	// ==array object
	CW(MOV_AX_MAX_8);
        CB(4);
	CW(SHR_AX);
	CB( METHOD_FLAG_BITS );	// ==new value on stacktop
	break;

      case 0xBF:	// athrow
 	// this test is independend EXCEPTIONS_BY_SIGNALS
	CompTriggerNullPointerException2(cinfo,EAX);
	CompTriggerAthrowException(cinfo);
	dprintf(stderr,"athrow athrow athrow\n");
	break;
  
      case 0xC0:	// checkcast
      case 0xE0:	// checkcast_quick
	wop=getint16U(&j,cinfo);
	#ifdef JDK102
	if (!ResolveClassConstantFromClass(klass,wop,cinfo->ee,(unsigned)-1))
	#else
    	if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
	#endif
	{
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
	   return -1;
	}
	clazz=( ClassClass *) klass->constantpool[wop].p;
	dprintf(stderr,"CHECKCAST wop =%d %p %s\n",wop,clazz,unha11(clazz)->name);
	// object NULL is possible
	CW(OR_AXAX);	// obj null -> result= 0    [Dalheimer S 129]
#define THROW_CCAST_EX 9
	CB(JE);
	CB(22+THROW_CCAST_EX);	// jmp to ready
	//
	// bool_t MyIsInstanceOf(ClassClass *dcb,ExecEnv *ee,JHandle * h);
	//				#3	#2		#1
	// #1
	CB(PUSHAX);
   	// #2
   	CW(MOV_CX_MBP_8);
	CB(LOCSTART-16);		// get EE into ecx
	CB(PUSHCX);
	// #3
	CB(PUSHLONG);
	CL(clazz);
	CB(MOV_BX);
	CL(MyIsInstanceOf);
	CW(CALL_EBX);
	CB(POPBX);
	CB(POPCX);
	CW(MOV_BXAX);
	CB(POPAX);	// restore our stacktop in eax
	CompTriggerClassCastException(cinfo);
	// label:
	break;

      case 0xC1:	// instanceof
      case 0xE1:	// instanceof_quick
	wop=getint16U(&j,cinfo);
	#ifdef JDK102
	if (!ResolveClassConstantFromClass(klass,wop,cinfo->ee,(unsigned)-1))
	#else
  	if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
	#endif
  	{
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
	   return -1;
	}
	clazz=( ClassClass *) klass->constantpool[wop].p;
	CW(OR_AXAX);	// eax obj null -> erg= 0    [Dalheimer S 129]   
	CB(JE);
	CB(20);		// jmp to label1: return false
	// bool_t MyIsInstanceOf(ClassClass *dcb,ExecEnv *ee,JHandle * h);
	//			    	#3	#2		#1
	dprintf(stderr,"INSTANCEOF wop =%d %p %s\n",wop,clazz,unha11(clazz)->name);
   	// #1
	CB(PUSHAX);
   	// #2
      	CW(MOV_CX_MBP_8);
	CB(LOCSTART-16);		// get EE into ecx
	CB(PUSHCX);
	// #3
	CB(PUSHLONG);	
	CL(clazz);
	CB(MOV_BX);
	CL(MyIsInstanceOf);
	CL(CALL_ADDSP);
	CB(12);
	// label1:
	break;

// If we ever write own monitorEnter/Exit we could pass directly EAX instead of
// stack
      case 0xC2:
	CompTriggerNullPointerException2(cinfo,EAX);
      	CB(PUSHAX);
	CB(MOV_BX);
	CL(monitorEnter);
	CW(CALL_EBX);
	CB(POPAX);
	CB(POPAX);
	break;

      case 0xC3:
	CompTriggerNullPointerException2(cinfo,EAX);
      	CB(PUSHAX);
	CB(MOV_BX);
	CL(monitorExit);
	CW(CALL_EBX);
	CB(POPAX);
	CB(POPAX);
	break;

      case 0xC4:	// wide 	(have seen it yet only together with iinc)
 	cinfo->wide=1;
        dprintf(stderr,"wide prefix =%02x\n",cinfo->wide);
	break;

      case 0xC5:	// multiarrayalloc
	wop=getint16U(&j,cinfo);
	m=*(signed char*)(cinfo->bptr+j++);
	#ifdef JDK102
	if (!ResolveClassConstantFromClass(klass,wop,cinfo->ee,(unsigned)-1))
	#else
  	if (!ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1))
	#endif
  	{
	   lprintf("TYA: Resolve problem in opcode %x\n",code);
	   return -1;
	}
	clazz=( ClassClass *) klass->constantpool[wop].p;
	dprintf(stderr,"MULT ARR AL wop =%d dim=%d %s\n",wop,m,unha11(clazz)->name);
	switch (m)	// reverse buffer
	     {
	      case 1:CB(PUSHAX);break;
	      case 2:CB(POPBX);CB(PUSHAX);CB(PUSHBX);break;
	      case 3:CB(POPBX);CB(POPCX);CB(PUSHAX);CB(PUSHBX);CB(PUSHCX);break;
	      case 4:CB(POPBX);CB(POPCX);CB(POPDX);
		     CB(PUSHAX);CB(PUSHBX);CB(PUSHCX);CB(PUSHDX);break;
	      default:lprintf("TYA: Too much dimensions: %d in opcode %x\n",m,code);
	   	    return -1;
		    // no problem: this method should run interpreted
	     }
	//
	// calling MultiArrayAlloc(int dimensions, ClassClass *, stack_item *sizes)
	//				#3		#2		#1
	// #buffer of sizes 
	// #1	   
	CB(PUSH_SP);
	// #2
	CB(PUSHLONG);
	CL(clazz);
	// #3
	CB(PUSHLONG2);
	CB(m);
	CB(MOV_BX);
	CL(MultiArrayAlloc);	// FIXME: some init with 0 ?
	CL(CALL_ADDSP);
	CB(12+ m*SIS4);
	CompTriggerOutOfMemoryException(cinfo);
	break;

      case 0xC8:	// goto_w
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+(j-1);
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
	m=getint32(&j,cinfo);   
	iprintf("TYA: goto_w!!!!! not yet debugged   (jumping %d java byte)\n",m);
	CW(JMP1);
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	CL(0);		// backpatched later
	cinfo->backp[cinfo->backcnt].javadist=m;
	cinfo->backcnt++;
	break;

      case 0xC9:	// jsr_w
	cinfo->backp[cinfo->backcnt].java=cinfo->bptr+(j-1);
	m=getint32(&j,cinfo);
	iprintf("TYA: jsr_w!!!!! not yet debugged   (jumping %d java byte)\n",m);
	CB(PUSHAX);
	CB(CALL);
	CL(0);
	CB(POPAX); //1
	CW(ADDAX); //3 	stacktop now is "next_java_instruction"
	CB(9);	//4
	CB(JMP1); //5
	cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
	cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
	CL(0); //9	 backpatched later
	cinfo->backp[cinfo->backcnt].javadist=m;
	cinfo->backcnt++;
	break;

      case 0xCA:	// debugbreak;
	CB(DEBUGBREAK);
	break;
      case 0xD1:	// ret_w
   	op1=getint16U(&j,cinfo);
	iprintf("TYA: ret_w  !!!!! not yet debugged  (op1 =%x)\n",op1);
	Comp_PUSH_LocalVarToStack(op1,cinfo);	// bypassing eax-stacktop
	CB(RETN);
	break;
      default:
	{
	   char *msg=alloca(32);
	   sprintf(msg,"TYA: unimplemented opcode=%02x\n",code);
	   lprintf(msg);panic(msg);
	}
     }
   return j-jj;		// bytes read
}
