#include <iostream.h>

#include "icqevent.h"
#include "icq-defines.h"


//-----ICQEvent::constructor-----------------------------------------------------------------------
ICQEvent::ICQEvent(unsigned short theCmd, unsigned short theSubCmd, unsigned long theSeq, unsigned long theUin,
                   INetSocket *theSocket, Packet *thePacket, OutputWin *theOutWin)
{
   // set up internal variables
   cmd = theCmd;
   subCmd = theSubCmd;
   seq = theSeq;
   sock = theSocket;
   uin = theUin;
   outWin = theOutWin;
   retries = 0;
   packet = new Packet(thePacket);
}

bool ICQEvent::start(void)
{
   // send the packet
   if (!sock->sendPacket(*packet))
      return(false);
   else
   {
      if (DEBUG_LEVEL >= 2) cout << "Packet sent (" << (cmd == ICQ_CMDxTCP_START ? "TCP" : "UDP") << "):\n" << packet->print() << endl;
      if (cmd != ICQ_CMDxTCP_START)   // if not TCP then start a timeout timer
      {
         connect(&ackTimer, SIGNAL(timeout()), this, SLOT(noAck()));
         ackTimer.start(MAX_WAIT_ACK * 1000, true);
      }
      return(true);
   }
}


//-----ICQEvent::destructor------------------------------------------------------------------------
ICQEvent::~ICQEvent(void)
{
   if (ackTimer.isActive()) ackTimer.stop();
   delete packet;
}


//-----ICQEvent::isEvent---------------------------------------------------------------------------
bool ICQEvent::isEvent(int sockfd, unsigned long theSeq)
{
   return(sock->descriptor() == sockfd && seq == theSeq);
}


//-----ICQEvent::noAck-----------------------------------------------------------------------------
void ICQEvent::noAck()
{
   if (!sock->connected()) 
   {
      outWin->wprintf("%s%s socked not connected (%d).", (cmd == ICQ_CMDxTCP_START ? TCP : UDP), (cmd == ICQ_CMDxTCP_START ? "user" : "server"), seq);
      emit timedOut(false, sock->descriptor(), seq);
   }
   else if (retries < MAX_SERVER_RETRIES && cmd != ICQ_CMDxTCP_START)   // retry the function if not TCP
   {
      outWin->wprintf("%stimed out (%d), retrying...", (cmd == ICQ_CMDxTCP_START ? TCP : UDP), seq);
      retries++;
      sock->sendPacket(*packet);
      ackTimer.start(MAX_WAIT_ACK * 1000, true);
   }
   else  // no more retries or TCP function
   {
      outWin->wprintf("%s%s timed out (%d).", (cmd == ICQ_CMDxTCP_START ? TCP : UDP), (cmd == ICQ_CMDxTCP_START ? "user" : "server"), seq);
      emit timedOut(false, sock->descriptor(), seq);
   }
}

