#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream.h>
#include <stdlib.h>
#include <unistd.h>

#include "icq-defines.h"
#include "licq.h"

#ifdef USE_KDE
Licq::Licq(int argc, char **argv) : KApplication(argc, argv)
#else
Licq::Licq(int argc, char **argv) : QApplication(argc, argv)
#endif
{
   DEBUG_LEVEL = 0;
   quitNowVal = false;
   icq = NULL;
   licqgui = NULL;

   // parse command line for arguments
   bool baseDirSet = false;   
   while(true)
   {
      int i = getopt(argc, argv, "hd:b:");
      if (i < 0) break;
      switch (i)
      {
      case 'h':  // help
	      usage();
	      quitNowVal = true; 
         return;
	   case 'b':  // base directory
	      sprintf(BASE_DIR, "%s/", optarg);
	      baseDirSet = true;
         break;
      case 'd':  // DEBUG_LEVEL
         DEBUG_LEVEL = atol(optarg);
         break;
      }
   }
   
   // if no base directory set on the command line then get it from HOME
   if (!baseDirSet)
   {
      char *home;
      if ((home = getenv("HOME")) == NULL)
      {
         cerr << "Licq: $HOME not set.\n";
	      quitNowVal = true; 
         return;
      }
      sprintf(BASE_DIR, "%s/%s/", home, DEFAULT_HOME_DIR);
   }
   
   // check if user has conf files installed
   if (access(BASE_DIR, F_OK) < 0)  // BASE_DIR does not exist
   {
      if (!installBaseDir())
      {
      //      cerr << "You must run licq.inst to install the data and config files to " << BASE_DIR << "." << endl;
         quitNowVal = true; 
         return;
      }
      cout << "Done installation, continuing load." << endl << endl;
   }
   
   setStyle(WindowsStyle);
   // create the main widgets
   if (DEBUG_LEVEL >= 1) cout << "\n=> Setting up Licq daemon." << endl;
   icq = new ICQ;
   if (DEBUG_LEVEL >= 1) cout << "\n=> Setting up Licq GUI." << endl;
   licqgui = new LicqGUI(icq);
   if (DEBUG_LEVEL >= 1) cout << "\n=> Done." << endl << endl;
   
   setMainWidget(licqgui);
   licqgui->show();
   
#ifdef USE_KDE
   kicq = new Kicq;   
   KWM::setDockWindow(kicq->winId());
   kicq->show();
   kicq->reset();
   connect(licqgui, SIGNAL(changeDockStatus(unsigned short int)), kicq,SLOT(change_dock_status(unsigned short int)));
   connect(kicq, SIGNAL(change_status_from_dock(int)), licqgui, SLOT(changeStatus(int)));
   connect(kicq, SIGNAL(lowericq()), licqgui, SLOT(lower()));
   connect(kicq, SIGNAL(raiseicq()), licqgui, SLOT(raise()));
#endif 
}


Licq::~Licq(void)
{
   if (licqgui != NULL) delete licqgui;
   if (icq != NULL) delete icq;
}


void Licq::usage(void)
{
   cerr << PACKAGE << " version " << VERSION << "." << endl
        << "Usage:  Licq [-h] [-d #] [-b configdir]" << endl << endl
        << " -h            this help screen" << endl
        << " -d #          extra debugging info, # is level of information:" << endl
        << "                  1  show starting up information" << endl
        << "                  2  dump every sent packet" << endl
        << " -b configdir  set the base directory for the config and data files" << endl;
}


bool Licq::installBaseDir(void)
{   
   cout << PACKAGE << " version " << VERSION << " user installation." << endl << endl
        << PACKAGE << " will be installed to " << BASE_DIR << " from " << SHARE_DIR << endl
        << "Hit enter to continue." << endl;
   
   getchar();
   
   if (access(SHARE_DIR, F_OK) < 0)  // SHARE_DIR does not exist
   {
      cerr << SHARE_DIR << " does not exist!  Licq has not been installed properly." << endl;
      return(false);
   }
   
   char cmd[MAX_FILENAME_LEN * 2];
   
   // create directories
   cout << "Creating " << BASE_DIR << "...";
   sprintf(cmd, "%s -m 700 -d %s", INSTALL_PROG, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check permission in above directory." << endl; return(false); }   
   cout << "done." << endl;
   
   cout << "Creating " << BASE_DIR << "conf...";
   sprintf(cmd, "%s -m 700 -d %sconf", INSTALL_PROG, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check permission in above directory." << endl; return(false); }   
   cout << "done." << endl;
   
   cout << "Creating " << BASE_DIR << "data...";
   sprintf(cmd, "%s -m 700 -d %sdata", INSTALL_PROG, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check permission in above directory." << endl; return(false); }      
   cout << "done." << endl;
   
   cout << "Creating " << BASE_DIR << "history...";
   sprintf(cmd, "%s -m 700 -d %shistory", INSTALL_PROG, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check permission in above directory." << endl; return(false); }      
   cout << "done." << endl;

   cout << "Creating " << BASE_DIR << "translations...";
   sprintf(cmd, "%s -m 700 -d %stranslations", INSTALL_PROG, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check permission in above directory." << endl; return(false); }
   cout << "done." << endl;

   // copy files
   cout << "Copying files from " << SHARE_DIR << "/conf to " << BASE_DIR << "conf...";
   sprintf (cmd, "%s -m 600 %s/conf/licq.conf %sconf/", INSTALL_PROG, SHARE_DIR, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check existence and permissions of licq.conf." << endl; return(false); }
   
   sprintf (cmd, "%s -m 600 %s/conf/users.conf %sconf/", INSTALL_PROG, SHARE_DIR, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check existence and permissions of users.conf." << endl; return(false); }
   
   sprintf (cmd, "%s -m 600 %s/conf/sample.uin %sconf/", INSTALL_PROG, SHARE_DIR, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check existence and permissions of sample.uin." << endl; return(false); }   
   cout << "done." << endl;
   
   cout << "Copying " << SHARE_DIR << "/data/* to " << BASE_DIR << "data...";
   sprintf (cmd, "%s -m 600 %s/data/* %sdata/", INSTALL_PROG, SHARE_DIR, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check existence and permissions of above mentioned files." << endl; return(false); }
   cout << "done." << endl;

   cout << "Copying " << SHARE_DIR << "/translations/* to " << BASE_DIR << "translations...";
   sprintf (cmd, "%s -m 600 %s/translations/* %stranslations/", INSTALL_PROG, SHARE_DIR, BASE_DIR);
   if (system(cmd) != 0) { cerr << "error!  Check existence and permissions of above mentioned files." << endl; return(false); }
   cout << "done." << endl;


   // enter the alias, password and uin
   char alias[32], password[16];
   unsigned long uin;
   cout << "Enter your alias: ";
   cin >> alias;
   cout << "Enter your uin: ";
   cin >> uin;
   cout << "Enter your password (warning - will appear on screen): ";
   cin >> password;

   // save them in licq.conf
   cout << "Saving info...";
   sprintf (cmd, "%sconf/licq.conf", BASE_DIR);
   File licqConf(cmd);
   licqConf.section("owner").key("Alias").write(alias);
   licqConf.section("owner").key("Password").write(password);
   licqConf.section("owner").key("Uin").write(uin);
   cout << "done." << endl;

   return(true);

}



bool Licq::quitNow(void)
{
   return (quitNowVal);
}
