#ifndef MSGBOXLIST_H
#define MSGBOXLIST_H

#include <qlistview.h>
#include <qpopmenu.h>

#include "user.h"


//=====UserViewItem================================================================================
class MsgViewItem : public QListViewItem
{
public:
   MsgViewItem (Message *, unsigned short, QListView *);
   virtual const char *key (int column, bool ascending) const;
   short index;
   Message msg;

protected:
   virtual void paintCell ( QPainter *, const QColorGroup &, int column, int width, int align);
   
friend class MsgView;
};


//=====UserList====================================================================================
class MsgView : public QListView
{
public:
   MsgView (QWidget *parent = 0, const char *name = 0);
   Message *currentMsg(void);
   void markRead(short);
protected:
   void mouseReleaseEvent(QMouseEvent *e); 
};


#endif
