#include "HistoryDialog.h"

HistoryDialog::HistoryDialog(QWidget* parent, const char* name) : HistoryDialogData(parent,name)
{
    setCaption( "History" );
    setIcon(*myMainIcon);
    setMinimumSize(width(),110);

    list.setAutoDelete(true);
    maxItems = 200;
    autoAdd = true;
    
    file = new HistoryFile(".sidplay-history");
    file->load(*this);
    
    QString tmp;
    tmp.sprintf("%d",maxItems);
    sizeLineEdit->setText(tmp);
}

HistoryDialog::~HistoryDialog()
{
    delete file;
}

void HistoryDialog::add(const char* fileName, const char* info)
{
    if (autoAdd)
    {
        if (list.count() >= maxItems)
        {
            list.removeFirst();
            historyListBox->removeItem(0);
        }
        list.append(new HistoryItem(fileName,info));
        historyListBox->insertItem(info);
    }
}

void HistoryDialog::historyItemHighlighted(int index)
{
    emit playHistoryEntry(list.at(index)->fileName());
}

void HistoryDialog::prevButtonClicked()
{
    if (historyListBox->count() > 0)
    {
        int index = historyListBox->currentItem();
        index--;
        if (index >= 0)  // first is 0
            historyListBox->setCurrentItem(index);
    }
}

void HistoryDialog::nextButtonClicked()
{
    int count = historyListBox->count();
    if (count > 0)
    {
        int index = historyListBox->currentItem();
        index++;
        if (index <= (count-1))  // last is count-1 
            historyListBox->setCurrentItem(index);
    }
}

void HistoryDialog::deleteButtonClicked()
{
    int index = historyListBox->currentItem();
    if (index >= 0)
    {
        list.remove(index);
        historyListBox->removeItem(index);
    }
}

void HistoryDialog::clearButtonClicked()
{
    if (!list.isEmpty())
    {
        QMessageBox mb( "SIDPLAY",
                       "Do you really want to clear the history?",
                       QMessageBox::Information,
                       QMessageBox::Yes,
                       QMessageBox::No | QMessageBox::Default | QMessageBox::Escape,
                       0);
        mb.setButtonText( QMessageBox::Yes, "Yes" );
        mb.setButtonText( QMessageBox::No, "No" );
        switch( mb.exec() ) 
        {
         case QMessageBox::Yes:
            {
                historyListBox->clear();
                list.clear();
                break;
            }
         case QMessageBox::No:
            break;
        }
    }
}

void HistoryDialog::historySizeChanged()
{
    maxItems = atoi(sizeLineEdit->text());
    while (list.count() > maxItems)
    {
        list.removeFirst();
        historyListBox->removeItem(0);
    }
}

void HistoryDialog::resizeEvent(QResizeEvent*)
{
    int w = width();
    int h = height();
    
    historyListBox->setGeometry(10,10,w-20,h-90);
    deleteButton->move(160,h-70);
    prevButton->move(150,h-40);
    nextButton->move(40,h-40);
    clearButton->move(220,h-70);
    sizeLineEdit->move(100,h-70);
    maxEntriesLabel->move(20,h-70);
}

bool HistoryDialog::save()
{
    return file->save(*this);
}
