/*
 * $Id: config_panel.h,v 1.7 1998/09/27 01:30:50 gregm Exp $
 * GXSNMP -- An snmp management application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Configuration panel for gxsnmp
 */

#ifndef __CONFIG_PANEL_H__
#define __CONFIG_PANEL_H__

#define CONFIG_VERSION   1.0
#define CONFIG_HEADER  "/* Configuration file automaticly generated, DO NOT EDIT */"

#define CONF_SNMP_RCOM      0
#define CONF_SNMP_WCOM      1
#define CONF_SNMP_PORT      2
#define CONF_SNMP_RETR      3
#define CONF_SNMP_TIME      4

typedef struct __config_panel {
  GtkWidget     *window;
  GtkWidget     *entries[12];
  GtkWidget     *def_sql_host;
  GtkWidget     *def_sql_user;
  GtkWidget     *def_sql_passwd;
  GtkWidget     *def_sql_db;
  GtkWidget     *def_sql_port;
} config_panel;

typedef struct __gxsnmp_config {
  /* 
   * Snmp defaults.
   */
  char          *def_snmp_com;
  char          *def_snmp_wcom;
  int           def_snmp_vers;
  int           def_snmp_port;
  int           def_snmp_retr;
  int           def_snmp_time;
  /* 
   * SQL defaults.
   */
  char          *def_sql_host;
  char          *def_sql_user;
  char          *def_sql_pass;
  char          *def_sql_db;
  int           def_sql_port;
} gxsnmp_config;

/*
 * Global standard panel functions
 */

void                 open_config_panel             (void);
void                 hide_config_panel             (void);
void                 destroy_config_panel          (void);
void                 reset_config_panel            (void);

#endif









