#include <stddef.h>
#include <stdlib.h>
#include <dirent.h>
#include <string.h>
#include <sys/types.h>

struct kernel_dirent
{
  long int d_ino;
  long d_off;
  unsigned short int d_reclen;
  char d_name[256];
};

static void
l2k(struct kernel_dirent *d, const struct dirent *s)
{
  d->d_ino = s->d_fileno;
  d->d_off = s->d_off;
  d->d_reclen = (s->d_reclen
		 - sizeof(struct dirent) + sizeof (struct kernel_dirent));
  memcpy(d->d_name, s->d_name, 256);
}

struct kernel_dirent *readdA0 (DIR *dirp)
{
  struct dirent *s, ss;
  static struct kernel_dirent kd;
  if (readdir_r(dirp, &ss, &s) != 0)
    return NULL;
  if (s == NULL)
    return NULL;
  l2k(&kd, s);
  return &kd;
}

int readdA0_r (DIR *dirp, struct kernel_dirent *entry,
	       struct kernel_dirent **result)
{
  int rr;
  struct dirent e, *r;
  rr = readdir_r (dirp, &e, &r);
  if (rr != 0)
    return rr;
  l2k(entry, &e);
  *result = entry;
  return 0;
}

int scandA0 (const char *dir,
	     struct kernel_dirent ***namelist,
	     int (*selector) (struct kernel_dirent *),
	     int (*cmp) (const void * a, const void * b))
{
  int mycmp (const void *ax, const void *bx)
    {
      struct kernel_dirent ka, kb, *kap = &ka, *kbp = &kb;
      l2k(kap, *(struct dirent **)ax);
      l2k(kbp, *(struct dirent **)bx);
      return cmp(&kap, &kbp);
    }
  int mysel (const struct dirent *d)
    {
      struct kernel_dirent kd;
      l2k(&kd, d);
      return selector(&kd);
    }
  int rr, i;
  struct dirent **names;
  rr = scandir(dir, &names, selector == NULL ? NULL : mysel,
	       cmp == NULL ? NULL : mycmp);
  if (rr == -1)
    return -1;
  *namelist = malloc(sizeof(**namelist) * rr);
  for (i = 0; i < rr; i++)
    {
      namelist[0][i] = malloc(sizeof(struct kernel_dirent));
      l2k(namelist[0][i],names[i]);
      free(names[i]);
    }
  free(names);
  return rr;
}

/* Function to compare two `struct dirent's alphabetically.  */
int alphasoA1 (struct kernel_dirent *a, struct kernel_dirent *b)
{
  return strcmp(a->d_name, b->d_name);
}

/* Read directory entries from FD into BUF, reading at most NBYTES.
   Reading starts at offset *BASEP, and *BASEP is updated with the new
   position after reading.  Returns the number of bytes read; zero when at
   end of directory; or -1 for errors.  */
ssize_t getdA0entries (int fd, char *buf,
		    size_t nbytes, off_t *basep)
{
  abort();
}
