/*
 *	cook - file construction tool
 *	Copyright (C) 1994, 1997 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for cook/fngrprnt.c
 */

#ifndef COOK_FNGRPRNT_H
#define COOK_FNGRPRNT_H

#include <ac/time.h>
#include <str.h>

typedef struct fp_ty fp_ty;
struct fp_ty
{
	time_t		oldest;
	time_t		newest;
	string_ty	*fingerprint;
};

fp_ty *fp_search _((string_ty *path));
void fp_assign _((string_ty *, fp_ty *));
void fp_delete _((string_ty *));
string_ty *fp_fingerprint _((string_ty *path));

#endif /* COOK_FNGRPRNT_H */
