#!/usr/bin/mawk -We
# be sure to chmod +x this!

# ./script "fieldname: regex" "fieldname: regex" ... --
#	 "fieldname" "fieldname" ...
# Find all records matching the regex expressions, and output the
# 	requested fieldnames.
# The fieldnames can be upper or lowercase.  When outputing the
# 	fieldnames, the case used in the same as specified on the
#	cmd line.

# sample cmdline:
#
# dpkg-awk --sort "Package" "Status: .* installed$"  -- ^Description ^Conffiles

# --sort(-s) "<space separated list of fields to sort on>"
# --filename(-f) <filename to parse, default = /var/lib/dpkg/status>
# dpkg-awk [options] <regex expresion list> -- <output field list>

# <output field list>
# If the first char is "^", then it is a list of fields *NOT* to output,
# otherwise, it will output the listed fields.

BEGIN{ oflags = ":;#" }

function option_split_helper(ndx, s_o, l_o, val)
{
	if (length(ndx) == 1)
		s_o[ndx] = val
	else
		l_o[ndx] = val
}
function option_split(opt, s_o, s_o_f, l_o, l_o_f,
	a, opts, itm, flags)
{
	split(opt, opts, " ")
	for (a in opts) {
#print "opts[" a "]='" opts[a] "'\n"
		itm = opts[a]
#print itm " "
		flags = ""
		while (match(itm, "^[" oflags "]")) {
			flags = flags substr(itm, 1, 1)
			itm = substr(itm, 2)
#print itm " "
		}
#print "\n"
		option_split_helper(itm, s_o, l_o, "")
		if (length(flags)) option_split_helper(itm, s_o_f, l_o_f, flags)
		delete opts[a]
	}
}
function option_match(header, text, opts, opts_flags, argv, argc,
	ret_val, fchar, flags, value)
{
	itm = argv[c]
	gsub(/=.*$/, "", itm)
#print "argv[" c "]='" argv[c] "' itm='" itm "'\n"
	ret_val = 0
#for (a in opts) print "o_m opts[" a "]='" opts[a] "'\n"
	if (match(itm, "^" header )){
#print "match!\n"
		sub("^" header, "", itm)
		if (itm in opts){
			if (itm in opts_flags){
				flags = opts_flags[itm]
#print "o_m flags=" flags "\n"
				for (a = 1; a <= length(oflags); a++) {
					fchar = substr(oflags, a, 1)
					if (match(flags, "[" fchar "]")) {
						if ((fchar == ":") || (fchar == ";")) {
							if (match(argv[c], /=.*$/)){
								sub(/^.*=/, "", argv[c])
								value = argv[c]
								delete argv[c]
							} else {
								delete argv[c]
								if ((c++) <= argc) {
									if (((fchar == ";") && !(match(argv[c], /^-/))) || (fchar == ":")) {
										value = argv[c]
										delete argv[c]
									}
								} else
									value = ""
							}
						}
						if (fchar == "#") {
#print "o_m number\n"
							value = options[itm]
							if (match(argv[c], /=.*$/)){
								sub(/^.*=/, "", argv[c])
								value = argv[c]
								delete argv[c]
							} else {
								delete argv[c]
								value++
							}
						}
					}
				}
			} else
				value = ""
			options[itm] = value
		} else
			if (itm) print "illegal " text " option! '" itm "'\n"
		ret_val=1
	}
	return ret_val
}
function option_parse(opt_list, relation, argc, argv,
	short_opts, short_opts_value,
	long_opts, long_opts_value,
	m, rels, short, long)
{
	option_split(opt_list " :exebase :exedir", short_opts, short_opts_value, long_opts, long_opts_value)
	for (c = 1; c <= argc; c++) {
		if (option_match("--", "long", long_opts, long_opts_value, argv, argc)) continue
		if (option_match("-", "short", short_opts, short_opts_value, argv, argc)) continue
	}
	split(relation, rels, " ")
	for ( c in rels) {
		equal = index(rels[c], "=")
		first = substr(rels[c], 1, 1)
		if (first in options) {
			second = substr(rels[c], 3)
			if (!(second in options))
				# Only move the 'first' option into the
				# 'second' slot if the 'second' one
				# hasn't been defined yet.
				options[second] = options[first]
			delete options[first]
		}
	}
	if ("exebase" in options) {
		script_exebase = options["exebase"]
		delete options["exebase"]
	}
	if ("exedir" in options) {
		script_exedir = options["exedir"]
		delete options["exedir"]
	}
}
