{
Copyright (C) 1998-99 Free Software Foundation, Inc.
Author: Frank Heckenbach <frank@pascal.gnu.de>

Internal Pascal declarations of the GPC run time system that are not
needed in normal programs. This file is a supplement to gpc.pas. Use
of the routines in this file is at your own risk. They might only
work under certain circumstances, and might change without notice.

This file is part of GNU Pascal Library. The GNU Pascal Library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any
later version.

The GNU Pascal Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU Pascal Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.
}

unit Internal;

interface

uses GPC;

{ ================= PROGRAM INITIALIZATION AND TERMINATION ================ }

{ RTS initialization, called before entering the main Pascal program, from rt0.c }

procedure GPC_Initialize (ArgumentCount : Integer; Arguments, Environment : PCStrings); asmname '_p_initialize';

{ Subroutines of GPC_Initialize. All GPC_Initialize does is call these routines. }

procedure GPC_Init_Heap;                                                                asmname '_p_init_heap';
procedure GPC_Init_Env (Environment : PCStrings);                                       asmname '_p_init_env';
procedure GPC_Init_Arguments (ArgumentCount : Integer; Arguments : PCStrings);          asmname '_p_init_arguments';
procedure GPC_Init_Locale;                                                              asmname '_p_init_locale';
procedure GPC_Init_Signals;                                                             asmname '_p_init_signals';
procedure GPC_Initialize_Std_Files; { Without I/O checking }                            asmname '_p_initialize_std_files';
procedure GPC_Init_Std_Files;       { With    I/O checking }                            asmname '_p_init_std_files';
procedure GPC_Init_Files_AtExit;                                                        asmname '_p_init_files_atexit';
procedure GPC_Run_Constructors;                                                         asmname '_p_run_constructors';

{ Automatically called at the end of the program }
procedure GPC_Done_Files;                                                               asmname '_p_done_files';

var
  RTSWarnFlag  : asmname '_p_warn'  Integer;
  RTSDebugFlag : asmname '_p_debug' Integer;

procedure FlushAllFiles (OnlyTTYs : Boolean); asmname '_p_fflush';
procedure ExitProgram (Status : Integer); asmname '_p_exit';

{ Heap manager initialization, from heap.pas. Called by GPC_Init_Heap }
procedure HeapInit; asmname '_p_heap_init';

{ Miscellaneous routines for extended pascal support, from misc.c }

type ProcPtr = ^Procedure;
procedure GPC_Collect (Proc : ProcPtr; Run_ID : Integer); asmname '_p_collect';

{ String handling routines, from string.c }

function  GPC_String_Operations (Opcode, ArgumentMask : Integer; ...) : Integer; asmname '_p_string';
procedure GPC_WriteStr          (StringType : Integer; Str1 : PChars; ...);      asmname '_p_writestr';
procedure GPC_ReadStr           (Str : PChars; StrLength, Count : Integer; ...); asmname '_p_readstr';

{ bind a filename to an external file, from fassign.pas }

procedure GPC_Internal_Assign (var T : AnyFile; Name : CString; NameLength : Integer); asmname '_p_internal_assign';

{ Old TFDD interface, from bind.c }

{ NOTE: These functions are deprecated. They will vanish soon. Instead of
  them, use the newer TFDD interface in gpc.pas }
type t_InFunc  = function (var PrivateData; var   Buffer; Size : Integer; var Result : Integer) : Integer;
type t_OutFunc = function (var PrivateData; const Buffer; Size : Integer; var Result : Integer) : Integer;
procedure hack_SetInFunc  (var aFile : AnyFile; InFunc  : t_InFunc ; PrivateData : Pointer); C;
procedure hack_SetOutFunc (var aFile : AnyFile; OutFunc : t_OutFunc; PrivateData : Pointer); C;

{ Generic file handling routines and their support, from file.c }

procedure GPC_InitFDR (var aFile : AnyFile; Name : CString; Size, Flags : Integer); asmname '_p_initfdr';
procedure GPC_DoneFDR (var aFile : AnyFile);                                        asmname '_p_donefdr';

{ Routines to read various things from files, from read.c }

procedure GPC_TextRead   (var aFile : Text; Count : Integer; ...); asmname '_p_read';
procedure GPC_LazyTryGet (var aFile : AnyFile);                    asmname '_p_lazytryget';
procedure GPC_LazyGet    (var aFile : AnyFile);                    asmname '_p_lazyget';
procedure GPC_LazyUnget  (var aFile : AnyFile);                    asmname '_p_lazyunget';

{ If an error occurs or remaining characters (including whitespace!) are left,
  the position of the error, not the error code, is returned (BP compatibility!) }
function GPC_Val_ByteInt_NoCheck   (Source : PChars; StrLength, Flags : Integer; var Result : ByteInt  ) : Integer; asmname '_p_val_byteint_nocheck';
function GPC_Val_ShortInt_NoCheck  (Source : PChars; StrLength, Flags : Integer; var Result : ShortInt ) : Integer; asmname '_p_val_shortint_nocheck';
function GPC_Val_Integer_NoCheck   (Source : PChars; StrLength, Flags : Integer; var Result : Integer  ) : Integer; asmname '_p_val_integer_nocheck';
function GPC_Val_MedInt_NoCheck    (Source : PChars; StrLength, Flags : Integer; var Result : MedInt   ) : Integer; asmname '_p_val_medint_nocheck';
function GPC_Val_LongInt_NoCheck   (Source : PChars; StrLength, Flags : Integer; var Result : LongInt  ) : Integer; asmname '_p_val_longint_nocheck';
function GPC_Val_ByteCard_NoCheck  (Source : PChars; StrLength, Flags : Integer; var Result : ByteCard ) : Integer; asmname '_p_val_bytecard_nocheck';
function GPC_Val_ShortCard_NoCheck (Source : PChars; StrLength, Flags : Integer; var Result : ShortCard) : Integer; asmname '_p_val_shortcard_nocheck';
function GPC_Val_Cardinal_NoCheck  (Source : PChars; StrLength, Flags : Integer; var Result : Cardinal ) : Integer; asmname '_p_val_cardinal_nocheck';
function GPC_Val_MedCard_NoCheck   (Source : PChars; StrLength, Flags : Integer; var Result : MedCard  ) : Integer; asmname '_p_val_medcard_nocheck';
function GPC_Val_LongCard_NoCheck  (Source : PChars; StrLength, Flags : Integer; var Result : LongCard ) : Integer; asmname '_p_val_longcard_nocheck';
{$if 0} { Not yet implemented }
function GPC_Val_ByteInt_Check     (Source : PChars; StrLength, Flags : Integer; var Result : ByteInt;   Min, Max : ByteInt  ) : Integer; asmname '_p_val_byteint_check';
function GPC_Val_ShortInt_Check    (Source : PChars; StrLength, Flags : Integer; var Result : ShortInt;  Min, Max : ShortInt ) : Integer; asmname '_p_val_shortint_check';
function GPC_Val_Integer_Check     (Source : PChars; StrLength, Flags : Integer; var Result : Integer;   Min, Max : Integer  ) : Integer; asmname '_p_val_integer_check';
function GPC_Val_MedInt_Check      (Source : PChars; StrLength, Flags : Integer; var Result : MedInt;    Min, Max : MedInt   ) : Integer; asmname '_p_val_medint_check';
function GPC_Val_LongInt_Check     (Source : PChars; StrLength, Flags : Integer; var Result : LongInt;   Min, Max : LongInt  ) : Integer; asmname '_p_val_longint_check';
function GPC_Val_ByteCard_Check    (Source : PChars; StrLength, Flags : Integer; var Result : ByteCard;  Min, Max : ByteCard ) : Integer; asmname '_p_val_bytecard_check';
function GPC_Val_ShortCard_Check   (Source : PChars; StrLength, Flags : Integer; var Result : ShortCard; Min, Max : ShortCard) : Integer; asmname '_p_val_shortcard_check';
function GPC_Val_Cardinal_Check    (Source : PChars; StrLength, Flags : Integer; var Result : Cardinal;  Min, Max : Cardinal ) : Integer; asmname '_p_val_cardinal_check';
function GPC_Val_MedCard_Check     (Source : PChars; StrLength, Flags : Integer; var Result : MedCard;   Min, Max : MedCard  ) : Integer; asmname '_p_val_medcard_check';
function GPC_Val_LongCard_Check    (Source : PChars; StrLength, Flags : Integer; var Result : LongCard;  Min, Max : LongCard ) : Integer; asmname '_p_val_longcard_check';
{$endif}
function GPC_Val_ShortReal         (Source : PChars; StrLength, Flags : Integer; var Result : ShortReal) : Integer; asmname '_p_val_shortreal';
function GPC_Val_Real              (Source : PChars; StrLength, Flags : Integer; var Result : Real     ) : Integer; asmname '_p_val_real';
function GPC_Val_LongReal          (Source : PChars; StrLength, Flags : Integer; var Result : LongReal ) : Integer; asmname '_p_val_longreal';

{ Routines to output various things, from write.c }

procedure GPC_TextWrite (var aFile : Text; Count : Integer; ...); asmname '_p_write';

implementation

end.
