/*
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Support routine for the Dos unit

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
*/

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>

/* Dos systems only know permissions (partly) for user, not for group and others */
#ifndef S_IRGRP
#define S_IRGRP S_IRUSR
#endif
#ifndef S_IROTH
#define S_IROTH S_IRUSR
#endif
#ifndef S_IWGRP
#define S_IWGRP S_IWUSR
#endif
#ifndef S_IWOTH
#define S_IWOTH S_IWUSR
#endif
#ifndef S_IXGRP
#define S_IXGRP S_IXUSR
#endif
#ifndef S_IXOTH
#define S_IXOTH S_IXUSR
#endif

typedef unsigned char Boolean;

int dos_setfattr (char *FileName, Boolean Writable, Boolean Executable);
int dos_setfattr (char *FileName, Boolean Writable, Boolean Executable)
{
  struct stat buf;
  if (!stat (FileName, &buf))
    {
      if (Writable)
        buf.st_mode |= S_IWUSR; /* Set only user write permissions, for reasons of safety! */
      else
        buf.st_mode &= ~ (S_IWUSR | S_IWGRP | S_IWOTH);
      if (Executable)
        buf.st_mode |= S_IXUSR | S_IXGRP | S_IXOTH;
      else
        buf.st_mode &= ~ (S_IXUSR | S_IXGRP | S_IXOTH);
      if (!chmod (FileName, buf.st_mode)) return 0;
    }
  return (errno == ENOENT) ? 2 : 5;
}
