#include "available-stubs.h"

#include <arpa/nameser.h>
#include "checker_api.h"

/* compiled from: . */
#ifdef HAVE__getshort
/* From `/usr/include/arpa/nameser.h:296'.  */
u_int16_t chkr_stub__getshort (const u_char *p)
     __asm__ (CHKR_PREFIX ("_getshort"));
u_int16_t
chkr_stub__getshort (const u_char *p)
{
  stubs_chkr_check_addr (p, 2 * sizeof (u_char), CHKR_RO, "p");
#if USE_BI_JUMP
  __builtin_jump (_getshort);
#else
  return _getshort (p);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE__getshort */

#ifdef HAVE__getlong
/* From `/usr/include/arpa/nameser.h:297'.  */
u_int32_t chkr_stub__getlong (const u_char *p)
     __asm__ (CHKR_PREFIX ("_getlong"));
u_int32_t
chkr_stub__getlong (const u_char *p)
{
  stubs_chkr_check_addr (p, 4 * sizeof (u_char), CHKR_RO, "p");
#if USE_BI_JUMP
  __builtin_jump (_getlong);
#else
  return _getlong (p);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE__getlong */
