#include "available-stubs.h"

#include <sys/types.h>
#include <regex.h>
#include "checker_api.h"

/* compiled from: . */
#ifdef HAVE_re_set_syntax
/* From `/usr/include/regex.h:440'.  */
reg_syntax_t chkr_stub_re_set_syntax (reg_syntax_t arg0) __asm__ (CHKR_PREFIX ("re_set_syntax"));
reg_syntax_t
chkr_stub_re_set_syntax (reg_syntax_t arg0)
{
#if USE_BI_JUMP
  __builtin_jump (re_set_syntax);
#else
  return re_set_syntax (arg0);
  {
    reg_syntax_t res;
    res = re_set_syntax (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_re_set_syntax */

#ifdef HAVE_re_compile_pattern
/* From `/usr/include/regex.h:447'.  */
const char * chkr_stub_re_compile_pattern (const char * arg0, size_t arg1, struct re_pattern_buffer * arg2) __asm__ (CHKR_PREFIX ("re_compile_pattern"));
const char *
chkr_stub_re_compile_pattern (const char * arg0, size_t arg1, struct re_pattern_buffer * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg2, sizeof (struct re_pattern_buffer), CHKR_XX, "arg2");
#if USE_BI_JUMP
  __builtin_jump (re_compile_pattern);
#else
  return re_compile_pattern (arg0, arg1, arg2);
  {
    const char * res;
    res = re_compile_pattern (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_re_compile_pattern */

#ifdef HAVE_re_compile_fastmap
/* From `/usr/include/regex.h:453'.  */
int chkr_stub_re_compile_fastmap (struct re_pattern_buffer * arg0) __asm__ (CHKR_PREFIX ("re_compile_fastmap"));
int
chkr_stub_re_compile_fastmap (struct re_pattern_buffer * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct re_pattern_buffer), CHKR_XX, "arg0");
#if USE_BI_JUMP
  __builtin_jump (re_compile_fastmap);
#else
  return re_compile_fastmap (arg0);
  {
    int res;
    res = re_compile_fastmap (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_re_compile_fastmap */

#ifdef HAVE_re_search
/* From `/usr/include/regex.h:463'.  */
int chkr_stub_re_search (struct re_pattern_buffer * arg0, const char * arg1, int arg2, int arg3, int arg4, struct re_registers * arg5) __asm__ (CHKR_PREFIX ("re_search"));
int
chkr_stub_re_search (struct re_pattern_buffer * arg0, const char * arg1, int arg2, int arg3, int arg4, struct re_registers * arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct re_pattern_buffer), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg5, sizeof (struct re_registers), CHKR_XX, "arg5");
#if USE_BI_JUMP
  __builtin_jump (re_search);
#else
  return re_search (arg0, arg1, arg2, arg3, arg4, arg5);
  {
    int res;
    res = re_search (arg0, arg1, arg2, arg3, arg4, arg5);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_re_search */

#ifdef HAVE_re_search_2
/* From `/usr/include/regex.h:471'.  */
int chkr_stub_re_search_2 (struct re_pattern_buffer * arg0, const char * arg1, int arg2, const char * arg3, int arg4, int arg5, int arg6, struct re_registers * arg7, int arg8) __asm__ (CHKR_PREFIX ("re_search_2"));
int
chkr_stub_re_search_2 (struct re_pattern_buffer * arg0, const char * arg1, int arg2, const char * arg3, int arg4, int arg5, int arg6, struct re_registers * arg7, int arg8)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct re_pattern_buffer), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (char), CHKR_RO, "arg3");
  stubs_chkr_check_addr (arg7, sizeof (struct re_registers), CHKR_XX, "arg7");
#if USE_BI_JUMP
  __builtin_jump (re_search_2);
#else
  return re_search_2 (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  {
    int res;
    res = re_search_2 (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_re_search_2 */

#ifdef HAVE_re_match
/* From `/usr/include/regex.h:478'.  */
int chkr_stub_re_match (struct re_pattern_buffer * arg0, const char * arg1, int arg2, int arg3, struct re_registers * arg4) __asm__ (CHKR_PREFIX ("re_match"));
int
chkr_stub_re_match (struct re_pattern_buffer * arg0, const char * arg1, int arg2, int arg3, struct re_registers * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct re_pattern_buffer), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg4, sizeof (struct re_registers), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (re_match);
#else
  return re_match (arg0, arg1, arg2, arg3, arg4);
  {
    int res;
    res = re_match (arg0, arg1, arg2, arg3, arg4);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_re_match */

#ifdef HAVE_re_match_2
/* From `/usr/include/regex.h:485'.  */
int chkr_stub_re_match_2 (struct re_pattern_buffer * arg0, const char * arg1, int arg2, const char * arg3, int arg4, int arg5, struct re_registers * arg6, int arg7) __asm__ (CHKR_PREFIX ("re_match_2"));
int
chkr_stub_re_match_2 (struct re_pattern_buffer * arg0, const char * arg1, int arg2, const char * arg3, int arg4, int arg5, struct re_registers * arg6, int arg7)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct re_pattern_buffer), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (char), CHKR_RO, "arg3");
  stubs_chkr_check_addr (arg6, sizeof (struct re_registers), CHKR_XX, "arg6");
#if USE_BI_JUMP
  __builtin_jump (re_match_2);
#else
  return re_match_2 (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  {
    int res;
    res = re_match_2 (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_re_match_2 */

#ifdef HAVE_re_set_registers
/* From `/usr/include/regex.h:502'.  */
void chkr_stub_re_set_registers (struct re_pattern_buffer * arg0, struct re_registers * arg1, unsigned int arg2, regoff_t * arg3, regoff_t * arg4) __asm__ (CHKR_PREFIX ("re_set_registers"));
void
chkr_stub_re_set_registers (struct re_pattern_buffer * arg0, struct re_registers * arg1, unsigned int arg2, regoff_t * arg3, regoff_t * arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct re_pattern_buffer), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (struct re_registers), CHKR_XX, "arg1");
  stubs_chkr_check_addr (arg3, sizeof (regoff_t), CHKR_XX, "arg3");
  stubs_chkr_check_addr (arg4, sizeof (regoff_t), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (re_set_registers);
#else
  re_set_registers (arg0, arg1, arg2, arg3, arg4);
  re_set_registers (arg0, arg1, arg2, arg3, arg4);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_re_set_registers */

#ifdef HAVE_regcomp
/* From `/usr/include/regex.h:513'.  */
int chkr_stub_regcomp (regex_t *preg, const char *regex, int cflags)
     __asm__ (CHKR_PREFIX ("regcomp"));
int
chkr_stub_regcomp (regex_t *preg, const char *regex, int cflags)
{
  int res;

  stubs_chkr_check_addr (preg, sizeof (regex_t), CHKR_TW, "preg");
  stubs_chkr_check_str (regex, CHKR_RO, "regex");

  res = regcomp (preg, regex, cflags);
  return res;
}
#endif /* HAVE_regcomp */

#ifdef HAVE_regexec
/* From `/usr/include/regex.h:516'.  */
int chkr_stub_regexec (const regex_t *preg, const char *string, size_t nmatch,
		       regmatch_t *pmatch, int eflags)
     __asm__ (CHKR_PREFIX ("regexec"));
int
chkr_stub_regexec (const regex_t *preg, const char *string, size_t nmatch,
		   regmatch_t *pmatch, int eflags)
{
  int i;
  int res;

  stubs_chkr_check_addr (preg, sizeof (regex_t), CHKR_TW, "preg");
  stubs_chkr_check_str (string, CHKR_RO, "string");
  for (i = 0; i < nmatch; i++)
    {
      stubs_chkr_check_addr (&(pmatch[i].rm_so), sizeof (regoff_t), CHKR_WO,
			     "rm_so");
      stubs_chkr_check_addr (&(pmatch[i].rm_eo), sizeof (regoff_t), CHKR_WO,
			     "rm_eo");
    }

  res = regexec (preg, string, nmatch, pmatch, eflags);
  return res;
}
#endif /* HAVE_regexec */

#ifdef HAVE_regerror
/* From `/usr/include/regex.h:519'.  */
size_t chkr_stub_regerror (int errcode, const regex_t *regex, char *errbuf,
			   size_t buf_size) __asm__ (CHKR_PREFIX ("regerror"));
size_t
chkr_stub_regerror (int errcode, const regex_t *regex, char *errbuf,
		    size_t buf_size)
{
  size_t len;
  size_t res;

  stubs_chkr_check_addr (regex, sizeof (regex_t), CHKR_TW, "regex");
  if (errbuf && buf_size)
    stubs_chkr_check_addr (errbuf, buf_size, CHKR_MW, "arg2");

  res = regerror (errcode, regex, errbuf, buf_size);
  if (buf_size && errbuf)
    {
      len = strlen (errbuf);
      stubs_chkr_set_right (errbuf, len + 1, CHKR_RW);
    }
  return res;
}
#endif /* HAVE_regerror */

#ifdef HAVE_regfree
/* From `/usr/include/regex.h:520'.  */
void chkr_stub_regfree (regex_t * arg0) __asm__ (CHKR_PREFIX ("regfree"));
void
chkr_stub_regfree (regex_t *regex)
{
  stubs_chkr_check_addr (regex, sizeof (regex_t), CHKR_TW, "regex");
  regfree (regex);
}
#endif /* HAVE_regfree */

