/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998  Damon Chaplin
 *
 *  Based on GtkRadioButton widget from GTK,
 *  Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __GTK_PALETTE_BUTTON_H__
#define __GTK_PALETTE_BUTTON_H__


#include <gdk/gdk.h>
#include <gtk/gtkradiobutton.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_PALETTE_BUTTON(obj)          GTK_CHECK_CAST (obj, gtk_palette_button_get_type (), GtkPaletteButton)
#define GTK_PALETTE_BUTTON_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_palette_button_get_type (), GtkPaletteButtonClass)
#define GTK_IS_PALETTE_BUTTON(obj)       GTK_CHECK_TYPE (obj, gtk_palette_button_get_type ())


typedef struct _GtkPaletteButton       GtkPaletteButton;
typedef struct _GtkPaletteButtonClass  GtkPaletteButtonClass;

struct _GtkPaletteButton
{
  GtkRadioButton radio_button;
};

struct _GtkPaletteButtonClass
{
  GtkRadioButtonClass parent_class;
};


guint      gtk_palette_button_get_type       (void);
GtkWidget* gtk_palette_button_new            (GSList      *group);
GtkWidget* gtk_palette_button_new_with_label (GSList      *group,
					      const gchar *label);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_PALETTE_BUTTON_H__ */
