/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998  Damon Chaplin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __UTILS_H__
#define __UTILS_H__

/* This shows a simple dialog box with a label and an 'OK' button.
   Example usage:
    show_message_box("Error saving file");
 */
void	    show_message_box		(gchar		    *message);


/* This shows a dialog box with a message and a number of buttons.
 * Signal handlers can be supplied for any of the buttons.
 * NOTE: The dialog is automatically destroyed when any button is clicked.
 * default_button specifies the default button, numbered from 1..
 * data is passed to the signal handler.

   Example usage:
     gchar *buttons[] = { "Yes", "No", "Cancel" };
     GtkSignalFunc signal_handlers[] = { on_yes, on_no, NULL };
     show_dialog("Do you want to save the current project?", 3, buttons, 3,
                 signal_handlers, NULL);
 */
void	    show_dialog			(gchar		    *message,
					 gint		     nbuttons,
					 gchar		    *buttons[],
					 gint		     default_button,
					 GtkSignalFunc	     signal_handlers[],
					 gpointer	     data);


/* This shows a dialog box with a message and an Entry for entering a value.
 * When the OK button is pressed the handler of the specified widget will
 * be called with the value and the given data.
 * NOTE: The dialog is automatically destroyed when any button is clicked.

   Example usage:
     show_entry_dialog("Name:", "default", widget, on_dialog_ok, "NewName");

void
on_dialog_ok(GtkWidget *widget, gchar *value, gpointer data)
{
...

 */
typedef gint (*GbEntryDialogFunc)	(GtkWidget	*widget,
					 gchar		*value,
					 gpointer	 data);

void	    show_entry_dialog		(gchar		    *message,
					 gchar		    *initial_value,
					 GtkWidget	    *widget,
					 GbEntryDialogFunc   signal_handler,
					 gpointer	     data);


/* Returns TRUE if string contains substring. */
gboolean    gb_strstr			(gchar		*string,
					 gchar		*substring);

/* Returns the index of a widget in a box. Note that the box packing
   property means that widgets may not be displayed in this order. */
gint	    gb_box_get_pos		(GtkBox		*box,
					 GtkWidget	*widget);

/* Returns the structure corresponding to the given widget in a table. */
GtkTableChild* gb_table_find_child	(GtkTable	*table,
					 GtkWidget	*widget);
#ifdef GLD_HAVE_GTK_1_1
GtkPackerChild *gb_packer_find_child	(GtkPacker * packer,
					 GtkWidget * widget);
#endif

#endif	/* __UTILS_H__ */
