/* 
   PXKApplication.h

   NSApplication for GNUstep GUI X/DPS Backend

   The PXKApplication class manages the main event loop of
   the program, keeps track of the application's windows
   and which one is the key window.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Date: September 1995
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_PXKApplication
#define _GNUstep_H_PXKApplication

#include <X11/Xlib.h>
#include <AppKit/NSApplication.h>

#if !defined(LIB_FOUNDATION_LIBRARY) && !defined(NeXT_PDO)
/* Assume gnustep-base */
# include <base/RunLoop.h>
#endif

@class NSEvent;

@interface PXKApplication : NSApplication
#if !defined(LIB_FOUNDATION_LIBRARY) && !defined(NeXT_PDO)
/* Assume gnustep-base */
				<FdListening>
#endif
{
}

/* Don't put these into a category to avoid problems with super in category
   methods */
- (void)_nextEvent;

- (void)setGrabXWindow:(Window)w;
- (Window)grabXWindow;
@end

#endif /* _GNUstep_H_PXKApplication */
