/* 
   PXKBox.m

   NSBox for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: March 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "config.h"
#include <gnustep/xdps/PXKBox.h>
#include <AppKit/NSColor.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSTextFieldCell.h>

@implementation PXKBox

//
// Displaying
//
- (void)drawRect:(NSRect)rect
{
  // Fill inside
  [[window backgroundColor] set];
  NSRectFill(bounds);

  // Draw border
  switch(border_type)
    {
    case NSNoBorder:
      break;
    case NSLineBorder:
      NSFrameRect(border_rect);
      break;
    case NSBezelBorder:
      NSDrawGrayBezel(border_rect, bounds);
      break;
    case NSGrooveBorder:
      NSDrawGroove(border_rect, bounds);
      break;
    }

  // Draw title
  switch(title_position)
    {
    case NSNoTitle:
      // Nothing to do
      break;
    case NSAboveTop:
    case NSAtTop:
    case NSBelowTop:
    case NSAboveBottom:
    case NSAtBottom:
    case NSBelowBottom:
      [cell setBackgroundColor: [window backgroundColor]];
      [cell drawWithFrame: title_rect inView: self];
    }
}

@end
