#include <GL/gl.h>
#include <GL/glu.h>
#include "MWin.hh"
#include "trackball.h"
#include "lw.h"

MWin::MWin()
{
  vbox = new Gtk_VBox(false, 10);
  label = new Gtk_Label("Left button drag over the image\n to spin the object");
  add(vbox);
  vbox->show();
  
  vbox->pack_start(label, FALSE, FALSE, 0);
  label->show();
  
  /* attribute list for gtkglarea widget 
     Specifies a list of Boolean attributes and enum/integer
     attribute/value pairs. The last attribute must be NULL.
     See glXChooseVisual manpage for further explanation.
   */
  int attrList[] = {
    GDK_GL_RGBA,
    GDK_GL_DOUBLEBUFFER,
    GDK_GL_DEPTH_SIZE,1,
    GDK_GL_NONE
  };


  //glarea = new Gtk_GLArea(attrList);
  glarea = new Gtk_GLArea();
  glarea->set_usize(200, 200);
  glarea->set_events(GDK_BUTTON_PRESS_MASK|
		     GDK_BUTTON_RELEASE_MASK|
		     GDK_POINTER_MOTION_MASK|
		     GDK_POINTER_MOTION_HINT_MASK);
  
  vbox->pack_start(glarea, TRUE, TRUE, 0);
  glarea->show();

  gtk_idle_add(draw_lwobject, this);
}

gint MWin::button_press_event_impl(GdkEventButton *event)
{
  if (event->button == 1) 
    {
      beginx = event->x;
      beginy = event->y;
      trackball(lastquat, 0.0, 0.0, 0.0, 0.0);
    }
  return(TRUE);
}

gint MWin::motion_notify_event_impl(GdkEventMotion *event)
{
  int x, y;
  GdkModifierType state;
  if (event->is_hint) {
    gdk_window_get_pointer(event->window, &x, &y, &state);
  } else {
    x = int(event->x);
    y = int(event->y);
    state = (GdkModifierType)(event->state);
  }
  if (state & GDK_BUTTON1_MASK) {
    int width  = GTK_WIDGET(gtkobject)->allocation.width;
    int height = GTK_WIDGET(gtkobject)->allocation.height;
    /* recalculate spin speed */
    trackball(lastquat,
	      (2.0*beginx - width) / width,
	      (height- 2.0*beginy) / height,
	      (2.0*x - width) / width,
	      (height- 2.0*y) / height);
    beginx = x;
    beginy = y;
  }
  return(TRUE);
}

gint MWin::configure_event_impl(GdkEventConfigure *event)
{
  this->glarea->begingl();
  glViewport(0,0, (GLint)this->glarea->width(), (GLint)this->glarea->height());
  this->glarea->endgl();
  return(TRUE);
}

void initgl(void)
{
  GLfloat light0_pos[4]   = { -50.0, 50.0, 0.0, 0.0 };
  GLfloat light0_color[4] = { .6, .6, .6, 1.0 }; /* white light */
  GLfloat light1_pos[4]   = {  50.0, 50.0, 0.0, 0.0 };
  GLfloat light1_color[4] = { .4, .4, 1, 1.0 };  /* cold blue light */

  /* initialize view */
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(45, 1.0, 1,100);
  glMatrixMode(GL_MODELVIEW);

  /* remove back faces */
  glEnable(GL_CULL_FACE);
  glEnable(GL_DEPTH_TEST);
  
  /* speedups */
  glEnable(GL_DITHER);
  glShadeModel(GL_SMOOTH);
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
  glHint(GL_POLYGON_SMOOTH_HINT, GL_FASTEST);

  /* light */
  glLightfv(GL_LIGHT0, GL_POSITION, light0_pos);
  glLightfv(GL_LIGHT0, GL_DIFFUSE,  light0_color);  
  glLightfv(GL_LIGHT1, GL_POSITION, light1_pos);
  glLightfv(GL_LIGHT1, GL_DIFFUSE,  light1_color);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHT1);
  glEnable(GL_LIGHTING);
    
  glColorMaterial(GL_FRONT_AND_BACK,GL_AMBIENT_AND_DIFFUSE);
  glEnable(GL_COLOR_MATERIAL);  
}

static gint draw_lwobject(MWin *mwin)
{
  GLfloat m[4][4];

  static int init = 0;

  if (mwin->glarea->begingl()) {
    if (!init) {
      trackball(mwin->curquat , 0.0, 0.0, 0.0, 0.0);
      trackball(mwin->lastquat, 0.0, 0.0, 0.0, 0.0);
      initgl();
      init = 1;
    }
		
    glClearColor(.3,.4,.6,1);
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

    glLoadIdentity();
    glTranslatef(0,0,-30);      /* object position */
    build_rotmatrix(m,mwin->curquat);	/* rotation */
    glMultMatrixf(&m[0][0]);
  
    add_quats(mwin->lastquat, mwin->curquat, mwin->curquat); /* spin */
  
    lw_object_show(mwin->lw_object);
  
    /* opengl rendering done for now */
    mwin->glarea->endgl();
  }
  
  /* swap backbuffer to front */
  mwin->glarea->swapbuffers();
  
  return(TRUE);
}

