#include <iostream.h>
#include <testgtkmm.h>
#include <stdio.h>

static GtkMenuEntry menu_items[] =
{
    {"<Main>/File/New", 0, 0, 0},
    {"<Main>/File/Open", 0, 0, 0},
    {"<Main>/File/Save", 0, 0, 0},
    {"<Main>/File/<separator>", 0, 0, 0},
    {"<Main>/Options/A", 0, 0, 0},
    {"<Main>/Options/B", 0, 0, 0},
    {"<Main>/File/test/A", 0, 0, 0},
    {"<Main>/File/test/B", 0, 0, 0},
    {"<Main>/File/test/C", 0, 0, 0},
    {"<Main>/File/<separator>", 0, 0, 0},
    {"<Main>/File/Quit", 0, 0, 0}
};
static int nmenu_items = sizeof(menu_items)/sizeof(menu_items[0]);

togglebuttontest::togglebuttontest() 
    : tb("togglebutton"), 
      tb2("toggle2") { 
    tb.set_state(true);
    tb2.set_state(false);
    tb.show();
    tb2.show();
    add(&tb);
    add(&tb2);
}

timertest::timertest() : b("Stop"), l("1") {
    connect_to_method(b.clicked, this, &timertest::stopit);
    add(&b);
    add(&l);
    b.show();
    l.show();
}
gint timertest::tick() {
    state=state ? false : true;
    const gchar *label=state ? "Flip" : "Flop";
    l.set(label);
    return flag;
}

void timertest::show_impl() { test::show_impl(); startit(); }
void timertest::hide_impl() { stopit(); test::hide_impl(); }
void timertest::startit() {
    printf("startit\n");
    flag=1; state=true;
    connect_to_method(Gtk_Main::timeout(100), this, &timertest::tick);
}

void timertest::stopit() {
    printf("stopit\n");
    flag=0;
}

menufactorytest::menufactorytest(void) : mf(GTK_MENU_FACTORY_MENU_BAR),
	subfactory(GTK_MENU_FACTORY_MENU_BAR)
{
  dummy *d1 = new dummy("d1"),
    *d2 = new dummy("d2"),
    *d3 = new dummy("d3");
  
  mf.add_subfactory(&subfactory,"<Main>");
  mf.add_entries(menu_items,nmenu_items);


  mf.add_entry("<Main>/File/Choose me", "M", 
	       MenuFactoryConnector<menufactorytest, char*>(this, &menucallback,
							    "This menu item is connected to a method of this object"));

  mf.add_entry("<Main>/File/D1", "N", 
	       MenuFactoryConnector<dummy, char*>(d1, &dummy::method_char,
						  "This menu item is connected to a method of an external object"));

  mf.add_entry("<Main>/File/D2", "O", 
	       MenuFactoryConnector<dummy, int>(d2, &dummy::method_int, 12));

  mf.add_entry("<Main>/File/D3", "P", 
	       MenuFactoryConnector<dummy, ignored>(d3, &dummy::method_noarg));


  mb = subfactory.get_menubar_widget();
	
  add(mb);
  mb->show();
}

void menufactorytest::menucallback(char *data)
{
    printf("Menu callback %s\n",data);
}

#if GTK_MAJOR_VERSION > 1 || ( GTK_MAJOR_VERSION == 1 && GTK_MINOR_VERSION >= 1)
static GtkItemFactoryEntry item_items[] =
{
    {"/File",              0, 0, 0, "<Branch>" },
    {"/File/Open",         0, 0, 0 },
    {"/File/Save",         0, 0, 0 },
    {"/File/",             0, 0, 0, "<Separator>" },
    {"/File/CheckItem",    0, 0, 0, "<CheckItem>" },
    {"/File/ToggleItem",   0, 0, 0, "<ToggleItem>" },
    {"/File/",             0, 0, 0, "<Separator>" },
    {"/Options",           0, 0, 0, "<Branch>" },
    {"/Options/A",         0, 0, 0 },
    {"/Options/B",         0, 0, 0 },
    {"/File/RadioItems",   0, 0, 0, "<Branch>" },
    {"/File/RadioItems/A", 0, 0, 0, "<RadioItem>" },
    {"/File/RadioItems/B", 0, 0, 0, "/File/RadioItems/A" },
    {"/File/RadioItems/C", 0, 0, 0, "/File/RadioItems/B" },
    {"/File/",             0, 0, 0, "<Separator>" },
    {"/File/Quit",         0, 0, 0 },
    {"/Help",              0, 0, 0, "<LastBranch>" } ,
    {"/Help/About",        0, 0, 0 } 
};
static int nitem_items = sizeof(item_items)/sizeof(item_items[0]);

void itemfactorytest::itemcallback( string m) {
  cout << m << endl;
}

void globalCB( ) {
  cout << "global callback" << endl;
}

class MessageReceiver {
public:
  void bonk( string s) {
    cout << "messageReceiver:" << s << endl;
  }
} aReceiver;

itemfactorytest::itemfactorytest(void)
{
  itemf =new Gtk_ItemFactory_MenuBar("<Main>");
  
  itemf->create_items(nitem_items,item_items,0);

  itemf->create_item( "/File/", 0, "<Separator>",0);
  itemf->create_item( "/File/DynamicItem", 0, "<Item>", 
		      ItemFactoryConnector<itemfactorytest, string>(this,&itemcallback, 
					  "This item is connected to a method of this object"));
  itemf->create_item( "/File/", 0, "<Separator>",0);
  itemf->create_item( "/File/DynamicBranch", 0, "<Branch>",0);
  itemf->create_item( "/File/DynamicBranch/Item1", 0, "<Item>",
		      ItemFactoryConnector<itemfactorytest, string>(this,&itemcallback,
					  "item1 was selected"));
  itemf->create_item( "/File/DynamicBranch/Item2", 0, "<Item>", 
		      ItemFactoryConnector<itemfactorytest, string>(this,&itemcallback, 
					  "item2 was selected"));
  itemf->create_item( "/File/DB2/Item1", 0, "<ToggleItem>", 
		      ItemFactoryConnector<itemfactorytest, string>(this,&itemcallback, 
					  "DB2/item1 was selected"));
  itemf->create_item( "/File/DB2/Item2", 0, "<Item>", 
		      ItemFactoryConnector<MessageReceiver, string>(&aReceiver,&(MessageReceiver::bonk),
					  "DB2/item2 was selected"));
  itemf->create_item( "/File/DB2/global", 0, "<Item>",&globalCB);

  itemf->create_item( "/File/DB2/radio", 0, "<Branch>",0);
  itemf->create_item( "/File/DB2/radio/A", 0, "<RadioItem>",0);
  itemf->create_item( "/File/DB2/radio/B", 0, "/File/DB2/radio/A",
		      ItemFactoryConnector<MessageReceiver, string>(&aReceiver,&(MessageReceiver::bonk),
								    "DB2/RadioB was selected"));
  itemf->create_item( "/File/DB2/radio/C", 0, "/File/DB2/radio/B",
		      ItemFactoryConnector<MessageReceiver, string>(&aReceiver,&MessageReceiver::bonk,
								    "DB2/RadioC was selected"));
  itemf->create_item( "/File/CBox", 0, "<Branch>",0);
  itemf->create_item( "/File/CBox/A", 0, "<CheckItem>",
		      ItemFactoryConnector<MessageReceiver, string>(&aReceiver,&MessageReceiver::bonk,
								    "CBox A was selected"));
  mb = itemf->get_menubar_widget("");

  g_return_if_fail(mb);
  
  add(mb);
  mb->show();
}
#endif

test::test() {
    Gtk_Window::add(&vbox);
    set_usize(200,100);
    vbox.show();
    vbox.pack_start(&hsep);
    vbox.pack_start(&closebutton);
}

chooser::chooser() {
    add(&vbox);
    vbox.show();
}


void chooser::add_item(const char *name, test *w)
{
    Gtk_Button *b=new Gtk_Button(name);
    vbox.pack_start(b,TRUE,FALSE,0);
    b->show();
    w->set_title(name);
    connect_to_signal(b->clicked, w->show);
}

gint test::delete_event_impl(GdkEventAny* ) 
{
    hide();
    return 1;
}
gint chooser::delete_event_impl(GdkEventAny *)
{
    hide();
    Gtk_Main::instance()->quit();
    return 1;
}

void dummy::method_char(char *data)
{
  cout << "This is dummy object " << s << " char method: " << data << endl;
}

void dummy::method_int(int data)
{
  cout << "This is dummy object " <<  s << " int method: " << data << endl;
}

void dummy::method_noarg(void)
{
  cout << "This is dummy object " << s << " no_arg method" << endl;
}



int main(int argc, char *argv[]) {
    Gtk_Main m(&argc, &argv);
    chooser c;
#if GTK_MAJOR_VERSION > 1 || ( GTK_MAJOR_VERSION == 1 && GTK_MINOR_VERSION >= 1)
    c.add_item("itemfactory",new itemfactorytest);
#endif
    c.add_item("menufactory",new menufactorytest);
    c.add_item("togglebutton",new togglebuttontest);
    c.add_item("timer",new timertest);
    c.set_usize(200,100);
    c.show();
    m.run();
    return 0;
}
