#include <stdio.h>
#include <gtk--.h>

// Main idea of this test program is to test how connections work in gtk.
//
// It does not do anything too neat, just prints some dummy things to
// console.

class MyWin : public Gtk_Window
{
  Gtk_VBox box;
  Gtk_Button b;
  Gtk_Tooltips btip;
  Gtk_Entry text;
  
  int num;

  // Connection-objects can be used for disconecting a connection.
  // it isnt necessary to know about these at all, they are here
  // for easier use of connect().
  Connection c1,c2,c3,c4;
  Gtk_Main *main;
public:  
  Signal1<GdkEventKey *> keyPressed;
  Signal1<gint> foo;
  Signal0 test;
  
private:

  void dohello(){ printf("Button pushed - number was %d\n",num);}
  void dohello_cb(void *){printf("Button pushed_cb - number was %d\n",num);}

  gint keypress(GdkEventKey *event)
  { 
    // sending foo and keyPressed-signals.
    foo(10); keyPressed(event); 
    test();
    c1.disconnect(); // now we'll test disconnecting the connections.
    c2.disconnect();
    c3.disconnect();
    c4.disconnect();
    printf("Keypress was %d\n",event->keyval);
    return 0;
  }


public:
  virtual void doblah(gint a) {  }
  void doblah_cb(gint a,void*) { }

  virtual gint destroy_event_impl(GdkEventAny *o) {
    printf("destroy_event_impl\n");
    return 0; 
  }

  
  MyWin(gint num, Gtk_Main *m);
};

MyWin::MyWin(int num, Gtk_Main *m)
  : Gtk_Window(GTK_WINDOW_TOPLEVEL),
    box(true,0),
    b("Push me"),
    num(num),
    main(m)
{
  // vbox
  add(&box);
  box.show();
  
  // button
  box.pack_start(&b);

  // connect gtk signal to c++ function
  connect_to_method(b.clicked,this,&dohello);
  connect_to_method(b.clicked,this,&dohello_cb,(void*)0);

  // connect sig0 to c++ function
  connect_to_method(test,this,&dohello);
  connect_to_method(test,this,&dohello_cb,(void*)0);

  // connect c++ signal to c++ function from gtk--
  c3=connect_to_method(foo,this,&border_width);

  // connect c++ signal to user function
  c4=connect_to_method(foo,this,&doblah);
  c2=connect_to_method(foo,this,&doblah_cb,(void*)0);

  btip.set_tip(&b,"This button is connected using the new c++ signal handler code.");
  b.show();
  
  // text entry
  box.pack_start(&text);
  text.show();
  connect_to_method(text.key_press_event,this,&keypress);
}

static void staticfunction(GdkEventKey* a) {
  printf("Staticfunction called! %p\n",a);
}

static void staticfunction_cb(GdkEventKey* a,void *) {
  printf("Staticfunction-cb called! %p\n",a);
}

static gint myquit(GdkEventAny*) {
  printf("MYQUIT\n");
  Gtk_Main::instance()->quit();
  return 0;
}

int
main(int argc, char *argv[])
{
  Gtk_Main myapp(&argc, &argv);
  MyWin mywin(5,&myapp);
  
  connect_to_function(mywin.delete_event,&myquit);
  mywin.show();

  // connecting to static function
  connect_to_function(mywin.keyPressed,&staticfunction); 
  connect_to_function(mywin.keyPressed,&staticfunction_cb,(void*)0);
  myapp.run();
  return 0;
}








