
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <ctype.h>
#include <sys/types.h>
#include <unistd.h>

// for determining gtk version (better use gtk/gtk.h, it works on all gtk's)
#include <gtk/gtk.h>
//#include <gtk/gtkfeatures.h>

#ifndef GTK_MAJOR_VERSION
#define GTK_MAJOR_VERSION 0
#define GTK_MINOR_VERSION 0
#define GTK_MICRO_VERSION 0
#endif

struct parameter_spec;
struct type_spec;
struct signal_spec;
struct signal_block_start;

void print_param_list_names(FILE *out, parameter_spec *p);
void print_param_list_both(FILE *out, parameter_spec *p);
void print_param_list_types(FILE *out, parameter_spec *p);
char *signal_func(FILE *out,char *c,char*n); 
char *signal_func1(FILE *out, char *c,char *n);
void checkchar(char *s, char c);
char *parseparam(char *s, parameter_spec **p);
char *parsename(char *s, char **name);
char *parsesignal(char *s, signal_spec **spec);
char *parsetype(char *s, type_spec *spec);
void parse_error(char *err,char *rest);
void generate_signal_object1(FILE *out, signal_spec *p, signal_block_start *bs, int is_short_spec, int is_vfunc_spec);
void printfromtemplate(FILE *out, char *format, char **replacelist);
extern "C" {
    char *strdup(const char *);
    char *basename(const char *);
}
char *parameter_count(parameter_spec *p);
char *get_arg_types(parameter_spec *p);
char *get_arg_both(parameter_spec *p);
char *get_arg_names(parameter_spec *p);

int pid;
static char *source;

static char *cpp_class_init_hook = NULL;

int gnome_widget = 0;

//
// Parser data structures!
//


struct parser_keywords {
    char *name;
    char *(*function)(char *b,char *n);
};

struct signal_block_start {
public:
    char *uname;
    char *lname;
    char *base;
    char *baseprefix;
    char *prefix;
    struct signal_spec *first;
    signal_block_start() : uname(0), lname(0), base(0), 
      baseprefix(0), prefix(0), first(0) { }
};

struct type_spec {
    char *name;
};

struct parameter_spec {
    type_spec type;
    parameter_spec *next;
};

struct signal_spec {
    type_spec rettype;
    signal_spec *next;
    parameter_spec *firstparameter;
    char *funcname;
    char *funcname_gtk;
    signal_spec() : next(0), firstparameter(0), funcname(0) { }
};

signal_block_start currentblock;

FILE *out;
FILE *out2;
FILE *out3;

FILE *safe_fopen (const char *p, char *n)
{
  char b[1000];
  sprintf (b,"%s%d", p, pid);
  return fopen (b, n);
}


//
// Parser functions
//

char *signalspec_func(char *s ,char *c) {  
    signal_spec **spec=&currentblock.first;
    while(*spec&&(*spec)->next) {
	spec=&(*spec)->next;
    }
    if (*spec) spec=&(*spec)->next;
    checkchar(c++,'(');
    c=parsesignal(c,spec);
    checkchar(c++,')');
    //fprintf(stderr,"SIGNAL_PARSED: %s\n",(*spec)->funcname);
    generate_signal_object1(out,*spec,&currentblock,
			    !strncmp(s, "SIGNAL_SHORT_SPEC", strlen("SIGNAL_SHORT_SPEC")),
			    !strncmp(s, "SIGNAL_VFUNC_SPEC", strlen("SIGNAL_VFUNC_SPEC"))
			    );
    return c;
}

char *cppclassinithook_func(char *, char *c) {
  int size;
  
  char *t;
  
  checkchar(c++,'(');
  if(! (t = strchr(c, ')')))
     {
       fprintf(stderr, "Bad CPP_CLASS_INIT_HOOK\n");
       exit(-1);
     }
  
  cpp_class_init_hook = new char[(size = t - c) + 1];
  memset(cpp_class_init_hook, 0, size + 1);
  memcpy(cpp_class_init_hook, c, size);

  //  printf("%%%% : cpp_class_init_hook : '%s'\n", cpp_class_init_hook);
  
  return t + 1;
  
}


char *signalstart_func(char *, char *c) {
    currentblock.first=0; // mem leak.
    checkchar(c++,'(');
    c=parsename(c,&currentblock.uname);
    checkchar(c++,',');
    c=parsename(c,&currentblock.base);
    checkchar(c++,')');

    // stupid hack
    if (!gnome_widget) currentblock.baseprefix = strdup("Gtk");

    // the next one converts CheckButton to check_button, and HRuler to hruler
    currentblock.lname=(char*)malloc(strlen(currentblock.uname)+1+15);
    char *tmp1=currentblock.uname;
    char *tmp2=currentblock.lname;
    while(*tmp1) {
	if (isupper(*tmp1)&&tmp1!=currentblock.uname&&tmp1!=currentblock.uname+1) { *tmp2='_'; tmp2++; }
	*tmp2=tolower(*tmp1);
	tmp1++; tmp2++;
    }
    *tmp2=0; // null terminate
    //strcpy(currentblock.lname,currentblock.uname);
    return c;
}

char *class_start_func(char *, char *c) {
    fclose(out);
    out=safe_fopen(".gtkmmheader1","w");
    return c;
}
char *impl_start_func(char *, char *c) {
    fprintf(out,"#endif\n");
    fclose(out);
    out=safe_fopen(".gtkmmsource1","w");
    return c;
}

char *base_prefix_func(char * s, char * c) {
  checkchar(c++, '(');
  c=parsename(c,&currentblock.baseprefix);
  checkchar(c++, ')');
  return c;
}

char *prefix_func(char * s, char * c) {
  checkchar(c++, '(');
  c=parsename(c,&currentblock.prefix);
  checkchar(c++, ')');
  return c;
}

char *capitalize(char* s) 
{
  char *tmp = s;
  if (s) {
    if (s[0] != '\0') {
      s[0] = toupper(s[0]);
    }
    ++s;
    while (*s) {
      *s = tolower(*s);
      ++s;
    }
  }
  return tmp;
}

char *lowercase(char* s)
{
  char *tmp = s;
  if (s) {
    while (*s) {
      *s = tolower(*s);
      ++s;
    }
  }
  return tmp;
}

char *uppercase(char* s)
{
  char *tmp = s;
  if (s) {
    while (*s) {
      *s = toupper(*s);
      ++s;
    }
  }
  return tmp;
}


// If specified, use that; otherwise take guess
//  based on which lib we're compiling.
char *prefix() 
{
  static char buf[100];
  strncpy(buf, gnome_widget ? 
	  (currentblock.prefix ? lowercase(currentblock.prefix) : "gnome") :
	  "gtk",100);
  return buf;
}

char *Prefix()
{
  static char buf[100];
  strncpy(buf, gnome_widget ? 
	  (currentblock.prefix ? capitalize(currentblock.prefix) : "Gnome") :
	  "Gtk",100);
  return buf;
}

char *PREFIX()
{
  static char buf[100];
  strncpy(buf, gnome_widget ? 
	  (currentblock.prefix ? uppercase(currentblock.prefix) : "GNOME") :
	  "GTK",100);
  return buf;
}

char *signalend_func(char *, char *c) {
    checkchar(c++,'(');
    checkchar(c++,')');

    char *gentemplate=
	"  struct $Prefix_c_signals_$W : public $BasePrefix_c_signals_$BASE {\n";
    char *mapping[]={
	"W",currentblock.uname,
	"w",currentblock.lname,
	"BASE", currentblock.base,
	"BasePrefix", currentblock.baseprefix,
	"prefix", prefix(),
	"Prefix", Prefix(),
	"PREFIX", PREFIX(),
	(char*)0,(char*)0};
    printfromtemplate(out3,gentemplate,mapping);

    signal_spec *p=currentblock.first;
    for(;p;p=p->next) {
	char *mapping[]={
	    "W",currentblock.uname,
	    "w",currentblock.lname,
	    "NUM",parameter_count(p->firstparameter),    
	    "RETTYPE",p->rettype.name,
	    "ARGTYPES", get_arg_types(p->firstparameter),   
	    "NAME", p->funcname, 
	    "DOT", (p->firstparameter?",":""),
	    "ARGBOTH", get_arg_both(p->firstparameter),
	    "ARGNAMES", get_arg_names(p->firstparameter),
	    "RETURN_0", (strcmp(p->rettype.name,"void"))?"return 0":"",
	    "RETURN", (strcmp(p->rettype.name,"void"))?"return":"",
	    "prefix", prefix(), 
	    "Prefix", Prefix(),
            "PREFIX", PREFIX(),
	    (char*)0,(char*)0};
	char *gentemplate=
	    "    $RETTYPE (*$NAME)($Prefix$W*$DOT$ARGTYPES);\n";
	printfromtemplate(out3,gentemplate,mapping);
  

    }

    char *gentt=
	"  };\n";
    printfromtemplate(out3,gentt,mapping);
  

    char *gent2=
	//      "    $Prefix_Class_Proxy_$W::$Prefix_Class_Proxy_$W(char *this_class_name, guint (*type_func_ptr)())\n"
	//"    : name(this_class_name), get_type_func_ptr(type_func_ptr) {\n"
	//"       printf(\"Initializing: %s, %p\\n\",this_class_name,type_func_ptr); "
	//"    }\n"
	"    guint $Prefix_Class_Proxy_$W::get_type() {\n"
	"      static guint type=0;\n"
	"      if (!type) {\n"
	"      GtkTypeInfo info = {\n"
	"        name, sizeof(proxy_Object), sizeof(proxy_Class),\n"
	"        (GtkClassInitFunc) class_init_function,\n"
	"        (GtkObjectInitFunc) object_init_function,\n"
	"        (GtkArgSetFunc) NULL,\n"
	"        (GtkArgGetFunc) NULL\n"
	"        };\n"
	"        type=gtk_type_unique(get_type_func_ptr(), &info);\n"
	"      }\n"
	"    return type;\n"
	"    }\n"
	"  Gtk_c_signals_Base *$Prefix_$W::internal_getsignalbase() {\n"
	"  $Prefix_c_signals_$W *tmp=&(($Prefix_Class_Proxy_$W::proxy_Class*)GTK_OBJECT_CLASS(gtkobject->klass))->sigs; "
	"  return tmp;\n"
	"  }\n"
	"    void $Prefix_Class_Proxy_$W::class_init_function($Prefix_Class_Proxy_$W::proxy_Class *p) {\n"
	"      CppObjectType::cpp_class_init(&p->parent_class,&p->sigs);\n"
	"    }\n"
	"    void $Prefix_Class_Proxy_$W::object_init_function($Prefix_Class_Proxy_$W::proxy_Object *) {\n"
	"    }\n"
	;

    printfromtemplate(out2,gent2,mapping);
      

    char *gent3=
	"  class $Prefix_$W;\n"
	"  class $Prefix_Class_Proxy_$W {\n"
	"  public:\n"
	"    typedef $Prefix_$W CppObjectType;\n"
	"    typedef $Prefix$W BaseObjectType;\n"
	"    typedef $Prefix$WClass BaseClassType;\n"
	//      "    $BasePrefix_Class_Proxy_$W(char *this_class_name, guint (*type_func_ptr)());\n"
	//      "    : name(this_class_name), get_type_func_ptr(type_func_ptr) {\n"
	//      "       printf(\"Initializing: %s, %p\\n\",this_class_name,type_func_ptr); "
	//      "    }\n"
 	"    struct proxy_Object {\n"
	"      BaseObjectType object;\n"
	"    };\n"
	"    struct proxy_Class {\n"
	"      BaseClassType parent_class;\n"
	"      $Prefix_c_signals_$W sigs;\n"
	"    };\n"
	"    static void class_init_function(proxy_Class *p);\n"
	"    static void object_init_function(proxy_Object *);\n"
	"    guint get_type();\n"
	"    char *name;\n"
	"    guint (*get_type_func_ptr)();\n"
	"  };\n"
	;

    printfromtemplate(out3,gent3,mapping);


    char *genextra=
	"$Prefix_Class_Proxy_$W $Prefix_$W::c_class={\"$Prefix_$W\",$prefix_$w_get_type};\n";

    printfromtemplate(out2,genextra,mapping);

    char *gent1=
	"\n"
	"  typedef $Prefix$W BaseObjectType;\n"
	//   "  static $BasePrefix_Class_Proxy<$CPP, $C, $OBJ> c_class;\n"
	"  static $Prefix_Class_Proxy_$W c_class; \n"

	"  virtual Gtk_c_signals_Base *internal_getsignalbase();\n"
	"  static void cpp_class_init($Prefix$WClass *o,$Prefix_c_signals_$W *s) {\n"
	"    $BasePrefix_$BASE::cpp_class_init(($BasePrefix$BASEClass *)o,s);\n";
    printfromtemplate(out,gent1,mapping);

    if(cpp_class_init_hook)
      fprintf(out, "    %s;\n", cpp_class_init_hook);

    p=currentblock.first;
    for(;p;p=p->next) {
	char *mapping[]={
	    "W",currentblock.uname,
	    "w",currentblock.lname,
	    "NUM",parameter_count(p->firstparameter),    
	    "RETTYPE",p->rettype.name,
	    "ARGTYPES", get_arg_types(p->firstparameter),   
	    "NAME", p->funcname, 
	    "GTKNAME", p->funcname_gtk, 
	    "DOT", (p->firstparameter?",":""),
	    "ARGBOTH", get_arg_both(p->firstparameter),
	    "ARGNAMES", get_arg_names(p->firstparameter),
	    "RETURN_0", (strcmp(p->rettype.name,"void"))?"return 0":"",
	    "RETURN", (strcmp(p->rettype.name,"void"))?"return":"",
	    (char*)0,(char*)0};
	char *gent2=
	    "    s->$NAME=o->$GTKNAME;\n"
            "    o->$GTKNAME=$NAME_callback;\n";

	printfromtemplate(out,gent2,mapping);
    }
    fprintf(out,"  }\n");

    return c;
}


void checkchar(char *s, char c) {
    if (*s!=c) { 
	parse_error("checkchar failed.",s);
	fprintf(stderr,"at char '%c'\n",c);
    }
}


char *parseparam(char *s, parameter_spec **p) {
    *p=new parameter_spec;
    (*p)->next=0;
    switch(*s++) {
    case ')': // end of param list.
	delete *p;
	*p=0;
	s--;
	break;
    case ',': // next param
    case '(': // start of param list
	if (*s==')') { delete *p; *p=0; break; }
	s=parsetype(s,&(*p)->type);
	{   
	    char *c=(*p)->type.name;
	    for(;*c;c++) if (*c=='_') *c=' '; // convert all _'s to spaces
	}
	s=parseparam(s,&(*p)->next);
	break;
    default:
	parse_error("Parseparam expected '(', ')' or ','",s);
    }
    //fprintf(stderr,"PARAM Parsed\n");
    return s;
}

char *parsename(char *s, char **name) {
    int l1=strspn(s," ");
    s+=l1;
    int l=strcspn(s," (),");
    if (!l) {
	parse_error("Expected ' ', '(' or ')'",s);
    }
    char *n=new char[l+1];
    *n=0;
    strncpy(n,s,l);
    n[l]=0;
    *name=n;
    //fprintf(stderr,"NAME Parsed\n");
    return s+l;
}



char *parsesignal(char *s, signal_spec **spec) {
  int len;
  char *lfuncname;
  
    *spec=new signal_spec;
    s=parsetype(s,&(*spec)->rettype);
    checkchar(s++,' ');
    s=parsename(s,&(*spec)->funcname);

    len = strlen(lfuncname = (*spec)->funcname);
    
    // if funcname ends with '_c', funcname_gtk is funcname without the '_c'
    if(!strcmp(lfuncname + len - 2, "_c")) {
      (*spec)->funcname_gtk = new char[len];
      strncpy((*spec)->funcname_gtk, lfuncname, len - 2);
      (*spec)->funcname_gtk[len - 2 ] = 0;
    } 
    else (*spec)->funcname_gtk = lfuncname;
    
    
    checkchar(s,'(');
    s=parseparam(s,&(*spec)->firstparameter);
    checkchar(s++,')');
    //fprintf(stderr,"SIGNAL Parsed\n");
    return s;
}

// cannot have spaces or ,'s inside type.
// this cannot read  void(*)()'s.
char *parsetype(char *s, type_spec *spec) {
    int l=strcspn(s,"), ");
    char *tname=new char[l+1];
    *tname=0;
    strncpy(tname,s,l);
    tname[l]=0;
    spec->name=tname;
    //fprintf(stderr,"TYPE Parsed\n");
    return s+l;
}

//
// Code generation functions
//

int parameter_count_num(parameter_spec *p) {
    if (!p) return 0;
    return 1+parameter_count_num(p->next);
}

char *parameter_count(parameter_spec *p) {
    char *t=(char*)malloc(2);
    t[0]="0123456789"[parameter_count_num(p)];
    t[1]=0;
    return t;
}



/*
void print_param_list_types(FILE *out, parameter_spec *p) {
  while(p) {
    fprintf(out,"%s",p->type.name);
    p=p->next;
    if (p) fprintf(out,",");
  }
}
*/
char *get_arg_types(parameter_spec *p) {
    char *c=(char*)malloc(2);
    *c=0;
    while(p) {
	char *c1=(char*)malloc(strlen(c)+strlen(p->type.name)+1+1+1);
	strcpy(c1,c);
	strcat(c1,p->type.name);
	p=p->next;
	if (p) strcat(c1,", ");
	free(c);
	c=c1;
    }
    return c;
}

char *get_arg_both(parameter_spec *p) {
    char *c=(char*)malloc(2);
    *c=0;
    char *pp=(char*)malloc(4);
    pp[0]=' '; pp[1]='p'; pp[3]=0;
    int count=0;
    while(p) {
	char *c1=(char*)malloc(strlen(c)+strlen(p->type.name)+6);
	strcpy(c1,c);
	strcat(c1,p->type.name);
	pp[2]="1234567890"[count];
	strcat(c1,pp);
	p=p->next;
	if (p) strcat(c1,", ");
	free(c);
	c=c1;
	count++;
    }
    return c;
}

char *get_arg_names(parameter_spec *p) {
    char *c=(char*)malloc(2);
    *c=0;
    char *pp=(char*)malloc(3);
    pp[0]='p'; pp[2]=0;
    int count=0;
    while(p) {
	char *c1=(char*)malloc(strlen(c)+1+2+1+1);
	strcpy(c1,c);
	pp[1]="1234567890"[count];
	strcat(c1,pp);
	p=p->next;
	if (p) strcat(c1,", ");
	free(c);
	c=c1;
	count++;
    }
    return c;
}


/*
void print_param_list_names(FILE *out, parameter_spec *p) {
  int count=1;
  while(p) {
    fprintf(out,"p%d",count);
    p=p->next;
    count++;
    if (p) fprintf(out,",");
  }
}

void print_param_list_both(FILE *out, parameter_spec *p) {
  int count=1;
  while(p) {
    fprintf(out,"%s p%d",p->type.name,count);
    p=p->next;
    count++;
    if (p) fprintf(out,",");
  }
}
*/
/*
  static int argcount;
  void count(parameter_spec *p) { argcount++; }
  */
//
// Use this function like this:
// char *repl[]={"NAME","DATA",
//               "FOO","D1",
//               "FOO2","D3",
//                0,0};
// char *source="djkfghdkjhgdjghjk $NAME$FOO$FOO2"
// printfromtemplate(source,repl); will print
// "djkfghdkjhgdjghjk DATAD1D12"
//
void printfromtemplate(FILE *out, char *format, char **replacelist) {
    char *f=strdup(format);
    char *freeme=f;

    char *t;
    while(1) {
      t=strchr(f,'$');       // t points to next $
      if (t == NULL) break;

      // output part before $ (null-terminate at $ then restore $)
      *t='\0';
      fprintf(out,"%s",f);    
      *t='$';                
      
      // check if we have a match
      char **repllist=replacelist; // replacelist AKA "mapping"

      while( *repllist != '\0') {   // mapping is NULL terminated 
	if ( strncmp(*repllist, // The string to replace
		     t+1,       // Right after $
		     strlen(*repllist)) == 0 ) {
	  break;
	}
	else {
	  repllist+=2;               // Step to next thing to replace
	}
      }

      if (*repllist) {
	// we do. print replacement
	fprintf(out,"%s",repllist[1]);   // The replacement string.
	f = t + strlen(repllist[0]) + 1; // Start after the template.    
      } else {
	fprintf(out,"$");
	f = t + 1;
      }
    }
    fprintf(out,"%s",f); // print rest.
    free(freeme);
}


void generate_signal_object1(FILE *out, signal_spec *p, signal_block_start *bs,
			     int is_short_spec, int is_vfunc_spec) {

    char *genheader=0;
    if (!is_vfunc_spec) {

    //"  Signal_proxy$NUM<$RETTYPE,Gtk_$W,GtkObject$DOT$ARGTYPES> $NAME;\n"

	if (!strcmp(p->rettype.name,"void")) {
    genheader=
	"  Signal_proxy$NUM<GtkObject$DOT$ARGTYPES> $NAME;\n"
	"protected:\n"
	"  virtual $RETTYPE $NAME_impl($ARGBOTH);\n"
	"public:\n"
	"  static $RETTYPE $NAME_callback($Prefix$W *o$DOT$ARGBOTH);\n"
	;
	} else {
    genheader=
	"  Signal_proxy$NUM_r<$RETTYPE,GtkObject$DOT$ARGTYPES> $NAME;\n"
	"protected:\n"
	"  virtual $RETTYPE $NAME_impl($ARGBOTH);\n"
	"public:\n"
	"  static $RETTYPE $NAME_callback($Prefix$W *o$DOT$ARGBOTH);\n"
	;
	}
    } else {
    genheader=
	"protected:\n"
	"  virtual $RETTYPE $NAME_impl($ARGBOTH);\n"
	"public:\n"
	"  static $RETTYPE $NAME_callback($Prefix$W *o$DOT$ARGBOTH);\n"
	;
    }

    char *gentemplate=
	"  $RETTYPE $Prefix_$W::$NAME_impl($ARGBOTH) {\n"
	"    $Prefix_c_signals_$W *sig=($Prefix_c_signals_$W *)internal_getsignalbase();\n"
	"    if (!sig->$NAME) $RETURN_0;\n"
	"    $RETURN sig->$NAME(gtkobj()$DOT$ARGNAMES);\n"
	"  }\n"
	"  $RETTYPE $Prefix_$W::$NAME_callback($Prefix$W *o$DOT$ARGBOTH) {\n"
	"    $Prefix_$W *obj=($Prefix_$W *)gtk_object_get_data(GTK_OBJECT(o),\"cpp\");\n"
        "    // disabled because it may emit unnecessary (and confusing) messages during the\n"
        "    // destruction process (e.g. in containers)\n"
	"    // $ASSERT_OBJ;\n"
	"    if (obj) $RETURN obj->$NAME_impl($ARGNAMES);\n"
	"      $RETURN_0;\n"
	"  }\n";

    char *mapping[]={
	"NUM",parameter_count(p->firstparameter),    
	"RETTYPE",p->rettype.name,
	//    "CLASS",bs->cppobjname,  
	"ARGTYPES", get_arg_types(p->firstparameter),   
	"NAME", p->funcname, 
	"DOT", (p->firstparameter?",":""),
	"ARGBOTH", get_arg_both(p->firstparameter),
	"ARGNAMES", get_arg_names(p->firstparameter),
	"RETURN_0", (strcmp(p->rettype.name,"void"))?"return 0":"return",
	"RETURN", (strcmp(p->rettype.name,"void"))?"return":"",
	"ASSERT_OBJ", (strcmp(p->rettype.name,"void"))?"g_return_val_if_fail(obj,0)":"g_return_if_fail(obj)",
	"W",currentblock.uname,
	"w",currentblock.lname,
	"Prefix", Prefix(),
	"PREFIX", PREFIX(),

	(char*)0,(char*)0};

    if(!is_short_spec) printfromtemplate(out2,gentemplate,mapping);
    printfromtemplate(out,genheader,mapping);
 
}


struct parser_keywords keywords[]={
    {"SIGNAL_START",signalstart_func},
    {"SIGNAL_SPEC",signalspec_func},
    {"SIGNAL_SHORT_SPEC",signalspec_func},
    {"SIGNAL_VFUNC_SPEC",signalspec_func},
    {"CPP_CLASS_INIT_HOOK",cppclassinithook_func},
    {"SIGNAL_END",signalend_func},
    {"CLASS_START",class_start_func},
    {"IMPL_START", impl_start_func},
    {"BASE_PREFIX", base_prefix_func},
    {"PREFIX", prefix_func},
    {0,0}
};

bool cond_comp_eq(int major, int minor, int micro) {
   if(major!=GTK_MAJOR_VERSION)
      return false;

   if(minor==-1)
      return true;   
   if(minor!=GTK_MINOR_VERSION)
      return false;

   if(micro==-1)
      return true;
   return micro==GTK_MICRO_VERSION;
}

bool cond_comp_gt(int major, int minor, int micro) {
   int diff;

   diff=GTK_MAJOR_VERSION-major;
   if(diff)
      return diff>0;

   diff=GTK_MINOR_VERSION-minor;
   if(diff)
      return diff>0;

   return GTK_MICRO_VERSION>micro;
}

bool cond_comp_geq(int major, int minor, int micro) {
   return cond_comp_eq(major,minor,micro)
       || cond_comp_gt(major,minor,micro);
}

struct compare_function {
   const char *op;
   bool (*function)(int major, int minor, int micro);
} cond_compare[]={
   { "==", cond_comp_eq },
   { ">=",cond_comp_geq },
   { ">", cond_comp_gt },
   { 0, 0 }
};

bool cond_output, cond_active;
char *cond_start_func(char *, char *arg) {
   if(cond_active)
      parse_error("nested conditionals not yet allowed",arg);

   while(*arg && isspace(*arg)) ++arg;
   char *start=arg;
   while(*arg && !isspace(*arg) && !isdigit(*arg)) ++arg;
   if(start==arg)
      parse_error("expecting comparison operator",arg);

   compare_function *c=cond_compare;
   while(c->op) {
      if(!strncmp(start,c->op,arg-start))
         break;
      ++c;
   }
   if(!c->op) 
      parse_error("expecting comparison operator",arg);

   int major, minor, micro;
   if(sscanf(arg,"%d.%d.%d",&major,&minor,&micro)!=3)
      if(sscanf(arg,"%d.%d",&major,&minor)!=2)
         if(sscanf(arg,"%d",&major)!=1)
            parse_error("expecting gtk version number",arg);
         else
            minor=micro=-1;
      else
         micro=-1;

   cond_output=(c->function)(major,minor,micro);
   cond_active=true;

   return 0;
}

char *cond_else_func(char *, char *arg) {
   if(!cond_active)
      parse_error("#elsegtk without #ifgtk",arg);
   cond_output=!cond_output;
   return 0;
}

char *cond_end_func(char *, char *arg) {
   if(!cond_active)
      parse_error("#endifgtk without #ifgtk",arg);
   cond_output=true;
   cond_active=false;
   return 0;
}

struct parser_keywords cond_keywords[]={
    {"#ifgtk", cond_start_func},
    {"#elsegtk", cond_else_func},
    {"#endifgtk", cond_end_func},
    {0,0}
};

static int linenum=1;
void parser(FILE *infile) {  
    char buf[180];
    cond_active=false;
    cond_output=true;
    while(fgets(buf,180,infile)) {
	char *sbuf=buf;
	while(sbuf) {
            parser_keywords *p=cond_keywords;
            while(p->name) {
               unsigned int name_len=strlen(p->name);
               if(strlen(sbuf)>=name_len &&
                  !strncmp(sbuf,p->name,name_len))
               {
                  (void)(p->function)(sbuf,sbuf+name_len);
                  if(cond_output)
 		     fprintf (out,"#line %d \"%s\"\n", linenum+1, source);
                  sbuf=0;
                  goto nextfind;
               }
               ++p;
            }
            if(!cond_output) {
               sbuf=0;
               goto nextfind;
            }
	    p=keywords;
	    while(p->name) {
		char *t=strstr(sbuf,p->name);
		if (t) {
		    sbuf=(p->function)(t,t+strlen(p->name));
		    checkchar(sbuf++,';');
		    fprintf (out,"#line %d \"%s\"\n", linenum, source);
		    goto nextfind;
		}
		p++;
	    }
	    // default action is to print the line as it is and read next.
	    fprintf(out,"%s",sbuf);
	    sbuf=0;
	nextfind:;
	} 
	linenum++;
    }
    //fprintf(stderr,"FILE Parsed\n");

}

void parse_error(char *err,char *rest) {
    fprintf(stderr,"%d : Parse error %s\nAt: -%s\n",linenum,err,rest);
    char *a=0;
    *a=10; // sigsegv
}

void usage(char *argv0, char *reason) {
    printf("%s\n",reason);
    printf("Usage: %s [-h] [-l] source dest\n",argv0);
    printf("    -h = help\n");
    printf("    -l = generate local files -- use this flag for non-gtk-- widgets\n");
    printf("    -g = generate a Gnome widget\n");
    printf("\nNote: This will read source.gen_h file and generates dest.cc dest.h files.\n");
    exit(EXIT_FAILURE);
}

int main(int argc,char *argv[]) {
    FILE *in=0;
    int i=1,local=0;
    char buf[1024],genname[240],error[240],*target_basename=0,*target=0;

    while ((i<argc)&&(argv[i][0]=='-'))
      {switch (argv[i][1])
         {case 'h': /* version */
            usage(argv[0],"");
          case 'l': /* local */
            local=1;
            break;
	  case 'g': /* Gnome widget */
	    gnome_widget = 1;
	    break;
          default:
            printf("Unknown option %s\n",argv[i]);
         }
       i++;
      } 

    if (argc-i==2) {
        source=argv[i];
        target=argv[i+1]; 
	target_basename = basename(target);
	strcpy(genname,source);
	in=fopen(source,"r");
	if (!in) {
	    sprintf(error,"Cannot open file %s.",source);
	    usage(argv[0],error);
	}
    } else {
	usage(argv[0],"Invalid number of arguments.");
    }
    pid = getpid();
    
    out=safe_fopen(".gtkmmheader","w");
    out2=safe_fopen(".gtkmmsource","w");
    out3=safe_fopen(".gtkmmextraheader","w");

    fprintf(out,"// -*- c++ -*-\n");
    fprintf(out,"/*\n");
    fprintf(out,"   This file has been generated by gtksig from %s. DO NOT MODIFY!!!\n",genname);
    fprintf(out,"*/\n");

    fprintf(out2,"/*\n");
    fprintf(out2,"   This file has been generated by gtksig from %s. DO NOT MODIFY!!!\n",genname);
    fprintf(out2,"*/\n");
    if (!local)
      if (gnome_widget) {
	fprintf(out2,"#include <gnome--/%s.h>\n",target_basename);
      }
      else {
	fprintf(out2,"#include <gtk--/%s.h>\n",target_basename);
      }
    else
      fprintf(out2,"#include \"%s.h\"\n",target_basename);

    if (gnome_widget) {
      // Some of the Gnome basenames have - in them
      char * f = strdup(target_basename);
      char * p = f;
      while (*p != '\0') {
	if (*p == '-') { *p = '_'; }
	++p;
      }
      fprintf(out,"#ifndef GNOMEMM_%s_HEADER\n#define GNOMEMM_%s_HEADER\n",f,f);
      free(f);
    }
    else {
      fprintf(out,"#ifndef GTKMM_%s_HEADER\n#define GTKMM_%s_HEADER\n",target_basename,target_basename);
    }

    parser(in);
    fclose(out3);
    fclose(out2);
    fclose(out);

    sprintf(buf,"cat .gtkmmheader%d .gtkmmextraheader%d .gtkmmheader1%d >%s.h",
	    pid,pid,pid,target);
    system(buf);

    sprintf(buf,"cat .gtkmmsource%d .gtkmmsource1%d >%s.cc",pid,pid,target);
    system(buf);
    sprintf(buf,"rm .gtkmmextraheader%d .gtkmmheader%d .gtkmmheader1%d .gtkmmsource1%d .gtkmmsource%d",pid,pid,pid,pid,pid);
    system(buf);
    return 0;
}
