/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: lioattach.c,v 6.1 96/11/21 15:37:09 nevin Rel $
 *
 *	Function:	- attach stream to io daemon
 *	Accepts:	- stream
 *			- remote IO node
 *			- remote LAM file descriptor
 *			- buffering mode (one of _IOFBF, _IOLBF or _IONBF)
 *	Returns:	- 0 or LAMERROR
 */

#include <lam_config.h>
#include <sfh.h>

#include <errno.h>
#include <stdio.h>

#include <typical.h>
#include <t_types.h>

/*
 * external functions
 */
extern char		*iosockname();
extern int		mwrite();
extern int		sfh_sock_open_clt_unix_stm();


int
lioattach(stream, node, tfd, buffering)

FILE			*stream;
int4			node;
int4			tfd;
int			buffering;

{
	int		iofd;			/* socket to IO daemon */
	char		*iosock;		/* IO daemon server sock name */
	int4		data[2];		/* forwarding info */
/*
 * Create a socket connected to IO daemon.
 */
	iosock = iosockname();
	if (iosock == 0) return(LAMERROR);

	iofd = sfh_sock_open_clt_unix_stm(iosock);
	free(iosock);
	if (iofd < 0) return(LAMERROR);
/*
 * Pass forwarding information to IO daemon.
 */
	data[0] = node;
	data[1] = tfd;
	if (mwrite(iofd, (char *) data, sizeof(data)) != sizeof(data)) {
		close(iofd);
		return(LAMERROR);
	}
/*
 * Redirect the stream to the socket to IO daemon.
 */
	if (freopen("/dev/null", "a", stream) == NULL) {
		close(iofd);
		return(LAMERROR);
	}
	
	if (dup2(iofd, fileno(stream)) < 0) {
		close(iofd);
		return(LAMERROR);
	}
/*
 * Set the line buffering discipline.
 */
	if (setvbuf(stream, NULL, buffering, BUFSIZ) != 0) {
		return(LAMERROR);
	}

	return(0);
}
