/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: di_wait.ext.c,v 6.1 96/11/23 18:39:29 nevin Rel $
 *
 *	Function:	- block waiting for network frame message
 *	Accepts:	- socket descriptor
 */

#include <lam_config.h>

#include <sys/types.h>
#include <sys/time.h>

#if NEED_SYS_SELECT_H
#include <sys/select.h>
#endif

#include <terror.h>

/*
 * external functions 
 */
extern void		di_forward();

void
di_wait(sockd)

int			sockd;

{
	fd_set		readmask;		/* select read-mask */
/*
 * Block for datalink input.
 */
	FD_ZERO(&readmask);
	FD_SET(sockd, &readmask);

	if (select(sockd + 1, &readmask, (fd_set *) 0, (fd_set *) 0,
			(struct timeval *) 0) < 0) {
		terror("dli_inet (select)");
		kexit(errno);
	}

	di_forward();
}
