/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: blktype.c,v 6.1.1.1 97/01/27 17:12:36 nevin Exp $
 * 
 *	Function:	- get description of blocking request type code
 *	Accepts:	- request type code
 *	Returns:	- description string or NULL
 */

#include <errno.h>

#include "blktype.h"

/*
 * local variables
 */
static char		*blkdesc[] = {
		"MPI_Buffer_attach",		/* BLKMPIBUFATTACH */
		"MPI_Buffer_detach",		/* BLKMPIBUFDETACH */
		"MPI_Initialized",		/* BLKMPIINITED */
		"MPI_Abort",			/* BLKMPIABORT */
		"MPI_Address",			/* BLKMPIADDRESS */
		"MPI_Allgather",		/* BLKMPIALLGATHER */
		"MPI_Allgatherv",		/* BLKMPIALLGATHERV */
		"MPI_Allreduce",		/* BLKMPIALLREDUCE */
		"MPI_Alltoall",			/* BLKMPIALLTOALL */
		"MPI_Alltoallv",		/* BLKMPIALLTOALLV */
		"MPI_Attr_delete",		/* BLKMPIATTRDEL */
		"MPI_Attr_get",			/* BLKMPIATTRGET */
		"MPI_Attr_put",			/* BLKMPIATTRPUT */
		"MPI_Barrier",			/* BLKMPIBARRIER */
		"MPI_Bcast",			/* BLKMPIBCAST */
		"MPI_Bsend",			/* BLKMPIBSEND */
		"MPI_Bsend_init",		/* BLKMPIBSINIT */
		"MPI_Cancel",			/* BLKMPICANCEL */
		"MPI_Cart_coords",		/* BLKMPICARTCOORDS */
		"MPI_Cart_create",		/* BLKMPICARTCREATE */
		"MPI_Cartdim_get",		/* BLKMPICARTDIMGET */
		"MPI_Cart_get",			/* BLKMPICARTGET */
		"MPI_Cart_map",			/* BLKMPICARTMAP */
		"MPI_Cart_rank",		/* BLKMPICARTRANK */
		"MPI_Cart_shift",		/* BLKMPICARTSHIFT */
		"MPI_Cart_sub",			/* BLKMPICARTSUB */
		"MPI_Comm_compare",		/* BLKMPICOMMCMP */
		"MPI_Comm_create",		/* BLKMPICOMMCREATE */
		"MPI_Comm_dup",			/* BLKMPICOMMDUP */
		"MPI_Comm_free",		/* BLKMPICOMMFREE */
		"MPI_Comm_group",		/* BLKMPICOMMGROUP */
		"MPI_Comm_rank",		/* BLKMPICOMMRANK */
		"MPI_Comm_remote_group",	/* BLKMPICOMMRGROUP */
		"MPI_Comm_remote_size",		/* BLKMPICOMMRSIZE */
		"MPI_Comm_size",		/* BLKMPICOMMSIZE */
		"MPI_Comm_split",		/* BLKMPICOMMSPLIT */
		"MPI_Comm_test_inter",		/* BLKMPICOMMTESTINTER */
		"MPI_Dims_create",		/* BLKMPIDIMSCREATE */
		"MPI_Error_class",		/* BLKMPIERRCLASS */
		"MPI_Errhandler_create",	/* BLKMPIERRCREATE */
		"MPI_Errhandler_free",		/* BLKMPIERRFREE */
		"MPI_Errhandler_get",		/* BLKMPIERRGET */
		"MPI_Errhandler_set",		/* BLKMPIERRSET */
		"MPI_Error_string",		/* BLKMPIERRSTRING */
		"MPI_Finalize",			/* BLKMPIFINAL */
		"MPI_Gather",			/* BLKMPIGATHER */
		"MPI_Gatherv",			/* BLKMPIGATHERV */
		"MPI_Get_count",		/* BLKMPIGETCOUNT */
		"MPI_Get_elements",		/* BLKMPIGETELEM */
		"MPI_Get_processor_name",	/* BLKMPIGETPNAME */
		"MPI_Graph_create",		/* BLKMPIGRAPHCREATE */
		"MPI_Graphdims_get",		/* BLKMPIGRAPHDIMSGET */
		"MPI_Graph_get",		/* BLKMPIGRAPHGET */
		"MPI_Graph_map",		/* BLKMPIGRAPHMAP */
		"MPI_Graph_neighbors",		/* BLKMPIGRAPHNBR */
		"MPI_Graph_neighbors_count",	/* BLKMPIGRAPHNBRCOUNT */
		"MPI_Group_compare",		/* BLKMPIGROUPCMP */
		"MPI_Group_difference",		/* BLKMPIGROUPDIFF */
		"MPI_Group_excl",		/* BLKMPIGROUPEXCL */
		"MPI_Group_free",		/* BLKMPIGROUPFREE */
		"MPI_Group_incl",		/* BLKMPIGROUPINCL */
		"MPI_Group_intersection",	/* BLKMPIGROUPINTER */
		"MPI_Group_rank",		/* BLKMPIGROUPRANK */
		"MPI_Group_range_excl",		/* BLKMPIGROUPREXCL */
		"MPI_Group_range_incl",		/* BLKMPIGROUPRINCL */
		"MPI_Group_size",		/* BLKMPIGROUPSIZE */
		"MPI_Group_translate_ranks",	/* BLKMPIGROUPTRANKS */
		"MPI_Group_union",		/* BLKMPIGROUPUNION */
		"MPI_Ibsend",			/* BLKMPIIBSEND */
		"MPI_Intercomm_create",		/* BLKMPIICOMMCREATE */
		"MPI_Intercomm_merge",		/* BLKMPIICOMMMERGE */
		"MPI_Init",			/* BLKMPIINIT */
		"MPI_Iprobe",			/* BLKMPIIPROBE */
		"MPI_Irecv",			/* BLKMPIIRECV */
		"MPI_Irsend",			/* BLKMPIIRSEND */
		"MPI_Isend",			/* BLKMPIISEND */
		"MPI_Issend",			/* BLKMPIISSEND */
		"MPI_Keyval_create",		/* BLKMPIKEYCREATE */
		"MPI_Keyval_free",		/* BLKMPIKEYFREE */
		"MPI_Op_create",		/* BLKMPIOPCREATE */
		"MPI_Op_free",			/* BLKMPIOPFREE */
		"MPI_Pack",			/* BLKMPIPACK */
		"MPI_Pack_size",		/* BLKMPIPACKSIZE */
		"MPI_Probe",			/* BLKMPIPROBE */
		"MPI_Recv",			/* BLKMPIRECV */
		"MPI_Reduce",			/* BLKMPIREDUCE */
		"MPI_Reduce_scatter",		/* BLKMPIREDUCESCATTER */
		"MPI_Request_free",		/* BLKMPIREQFREE */
		"MPI_Recv_init",		/* BLKMPIRINIT */
		"MPI_Rsend",			/* BLKMPIRSEND */
		"MPI_Rsend_init",		/* BLKMPIRSINIT */
		"MPI_Scan",			/* BLKMPISCAN */
		"MPI_Scatter",			/* BLKMPISCATTER */
		"MPI_Scatterv",			/* BLKMPISCATTERV */
		"MPI_Send",			/* BLKMPISEND */
		"MPI_Sendrecv",			/* BLKMPISENDRECV */
		"MPI_Sendrecv_replace",		/* BLKMPISENDRECVREP */
		"MPI_Send_init",		/* BLKMPISINIT */
		"MPI_Ssend",			/* BLKMPISSEND */
		"MPI_Ssend_init",		/* BLKMPISSINIT */
		"MPI_Start",			/* BLKMPISTART */
		"MPI_Startall",			/* BLKMPISTARTALL */
		"MPI_Type_commit",		/* BLKMPITCOMMIT */
		"MPI_Type_contiguous",		/* BLKMPITCONTIG */
		"MPI_Pcontrol",			/* BLKMPIPCONTROL */
		"MPI_Test",			/* BLKMPITEST */
		"MPI_Testall",			/* BLKMPITESTALL */
		"MPI_Testany",			/* BLKMPITESTANY */
		"MPI_Test_cancelled",		/* BLKMPITESTCANCEL */
		"MPI_Testsome",			/* BLKMPITESTSOME */
		"MPI_Type_extent",		/* BLKMPITEXTENT */
		"MPI_Type_free",		/* BLKMPITFREE */
		"MPI_Type_hindexed",		/* BLKMPITHINDEX */
		"MPI_Type_hvector",		/* BLKMPITHVECTOR */
		"MPI_Type_indexed",		/* BLKMPITINDEX */
		"MPI_Type_lb",			/* BLKMPITLB */
		"MPI_Topo_test",		/* BLKMPITOPOTEST */
		"MPI_Type_size",		/* BLKMPITSIZE */
		"MPI_Type_struct",		/* BLKMPITSTRUCT */
		"MPI_Type_ub",			/* BLKMPITUB */
		"MPI_Type_vector",		/* BLKMPITVECTOR */
		"MPI_Unpack",			/* BLKMPIUNPACK */
		"MPI_Wait",			/* BLKMPIWAIT */
		"MPI_Waitall",			/* BLKMPIWAITALL */
		"MPI_Waitany",			/* BLKMPIWAITANY */
		"MPI_Waitsome",			/* BLKMPIWAITSOME */
		"MPIL_Spawn",			/* BLKMPILSPAWN */
		"MPIL_Comm_parent",		/* BLKMPILCOMMPARENT */
		"MPIL_Trace_on",		/* BLKMPILTRACEON */
		"MPIL_Trace_off",		/* BLKMPILTRACEOFF */
		"MPIL_Comm_id",			/* BLKMPILCOMMID */
		"MPIL_Comm_gps",		/* BLKMPILCOMMGPS */
		"MPIL_Type_id",			/* BLKMPILTYPEID */
		"MPIL_Signal",			/* BLKMPILSIGNAL */
		"MPIL_Universe_size",		/* BLKMPILUNIVERSESIZE */
		"MPI_Info_create",		/* BLKMPIINFOCREATE */
		"MPI_Info_delete",		/* BLKMPIINFODEL */
		"MPI_Info_dup",			/* BLKMPIINFODUP */
		"MPI_Info_free",		/* BLKMPIINFOFREE */
		"MPI_Info_get",			/* BLKMPIINFOGET */   
		"MPI_Info_get_nkeys",		/* BLKMPIINFONKEYS */
		"MPI_Info_get_nthkey",		/* BLKMPIINFONTH */   
		"MPI_Info_get_valuelen",	/* BLKMPIINFOVALLEN */
		"MPI_Info_set",			/* BLKMPIINFOSET */   
		"MPI_Spawn",			/* BLKMPISPAWN */     
		"MPI_Spawn_multiple",		/* BLKMPISPAWNMULT */     
		"MPI_Accept",			/* BLKMPIACCEPT */     
		"MPI_Connect",			/* BLKMPICONNECT */     
		"MPI_Comm_disconnect",		/* BLKMPICOMMDISC */     
		"MPI_Port_open",		/* BLKMPIPORTOPEN */     
		"MPI_Port_close",		/* BLKMPIPORTCLOSE */     
		"MPI_Name_publish",		/* BLKMPINAMEPUB */     
		"MPI_Name_unpublish",		/* BLKMPINAMEUNPUB */     
		"MPI_Name_get",			/* BLKMPINAMEGET */     
		"MPI_Get_version",		/* BLKMPIGETVERSION */     
		};


char *
blktype(type)
 
int4			type;
 
{
 	char		*p;
 
 	if ((type >= BLKLOW) && (type <= BLKHIGH)) {
 		p = blkdesc[type - BLKLOW];
 	} else {
 		p = 0;
 		errno = EINVAL;
 	}
 
 	return(p);
}
