/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	RBD
 *
 *	$Log:	f2cstring.c,v $
 * Revision 6.1  96/11/23  19:57:55  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:46:30  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:57:00  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:56:43  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:34:58  gdburns
 * Ohio Release
 * 
 * Revision 2.2  94/02/15  18:06:16  raja
 * pre-release to 2.3
 * 
 *	Function:	- create a C string from a F77 string
 *	Accepts:	- F77 string
 *			- string length
 *	Returns:	- C string or NULL
 */

#include <stdlib.h>
#include <string.h>

char *
f2cstring(str, len)

char			*str;
unsigned int		len;

{
	char		*cstr;
	int		i;
/*
 * Allocate space for the C string.
 */
	if ((cstr = malloc(len + 1)) == 0) {
		return((char *) 0);
	}

	if (len > 0) {
		strncpy(cstr, str, (int) len);
	}
/*
 * Bypass trailing spaces and null-terminate the string.
 * If all characters are spaces, leave the first one in.
 */
	for (i = len - 1; i > 0; --i) {
		if (cstr[i] != ' ') {
			break;
		}
	}

	if ((i >= 0) || (len == 0)) {
		cstr[i + 1] = '\0';
	}

	return(cstr);
}
