/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: blktype.h,v 6.1.1.1 97/01/21 09:55:56 nevin Exp $
 *
 *	Function:	- LAM MPI blocking request type codes
 */

#ifndef _BLKTYPE
#define _BLKTYPE

#include "lam.h"

#define BLKLOW			((int4) 1)	/* lowest valid block type */

#define BLKMPIBUFATTACH		((int4) 1)
#define BLKMPIBUFDETACH		((int4) 2)
#define BLKMPIINITED		((int4) 3)
#define BLKMPIABORT		((int4) 4)
#define BLKMPIADDRESS		((int4) 5)
#define BLKMPIALLGATHER		((int4) 6)
#define BLKMPIALLGATHERV	((int4) 7)
#define BLKMPIALLREDUCE		((int4) 8)
#define BLKMPIALLTOALL		((int4) 9)
#define BLKMPIALLTOALLV		((int4) 10)
#define BLKMPIATTRDEL		((int4) 11)
#define BLKMPIATTRGET		((int4) 12)
#define BLKMPIATTRPUT		((int4) 13)
#define BLKMPIBARRIER		((int4) 14)
#define BLKMPIBCAST		((int4) 15)
#define BLKMPIBSEND		((int4) 16)
#define BLKMPIBSINIT		((int4) 17)
#define BLKMPICANCEL		((int4) 18)
#define BLKMPICARTCOORDS	((int4) 19)
#define BLKMPICARTCREATE	((int4) 20)
#define BLKMPICARTDIMGET	((int4) 21)
#define BLKMPICARTGET		((int4) 22)
#define BLKMPICARTMAP		((int4) 23)
#define BLKMPICARTRANK		((int4) 24)
#define BLKMPICARTSHIFT		((int4) 25)
#define BLKMPICARTSUB		((int4) 26)
#define BLKMPICOMMCMP		((int4) 27)
#define BLKMPICOMMCREATE	((int4) 28)
#define BLKMPICOMMDUP		((int4) 29)
#define BLKMPICOMMFREE		((int4) 30)
#define BLKMPICOMMGROUP		((int4) 31)
#define BLKMPICOMMRANK		((int4) 32)
#define BLKMPICOMMRGROUP	((int4) 33)
#define BLKMPICOMMRSIZE		((int4) 34)
#define BLKMPICOMMSIZE		((int4) 35)
#define BLKMPICOMMSPLIT		((int4) 36)
#define BLKMPICOMMTESTINTER	((int4) 37)
#define BLKMPIDIMSCREATE	((int4) 38)
#define BLKMPIERRCLASS		((int4) 39)
#define BLKMPIERRCREATE		((int4) 40)
#define BLKMPIERRFREE		((int4) 41)
#define BLKMPIERRGET		((int4) 42)
#define BLKMPIERRSET		((int4) 43)
#define BLKMPIERRSTRING		((int4) 44)
#define BLKMPIFINAL		((int4) 45)
#define BLKMPIGATHER		((int4) 46)
#define BLKMPIGATHERV		((int4) 47)
#define BLKMPIGETCOUNT		((int4) 48)
#define BLKMPIGETELEM		((int4) 49)
#define BLKMPIGETPNAME		((int4) 50)
#define BLKMPIGRAPHCREATE	((int4) 51)
#define BLKMPIGRAPHDIMSGET	((int4) 52)
#define BLKMPIGRAPHGET		((int4) 53)
#define BLKMPIGRAPHMAP		((int4) 54)
#define BLKMPIGRAPHNBR		((int4) 55)
#define BLKMPIGRAPHNBRCOUNT	((int4) 56)
#define BLKMPIGROUPCMP		((int4) 57)
#define BLKMPIGROUPDIFF		((int4) 58)
#define BLKMPIGROUPEXCL		((int4) 59)
#define BLKMPIGROUPFREE		((int4) 60)
#define BLKMPIGROUPINCL		((int4) 61)
#define BLKMPIGROUPINTER	((int4) 62)
#define BLKMPIGROUPRANK		((int4) 63)
#define BLKMPIGROUPREXCL	((int4) 64)
#define BLKMPIGROUPRINCL	((int4) 65)
#define BLKMPIGROUPSIZE		((int4) 66)
#define BLKMPIGROUPTRANKS	((int4) 67)
#define BLKMPIGROUPUNION	((int4) 68)
#define BLKMPIIBSEND		((int4) 69)
#define BLKMPIICOMMCREATE	((int4) 70)
#define BLKMPIICOMMMERGE	((int4) 71)
#define BLKMPIINIT		((int4) 72)
#define BLKMPIIPROBE		((int4) 73)
#define BLKMPIIRECV		((int4) 74)
#define BLKMPIIRSEND		((int4) 75)
#define BLKMPIISEND		((int4) 76)
#define BLKMPIISSEND		((int4) 77)
#define BLKMPIKEYCREATE		((int4) 78)
#define BLKMPIKEYFREE		((int4) 79)
#define BLKMPIOPCREATE		((int4) 80)
#define BLKMPIOPFREE		((int4) 81)
#define BLKMPIPACK		((int4) 82)
#define BLKMPIPACKSIZE		((int4) 83)
#define BLKMPIPROBE		((int4) 84)
#define BLKMPIRECV		((int4) 85)
#define BLKMPIREDUCE		((int4) 86)
#define BLKMPIREDUCESCATTER	((int4) 87)
#define BLKMPIREQFREE		((int4) 88)
#define BLKMPIRINIT		((int4) 89)
#define BLKMPIRSEND		((int4) 90)
#define BLKMPIRSINIT		((int4) 91)
#define BLKMPISCAN		((int4) 92)
#define BLKMPISCATTER		((int4) 93)
#define BLKMPISCATTERV		((int4) 94)
#define BLKMPISEND		((int4) 95)
#define BLKMPISENDRECV		((int4) 96)
#define BLKMPISENDRECVREP	((int4) 97)
#define BLKMPISINIT		((int4) 98)
#define BLKMPISSEND		((int4) 99)
#define BLKMPISSINIT		((int4) 100)
#define BLKMPISTART		((int4) 101)
#define BLKMPISTARTALL		((int4) 102)
#define BLKMPITCOMMIT		((int4) 103)
#define BLKMPITCONTIG		((int4) 104)
#define BLKMPIPCONTROL		((int4) 105)
#define BLKMPITEST		((int4) 106)
#define BLKMPITESTALL		((int4) 107)
#define BLKMPITESTANY		((int4) 108)
#define BLKMPITESTCANCEL	((int4) 109)
#define BLKMPITESTSOME		((int4) 110)
#define BLKMPITEXTENT		((int4) 111)
#define BLKMPITFREE		((int4) 112)
#define BLKMPITHINDEX		((int4) 113)
#define BLKMPITHVECTOR		((int4) 114)
#define BLKMPITINDEX		((int4) 115)
#define BLKMPITLB		((int4) 116)
#define BLKMPITOPOTEST		((int4) 117)
#define BLKMPITSIZE		((int4) 118)
#define BLKMPITSTRUCT		((int4) 119)
#define BLKMPITUB		((int4) 120)
#define BLKMPITVECTOR		((int4) 121)
#define BLKMPIUNPACK		((int4) 122)
#define BLKMPIWAIT		((int4) 123)
#define BLKMPIWAITALL		((int4) 124)
#define BLKMPIWAITANY		((int4) 125)
#define BLKMPIWAITSOME		((int4) 126)
#define BLKMPILSPAWN		((int4) 127)
#define BLKMPILCOMMPARENT	((int4) 128)
#define BLKMPILTRACEON		((int4) 129)
#define BLKMPILTRACEOFF		((int4) 130)
#define BLKMPILCOMMID		((int4) 131)
#define BLKMPILCOMMGPS		((int4) 132)
#define BLKMPILTYPEID		((int4) 133)
#define BLKMPILSIGNAL		((int4) 134)
#define BLKMPILUNIVERSESIZE	((int4) 135)
#define BLKMPIINFOCREATE	((int4) 136)
#define BLKMPIINFODEL		((int4) 137)
#define BLKMPIINFODUP		((int4) 138)
#define BLKMPIINFOFREE		((int4) 139)
#define BLKMPIINFOGET		((int4) 140)
#define BLKMPIINFONKEYS		((int4) 141)
#define BLKMPIINFONTH		((int4) 142)
#define BLKMPIINFOVALLEN	((int4) 143)
#define BLKMPIINFOSET		((int4) 144)
#define BLKMPISPAWN		((int4) 145)
#define BLKMPISPAWNMULT		((int4) 146)
#define BLKMPIACCEPT		((int4) 147)
#define BLKMPICONNECT		((int4) 148)
#define BLKMPICOMMDISC		((int4) 149)
#define BLKMPIPORTOPEN		((int4) 150)
#define BLKMPIPORTCLOSE		((int4) 151)
#define BLKMPINAMEPUB		((int4) 152)
#define BLKMPINAMEUNPUB		((int4) 153)
#define BLKMPINAMEGET		((int4) 154)
#define BLKMPIGETVERSION	((int4) 155)

#define BLKHIGH			((int4) 155)	/* highest valid block type */

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern char		*blktype __ARGS((int4 type));

#ifdef __cplusplus
}
#endif

#endif /* _BLKTYPE */
