/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: rpi.tcp.h,v 6.1.1.1 97/03/24 12:06:46 nevin Exp $
 *
 *	Function:	- TCP client-to-client interface header
 */

#ifndef _RPI_TCP_H
#define _RPI_TCP_H

#include <all_hash.h>
#include <all_list.h>
#include <mpisys.h>
#include <portable.h>
#include <t_types.h>

/*
 * constants
 */
#define INITHASH	((int4) 32)		/* initial hash table size */
#define TCPSHORTMSGLEN	16384			/* max. length of short msg */

/*
 * structures
 *
 * client-to-client specific process data
 */
struct c2c_proc {
	struct c2c_envl	cp_env;			/* incoming envelope */
	int		cp_sock;		/* socket descriptor */
	int		cp_nenvin;		/* # env. bytes left to read */
	char		*cp_envbuf;		/* envelope buffer pointer */
	int		cp_nmsgin;		/* # msg. bytes left to read */
	char		*cp_msgbuf;		/* message buffer pointer */
	int		cp_extra;		/* # bytes to go into sink */
	MPI_Request	cp_wreq;		/* req writing to process */
	MPI_Request	cp_rreq;		/* reading req */
	MPI_Request	cp_mreq;		/* req to match from */
	int		(*cp_readfn)();		/* read function */
	struct cbuf_msg *cp_bmsg;		/* buffering? */
	int		cp_nbfde;		/* # buffered envelopes */
};

#endif	/* _RPI_TCP_H */
