/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: abort.c,v 6.1 96/11/23 22:50:38 nevin Rel $
 *
 *	Function:	- attempts to abort all processes in group
 *			- prints error message
 *	Accepts:	- communicator
 *			- error code
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <ksignal.h>
#include <mpi.h>
#include <mpisys.h>
#include <net.h>
#include <preq.h>
#include <rpisys.h>

int
MPI_Abort(comm, errcode)

MPI_Comm		comm;
int			errcode;

{
	int		size;			/* group size */
	int		rank;			/* process rank */
	int		err;			/* error code */
	int		class;			/* error class */
	int		i;
	struct _proc	**p;

	lam_initerr();
	lam_setfunc(BLKMPIABORT);
/*
 * Switch error code to extracted errno value.  If the class is 0 then
 * the errno is taken to be the code.
 */
	lam_bkerr(errcode, &class, &i, &err);
	if (class) errcode = err;

	if (comm == MPI_COMM_NULL) comm = MPI_COMM_WORLD;

	err = MPI_Comm_size(comm, &size);
	if (err != MPI_SUCCESS) kexit(errcode);

	err = MPI_Comm_rank(comm, &rank);
	if (err != MPI_SUCCESS) kexit(errcode);
/*
 * Doom all other processes in the group if we know their pids.
 */
	if ((_kio.ki_rtf & RTF_MPIRUN) || (_kio.ki_parent > 0)) {
		p = comm->c_group->g_procs;

		for (i = 0; i < size; ++i, ++p) {

			if (i != rank) {
				rpdoom((*p)->p_gps.gps_node, SELECT_PID,
						(*p)->p_gps.gps_pid, SIGUDIE);
			}
		}
	}
/*
 * Abort the local process if in the group.
 */
	if (rank >= 0) {
		kexit(errcode);
	}

	lam_resetfunc(BLKMPIABORT);
	return(MPI_SUCCESS);
}
