/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	JRV/RBD
 *
 *	$Id: allreduce.c,v 6.1 96/11/23 22:50:45 nevin Rel $
 *
 *	Function:	- reduce and return data to all processes
 *	Accepts:	- send buffer
 *			- receive buffer
 *			- count of elements
 *			- type of elements
 *			- operation to perform
 *			- communicator
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Allreduce(sbuf, rbuf, count, dtype, op, comm)

void			*sbuf;
void			*rbuf;
int			count;
MPI_Datatype		dtype;
MPI_Op			op;
MPI_Comm		comm;

{
	int		err;			/* error code */

	lam_initerr();
	lam_setfunc(BLKMPIALLREDUCE);
/*
 * Check for invalid arguments.
 */
	if ((comm == MPI_COMM_NULL) || LAM_IS_INTER(comm)) {
		return (lam_errfunc(comm, BLKMPIALLREDUCE,
				lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(comm, BLKMPIALLREDUCE,
				lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	LAM_TRACE(lam_tr_cffstart(BLKMPIALLREDUCE));
/*
 * Reduce to 0 and broadcast.
 */
	err = MPI_Reduce(sbuf, rbuf, count, dtype, op, 0, comm);
	if (err != MPI_SUCCESS) {
		return (lam_errfunc(comm, BLKMPIALLREDUCE, err));
	}

	err = MPI_Bcast(rbuf, count, dtype, 0, comm);
	if (err != MPI_SUCCESS) {
		return (lam_errfunc(comm, BLKMPIALLREDUCE, err));
	}

	LAM_TRACE(lam_tr_cffend(BLKMPIALLREDUCE, -1, comm, dtype, count));

	lam_resetfunc(BLKMPIALLREDUCE);
	return(MPI_SUCCESS);
}
