/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: cfree.c,v 6.1 96/11/23 22:51:25 nevin Rel $
 *
 *	Function:	- free a communicator
 *	Accepts:	- communicator (inout)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*
 * external functions
 */
extern int		lam_comm_free();


int
MPI_Comm_free(comm)

MPI_Comm		*comm;

{
	int		err;

	lam_initerr();
	lam_setfunc(BLKMPICOMMFREE);
/*
 * Check the arguments.
 */
	if (comm == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMFREE, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (*comm == MPI_COMM_NULL || ((*comm)->c_flags & LAM_PREDEF)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMFREE, lam_mkerr(MPI_ERR_COMM, 0)));
	}
/*
 * Delete the communicator if it has no pending requests.
 */
	if (--((*comm)->c_refcount) == 0) {

		err = lam_comm_free(*comm);
		*comm = MPI_COMM_NULL;

		if (err != MPI_SUCCESS) {
			return(lam_errfunc(MPI_COMM_WORLD,
						BLKMPICOMMFREE, err));
		}
	} else {
		*comm = MPI_COMM_NULL;
	}

	lam_resetfunc(BLKMPICOMMFREE);
	return(MPI_SUCCESS);
}
