/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: crgroup.c,v 6.1 96/11/23 22:51:30 nevin Rel $
 *
 *	Function:	- get remote group (create a new group)
 *	Accepts:	- inter-communicator
 *			- ptr to group
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Comm_remote_group(comm, pgroup)

MPI_Comm		comm;
MPI_Group		*pgroup;

{
	lam_initerr();
	lam_setfunc(BLKMPICOMMRGROUP);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMRGROUP, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTRA(comm)) {
		return(lam_errfunc(comm,
			BLKMPICOMMRGROUP, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (pgroup == 0) {
		return(lam_errfunc(comm,
			BLKMPICOMMRGROUP, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*pgroup = comm->c_rgroup;
	comm->c_rgroup->g_refcount++;

	lam_resetfunc(BLKMPICOMMRGROUP);
  	return(MPI_SUCCESS);
}
